"""Initial migration for django_twilio_call."""

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):
    """Create initial models for django_twilio_call."""

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Queue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('is_active', models.BooleanField(db_index=True, default=True, verbose_name='is active')),
                ('metadata', models.JSONField(blank=True, default=dict, verbose_name='metadata')),
                ('name', models.CharField(max_length=100, unique=True, verbose_name='name')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('routing_strategy', models.CharField(choices=[('fifo', 'First In First Out'), ('lifo', 'Last In First Out'), ('round_robin', 'Round Robin'), ('least_busy', 'Least Busy Agent'), ('skills_based', 'Skills Based')], default='fifo', max_length=20, verbose_name='routing strategy')),
                ('priority', models.IntegerField(default=0, help_text='Higher priority queues are processed first', validators=[django.core.validators.MinValueValidator(0)], verbose_name='priority')),
                ('max_size', models.IntegerField(default=100, help_text='Maximum number of calls in queue', validators=[django.core.validators.MinValueValidator(1)], verbose_name='max size')),
                ('max_wait_time', models.IntegerField(default=300, help_text='Maximum wait time in seconds before timeout', validators=[django.core.validators.MinValueValidator(0)], verbose_name='max wait time')),
                ('music_on_hold_url', models.URLField(blank=True, verbose_name='music on hold URL')),
                ('announcement_url', models.URLField(blank=True, help_text='Audio played when caller joins queue', verbose_name='announcement URL')),
                ('periodic_announcement_url', models.URLField(blank=True, help_text='Audio played periodically while waiting', verbose_name='periodic announcement URL')),
                ('periodic_announcement_frequency', models.IntegerField(default=60, help_text='Seconds between periodic announcements', validators=[django.core.validators.MinValueValidator(10)], verbose_name='periodic announcement frequency')),
                ('callback_enabled', models.BooleanField(default=False, help_text='Allow callers to request callback', verbose_name='callback enabled')),
                ('callback_message', models.TextField(blank=True, help_text='Message played when offering callback', verbose_name='callback message')),
                ('operating_hours_start', models.TimeField(blank=True, null=True, verbose_name='operating hours start')),
                ('operating_hours_end', models.TimeField(blank=True, null=True, verbose_name='operating hours end')),
                ('operating_days', models.JSONField(blank=True, default=list, help_text='List of operating days (0=Monday, 6=Sunday)', verbose_name='operating days')),
                ('closed_message', models.TextField(blank=True, help_text='Message played when queue is closed', verbose_name='closed message')),
                ('max_calls_per_agent', models.IntegerField(default=1, validators=[django.core.validators.MinValueValidator(1)], verbose_name='max calls per agent')),
                ('agent_timeout', models.IntegerField(default=30, help_text='Seconds to ring agent before moving to next', validators=[django.core.validators.MinValueValidator(5)], verbose_name='agent timeout')),
                ('wrap_up_time', models.IntegerField(default=0, help_text='Seconds after call before agent is available', validators=[django.core.validators.MinValueValidator(0)], verbose_name='wrap up time')),
                ('record_calls', models.BooleanField(default=False, verbose_name='record calls')),
                ('transcribe_calls', models.BooleanField(default=False, verbose_name='transcribe calls')),
                ('whisper_to_agent', models.TextField(blank=True, help_text='Message whispered to agent before connecting', verbose_name='whisper to agent')),
            ],
            options={
                'verbose_name': 'queue',
                'verbose_name_plural': 'queues',
                'db_table': 'django_twilio_call_queue',
                'ordering': ['-priority', 'created_at'],
            },
        ),
        migrations.CreateModel(
            name='PhoneNumber',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('is_active', models.BooleanField(db_index=True, default=True, verbose_name='is active')),
                ('metadata', models.JSONField(blank=True, default=dict, verbose_name='metadata')),
                ('phone_number', models.CharField(db_index=True, max_length=20, unique=True, verbose_name='phone number')),
                ('friendly_name', models.CharField(blank=True, max_length=100, verbose_name='friendly name')),
                ('twilio_sid', models.CharField(blank=True, db_index=True, max_length=50, unique=True, verbose_name='Twilio SID')),
                ('capabilities', models.JSONField(default=dict, verbose_name='capabilities')),
                ('emergency_enabled', models.BooleanField(default=False, verbose_name='emergency enabled')),
                ('trunk_sid', models.CharField(blank=True, max_length=50, verbose_name='trunk SID')),
                ('voice_url', models.URLField(blank=True, verbose_name='voice URL')),
                ('voice_fallback_url', models.URLField(blank=True, verbose_name='voice fallback URL')),
                ('sms_url', models.URLField(blank=True, verbose_name='SMS URL')),
                ('sms_fallback_url', models.URLField(blank=True, verbose_name='SMS fallback URL')),
                ('voice_application_sid', models.CharField(blank=True, max_length=50, verbose_name='voice application SID')),
                ('sms_application_sid', models.CharField(blank=True, max_length=50, verbose_name='SMS application SID')),
                ('phone_type', models.CharField(choices=[('local', 'Local'), ('mobile', 'Mobile'), ('tollfree', 'Toll-Free'), ('international', 'International'), ('shortcode', 'Short Code')], default='local', max_length=20, verbose_name='phone type')),
                ('country_code', models.CharField(max_length=5, verbose_name='country code')),
                ('region', models.CharField(blank=True, max_length=50, verbose_name='region')),
                ('postal_code', models.CharField(blank=True, max_length=20, verbose_name='postal code')),
                ('locality', models.CharField(blank=True, max_length=100, verbose_name='locality')),
                ('is_verified', models.BooleanField(default=False, verbose_name='is verified')),
                ('verification_date', models.DateTimeField(blank=True, null=True, verbose_name='verification date')),
                ('price', models.DecimalField(blank=True, decimal_places=4, max_digits=10, null=True, verbose_name='price')),
                ('price_unit', models.CharField(blank=True, default='USD', max_length=5, verbose_name='price unit')),
                ('default_queue', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='phone_numbers', to='django_twilio_call.queue', verbose_name='default queue')),
            ],
            options={
                'verbose_name': 'phone number',
                'verbose_name_plural': 'phone numbers',
                'db_table': 'django_twilio_call_phonenumber',
                'ordering': ['phone_number'],
            },
        ),
        migrations.CreateModel(
            name='Call',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('is_active', models.BooleanField(db_index=True, default=True, verbose_name='is active')),
                ('metadata', models.JSONField(blank=True, default=dict, verbose_name='metadata')),
                ('twilio_sid', models.CharField(db_index=True, max_length=50, unique=True, verbose_name='Twilio SID')),
                ('parent_sid', models.CharField(blank=True, db_index=True, max_length=50, verbose_name='parent SID')),
                ('from_number', models.CharField(db_index=True, max_length=20, verbose_name='from number')),
                ('to_number', models.CharField(db_index=True, max_length=20, verbose_name='to number')),
                ('direction', models.CharField(choices=[('inbound', 'Inbound'), ('outbound', 'Outbound')], max_length=10, verbose_name='direction')),
                ('status', models.CharField(choices=[('queued', 'Queued'), ('ringing', 'Ringing'), ('in-progress', 'In Progress'), ('completed', 'Completed'), ('failed', 'Failed'), ('busy', 'Busy'), ('no-answer', 'No Answer'), ('canceled', 'Canceled')], db_index=True, default='queued', max_length=20, verbose_name='status')),
                ('duration', models.IntegerField(default=0, help_text='Duration in seconds', verbose_name='duration')),
                ('price', models.DecimalField(blank=True, decimal_places=4, max_digits=10, null=True, verbose_name='price')),
                ('price_unit', models.CharField(blank=True, default='USD', max_length=5, verbose_name='price unit')),
                ('is_recorded', models.BooleanField(default=False, verbose_name='is recorded')),
                ('recording_url', models.URLField(blank=True, verbose_name='recording URL')),
                ('is_transcribed', models.BooleanField(default=False, verbose_name='is transcribed')),
                ('transcription_text', models.TextField(blank=True, verbose_name='transcription text')),
                ('voicemail_url', models.URLField(blank=True, verbose_name='voicemail URL')),
                ('queue_time', models.IntegerField(default=0, help_text='Time spent in queue in seconds', verbose_name='queue time')),
                ('ring_time', models.IntegerField(default=0, help_text='Time spent ringing in seconds', verbose_name='ring time')),
                ('talk_time', models.IntegerField(default=0, help_text='Time spent talking in seconds', verbose_name='talk time')),
                ('hold_time', models.IntegerField(default=0, help_text='Time spent on hold in seconds', verbose_name='hold time')),
                ('wrap_up_time', models.IntegerField(default=0, help_text='After-call work time in seconds', verbose_name='wrap up time')),
                ('is_callback', models.BooleanField(default=False, verbose_name='is callback')),
                ('callback_source', models.CharField(blank=True, max_length=50, verbose_name='callback source')),
                ('transferred_from', models.CharField(blank=True, max_length=50, verbose_name='transferred from')),
                ('transferred_to', models.CharField(blank=True, max_length=50, verbose_name='transferred to')),
                ('conference_sid', models.CharField(blank=True, db_index=True, max_length=50, verbose_name='conference SID')),
                ('forwarded_from', models.CharField(blank=True, max_length=20, verbose_name='forwarded from')),
                ('caller_name', models.CharField(blank=True, max_length=100, verbose_name='caller name')),
                ('answered_by', models.CharField(blank=True, choices=[('human', 'Human'), ('machine', 'Machine'), ('fax', 'Fax'), ('unknown', 'Unknown')], max_length=20, verbose_name='answered by')),
                ('disconnect_reason', models.CharField(blank=True, max_length=50, verbose_name='disconnect reason')),
                ('customer_rating', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(5)], verbose_name='customer rating')),
                ('customer_feedback', models.TextField(blank=True, verbose_name='customer feedback')),
                ('sentiment_score', models.FloatField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(-1), django.core.validators.MaxValueValidator(1)], verbose_name='sentiment score')),
                ('notes', models.TextField(blank=True, verbose_name='notes')),
                ('tags', models.JSONField(blank=True, default=list, verbose_name='tags')),
                ('error_code', models.CharField(blank=True, max_length=10, verbose_name='error code')),
                ('error_message', models.TextField(blank=True, verbose_name='error message')),
                ('last_status_change', models.DateTimeField(auto_now=True, verbose_name='last status change')),
                ('queue', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='calls', to='django_twilio_call.queue', verbose_name='queue')),
            ],
            options={
                'verbose_name': 'call',
                'verbose_name_plural': 'calls',
                'db_table': 'django_twilio_call_call',
                'ordering': ['-created_at'],
                'indexes': [models.Index(fields=['status', 'created_at'], name='idx_call_status'), models.Index(condition=models.Q(('status', 'queued')), fields=['queue', 'created_at'], name='idx_queued_calls')],
            },
        ),
        migrations.CreateModel(
            name='Agent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('is_active', models.BooleanField(db_index=True, default=True, verbose_name='is active')),
                ('metadata', models.JSONField(blank=True, default=dict, verbose_name='metadata')),
                ('extension', models.CharField(blank=True, max_length=10, unique=True, verbose_name='extension')),
                ('phone_number', models.CharField(blank=True, max_length=20, verbose_name='phone number')),
                ('sip_uri', models.CharField(blank=True, max_length=100, verbose_name='SIP URI')),
                ('status', models.CharField(choices=[('available', 'Available'), ('busy', 'Busy'), ('offline', 'Offline'), ('break', 'On Break'), ('after_call_work', 'After Call Work')], db_index=True, default='offline', max_length=20, verbose_name='status')),
                ('last_status_change', models.DateTimeField(auto_now_add=True, verbose_name='last status change')),
                ('skills', models.JSONField(blank=True, default=list, verbose_name='skills')),
                ('max_concurrent_calls', models.IntegerField(default=1, validators=[django.core.validators.MinValueValidator(1)], verbose_name='max concurrent calls')),
                ('wrap_up_time', models.IntegerField(default=0, help_text='Seconds after call before available', validators=[django.core.validators.MinValueValidator(0)], verbose_name='wrap up time')),
                ('auto_answer', models.BooleanField(default=False, verbose_name='auto answer')),
                ('record_calls', models.BooleanField(default=False, verbose_name='record calls')),
                ('monitor_calls', models.BooleanField(default=False, verbose_name='monitor calls')),
                ('whisper_enabled', models.BooleanField(default=True, verbose_name='whisper enabled')),
                ('total_calls_handled', models.IntegerField(default=0, verbose_name='total calls handled')),
                ('calls_handled_today', models.IntegerField(default=0, verbose_name='calls handled today')),
                ('average_handle_time', models.IntegerField(default=0, help_text='Average handle time in seconds', verbose_name='average handle time')),
                ('average_rating', models.DecimalField(blank=True, decimal_places=2, max_digits=3, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(5)], verbose_name='average rating')),
                ('total_talk_time', models.IntegerField(default=0, help_text='Total talk time in seconds', verbose_name='total talk time')),
                ('last_call_at', models.DateTimeField(blank=True, null=True, verbose_name='last call at')),
                ('current_call', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='current_agent', to='django_twilio_call.call', verbose_name='current call')),
                ('queues', models.ManyToManyField(blank=True, related_name='agents', to='django_twilio_call.queue', verbose_name='queues')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='agent_profile', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'agent',
                'verbose_name_plural': 'agents',
                'db_table': 'django_twilio_call_agent',
                'ordering': ['user__first_name', 'user__last_name'],
                'indexes': [models.Index(fields=['status', 'last_status_change'], name='idx_agent_status')],
            },
        ),
        migrations.AddField(
            model_name='call',
            name='agent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='calls', to='django_twilio_call.agent', verbose_name='agent'),
        ),
        migrations.CreateModel(
            name='CallRecording',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('recording_sid', models.CharField(max_length=50, unique=True, verbose_name='recording SID')),
                ('account_sid', models.CharField(max_length=50, verbose_name='account SID')),
                ('recording_url', models.URLField(verbose_name='recording URL')),
                ('duration', models.IntegerField(default=0, verbose_name='duration')),
                ('channels', models.IntegerField(default=1, verbose_name='channels')),
                ('source', models.CharField(choices=[('RecordVerb', 'Record Verb'), ('DialVerb', 'Dial Verb'), ('Conference', 'Conference'), ('OutboundAPI', 'Outbound API'), ('Trunking', 'Trunking'), ('WebRTC', 'WebRTC')], max_length=20, verbose_name='source')),
                ('encryption_details', models.JSONField(blank=True, default=dict, verbose_name='encryption details')),
                ('price', models.DecimalField(blank=True, decimal_places=4, max_digits=10, null=True, verbose_name='price')),
                ('price_unit', models.CharField(blank=True, max_length=5, verbose_name='price unit')),
                ('status', models.CharField(choices=[('processing', 'Processing'), ('completed', 'Completed'), ('failed', 'Failed'), ('deleted', 'Deleted')], default='processing', max_length=20, verbose_name='status')),
                ('error_code', models.CharField(blank=True, max_length=10, verbose_name='error code')),
                ('transcription_sid', models.CharField(blank=True, max_length=50, verbose_name='transcription SID')),
                ('transcription_text', models.TextField(blank=True, verbose_name='transcription text')),
                ('transcription_status', models.CharField(blank=True, choices=[('in-progress', 'In Progress'), ('completed', 'Completed'), ('failed', 'Failed')], max_length=20, verbose_name='transcription status')),
                ('call', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='recordings', to='django_twilio_call.call', verbose_name='call')),
            ],
            options={
                'verbose_name': 'call recording',
                'verbose_name_plural': 'call recordings',
                'db_table': 'django_twilio_call_callrecording',
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='CallLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('event_type', models.CharField(choices=[('initiated', 'Call Initiated'), ('queued', 'Call Queued'), ('ringing', 'Call Ringing'), ('answered', 'Call Answered'), ('connected', 'Call Connected'), ('hold', 'Call On Hold'), ('unhold', 'Call Resumed'), ('transfer', 'Call Transferred'), ('conference', 'Call Conferenced'), ('completed', 'Call Completed'), ('failed', 'Call Failed'), ('recording_start', 'Recording Started'), ('recording_stop', 'Recording Stopped'), ('voicemail', 'Voicemail Left'), ('dtmf', 'DTMF Input'), ('speech', 'Speech Input'), ('error', 'Error Occurred')], db_index=True, max_length=30, verbose_name='event type')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('data', models.JSONField(blank=True, default=dict, help_text='Additional event-specific data', verbose_name='event data')),
                ('error_code', models.CharField(blank=True, max_length=20, verbose_name='error code')),
                ('error_message', models.TextField(blank=True, verbose_name='error message')),
                ('call', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='django_twilio_call.call', verbose_name='call')),
                ('agent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='call_logs', to='django_twilio_call.agent', verbose_name='agent')),
            ],
            options={
                'verbose_name': 'Call Log',
                'verbose_name_plural': 'Call Logs',
                'db_table': 'django_twilio_call_calllog',
                'ordering': ['call', 'created_at'],
                'indexes': [
                    models.Index(fields=['call', 'event_type'], name='idx_calllog_call_event'),
                    models.Index(fields=['created_at'], name='idx_calllog_created'),
                    models.Index(fields=['call', 'created_at'], name='idx_calllog_call_created'),
                    models.Index(fields=['event_type', 'created_at'], name='idx_calllog_event_created'),
                    models.Index(fields=['agent', 'event_type', 'created_at'], name='idx_calllog_agent_event'),
                    models.Index(fields=['call', 'event_type', 'created_at'], name='idx_calllog_call_evt_crt'),
                ],
            },
        ),
        migrations.CreateModel(
            name='AgentActivity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('activity_type', models.CharField(choices=[('login', 'Login'), ('logout', 'Logout'), ('available', 'Became Available'), ('busy', 'Became Busy'), ('break_start', 'Break Started'), ('break_end', 'Break Ended'), ('call_start', 'Call Started'), ('call_end', 'Call Ended'), ('transfer', 'Call Transferred'), ('conference', 'Conference Started'), ('training_start', 'Training Started'), ('training_end', 'Training Ended')], db_index=True, max_length=30, verbose_name='activity type')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('duration', models.IntegerField(default=0, help_text='Duration in seconds', verbose_name='duration')),
                ('metadata', models.JSONField(blank=True, default=dict, verbose_name='metadata')),
                ('agent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='activities', to='django_twilio_call.agent', verbose_name='agent')),
                ('call', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='agent_activities', to='django_twilio_call.call', verbose_name='call')),
            ],
            options={
                'verbose_name': 'Agent Activity',
                'verbose_name_plural': 'Agent Activities',
                'db_table': 'django_twilio_call_agentactivity',
                'ordering': ['-created_at'],
                'indexes': [
                    models.Index(fields=['agent', 'created_at'], name='idx_activity_agent_crt'),
                    models.Index(fields=['activity_type', 'created_at'], name='idx_activity_type_crt'),
                    models.Index(fields=['agent', 'activity_type', 'created_at'], name='idx_activity_agt_typ_crt'),
                ],
            },
        ),
        migrations.CreateModel(
            name='TaskExecution',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('task_id', models.CharField(db_index=True, max_length=100, unique=True, verbose_name='task ID')),
                ('task_name', models.CharField(db_index=True, max_length=100, verbose_name='task name')),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('running', 'Running'), ('completed', 'Completed'), ('failed', 'Failed'), ('retry', 'Retry'), ('cancelled', 'Cancelled')], db_index=True, default='pending', max_length=20, verbose_name='status')),
                ('args', models.JSONField(blank=True, default=list, verbose_name='arguments')),
                ('kwargs', models.JSONField(blank=True, default=dict, verbose_name='keyword arguments')),
                ('result', models.JSONField(blank=True, null=True, verbose_name='result')),
                ('error', models.TextField(blank=True, verbose_name='error')),
                ('traceback', models.TextField(blank=True, verbose_name='traceback')),
                ('retry_count', models.IntegerField(default=0, verbose_name='retry count')),
                ('max_retries', models.IntegerField(default=3, verbose_name='max retries')),
                ('eta', models.DateTimeField(blank=True, null=True, verbose_name='ETA')),
                ('expires', models.DateTimeField(blank=True, null=True, verbose_name='expires')),
                ('started_at', models.DateTimeField(blank=True, null=True, verbose_name='started at')),
                ('completed_at', models.DateTimeField(blank=True, null=True, verbose_name='completed at')),
                ('runtime', models.FloatField(blank=True, null=True, verbose_name='runtime')),
                ('queue_name', models.CharField(default='default', max_length=50, verbose_name='queue name')),
                ('priority', models.IntegerField(default=0, verbose_name='priority')),
                ('metadata', models.JSONField(blank=True, default=dict, verbose_name='metadata')),
            ],
            options={
                'verbose_name': 'Task Execution',
                'verbose_name_plural': 'Task Executions',
                'db_table': 'django_twilio_call_taskexecution',
                'ordering': ['-created_at'],
                'indexes': [
                    models.Index(fields=['task_name', 'status'], name='idx_task_name_status'),
                    models.Index(fields=['status', 'created_at'], name='idx_task_status_created'),
                    models.Index(fields=['queue_name', 'status', 'priority'], name='idx_task_queue_priority'),
                ],
            },
        ),
        migrations.CreateModel(
            name='WebhookLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, unique=True, verbose_name='public ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='updated at')),
                ('webhook_type', models.CharField(db_index=True, max_length=50, verbose_name='webhook type')),
                ('url', models.URLField(verbose_name='URL')),
                ('method', models.CharField(default='POST', max_length=10, verbose_name='method')),
                ('headers', models.JSONField(blank=True, default=dict, verbose_name='headers')),
                ('payload', models.JSONField(blank=True, default=dict, verbose_name='payload')),
                ('response_status', models.IntegerField(blank=True, null=True, verbose_name='response status')),
                ('response_body', models.TextField(blank=True, verbose_name='response body')),
                ('response_time', models.FloatField(blank=True, null=True, verbose_name='response time')),
                ('is_success', models.BooleanField(default=False, verbose_name='is success')),
                ('error_message', models.TextField(blank=True, verbose_name='error message')),
                ('retry_count', models.IntegerField(default=0, verbose_name='retry count')),
                ('max_retries', models.IntegerField(default=3, verbose_name='max retries')),
                ('signature', models.CharField(blank=True, max_length=100, verbose_name='signature')),
                ('is_verified', models.BooleanField(default=False, verbose_name='is verified')),
                ('metadata', models.JSONField(blank=True, default=dict, verbose_name='metadata')),
                ('call', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='webhook_logs', to='django_twilio_call.call', verbose_name='call')),
            ],
            options={
                'verbose_name': 'Webhook Log',
                'verbose_name_plural': 'Webhook Logs',
                'db_table': 'django_twilio_call_webhooklog',
                'ordering': ['-created_at'],
                'indexes': [
                    models.Index(fields=['webhook_type', 'created_at'], name='idx_webhook_type_created'),
                    models.Index(fields=['is_success', 'created_at'], name='idx_webhook_success_crt'),
                    models.Index(fields=['call', 'webhook_type'], name='idx_webhook_call_type'),
                ],
            },
        ),
    ]