# Generated by Django 3.1.7 on 2021-05-08 15:44

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("django_sql_dashboard", "0002_dashboard_permissions"),
    ]

    operations = [
        migrations.AlterField(
            model_name="dashboard",
            name="edit_group",
            field=models.ForeignKey(
                blank=True,
                help_text="Group that can edit, for 'Users in group' policy",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="can_edit_dashboards",
                to="auth.group",
            ),
        ),
        migrations.AlterField(
            model_name="dashboard",
            name="edit_policy",
            field=models.CharField(
                choices=[
                    ("private", "Private"),
                    ("loggedin", "Logged-in users"),
                    ("group", "Users in group"),
                    ("staff", "Staff users"),
                    ("superuser", "Superusers"),
                ],
                default="private",
                help_text="Who can edit this dashboard",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="dashboard",
            name="owned_by",
            field=models.ForeignKey(
                blank=True,
                help_text="User who owns this dashboard",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="owned_dashboards",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AlterField(
            model_name="dashboard",
            name="view_group",
            field=models.ForeignKey(
                blank=True,
                help_text="Group that can view, for 'Users in group' policy",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="can_view_dashboards",
                to="auth.group",
            ),
        ),
        migrations.AlterField(
            model_name="dashboard",
            name="view_policy",
            field=models.CharField(
                choices=[
                    ("private", "Private"),
                    ("public", "Public"),
                    ("unlisted", "Unlisted"),
                    ("loggedin", "Logged-in users"),
                    ("group", "Users in group"),
                    ("staff", "Staff users"),
                    ("superuser", "Superusers"),
                ],
                default="private",
                help_text="Who can view this dashboard",
                max_length=10,
            ),
        ),
    ]
