class Trace:
    """
    Represents a trace of a trading strategy. A trace contains
    data that has been generated by a trading strategy during its
    execution.

    The data can be used to analyze the performance of the trading after
    it has been executed. Usually, the data contains metrics that
    have been generated by the trading strategy during its execution,
    and the signals that have been generated.
    """

    def __init__(
        self,
        strategy_id: str,
        symbol: str,
        data,
        drop_duplicates=True
    ):
        self.strategy_id = strategy_id
        self.symbol = symbol
        self.data = data
        self.drop_duplicates = drop_duplicates
