# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import httpx

from ..._types import NOT_GIVEN, Body, Query, Headers, NotGiven
from ..._utils import maybe_transform, async_maybe_transform
from ..._compat import cached_property
from ...types.v1 import assignment_grader_create_params
from ..._resource import SyncAPIResource, AsyncAPIResource
from ..._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ..._base_client import make_request_options
from ...types.v1.assignment_grader_response import AssignmentGraderResponse
from ...types.v1.assignment_grader_get_all_response import AssignmentGraderGetAllResponse

__all__ = ["AssignmentGraderResource", "AsyncAssignmentGraderResource"]


class AssignmentGraderResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AssignmentGraderResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/GoStudyFetchGo/studyfetch-sdk-python#accessing-raw-response-data-eg-headers
        """
        return AssignmentGraderResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AssignmentGraderResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/GoStudyFetchGo/studyfetch-sdk-python#with_streaming_response
        """
        return AssignmentGraderResourceWithStreamingResponse(self)

    def create(
        self,
        *,
        rubric: assignment_grader_create_params.Rubric,
        title: str,
        material_id: str | NotGiven = NOT_GIVEN,
        model: str | NotGiven = NOT_GIVEN,
        text_to_grade: str | NotGiven = NOT_GIVEN,
        user_id: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AssignmentGraderResponse:
        """
        Grade a new assignment

        Args:
          rubric: Grading rubric

          title: Title of the assignment

          material_id: Material ID to grade

          model: AI model to use

          text_to_grade: Text content to grade

          user_id: User ID for tracking

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._post(
            "/api/v1/assignment-grader/create",
            body=maybe_transform(
                {
                    "rubric": rubric,
                    "title": title,
                    "material_id": material_id,
                    "model": model,
                    "text_to_grade": text_to_grade,
                    "user_id": user_id,
                },
                assignment_grader_create_params.AssignmentGraderCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AssignmentGraderResponse,
        )

    def get_all(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AssignmentGraderGetAllResponse:
        """Get all assignment graders"""
        return self._get(
            "/api/v1/assignment-grader/get",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AssignmentGraderGetAllResponse,
        )

    def get_by_id(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AssignmentGraderResponse:
        """
        Get an assignment grader by ID

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return self._get(
            f"/api/v1/assignment-grader/get/{id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AssignmentGraderResponse,
        )


class AsyncAssignmentGraderResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncAssignmentGraderResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/GoStudyFetchGo/studyfetch-sdk-python#accessing-raw-response-data-eg-headers
        """
        return AsyncAssignmentGraderResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncAssignmentGraderResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/GoStudyFetchGo/studyfetch-sdk-python#with_streaming_response
        """
        return AsyncAssignmentGraderResourceWithStreamingResponse(self)

    async def create(
        self,
        *,
        rubric: assignment_grader_create_params.Rubric,
        title: str,
        material_id: str | NotGiven = NOT_GIVEN,
        model: str | NotGiven = NOT_GIVEN,
        text_to_grade: str | NotGiven = NOT_GIVEN,
        user_id: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AssignmentGraderResponse:
        """
        Grade a new assignment

        Args:
          rubric: Grading rubric

          title: Title of the assignment

          material_id: Material ID to grade

          model: AI model to use

          text_to_grade: Text content to grade

          user_id: User ID for tracking

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return await self._post(
            "/api/v1/assignment-grader/create",
            body=await async_maybe_transform(
                {
                    "rubric": rubric,
                    "title": title,
                    "material_id": material_id,
                    "model": model,
                    "text_to_grade": text_to_grade,
                    "user_id": user_id,
                },
                assignment_grader_create_params.AssignmentGraderCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AssignmentGraderResponse,
        )

    async def get_all(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AssignmentGraderGetAllResponse:
        """Get all assignment graders"""
        return await self._get(
            "/api/v1/assignment-grader/get",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AssignmentGraderGetAllResponse,
        )

    async def get_by_id(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AssignmentGraderResponse:
        """
        Get an assignment grader by ID

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return await self._get(
            f"/api/v1/assignment-grader/get/{id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AssignmentGraderResponse,
        )


class AssignmentGraderResourceWithRawResponse:
    def __init__(self, assignment_grader: AssignmentGraderResource) -> None:
        self._assignment_grader = assignment_grader

        self.create = to_raw_response_wrapper(
            assignment_grader.create,
        )
        self.get_all = to_raw_response_wrapper(
            assignment_grader.get_all,
        )
        self.get_by_id = to_raw_response_wrapper(
            assignment_grader.get_by_id,
        )


class AsyncAssignmentGraderResourceWithRawResponse:
    def __init__(self, assignment_grader: AsyncAssignmentGraderResource) -> None:
        self._assignment_grader = assignment_grader

        self.create = async_to_raw_response_wrapper(
            assignment_grader.create,
        )
        self.get_all = async_to_raw_response_wrapper(
            assignment_grader.get_all,
        )
        self.get_by_id = async_to_raw_response_wrapper(
            assignment_grader.get_by_id,
        )


class AssignmentGraderResourceWithStreamingResponse:
    def __init__(self, assignment_grader: AssignmentGraderResource) -> None:
        self._assignment_grader = assignment_grader

        self.create = to_streamed_response_wrapper(
            assignment_grader.create,
        )
        self.get_all = to_streamed_response_wrapper(
            assignment_grader.get_all,
        )
        self.get_by_id = to_streamed_response_wrapper(
            assignment_grader.get_by_id,
        )


class AsyncAssignmentGraderResourceWithStreamingResponse:
    def __init__(self, assignment_grader: AsyncAssignmentGraderResource) -> None:
        self._assignment_grader = assignment_grader

        self.create = async_to_streamed_response_wrapper(
            assignment_grader.create,
        )
        self.get_all = async_to_streamed_response_wrapper(
            assignment_grader.get_all,
        )
        self.get_by_id = async_to_streamed_response_wrapper(
            assignment_grader.get_by_id,
        )
