"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingletonCfnLaunchTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * An Amazon S3 Bucket implementing the singleton pattern
 */
class SingletonCfnLaunchTemplate extends aws_ec2_1.CfnLaunchTemplate {
    static getOrCreate(scope, name, data) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = `${name}`;
        return stack.node.tryFindChild(id) || new aws_ec2_1.CfnLaunchTemplate(stack, id, {
            launchTemplateName: name,
            launchTemplateData: {
                userData: data,
            },
        });
    }
}
exports.SingletonCfnLaunchTemplate = SingletonCfnLaunchTemplate;
_a = JSII_RTTI_SYMBOL_1;
SingletonCfnLaunchTemplate[_a] = { fqn: "aws-analytics-reference-architecture.SingletonCfnLaunchTemplate", version: "2.10.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2luZ2xldG9uLWxhdW5jaC10ZW1wbGF0ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9zaW5nbGV0b24tbGF1bmNoLXRlbXBsYXRlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEscUVBQXFFO0FBQ3JFLGlDQUFpQztBQUVqQyxpREFBd0Q7QUFDeEQsNkNBQW9DO0FBR3BDOztHQUVHO0FBQ0gsTUFBYSwwQkFBMkIsU0FBUSwyQkFBaUI7SUFFeEQsTUFBTSxDQUFDLFdBQVcsQ0FBQyxLQUFnQixFQUFFLElBQVksRUFBRSxJQUFZO1FBQ3BFLE1BQU0sS0FBSyxHQUFHLG1CQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzlCLE1BQU0sRUFBRSxHQUFHLEdBQUcsSUFBSSxFQUFFLENBQUM7UUFDckIsT0FBTyxLQUFLLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQXNCLElBQUksSUFBSSwyQkFBaUIsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQzFGLGtCQUFrQixFQUFFLElBQUk7WUFDeEIsa0JBQWtCLEVBQUU7Z0JBQ2xCLFFBQVEsRUFBRSxJQUFJO2FBQ2Y7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDOztBQVhILGdFQVlDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTUlULTBcblxuaW1wb3J0IHsgQ2ZuTGF1bmNoVGVtcGxhdGUgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtZWMyJztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogQW4gQW1hem9uIFMzIEJ1Y2tldCBpbXBsZW1lbnRpbmcgdGhlIHNpbmdsZXRvbiBwYXR0ZXJuXG4gKi9cbmV4cG9ydCBjbGFzcyBTaW5nbGV0b25DZm5MYXVuY2hUZW1wbGF0ZSBleHRlbmRzIENmbkxhdW5jaFRlbXBsYXRlIHtcblxuICBwdWJsaWMgc3RhdGljIGdldE9yQ3JlYXRlKHNjb3BlOiBDb25zdHJ1Y3QsIG5hbWU6IHN0cmluZywgZGF0YTogc3RyaW5nKSB7XG4gICAgY29uc3Qgc3RhY2sgPSBTdGFjay5vZihzY29wZSk7XG4gICAgY29uc3QgaWQgPSBgJHtuYW1lfWA7XG4gICAgcmV0dXJuIHN0YWNrLm5vZGUudHJ5RmluZENoaWxkKGlkKSBhcyBDZm5MYXVuY2hUZW1wbGF0ZSB8fCBuZXcgQ2ZuTGF1bmNoVGVtcGxhdGUoc3RhY2ssIGlkLCB7XG4gICAgICBsYXVuY2hUZW1wbGF0ZU5hbWU6IG5hbWUsXG4gICAgICBsYXVuY2hUZW1wbGF0ZURhdGE6IHtcbiAgICAgICAgdXNlckRhdGE6IGRhdGEsXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59Il19