"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingletonKey = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * An Amazon S3 Bucket implementing the singleton pattern
 */
class SingletonKey extends aws_kms_1.Key {
    /**
       * Get the Amazon KMS Key the AWS CDK Stack based on the provided name.
       * If no key exists, it creates a new one.
       */
    static getOrCreate(scope, keyName) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = `${keyName}`;
        const stackKey = stack.node.tryFindChild(id) ?? (stack.nestedStackParent ? stack.nestedStackParent.node.tryFindChild(id) : undefined);
        return stackKey || new aws_kms_1.Key(stack, id, {
            enableKeyRotation: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
        });
    }
}
exports.SingletonKey = SingletonKey;
_a = JSII_RTTI_SYMBOL_1;
SingletonKey[_a] = { fqn: "aws-analytics-reference-architecture.SingletonKey", version: "2.10.1" };
//# sourceMappingURL=data:application/json;base64,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