import { Vpc } from 'aws-cdk-lib/aws-ec2';
import { Construct } from 'constructs';
/**
 * @internal
 * Upload podTemplates to the Amazon S3 location used by the cluster.
 * @param {Construct} scope The local path of the yaml podTemplate files to upload
 * @param {string} vpcCidr The cidr for vpc
 * @param {string} eksClusterName The name used to tag the subnet and vpc
 */
export declare function vpcBootstrap(scope: Construct, vpcCidr: string, eksClusterName: string): Vpc;
