"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrEksNodegroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_eks_1 = require("aws-cdk-lib/aws-eks");
/**
 * @summary EmrEksNodegroup containing the default Nodegroups
 */
class EmrEksNodegroup {
}
exports.EmrEksNodegroup = EmrEksNodegroup;
_a = JSII_RTTI_SYMBOL_1;
EmrEksNodegroup[_a] = { fqn: "aws-analytics-reference-architecture.EmrEksNodegroup", version: "2.10.1" };
/*
 ** Default nodegroup configuration for Kubernetes applications required by EMR on EKS (e.g cert manager and cluster autoscaler)
 */
EmrEksNodegroup.TOOLING_ALL = {
    nodegroupName: 'tooling',
    instanceTypes: [new aws_ec2_1.InstanceType('t3.medium')],
    amiType: aws_eks_1.NodegroupAmiType.AL2_X86_64,
    minSize: 2,
    maxSize: 10,
    labels: { role: 'tooling' },
};
/**
 * Default nodegroup configuration for EMR on EKS critical workloads (both drivers and executors)
 */
EmrEksNodegroup.CRITICAL_ALL = {
    nodegroupName: 'critical',
    mountNvme: true,
    instanceTypes: [new aws_ec2_1.InstanceType('m6gd.8xlarge')],
    amiType: aws_eks_1.NodegroupAmiType.AL2_ARM_64,
    minSize: 0,
    maxSize: 100,
    labels: {
        'role': 'critical',
        'node-lifecycle': 'on-demand',
    },
    taints: [
        {
            key: 'role',
            value: 'critical',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
    ],
};
/**
 * Default nodegroup configuration for EMR on EKS shared (non-crtical) workloads (drivers only)
 */
EmrEksNodegroup.SHARED_DRIVER = {
    nodegroupName: 'shared-driver',
    instanceTypes: [new aws_ec2_1.InstanceType('m6g.xlarge')],
    amiType: aws_eks_1.NodegroupAmiType.AL2_ARM_64,
    minSize: 0,
    maxSize: 10,
    labels: {
        'role': 'shared',
        'spark-role': 'driver',
        'node-lifecycle': 'on-demand',
    },
    taints: [
        {
            key: 'role',
            value: 'shared',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
    ],
};
/**
 * Default nodegroup configuration for EMR on EKS shared (non-crtical) workloads (executors only)
 */
EmrEksNodegroup.SHARED_EXECUTOR = {
    nodegroupName: 'shared-executor',
    instanceTypes: [new aws_ec2_1.InstanceType('m6g.8xlarge'), new aws_ec2_1.InstanceType('m6gd.8xlarge')],
    minSize: 0,
    maxSize: 100,
    capacityType: aws_eks_1.CapacityType.SPOT,
    amiType: aws_eks_1.NodegroupAmiType.AL2_ARM_64,
    labels: {
        'role': 'shared',
        'spark-role': 'executor',
        'node-lifecycle': 'spot',
    },
    taints: [
        {
            key: 'role',
            value: 'shared',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
        {
            key: 'node-lifecycle',
            value: 'spot',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
    ],
};
/**
 * Default nodegroup configuration for EMR Studio notebooks used with EMR on EKS (executors only)
 */
EmrEksNodegroup.NOTEBOOK_EXECUTOR = {
    nodegroupName: 'notebook-executor',
    instanceTypes: [new aws_ec2_1.InstanceType('t3.2xlarge'), new aws_ec2_1.InstanceType('t3a.2xlarge')],
    minSize: 0,
    maxSize: 100,
    capacityType: aws_eks_1.CapacityType.SPOT,
    amiType: aws_eks_1.NodegroupAmiType.AL2_X86_64,
    labels: {
        'role': 'notebook',
        'spark-role': 'executor',
        'node-lifecycle': 'spot',
    },
    taints: [
        {
            key: 'role',
            value: 'notebook',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
        {
            key: 'node-lifecycle',
            value: 'spot',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
    ],
};
/**
 * Default nodegroup configuration for EMR Studio notebooks used with EMR on EKS (drivers only)
 */
EmrEksNodegroup.NOTEBOOK_DRIVER = {
    nodegroupName: 'notebook-driver',
    instanceTypes: [new aws_ec2_1.InstanceType('t3.large')],
    amiType: aws_eks_1.NodegroupAmiType.AL2_X86_64,
    minSize: 0,
    maxSize: 10,
    labels: {
        'role': 'notebook',
        'spark-role': 'driver',
        'node-lifecycle': 'on-demand',
    },
    taints: [
        {
            key: 'role',
            value: 'notebook',
            effect: aws_eks_1.TaintEffect.NO_SCHEDULE,
        },
    ],
};
/**
 * Default nodegroup configuration for EMR Studio notebooks used with EMR on EKS
 * This nodegroup is replacing [NOTEBOOK_DRIVER]{@link EmrEksNodegroup.NOTEBOOK_DRIVER}
 * and [NOTEBOOK_EXECUTOR]{@link EmrEksNodegroup.NOTEBOOK_EXECUTOR} because EMR on EKS
 * Managed Endpoint currently doesn't support Pod Template customization
 */
EmrEksNodegroup.NOTEBOOK_WITHOUT_PODTEMPLATE = {
    nodegroupName: 'notebook-without-pod-template',
    instanceTypes: [new aws_ec2_1.InstanceType('t3.2xlarge'), new aws_ec2_1.InstanceType('t3a.2xlarge')],
    amiType: aws_eks_1.NodegroupAmiType.AL2_X86_64,
    minSize: 0,
    maxSize: 100,
    capacityType: aws_eks_1.CapacityType.SPOT,
    labels: {
        'role': 'notebook',
        'node-lifecycle': 'spot',
    },
};
//# sourceMappingURL=data:application/json;base64,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