import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { BuildSpec } from 'aws-cdk-lib/aws-codebuild';
import { Location } from 'aws-cdk-lib/aws-s3';
/**
 * @deprecated The enum should not be used. Use https://github.com/flochaz/cdk-standalone-deployer
 */
export declare enum DeploymentType {
    WORKSHOP_STUDIO = 0,
    CLICK_TO_DEPLOY = 1
}
/**
 * @deprecated The enum should not be used. Use https://github.com/flochaz/cdk-standalone-deployer
 * The properties for the CdkDeployer construct.
 */
export interface CdkDeployerProps extends cdk.StackProps {
    /**
     * The CDK stack name to deploy
     * @default - The default stack is deployed
     */
    readonly cdkStack?: string;
    /**
     * The CFN parameters to pass to the CDK application
     * @default - No parameter is used
     */
    readonly cdkParameters?: {
        [name: string]: cdk.CfnParameterProps;
    };
    /**
     * The github repository containing the CDK application.
     * Either `githubRepository` or `s3Repository` needs to be set if `deploymentType` is `CLICK_TO_DEPLOY`.
     * @default - Github is not used as the source of the CDK code.
     */
    readonly githubRepository?: string;
    /**
     * The branch to use on the Github repository.
     * @default - The main branch of the repository
     */
    readonly gitBranch?: string;
    /**
     * The Amazon S3 repository location containing the CDK application. The object key is a Zip file.
     * Either `githubRepository` or `s3Repository` needs to be set if `deploymentType` is `CLICK_TO_DEPLOY`.
     * @default -  S3 is not used as the source of the CDK code
     */
    readonly s3Repository?: Location;
    /**
     * The location of the CDK application in the repository.
     * It is used to `cd` into the folder before deploying the CDK application
     * @default - The root of the repository
     */
    readonly cdkAppLocation?: string;
    /**
     * The deployment type
     * WORKSHOP_STUDIO: the CDK application is deployed through a workshop studio deployment process
     * CLICK_TO_DEPLOY: the CDK application is deployed through a one-click deploy button
     */
    readonly deploymentType: DeploymentType;
    /**
     * Deploy CodeBuild buildspec file name at the root of the cdk app folder
     */
    readonly deployBuildSpec?: BuildSpec;
    /**
     * Destroy Codebuild buildspec file name at the root of the cdk app folder
     */
    readonly destroyBuildSpec?: BuildSpec;
}
/**
 * A custom CDK Stack that can be synthetized as a CloudFormation Stack to deploy a CDK application hosted on GitHub or on S3 as a Zip file.
 * This stack is self contained and can be one-click deployed to any AWS account.
 * It can be used for AWS workshop or AWS blog examples deployment when CDK is not supported/desired.
 * The stack supports passing the CDK application stack name to deploy (in case there are multiple stacks in the CDK app) and CDK parameters.
 *
 * It contains the necessary resources to synchronously deploy a CDK application from a GitHub repository:
 *  * A CodeBuild project to effectively deploy the CDK application
 *  * A StartBuild custom resource to synchronously triggers the build using a callback pattern based on Event Bridge
 *  * The necessary roles and permissions
 *
 * The StartBuild CFN custom resource is using the callback pattern to wait for the build completion:
 *  1. a Lambda function starts the build but doesn't return any value to the CFN callback URL. Instead, the callback URL is passed to the build project.
 *  2. the completion of the build triggers an Event and a second Lambda function which checks the result of the build and send information to the CFN callback URL
 *
 *  * Usage example:
 * ```typescript
 * new CdkDeployer(AwsNativeRefArchApp, 'AwsNativeRefArchDeployer', {
 *  githubRepository: 'aws-samples/aws-analytics-reference-architecture',
 *  cdkAppLocation: 'refarch/aws-native',
 *  cdkParameters: {
 *    QuickSightUsername: {
 *      default: 'myuser',
 *      type: 'String',
 *    },
 *    QuickSightIdentityRegion: {
 *      default: 'us-east-1',
 *      type: 'String',
 *    },
 *  },
 * });
 * ```
 */
export declare class CdkDeployer extends cdk.Stack {
    /**
     * The result of the deloyment
     */
    readonly deployResult: string;
    /**
     * Constructs a new instance of the TrackedConstruct
     * @param {Construct} scope the Scope of the CDK Construct
     * @param {string} id the ID of the CDK Construct
     * @param {CdkDeployerProps} props the CdkDeployer [properties]{@link CdkDeployerProps}
     */
    constructor(scope: Construct, props: CdkDeployerProps);
}
