﻿"""
GUIDE AI Ethics Framework

G - Governance
U - Understanding
I - Integrity
D - Disclosure
E - Equity

This package provides:
- Ethical AI Auditing
- Governance & Compliance Tools
- Explainability (XAI)
- Transparency Reports
- GUIDE Principle-Based Assessments
"""

__version__ = "1.0.6"
__author__ = "GUIDE Ethics Team"

# Ethical AI Audit Tools
from .auditor import EthicalAIAudit

# Explainability (XAI)
from .xai_meaning import ExplainabilityGuide

# Public API
__all__ = [
    "EthicalAIAudit",
    "ExplainabilityGuide",
]
