import BaseStyle from '@primevue/core/base/style';

var theme = function theme(_ref) {
  var dt = _ref.dt;
  return "\n.p-card {\n    background: ".concat(dt('card.background'), ";\n    color: ").concat(dt('card.color'), ";\n    box-shadow: ").concat(dt('card.shadow'), ";\n    border-radius: ").concat(dt('card.border.radius'), ";\n    display: flex;\n    flex-direction: column;\n}\n\n.p-card-caption {\n    display: flex;\n    flex-direction: column;\n    gap: ").concat(dt('card.caption.gap'), ";\n}\n\n.p-card-body {\n    padding: ").concat(dt('card.body.padding'), ";\n    display: flex;\n    flex-direction: column;\n    gap: ").concat(dt('card.body.gap'), ";\n}\n\n.p-card-title {\n    font-size: ").concat(dt('card.title.font.size'), ";\n    font-weight: ").concat(dt('card.title.font.weight'), ";\n}\n\n.p-card-subtitle {\n    color: ").concat(dt('card.subtitle.color'), ";\n}\n");
};
var classes = {
  root: 'p-card p-component',
  header: 'p-card-header',
  body: 'p-card-body',
  caption: 'p-card-caption',
  title: 'p-card-title',
  subtitle: 'p-card-subtitle',
  content: 'p-card-content',
  footer: 'p-card-footer'
};
var CardStyle = BaseStyle.extend({
  name: 'card',
  theme: theme,
  classes: classes
});

export { CardStyle as default };
//# sourceMappingURL=index.mjs.map
