var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};

// src/object/methods/isEmpty.ts
function isEmpty(value) {
  return value === null || value === void 0 || value === "" || Array.isArray(value) && value.length === 0 || !(value instanceof Date) && typeof value === "object" && Object.keys(value).length === 0;
}

// src/object/methods/compare.ts
function compare(value1, value2, comparator, order = 1) {
  let result = -1;
  const emptyValue1 = isEmpty(value1);
  const emptyValue2 = isEmpty(value2);
  if (emptyValue1 && emptyValue2) result = 0;
  else if (emptyValue1) result = order;
  else if (emptyValue2) result = -order;
  else if (typeof value1 === "string" && typeof value2 === "string") result = comparator(value1, value2);
  else result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
  return result;
}

// src/object/methods/deepEquals.ts
function deepEquals(obj1, obj2) {
  if (obj1 === obj2) return true;
  if (obj1 && obj2 && typeof obj1 == "object" && typeof obj2 == "object") {
    var arrObj1 = Array.isArray(obj1), arrObj2 = Array.isArray(obj2), i, length, key;
    if (arrObj1 && arrObj2) {
      length = obj1.length;
      if (length != obj2.length) return false;
      for (i = length; i-- !== 0; ) if (!deepEquals(obj1[i], obj2[i])) return false;
      return true;
    }
    if (arrObj1 != arrObj2) return false;
    var dateObj1 = obj1 instanceof Date, dateObj2 = obj2 instanceof Date;
    if (dateObj1 != dateObj2) return false;
    if (dateObj1 && dateObj2) return obj1.getTime() == obj2.getTime();
    var regexpObj1 = obj1 instanceof RegExp, regexpObj2 = obj2 instanceof RegExp;
    if (regexpObj1 != regexpObj2) return false;
    if (regexpObj1 && regexpObj2) return obj1.toString() == obj2.toString();
    var keys = Object.keys(obj1);
    length = keys.length;
    if (length !== Object.keys(obj2).length) return false;
    for (i = length; i-- !== 0; ) if (!Object.prototype.hasOwnProperty.call(obj2, keys[i])) return false;
    for (i = length; i-- !== 0; ) {
      key = keys[i];
      if (!deepEquals(obj1[key], obj2[key])) return false;
    }
    return true;
  }
  return obj1 !== obj1 && obj2 !== obj2;
}

// src/object/methods/isFunction.ts
function isFunction(value) {
  return !!(value && value.constructor && value.call && value.apply);
}

// src/object/methods/isNotEmpty.ts
function isNotEmpty(value) {
  return !isEmpty(value);
}

// src/object/methods/resolveFieldData.ts
function resolveFieldData(data, field) {
  if (!data || !field) {
    return null;
  }
  try {
    const value = data[field];
    if (isNotEmpty(value)) return value;
  } catch (e) {
  }
  if (Object.keys(data).length) {
    if (isFunction(field)) {
      return field(data);
    } else if (field.indexOf(".") === -1) {
      return data[field];
    } else {
      let fields = field.split(".");
      let value = data;
      for (let i = 0, len = fields.length; i < len; ++i) {
        if (value == null) {
          return null;
        }
        value = value[fields[i]];
      }
      return value;
    }
  }
  return null;
}

// src/object/methods/equals.ts
function equals(obj1, obj2, field) {
  if (field) return resolveFieldData(obj1, field) === resolveFieldData(obj2, field);
  else return deepEquals(obj1, obj2);
}

// src/object/methods/contains.ts
function contains(value, list) {
  if (value != null && list && list.length) {
    for (let val of list) {
      if (equals(value, val)) return true;
    }
  }
  return false;
}

// src/object/methods/filter.ts
function filter(value, fields, filterValue) {
  let filteredItems = [];
  if (value) {
    for (let item of value) {
      for (let field of fields) {
        if (String(resolveFieldData(item, field)).toLowerCase().indexOf(filterValue.toLowerCase()) > -1) {
          filteredItems.push(item);
          break;
        }
      }
    }
  }
  return filteredItems;
}

// src/object/methods/findIndexInList.ts
function findIndexInList(value, list) {
  let index = -1;
  if (list) {
    for (let i = 0; i < list.length; i++) {
      if (list[i] === value) {
        index = i;
        break;
      }
    }
  }
  return index;
}

// src/object/methods/findLast.ts
function findLast(arr, callback) {
  let item;
  if (isNotEmpty(arr)) {
    try {
      item = arr.findLast(callback);
    } catch (e) {
      item = [...arr].reverse().find(callback);
    }
  }
  return item;
}

// src/object/methods/findLastIndex.ts
function findLastIndex(arr, callback) {
  let index = -1;
  if (isNotEmpty(arr)) {
    try {
      index = arr.findLastIndex(callback);
    } catch (e) {
      index = arr.lastIndexOf([...arr].reverse().find(callback));
    }
  }
  return index;
}

// src/object/methods/isObject.ts
function isObject(value, empty = true) {
  return value instanceof Object && value.constructor === Object && (empty || Object.keys(value).length !== 0);
}

// src/object/methods/resolve.ts
function resolve(obj, ...params) {
  return isFunction(obj) ? obj(...params) : obj;
}

// src/object/methods/isString.ts
function isString(value, empty = true) {
  return typeof value === "string" && (empty || value !== "");
}

// src/object/methods/toFlatCase.ts
function toFlatCase(str) {
  return isString(str) ? str.replace(/(-|_)/g, "").toLowerCase() : str;
}

// src/object/methods/getKeyValue.ts
function getKeyValue(obj, key = "", params = {}) {
  const fKeys = toFlatCase(key).split(".");
  const fKey = fKeys.shift();
  return fKey ? isObject(obj) ? getKeyValue(resolve(obj[Object.keys(obj).find((k) => toFlatCase(k) === fKey) || ""], params), fKeys.join("."), params) : void 0 : resolve(obj, params);
}

// src/object/methods/insertIntoOrderedArray.ts
function insertIntoOrderedArray(item, index, arr, sourceArr) {
  if (arr.length > 0) {
    let injected = false;
    for (let i = 0; i < arr.length; i++) {
      let currentItemIndex = findIndexInList(arr[i], sourceArr);
      if (currentItemIndex > index) {
        arr.splice(i, 0, item);
        injected = true;
        break;
      }
    }
    if (!injected) {
      arr.push(item);
    }
  } else {
    arr.push(item);
  }
}

// src/object/methods/isArray.ts
function isArray(value, empty = true) {
  return Array.isArray(value) && (empty || value.length !== 0);
}

// src/object/methods/isDate.ts
function isDate(value) {
  return value instanceof Date && value.constructor === Date;
}

// src/object/methods/isNumber.ts
function isNumber(value) {
  return isNotEmpty(value) && !isNaN(value);
}

// src/object/methods/isPrintableCharacter.ts
function isPrintableCharacter(char = "") {
  return isNotEmpty(char) && char.length === 1 && !!char.match(/\S| /);
}

// src/object/methods/localeComparator.ts
function localeComparator() {
  return new Intl.Collator(void 0, { numeric: true }).compare;
}

// src/object/methods/matchRegex.ts
function matchRegex(str, regex) {
  if (regex) {
    const match = regex.test(str);
    regex.lastIndex = 0;
    return match;
  }
  return false;
}

// src/object/methods/mergeKeys.ts
function mergeKeys(...args) {
  const _mergeKeys = (target = {}, source = {}) => {
    const mergedObj = __spreadValues({}, target);
    Object.keys(source).forEach((key) => {
      if (isObject(source[key]) && key in target && isObject(target[key])) {
        mergedObj[key] = _mergeKeys(target[key], source[key]);
      } else {
        mergedObj[key] = source[key];
      }
    });
    return mergedObj;
  };
  return args.reduce((acc, obj, i) => i === 0 ? obj : _mergeKeys(acc, obj), {});
}

// src/object/methods/minifyCSS.ts
function minifyCSS(css) {
  return css ? css.replace(/\/\*(?:(?!\*\/)[\s\S])*\*\/|[\r\n\t]+/g, "").replace(/ {2,}/g, " ").replace(/ ([{:}]) /g, "$1").replace(/([;,]) /g, "$1").replace(/ !/g, "!").replace(/: /g, ":") : css;
}

// src/object/methods/nestedKeys.ts
function nestedKeys(obj = {}, parentKey = "") {
  return Object.entries(obj).reduce((o, [key, value]) => {
    const currentKey = parentKey ? `${parentKey}.${key}` : key;
    isObject(value) ? o = o.concat(nestedKeys(value, currentKey)) : o.push(currentKey);
    return o;
  }, []);
}

// src/object/methods/removeAccents.ts
function removeAccents(str) {
  if (str && str.search(/[\xC0-\xFF]/g) > -1) {
    str = str.replace(/[\xC0-\xC5]/g, "A").replace(/[\xC6]/g, "AE").replace(/[\xC7]/g, "C").replace(/[\xC8-\xCB]/g, "E").replace(/[\xCC-\xCF]/g, "I").replace(/[\xD0]/g, "D").replace(/[\xD1]/g, "N").replace(/[\xD2-\xD6\xD8]/g, "O").replace(/[\xD9-\xDC]/g, "U").replace(/[\xDD]/g, "Y").replace(/[\xDE]/g, "P").replace(/[\xE0-\xE5]/g, "a").replace(/[\xE6]/g, "ae").replace(/[\xE7]/g, "c").replace(/[\xE8-\xEB]/g, "e").replace(/[\xEC-\xEF]/g, "i").replace(/[\xF1]/g, "n").replace(/[\xF2-\xF6\xF8]/g, "o").replace(/[\xF9-\xFC]/g, "u").replace(/[\xFE]/g, "p").replace(/[\xFD\xFF]/g, "y");
  }
  return str;
}

// src/object/methods/reorderArray.ts
function reorderArray(value, from, to) {
  if (value && from !== to) {
    if (to >= value.length) {
      to %= value.length;
      from %= value.length;
    }
    value.splice(to, 0, value.splice(from, 1)[0]);
  }
}

// src/object/methods/sort.ts
function sort(value1, value2, order = 1, comparator, nullSortOrder = 1) {
  const result = compare(value1, value2, comparator, order);
  let finalSortOrder = order;
  if (isEmpty(value1) || isEmpty(value2)) {
    finalSortOrder = nullSortOrder === 1 ? order : nullSortOrder;
  }
  return finalSortOrder * result;
}

// src/object/methods/stringify.ts
function stringify(value, indent = 2, currentIndent = 0) {
  const currentIndentStr = " ".repeat(currentIndent);
  const nextIndentStr = " ".repeat(currentIndent + indent);
  if (isArray(value)) {
    return "[" + value.map((v) => stringify(v, indent, currentIndent + indent)).join(", ") + "]";
  } else if (isDate(value)) {
    return value.toISOString();
  } else if (isFunction(value)) {
    return value.toString();
  } else if (isObject(value)) {
    return "{\n" + Object.entries(value).map(([k, v]) => `${nextIndentStr}${k}: ${stringify(v, indent, currentIndent + indent)}`).join(",\n") + `
${currentIndentStr}}`;
  } else {
    return JSON.stringify(value);
  }
}

// src/object/methods/toCapitalCase.ts
function toCapitalCase(str) {
  return isString(str, false) ? str[0].toUpperCase() + str.slice(1) : str;
}

// src/object/methods/toKebabCase.ts
function toKebabCase(str) {
  return isString(str) ? str.replace(/(_)/g, "-").replace(/[A-Z]/g, (c, i) => i === 0 ? c : "-" + c.toLowerCase()).toLowerCase() : str;
}

// src/object/methods/toTokenKey.ts
function toTokenKey(str) {
  return isString(str) ? str.replace(/[A-Z]/g, (c, i) => i === 0 ? c : "." + c.toLowerCase()).toLowerCase() : str;
}
export {
  compare,
  contains,
  deepEquals,
  equals,
  filter,
  findIndexInList,
  findLast,
  findLastIndex,
  getKeyValue,
  insertIntoOrderedArray,
  isArray,
  isDate,
  isEmpty,
  isFunction,
  isNotEmpty,
  isNumber,
  isObject,
  isPrintableCharacter,
  isString,
  localeComparator,
  matchRegex,
  mergeKeys,
  minifyCSS,
  nestedKeys,
  removeAccents,
  reorderArray,
  resolve,
  resolveFieldData,
  sort,
  stringify,
  toCapitalCase,
  toFlatCase,
  toKebabCase,
  toTokenKey
};
//# sourceMappingURL=index.mjs.map