# Copyright 2016-2025 Geoffrey R. Scheller
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Recursive Functions Package
===========================

Package to explore efficient ways to implement recursive functions.

Example recursive functions
---------------------------

- module: bm.recursive_functions.examples

  - Ackermann's function

    - with list
    
      - function: bm.recursive_functions.examples.ackermann_list

  - Fibonacci sequences

    - with generators

      - function: bm.recursive_functions.examples.fibonacci_generator
      - function: bm.recursive_functions.examples.rev_fibonacci_generator

CLI program entry points
------------------------

- package: bm.recursive_functions.cli

  - module: bm.recursive_functions.cli.ackermann

"""

__author__ = 'Geoffrey R. Scheller'
__copyright__ = 'Copyright (c) 2016-2025 Geoffrey R. Scheller'
__license__ = 'Apache License 2.0'
