import builtins  # noqa: F401
from files_sdk.api import Api  # noqa: F401
from files_sdk.list_obj import ListObj
from files_sdk.error import (  # noqa: F401
    InvalidParameterError,
    MissingParameterError,
    NotImplementedError,
)


class ChildSiteManagementPolicy:
    default_attributes = {
        "id": None,  # int64 - ChildSiteManagementPolicy ID
        "site_id": None,  # int64 - ID of the Site managing the policy
        "site_setting_name": None,  # string - The name of the setting that is managed by the policy
        "managed_value": None,  # string - The value for the setting that will be enforced for all child sites that are not exempt
        "skip_child_site_ids": None,  # array(int64) - The list of child site IDs that are exempt from this policy
    }

    def __init__(self, attributes=None, options=None):
        if not isinstance(attributes, dict):
            attributes = {}
        if not isinstance(options, dict):
            options = {}
        self.set_attributes(attributes)
        self.options = options

    def set_attributes(self, attributes):
        for (
            attribute,
            default_value,
        ) in ChildSiteManagementPolicy.default_attributes.items():
            setattr(self, attribute, attributes.get(attribute, default_value))

    def get_attributes(self):
        return {
            k: getattr(self, k, None)
            for k in ChildSiteManagementPolicy.default_attributes
            if getattr(self, k, None) is not None
        }

    # Parameters:
    #   site_setting_name (required) - string - The name of the setting that is managed by the policy
    #   managed_value (required) - string - The value for the setting that will be enforced for all child sites that are not exempt
    #   skip_child_site_ids - array(int64) - The list of child site IDs that are exempt from this policy
    def update(self, params=None):
        if not isinstance(params, dict):
            params = {}

        if hasattr(self, "id") and self.id:
            params["id"] = self.id
        else:
            raise MissingParameterError("Current object doesn't have a id")
        if "id" not in params:
            raise MissingParameterError("Parameter missing: id")
        if "site_setting_name" not in params:
            raise MissingParameterError("Parameter missing: site_setting_name")
        if "managed_value" not in params:
            raise MissingParameterError("Parameter missing: managed_value")
        if "id" in params and not isinstance(params["id"], int):
            raise InvalidParameterError("Bad parameter: id must be an int")
        if "site_setting_name" in params and not isinstance(
            params["site_setting_name"], str
        ):
            raise InvalidParameterError(
                "Bad parameter: site_setting_name must be an str"
            )
        if "managed_value" in params and not isinstance(
            params["managed_value"], str
        ):
            raise InvalidParameterError(
                "Bad parameter: managed_value must be an str"
            )
        if "skip_child_site_ids" in params and not isinstance(
            params["skip_child_site_ids"], builtins.list
        ):
            raise InvalidParameterError(
                "Bad parameter: skip_child_site_ids must be an list"
            )
        response, _options = Api.send_request(
            "PATCH",
            "/child_site_management_policies/{id}".format(id=params["id"]),
            params,
            self.options,
        )
        return response.data

    def delete(self, params=None):
        if not isinstance(params, dict):
            params = {}

        if hasattr(self, "id") and self.id:
            params["id"] = self.id
        else:
            raise MissingParameterError("Current object doesn't have a id")
        if "id" not in params:
            raise MissingParameterError("Parameter missing: id")
        if "id" in params and not isinstance(params["id"], int):
            raise InvalidParameterError("Bad parameter: id must be an int")
        Api.send_request(
            "DELETE",
            "/child_site_management_policies/{id}".format(id=params["id"]),
            params,
            self.options,
        )

    def destroy(self, params=None):
        self.delete(params)

    def save(self):
        if hasattr(self, "id") and self.id:
            new_obj = self.update(self.get_attributes())
            self.set_attributes(new_obj.get_attributes())
            return True
        else:
            new_obj = create(self.get_attributes(), self.options)
            self.set_attributes(new_obj.get_attributes())
            return True


# Parameters:
#   cursor - string - Used for pagination.  When a list request has more records available, cursors are provided in the response headers `X-Files-Cursor-Next` and `X-Files-Cursor-Prev`.  Send one of those cursor value here to resume an existing list from the next available record.  Note: many of our SDKs have iterator methods that will automatically handle cursor-based pagination.
#   per_page - int64 - Number of records to show per page.  (Max: 10,000, 1,000 or less is recommended).
def list(params=None, options=None):
    if not isinstance(params, dict):
        params = {}
    if not isinstance(options, dict):
        options = {}
    if "cursor" in params and not isinstance(params["cursor"], str):
        raise InvalidParameterError("Bad parameter: cursor must be an str")
    if "per_page" in params and not isinstance(params["per_page"], int):
        raise InvalidParameterError("Bad parameter: per_page must be an int")
    return ListObj(
        ChildSiteManagementPolicy,
        "GET",
        "/child_site_management_policies",
        params,
        options,
    )


def all(params=None, options=None):
    list(params, options)


# Parameters:
#   id (required) - int64 - Child Site Management Policy ID.
def find(id, params=None, options=None):
    if not isinstance(params, dict):
        params = {}
    if not isinstance(options, dict):
        options = {}
    params["id"] = id
    if "id" in params and not isinstance(params["id"], int):
        raise InvalidParameterError("Bad parameter: id must be an int")
    if "id" not in params:
        raise MissingParameterError("Parameter missing: id")
    response, options = Api.send_request(
        "GET",
        "/child_site_management_policies/{id}".format(id=params["id"]),
        params,
        options,
    )
    return ChildSiteManagementPolicy(response.data, options)


def get(id, params=None, options=None):
    find(id, params, options)


# Parameters:
#   site_setting_name (required) - string - The name of the setting that is managed by the policy
#   managed_value (required) - string - The value for the setting that will be enforced for all child sites that are not exempt
#   skip_child_site_ids - array(int64) - The list of child site IDs that are exempt from this policy
def create(params=None, options=None):
    if not isinstance(params, dict):
        params = {}
    if not isinstance(options, dict):
        options = {}
    if "site_setting_name" in params and not isinstance(
        params["site_setting_name"], str
    ):
        raise InvalidParameterError(
            "Bad parameter: site_setting_name must be an str"
        )
    if "managed_value" in params and not isinstance(
        params["managed_value"], str
    ):
        raise InvalidParameterError(
            "Bad parameter: managed_value must be an str"
        )
    if "skip_child_site_ids" in params and not isinstance(
        params["skip_child_site_ids"], builtins.list
    ):
        raise InvalidParameterError(
            "Bad parameter: skip_child_site_ids must be an list"
        )
    if "site_setting_name" not in params:
        raise MissingParameterError("Parameter missing: site_setting_name")
    if "managed_value" not in params:
        raise MissingParameterError("Parameter missing: managed_value")
    response, options = Api.send_request(
        "POST", "/child_site_management_policies", params, options
    )
    return ChildSiteManagementPolicy(response.data, options)


# Parameters:
#   site_setting_name (required) - string - The name of the setting that is managed by the policy
#   managed_value (required) - string - The value for the setting that will be enforced for all child sites that are not exempt
#   skip_child_site_ids - array(int64) - The list of child site IDs that are exempt from this policy
def update(id, params=None, options=None):
    if not isinstance(params, dict):
        params = {}
    if not isinstance(options, dict):
        options = {}
    params["id"] = id
    if "id" in params and not isinstance(params["id"], int):
        raise InvalidParameterError("Bad parameter: id must be an int")
    if "site_setting_name" in params and not isinstance(
        params["site_setting_name"], str
    ):
        raise InvalidParameterError(
            "Bad parameter: site_setting_name must be an str"
        )
    if "managed_value" in params and not isinstance(
        params["managed_value"], str
    ):
        raise InvalidParameterError(
            "Bad parameter: managed_value must be an str"
        )
    if "skip_child_site_ids" in params and not isinstance(
        params["skip_child_site_ids"], builtins.list
    ):
        raise InvalidParameterError(
            "Bad parameter: skip_child_site_ids must be an list"
        )
    if "id" not in params:
        raise MissingParameterError("Parameter missing: id")
    if "site_setting_name" not in params:
        raise MissingParameterError("Parameter missing: site_setting_name")
    if "managed_value" not in params:
        raise MissingParameterError("Parameter missing: managed_value")
    response, options = Api.send_request(
        "PATCH",
        "/child_site_management_policies/{id}".format(id=params["id"]),
        params,
        options,
    )
    return ChildSiteManagementPolicy(response.data, options)


def delete(id, params=None, options=None):
    if not isinstance(params, dict):
        params = {}
    if not isinstance(options, dict):
        options = {}
    params["id"] = id
    if "id" in params and not isinstance(params["id"], int):
        raise InvalidParameterError("Bad parameter: id must be an int")
    if "id" not in params:
        raise MissingParameterError("Parameter missing: id")
    Api.send_request(
        "DELETE",
        "/child_site_management_policies/{id}".format(id=params["id"]),
        params,
        options,
    )


def destroy(id, params=None, options=None):
    delete(id, params, options)


def new(*args, **kwargs):
    return ChildSiteManagementPolicy(*args, **kwargs)
