# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AlarmEventInfo(AbstractModel):
    """告警事件详情

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: str
        :param _AlarmTime: 告警时间
        :type AlarmTime: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _RegularName: 规则名称
        :type RegularName: str
        :param _AlarmLevel: 告警级别,0表示普通，1表示重要，2表示紧急
        :type AlarmLevel: int
        :param _AlarmWay: 告警方式,多个用逗号隔开（1:邮件，2:短信，3:微信，4:语音，5:代表企业微信，6:http）
        :type AlarmWay: int
        :param _AlarmRecipientId: 告警接收人Id，多个用逗号隔开
        :type AlarmRecipientId: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _AlarmIndicator: 告警指标,0表示任务失败，1表示任务运行超时，2表示任务停止，3表示任务暂停
        :type AlarmIndicator: int
        :param _AlarmIndicatorDesc: 告警指标描述
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicatorDesc: str
        :param _TriggerType: 指标阈值，1表示离线任务第一次运行失败，2表示离线任务所有重试完成后失败
注意：此字段可能返回 null，表示取不到有效值。
        :type TriggerType: int
        :param _EstimatedTime: 预计的超时时间，分钟级别
注意：此字段可能返回 null，表示取不到有效值。
        :type EstimatedTime: int
        :param _InstanceId: 实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _TaskName: 任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _IsSendSuccess: 0：部分成功，1：全部成功，2：全部失败
注意：此字段可能返回 null，表示取不到有效值。
        :type IsSendSuccess: int
        :param _MessageId: 消息ID
注意：此字段可能返回 null，表示取不到有效值。
        :type MessageId: str
        :param _Operator: 阈值计算算子，1 : 大于 2 ：小于
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: int
        :param _RegularId: 告警规则ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RegularId: str
        """
        self._AlarmId = None
        self._AlarmTime = None
        self._TaskId = None
        self._RegularName = None
        self._AlarmLevel = None
        self._AlarmWay = None
        self._AlarmRecipientId = None
        self._ProjectId = None
        self._AlarmIndicator = None
        self._AlarmIndicatorDesc = None
        self._TriggerType = None
        self._EstimatedTime = None
        self._InstanceId = None
        self._TaskName = None
        self._IsSendSuccess = None
        self._MessageId = None
        self._Operator = None
        self._RegularId = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def AlarmTime(self):
        return self._AlarmTime

    @AlarmTime.setter
    def AlarmTime(self, AlarmTime):
        self._AlarmTime = AlarmTime

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RegularName(self):
        return self._RegularName

    @RegularName.setter
    def RegularName(self, RegularName):
        self._RegularName = RegularName

    @property
    def AlarmLevel(self):
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def AlarmWay(self):
        return self._AlarmWay

    @AlarmWay.setter
    def AlarmWay(self, AlarmWay):
        self._AlarmWay = AlarmWay

    @property
    def AlarmRecipientId(self):
        return self._AlarmRecipientId

    @AlarmRecipientId.setter
    def AlarmRecipientId(self, AlarmRecipientId):
        self._AlarmRecipientId = AlarmRecipientId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AlarmIndicator(self):
        return self._AlarmIndicator

    @AlarmIndicator.setter
    def AlarmIndicator(self, AlarmIndicator):
        self._AlarmIndicator = AlarmIndicator

    @property
    def AlarmIndicatorDesc(self):
        return self._AlarmIndicatorDesc

    @AlarmIndicatorDesc.setter
    def AlarmIndicatorDesc(self, AlarmIndicatorDesc):
        self._AlarmIndicatorDesc = AlarmIndicatorDesc

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def EstimatedTime(self):
        return self._EstimatedTime

    @EstimatedTime.setter
    def EstimatedTime(self, EstimatedTime):
        self._EstimatedTime = EstimatedTime

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def IsSendSuccess(self):
        return self._IsSendSuccess

    @IsSendSuccess.setter
    def IsSendSuccess(self, IsSendSuccess):
        self._IsSendSuccess = IsSendSuccess

    @property
    def MessageId(self):
        return self._MessageId

    @MessageId.setter
    def MessageId(self, MessageId):
        self._MessageId = MessageId

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def RegularId(self):
        return self._RegularId

    @RegularId.setter
    def RegularId(self, RegularId):
        self._RegularId = RegularId


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._AlarmTime = params.get("AlarmTime")
        self._TaskId = params.get("TaskId")
        self._RegularName = params.get("RegularName")
        self._AlarmLevel = params.get("AlarmLevel")
        self._AlarmWay = params.get("AlarmWay")
        self._AlarmRecipientId = params.get("AlarmRecipientId")
        self._ProjectId = params.get("ProjectId")
        self._AlarmIndicator = params.get("AlarmIndicator")
        self._AlarmIndicatorDesc = params.get("AlarmIndicatorDesc")
        self._TriggerType = params.get("TriggerType")
        self._EstimatedTime = params.get("EstimatedTime")
        self._InstanceId = params.get("InstanceId")
        self._TaskName = params.get("TaskName")
        self._IsSendSuccess = params.get("IsSendSuccess")
        self._MessageId = params.get("MessageId")
        self._Operator = params.get("Operator")
        self._RegularId = params.get("RegularId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmIndicatorInfo(AbstractModel):
    """告警指标

    """

    def __init__(self):
        r"""
        :param _Id: 指标id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _AlarmIndicator: 告警指标,0表示任务失败，1表示任务运行超时，2表示任务停止，3表示任务暂停
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicator: int
        :param _AlarmIndicatorDesc: 告警指标描述
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicatorDesc: str
        :param _TriggerType: 指标阈值，1表示离线任务第一次运行失败，2表示离线任务所有重试完成后失败
注意：此字段可能返回 null，表示取不到有效值。
        :type TriggerType: int
        :param _EstimatedTime: 预计的超时时间，分钟级别
注意：此字段可能返回 null，表示取不到有效值。
        :type EstimatedTime: int
        :param _Operator: 实时任务告警需要的参数
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: int
        :param _AlarmIndicatorUnit: 告警指标阈值单位：ms(毫秒)、s(秒)、min(分钟)
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicatorUnit: str
        :param _Duration: 告警周期
        :type Duration: int
        :param _DurationUnit: 告警周期单位
        :type DurationUnit: str
        :param _MaxTimes: 周期内最多告警次数
        :type MaxTimes: int
        """
        self._Id = None
        self._AlarmIndicator = None
        self._AlarmIndicatorDesc = None
        self._TriggerType = None
        self._EstimatedTime = None
        self._Operator = None
        self._AlarmIndicatorUnit = None
        self._Duration = None
        self._DurationUnit = None
        self._MaxTimes = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def AlarmIndicator(self):
        return self._AlarmIndicator

    @AlarmIndicator.setter
    def AlarmIndicator(self, AlarmIndicator):
        self._AlarmIndicator = AlarmIndicator

    @property
    def AlarmIndicatorDesc(self):
        return self._AlarmIndicatorDesc

    @AlarmIndicatorDesc.setter
    def AlarmIndicatorDesc(self, AlarmIndicatorDesc):
        self._AlarmIndicatorDesc = AlarmIndicatorDesc

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def EstimatedTime(self):
        return self._EstimatedTime

    @EstimatedTime.setter
    def EstimatedTime(self, EstimatedTime):
        self._EstimatedTime = EstimatedTime

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def AlarmIndicatorUnit(self):
        return self._AlarmIndicatorUnit

    @AlarmIndicatorUnit.setter
    def AlarmIndicatorUnit(self, AlarmIndicatorUnit):
        self._AlarmIndicatorUnit = AlarmIndicatorUnit

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def DurationUnit(self):
        return self._DurationUnit

    @DurationUnit.setter
    def DurationUnit(self, DurationUnit):
        self._DurationUnit = DurationUnit

    @property
    def MaxTimes(self):
        return self._MaxTimes

    @MaxTimes.setter
    def MaxTimes(self, MaxTimes):
        self._MaxTimes = MaxTimes


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._AlarmIndicator = params.get("AlarmIndicator")
        self._AlarmIndicatorDesc = params.get("AlarmIndicatorDesc")
        self._TriggerType = params.get("TriggerType")
        self._EstimatedTime = params.get("EstimatedTime")
        self._Operator = params.get("Operator")
        self._AlarmIndicatorUnit = params.get("AlarmIndicatorUnit")
        self._Duration = params.get("Duration")
        self._DurationUnit = params.get("DurationUnit")
        self._MaxTimes = params.get("MaxTimes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmInfo(AbstractModel):
    """任务告警信息

    """

    def __init__(self):
        r"""
        :param _TaskIds: 关联任务id
        :type TaskIds: str
        :param _AlarmType: 告警类别；failure表示失败告警；overtime表示超时告警
        :type AlarmType: str
        :param _AlarmWay: 告警方式；SMS表示短信；Email表示邮件；HTTP 表示接口方式；Wechat表示微信方式
        :type AlarmWay: str
        :param _AlarmRecipient: 告警接收人，多个告警接收人以;分割
        :type AlarmRecipient: str
        :param _AlarmRecipientId: 告警接收人id，多个告警接收人id以;分割
        :type AlarmRecipientId: str
        :param _Hours: 预计运行的小时，取值范围0-23
        :type Hours: int
        :param _Minutes: 预计运行分钟，取值范围0-59
        :type Minutes: int
        :param _TriggerType: 告警出发时机；1表示第一次运行失败；2表示所有重试完成后失败；
        :type TriggerType: int
        :param _AlarmId: 告警信息id
        :type AlarmId: str
        :param _Status: 告警状态设置；1表示可用；0表示不可用，默认可用
        :type Status: int
        """
        self._TaskIds = None
        self._AlarmType = None
        self._AlarmWay = None
        self._AlarmRecipient = None
        self._AlarmRecipientId = None
        self._Hours = None
        self._Minutes = None
        self._TriggerType = None
        self._AlarmId = None
        self._Status = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def AlarmType(self):
        return self._AlarmType

    @AlarmType.setter
    def AlarmType(self, AlarmType):
        self._AlarmType = AlarmType

    @property
    def AlarmWay(self):
        return self._AlarmWay

    @AlarmWay.setter
    def AlarmWay(self, AlarmWay):
        self._AlarmWay = AlarmWay

    @property
    def AlarmRecipient(self):
        return self._AlarmRecipient

    @AlarmRecipient.setter
    def AlarmRecipient(self, AlarmRecipient):
        self._AlarmRecipient = AlarmRecipient

    @property
    def AlarmRecipientId(self):
        return self._AlarmRecipientId

    @AlarmRecipientId.setter
    def AlarmRecipientId(self, AlarmRecipientId):
        self._AlarmRecipientId = AlarmRecipientId

    @property
    def Hours(self):
        return self._Hours

    @Hours.setter
    def Hours(self, Hours):
        self._Hours = Hours

    @property
    def Minutes(self):
        return self._Minutes

    @Minutes.setter
    def Minutes(self, Minutes):
        self._Minutes = Minutes

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._AlarmType = params.get("AlarmType")
        self._AlarmWay = params.get("AlarmWay")
        self._AlarmRecipient = params.get("AlarmRecipient")
        self._AlarmRecipientId = params.get("AlarmRecipientId")
        self._Hours = params.get("Hours")
        self._Minutes = params.get("Minutes")
        self._TriggerType = params.get("TriggerType")
        self._AlarmId = params.get("AlarmId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmReceiverInfo(AbstractModel):
    """告警接收人详情

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: str
        :param _AlarmReceiver: 告警接收人ID
        :type AlarmReceiver: str
        :param _Email: 邮件，0：未设置，1：成功，2：失败
        :type Email: int
        :param _Sms: 短信，0：未设置，1：成功，2：失败
        :type Sms: int
        :param _Wechat: 微信，0：未设置，1：成功，2：失败
        :type Wechat: int
        :param _Voice: 电话，0：未设置，1：成功，2：失败
        :type Voice: int
        :param _Wecom: 企业微信，0：未设置，1：成功，2：失败
        :type Wecom: int
        :param _Http: http，0：未设置，1：成功，2：失败
        :type Http: int
        :param _WecomGroup: 企业微信群，0：未设置，1：成功，2：失败
注意：此字段可能返回 null，表示取不到有效值。
        :type WecomGroup: int
        """
        self._AlarmId = None
        self._AlarmReceiver = None
        self._Email = None
        self._Sms = None
        self._Wechat = None
        self._Voice = None
        self._Wecom = None
        self._Http = None
        self._WecomGroup = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def AlarmReceiver(self):
        return self._AlarmReceiver

    @AlarmReceiver.setter
    def AlarmReceiver(self, AlarmReceiver):
        self._AlarmReceiver = AlarmReceiver

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def Sms(self):
        return self._Sms

    @Sms.setter
    def Sms(self, Sms):
        self._Sms = Sms

    @property
    def Wechat(self):
        return self._Wechat

    @Wechat.setter
    def Wechat(self, Wechat):
        self._Wechat = Wechat

    @property
    def Voice(self):
        return self._Voice

    @Voice.setter
    def Voice(self, Voice):
        self._Voice = Voice

    @property
    def Wecom(self):
        return self._Wecom

    @Wecom.setter
    def Wecom(self, Wecom):
        self._Wecom = Wecom

    @property
    def Http(self):
        return self._Http

    @Http.setter
    def Http(self, Http):
        self._Http = Http

    @property
    def WecomGroup(self):
        return self._WecomGroup

    @WecomGroup.setter
    def WecomGroup(self, WecomGroup):
        self._WecomGroup = WecomGroup


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._AlarmReceiver = params.get("AlarmReceiver")
        self._Email = params.get("Email")
        self._Sms = params.get("Sms")
        self._Wechat = params.get("Wechat")
        self._Voice = params.get("Voice")
        self._Wecom = params.get("Wecom")
        self._Http = params.get("Http")
        self._WecomGroup = params.get("WecomGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateIntegrationTaskAlarmsRequest(AbstractModel):
    """BatchCreateIntegrationTaskAlarms请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskAlarmInfo: 告警配置信息
        :type TaskAlarmInfo: :class:`tencentcloud.wedata.v20210820.models.TaskAlarmInfo`
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskAlarmInfo = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskAlarmInfo(self):
        return self._TaskAlarmInfo

    @TaskAlarmInfo.setter
    def TaskAlarmInfo(self, TaskAlarmInfo):
        self._TaskAlarmInfo = TaskAlarmInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        if params.get("TaskAlarmInfo") is not None:
            self._TaskAlarmInfo = TaskAlarmInfo()
            self._TaskAlarmInfo._deserialize(params.get("TaskAlarmInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateIntegrationTaskAlarmsResponse(AbstractModel):
    """BatchCreateIntegrationTaskAlarms返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedCount: int
        :param _TotalCount: 任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchDeleteIntegrationTasksRequest(AbstractModel):
    """BatchDeleteIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteIntegrationTasksResponse(AbstractModel):
    """BatchDeleteIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedCount: int
        :param _TotalCount: 任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchDeleteTasksNewRequest(AbstractModel):
    """BatchDeleteTasksNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 批量删除的任务TaskId
        :type TaskIdList: list of str
        :param _DeleteMode: true : 删除后下游任务可正常运行
false：删除后下游任务不可运行
        :type DeleteMode: bool
        :param _EnableNotify: true：通知下游任务责任人
false:  不通知下游任务责任人
        :type EnableNotify: bool
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._DeleteMode = None
        self._EnableNotify = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def DeleteMode(self):
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode

    @property
    def EnableNotify(self):
        return self._EnableNotify

    @EnableNotify.setter
    def EnableNotify(self, EnableNotify):
        self._EnableNotify = EnableNotify

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._DeleteMode = params.get("DeleteMode")
        self._EnableNotify = params.get("EnableNotify")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteTasksNewResponse(AbstractModel):
    """BatchDeleteTasksNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchForceSuccessIntegrationTaskInstancesRequest(AbstractModel):
    """BatchForceSuccessIntegrationTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例信息
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchForceSuccessIntegrationTaskInstancesResponse(AbstractModel):
    """BatchForceSuccessIntegrationTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchKillIntegrationTaskInstancesRequest(AbstractModel):
    """BatchKillIntegrationTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例信息
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchKillIntegrationTaskInstancesResponse(AbstractModel):
    """BatchKillIntegrationTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchMakeUpIntegrationTasksRequest(AbstractModel):
    """BatchMakeUpIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _StartTime: 补数据开始时间
        :type StartTime: str
        :param _EndTime: 补数据结束时间
        :type EndTime: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._StartTime = None
        self._EndTime = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchMakeUpIntegrationTasksResponse(AbstractModel):
    """BatchMakeUpIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchModifyOwnersNewRequest(AbstractModel):
    """BatchModifyOwnersNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 需要更新责任人的TaskId数组
        :type TaskIdList: list of str
        :param _Owners: 需要更新的责任人
        :type Owners: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._Owners = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def Owners(self):
        return self._Owners

    @Owners.setter
    def Owners(self, Owners):
        self._Owners = Owners

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._Owners = params.get("Owners")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchModifyOwnersNewResponse(AbstractModel):
    """BatchModifyOwnersNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchOperateResult(AbstractModel):
    """批量操作的结果返回

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 批量操作成功数
        :type SuccessCount: int
        :param _FailedCount: 批量操作失败数
        :type FailedCount: int
        :param _TotalCount: 批量操作的总数
        :type TotalCount: int
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRerunIntegrationTaskInstancesRequest(AbstractModel):
    """BatchRerunIntegrationTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例信息
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRerunIntegrationTaskInstancesResponse(AbstractModel):
    """BatchRerunIntegrationTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchResult(AbstractModel):
    """批量操作结果

    """

    def __init__(self):
        r"""
        :param _Running: 正在运行的任务数
        :type Running: int
        :param _Success: 执行成功的任务数
        :type Success: int
        :param _Failed: 执行失败的任务数
        :type Failed: int
        :param _Total: 总任务数
        :type Total: int
        """
        self._Running = None
        self._Success = None
        self._Failed = None
        self._Total = None

    @property
    def Running(self):
        return self._Running

    @Running.setter
    def Running(self, Running):
        self._Running = Running

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def Failed(self):
        return self._Failed

    @Failed.setter
    def Failed(self, Failed):
        self._Failed = Failed

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total


    def _deserialize(self, params):
        self._Running = params.get("Running")
        self._Success = params.get("Success")
        self._Failed = params.get("Failed")
        self._Total = params.get("Total")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchResumeIntegrationTasksRequest(AbstractModel):
    """BatchResumeIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchResumeIntegrationTasksResponse(AbstractModel):
    """BatchResumeIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchReturn(AbstractModel):
    """操作结果

    """

    def __init__(self):
        r"""
        :param _Result: 执行结果
        :type Result: bool
        :param _ErrorDesc: 执行情况备注
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorDesc: str
        :param _ErrorId: 执行情况id
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorId: str
        """
        self._Result = None
        self._ErrorDesc = None
        self._ErrorId = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrorDesc(self):
        return self._ErrorDesc

    @ErrorDesc.setter
    def ErrorDesc(self, ErrorDesc):
        self._ErrorDesc = ErrorDesc

    @property
    def ErrorId(self):
        return self._ErrorId

    @ErrorId.setter
    def ErrorId(self, ErrorId):
        self._ErrorId = ErrorId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._ErrorDesc = params.get("ErrorDesc")
        self._ErrorId = params.get("ErrorId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStartIntegrationTasksRequest(AbstractModel):
    """BatchStartIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStartIntegrationTasksResponse(AbstractModel):
    """BatchStartIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchStopIntegrationTasksRequest(AbstractModel):
    """BatchStopIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopIntegrationTasksResponse(AbstractModel):
    """BatchStopIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchStopTasksNewRequest(AbstractModel):
    """BatchStopTasksNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 批量停止任务的TaskId
        :type TaskIdList: list of str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopTasksNewResponse(AbstractModel):
    """BatchStopTasksNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchSuspendIntegrationTasksRequest(AbstractModel):
    """BatchSuspendIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchSuspendIntegrationTasksResponse(AbstractModel):
    """BatchSuspendIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchUpdateIntegrationTasksRequest(AbstractModel):
    """BatchUpdateIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _Incharge: 责任人（多个责任人用小写分号隔开；离线任务传入的是账号名，实时任务传入的是账号id）
        :type Incharge: str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._Incharge = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def Incharge(self):
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._Incharge = params.get("Incharge")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchUpdateIntegrationTasksResponse(AbstractModel):
    """BatchUpdateIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BytesSpeed(AbstractModel):
    """实时任务同步速度 字节/s

    """

    def __init__(self):
        r"""
        :param _NodeType: 节点类型
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeType: str
        :param _NodeName: 节点名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeName: str
        :param _Values: 速度值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Values: list of SpeedValue
        """
        self._NodeType = None
        self._NodeName = None
        self._Values = None

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._NodeType = params.get("NodeType")
        self._NodeName = params.get("NodeName")
        if params.get("Values") is not None:
            self._Values = []
            for item in params.get("Values"):
                obj = SpeedValue()
                obj._deserialize(item)
                self._Values.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CanvasInfo(AbstractModel):
    """画布所需的信息

    """

    def __init__(self):
        r"""
        :param _TasksList: 画布任务信息
        :type TasksList: list of TaskCanvasInfo
        :param _LinksList: 画布任务链接信息
        :type LinksList: list of TaskLinkInfo
        """
        self._TasksList = None
        self._LinksList = None

    @property
    def TasksList(self):
        return self._TasksList

    @TasksList.setter
    def TasksList(self, TasksList):
        self._TasksList = TasksList

    @property
    def LinksList(self):
        return self._LinksList

    @LinksList.setter
    def LinksList(self, LinksList):
        self._LinksList = LinksList


    def _deserialize(self, params):
        if params.get("TasksList") is not None:
            self._TasksList = []
            for item in params.get("TasksList"):
                obj = TaskCanvasInfo()
                obj._deserialize(item)
                self._TasksList.append(obj)
        if params.get("LinksList") is not None:
            self._LinksList = []
            for item in params.get("LinksList"):
                obj = TaskLinkInfo()
                obj._deserialize(item)
                self._LinksList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAlarmRegularNameExistRequest(AbstractModel):
    """CheckAlarmRegularNameExist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目名称
        :type ProjectId: str
        :param _AlarmRegularName: 规则名称
        :type AlarmRegularName: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _Id: 主键ID
        :type Id: str
        :param _TaskType: 任务类型:201.实时,202.离线
        :type TaskType: int
        """
        self._ProjectId = None
        self._AlarmRegularName = None
        self._TaskId = None
        self._Id = None
        self._TaskType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AlarmRegularName(self):
        return self._AlarmRegularName

    @AlarmRegularName.setter
    def AlarmRegularName(self, AlarmRegularName):
        self._AlarmRegularName = AlarmRegularName

    @property
    def TaskId(self):
        warnings.warn("parameter `TaskId` is deprecated", DeprecationWarning) 

        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        warnings.warn("parameter `TaskId` is deprecated", DeprecationWarning) 

        self._TaskId = TaskId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._AlarmRegularName = params.get("AlarmRegularName")
        self._TaskId = params.get("TaskId")
        self._Id = params.get("Id")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAlarmRegularNameExistResponse(AbstractModel):
    """CheckAlarmRegularNameExist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否重名
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckDuplicateRuleNameRequest(AbstractModel):
    """CheckDuplicateRuleName请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _RuleGroupId: 规则组Id
        :type RuleGroupId: int
        :param _Name: 规则名称
        :type Name: str
        :param _RuleId: 规则Id
        :type RuleId: int
        """
        self._ProjectId = None
        self._RuleGroupId = None
        self._Name = None
        self._RuleId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._Name = params.get("Name")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDuplicateRuleNameResponse(AbstractModel):
    """CheckDuplicateRuleName返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则名称是否重复
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckDuplicateTemplateNameRequest(AbstractModel):
    """CheckDuplicateTemplateName请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 规则模板ID
        :type TemplateId: int
        :param _Name: 模板名称
        :type Name: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TemplateId = None
        self._Name = None
        self._ProjectId = None

    @property
    def TemplateId(self):
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDuplicateTemplateNameResponse(AbstractModel):
    """CheckDuplicateTemplateName返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否重名
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckIntegrationNodeNameExistsRequest(AbstractModel):
    """CheckIntegrationNodeNameExists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _Name: 节点名称
        :type Name: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Id: 节点ID
        :type Id: int
        """
        self._TaskId = None
        self._Name = None
        self._ProjectId = None
        self._Id = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckIntegrationNodeNameExistsResponse(AbstractModel):
    """CheckIntegrationNodeNameExists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回true代表存在，返回false代表不存在
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckIntegrationTaskNameExistsRequest(AbstractModel):
    """CheckIntegrationTaskNameExists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _SyncType: 同步类型1.单表同步，2.解决方案
        :type SyncType: int
        """
        self._TaskName = None
        self._ProjectId = None
        self._TaskId = None
        self._SyncType = None

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SyncType(self):
        return self._SyncType

    @SyncType.setter
    def SyncType(self, SyncType):
        self._SyncType = SyncType


    def _deserialize(self, params):
        self._TaskName = params.get("TaskName")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._SyncType = params.get("SyncType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckIntegrationTaskNameExistsResponse(AbstractModel):
    """CheckIntegrationTaskNameExists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: true表示存在，false表示不存在
        :type Data: bool
        :param _ExistsType: 任务名重复类型（0:未重复, 1:开发态重复, 2:生产态重复）
        :type ExistsType: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._ExistsType = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def ExistsType(self):
        return self._ExistsType

    @ExistsType.setter
    def ExistsType(self, ExistsType):
        self._ExistsType = ExistsType

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._ExistsType = params.get("ExistsType")
        self._RequestId = params.get("RequestId")


class CheckTaskNameExistRequest(AbstractModel):
    """CheckTaskNameExist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id/工作空间id
        :type ProjectId: str
        :param _TypeId: 任务类型（跟调度传参保持一致27）
        :type TypeId: int
        :param _TaskName: 任务名
        :type TaskName: str
        """
        self._ProjectId = None
        self._TypeId = None
        self._TaskName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TypeId(self):
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TypeId = params.get("TypeId")
        self._TaskName = params.get("TaskName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckTaskNameExistResponse(AbstractModel):
    """CheckTaskNameExist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CommitExportTaskRequest(AbstractModel):
    """CommitExportTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleExecId: 规则执行Id
        :type RuleExecId: int
        :param _ExportType: 导出类型(1.全部,2.触发行,3.通过行)
        :type ExportType: int
        :param _ExecutorGroupId: 执行资源组id
        :type ExecutorGroupId: str
        :param _QueueName: 计算资源队列
        :type QueueName: str
        """
        self._ProjectId = None
        self._RuleExecId = None
        self._ExportType = None
        self._ExecutorGroupId = None
        self._QueueName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId

    @property
    def ExportType(self):
        return self._ExportType

    @ExportType.setter
    def ExportType(self, ExportType):
        self._ExportType = ExportType

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId

    @property
    def QueueName(self):
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleExecId = params.get("RuleExecId")
        self._ExportType = params.get("ExportType")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        self._QueueName = params.get("QueueName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitExportTaskResponse(AbstractModel):
    """CommitExportTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 提交结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CommitIntegrationTaskRequest(AbstractModel):
    """CommitIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _CommitType: 0.仅提交，1.立即启动，2.停止线上作业，丢弃作业状态数据，重新启动运行，3.暂停线上作业，保留作业状态数据，继续运行，4.保留作业状态数据，继续运行
        :type CommitType: int
        :param _TaskType: 实时任务 201   离线任务 202  默认实时任务
        :type TaskType: int
        :param _ExtConfig: 额外参数
        :type ExtConfig: list of RecordField
        """
        self._TaskId = None
        self._ProjectId = None
        self._CommitType = None
        self._TaskType = None
        self._ExtConfig = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CommitType(self):
        return self._CommitType

    @CommitType.setter
    def CommitType(self, CommitType):
        self._CommitType = CommitType

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ExtConfig(self):
        return self._ExtConfig

    @ExtConfig.setter
    def ExtConfig(self, ExtConfig):
        self._ExtConfig = ExtConfig


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._CommitType = params.get("CommitType")
        self._TaskType = params.get("TaskType")
        if params.get("ExtConfig") is not None:
            self._ExtConfig = []
            for item in params.get("ExtConfig"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtConfig.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitIntegrationTaskResponse(AbstractModel):
    """CommitIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作成功与否标识
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CommitRuleGroupExecResultRequest(AbstractModel):
    """CommitRuleGroupExecResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: preject id
        :type ProjectId: str
        :param _RuleGroupExecId: rule group exec id
        :type RuleGroupExecId: int
        :param _RuleGroupState: group exec state
        :type RuleGroupState: str
        :param _RuleExecResults: runner rule exec result list
        :type RuleExecResults: list of RunnerRuleExecResult
        """
        self._ProjectId = None
        self._RuleGroupExecId = None
        self._RuleGroupState = None
        self._RuleExecResults = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId

    @property
    def RuleGroupState(self):
        return self._RuleGroupState

    @RuleGroupState.setter
    def RuleGroupState(self, RuleGroupState):
        self._RuleGroupState = RuleGroupState

    @property
    def RuleExecResults(self):
        return self._RuleExecResults

    @RuleExecResults.setter
    def RuleExecResults(self, RuleExecResults):
        self._RuleExecResults = RuleExecResults


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        self._RuleGroupState = params.get("RuleGroupState")
        if params.get("RuleExecResults") is not None:
            self._RuleExecResults = []
            for item in params.get("RuleExecResults"):
                obj = RunnerRuleExecResult()
                obj._deserialize(item)
                self._RuleExecResults.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitRuleGroupExecResultResponse(AbstractModel):
    """CommitRuleGroupExecResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CommitRuleGroupTaskRequest(AbstractModel):
    """CommitRuleGroupTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _TriggerType: 触发类型 1.手动触发 2.调度事中触发 3.周期调度触发
        :type TriggerType: int
        :param _ExecRuleConfig: 规则配置列表
        :type ExecRuleConfig: list of RuleConfig
        :param _ExecConfig: 执行配置
        :type ExecConfig: :class:`tencentcloud.wedata.v20210820.models.RuleExecConfig`
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _EngineType: 该规则运行的执行引擎，不传时会请求该数据源下默认的执行引擎
        :type EngineType: str
        """
        self._RuleGroupId = None
        self._TriggerType = None
        self._ExecRuleConfig = None
        self._ExecConfig = None
        self._ProjectId = None
        self._EngineType = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def ExecRuleConfig(self):
        return self._ExecRuleConfig

    @ExecRuleConfig.setter
    def ExecRuleConfig(self, ExecRuleConfig):
        self._ExecRuleConfig = ExecRuleConfig

    @property
    def ExecConfig(self):
        return self._ExecConfig

    @ExecConfig.setter
    def ExecConfig(self, ExecConfig):
        self._ExecConfig = ExecConfig

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._TriggerType = params.get("TriggerType")
        if params.get("ExecRuleConfig") is not None:
            self._ExecRuleConfig = []
            for item in params.get("ExecRuleConfig"):
                obj = RuleConfig()
                obj._deserialize(item)
                self._ExecRuleConfig.append(obj)
        if params.get("ExecConfig") is not None:
            self._ExecConfig = RuleExecConfig()
            self._ExecConfig._deserialize(params.get("ExecConfig"))
        self._ProjectId = params.get("ProjectId")
        self._EngineType = params.get("EngineType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitRuleGroupTaskResponse(AbstractModel):
    """CommitRuleGroupTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组执行id
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CommonContent(AbstractModel):
    """内容详情

    """

    def __init__(self):
        r"""
        :param _Content: 详情内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Content: str
        """
        self._Content = None

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonId(AbstractModel):
    """Id包装对象

    """

    def __init__(self):
        r"""
        :param _Id: Id值
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareResult(AbstractModel):
    """质量检查对比结果

    """

    def __init__(self):
        r"""
        :param _Items: 对比结果项列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of CompareResultItem
        :param _TotalRows: 检测总行数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalRows: int
        :param _PassRows: 检测通过行数
注意：此字段可能返回 null，表示取不到有效值。
        :type PassRows: int
        :param _TriggerRows: 检测不通过行数
注意：此字段可能返回 null，表示取不到有效值。
        :type TriggerRows: int
        """
        self._Items = None
        self._TotalRows = None
        self._PassRows = None
        self._TriggerRows = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalRows(self):
        return self._TotalRows

    @TotalRows.setter
    def TotalRows(self, TotalRows):
        self._TotalRows = TotalRows

    @property
    def PassRows(self):
        return self._PassRows

    @PassRows.setter
    def PassRows(self, PassRows):
        self._PassRows = PassRows

    @property
    def TriggerRows(self):
        return self._TriggerRows

    @TriggerRows.setter
    def TriggerRows(self, TriggerRows):
        self._TriggerRows = TriggerRows


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = CompareResultItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalRows = params.get("TotalRows")
        self._PassRows = params.get("PassRows")
        self._TriggerRows = params.get("TriggerRows")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareResultItem(AbstractModel):
    """对比结果项

    """

    def __init__(self):
        r"""
        :param _FixResult: 对比结果， 1为真 2为假
注意：此字段可能返回 null，表示取不到有效值。
        :type FixResult: int
        :param _ResultValue: 质量sql执行结果
注意：此字段可能返回 null，表示取不到有效值。
        :type ResultValue: str
        :param _Values: 阈值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Values: list of ThresholdValue
        :param _Operator: 比较操作类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: str
        :param _CompareType: 比较类型
注意：此字段可能返回 null，表示取不到有效值。
        :type CompareType: int
        :param _ValueComputeType: 值比较类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueComputeType: int
        """
        self._FixResult = None
        self._ResultValue = None
        self._Values = None
        self._Operator = None
        self._CompareType = None
        self._ValueComputeType = None

    @property
    def FixResult(self):
        return self._FixResult

    @FixResult.setter
    def FixResult(self, FixResult):
        self._FixResult = FixResult

    @property
    def ResultValue(self):
        return self._ResultValue

    @ResultValue.setter
    def ResultValue(self, ResultValue):
        self._ResultValue = ResultValue

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def CompareType(self):
        return self._CompareType

    @CompareType.setter
    def CompareType(self, CompareType):
        self._CompareType = CompareType

    @property
    def ValueComputeType(self):
        return self._ValueComputeType

    @ValueComputeType.setter
    def ValueComputeType(self, ValueComputeType):
        self._ValueComputeType = ValueComputeType


    def _deserialize(self, params):
        self._FixResult = params.get("FixResult")
        self._ResultValue = params.get("ResultValue")
        if params.get("Values") is not None:
            self._Values = []
            for item in params.get("Values"):
                obj = ThresholdValue()
                obj._deserialize(item)
                self._Values.append(obj)
        self._Operator = params.get("Operator")
        self._CompareType = params.get("CompareType")
        self._ValueComputeType = params.get("ValueComputeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareRule(AbstractModel):
    """对比规则

    """

    def __init__(self):
        r"""
        :param _Items: 比较条件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of CompareRuleItem
        :param _CycleStep: 周期性模板默认周期，单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleStep: int
        """
        self._Items = None
        self._CycleStep = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = CompareRuleItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._CycleStep = params.get("CycleStep")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareRuleItem(AbstractModel):
    """比较条件

    """

    def __init__(self):
        r"""
        :param _CompareType: 比较类型 1.固定值  2.波动值  3.数值范围比较  4.枚举范围比较  5.不用比较
注意：此字段可能返回 null，表示取不到有效值。
        :type CompareType: int
        :param _Operator: 比较操作类型 <  <=  ==  =>  >
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: str
        :param _ValueComputeType: 质量统计值类型 1.绝对值  2.上升 3. 下降  4._C包含   5. N_C不包含
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueComputeType: int
        :param _ValueList: 比较阈值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueList: list of ThresholdValue
        """
        self._CompareType = None
        self._Operator = None
        self._ValueComputeType = None
        self._ValueList = None

    @property
    def CompareType(self):
        return self._CompareType

    @CompareType.setter
    def CompareType(self, CompareType):
        self._CompareType = CompareType

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def ValueComputeType(self):
        return self._ValueComputeType

    @ValueComputeType.setter
    def ValueComputeType(self, ValueComputeType):
        self._ValueComputeType = ValueComputeType

    @property
    def ValueList(self):
        return self._ValueList

    @ValueList.setter
    def ValueList(self, ValueList):
        self._ValueList = ValueList


    def _deserialize(self, params):
        self._CompareType = params.get("CompareType")
        self._Operator = params.get("Operator")
        self._ValueComputeType = params.get("ValueComputeType")
        if params.get("ValueList") is not None:
            self._ValueList = []
            for item in params.get("ValueList"):
                obj = ThresholdValue()
                obj._deserialize(item)
                self._ValueList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustomFunctionRequest(AbstractModel):
    """CreateCustomFunction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 类型：HIVE、SPARK
        :type Type: str
        :param _Kind: 分类：窗口函数、聚合函数、日期函数......
        :type Kind: str
        :param _Name: 函数名称
        :type Name: str
        :param _ClusterIdentifier: 集群实例引擎 ID
        :type ClusterIdentifier: str
        :param _DbName: 数据库名称
        :type DbName: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._Type = None
        self._Kind = None
        self._Name = None
        self._ClusterIdentifier = None
        self._DbName = None
        self._ProjectId = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Kind(self):
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ClusterIdentifier(self):
        return self._ClusterIdentifier

    @ClusterIdentifier.setter
    def ClusterIdentifier(self, ClusterIdentifier):
        self._ClusterIdentifier = ClusterIdentifier

    @property
    def DbName(self):
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Kind = params.get("Kind")
        self._Name = params.get("Name")
        self._ClusterIdentifier = params.get("ClusterIdentifier")
        self._DbName = params.get("DbName")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustomFunctionResponse(AbstractModel):
    """CreateCustomFunction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionId: 函数唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :type FunctionId: str
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FunctionId = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class CreateDataSourceRequest(AbstractModel):
    """CreateDataSource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 数据源名称，在相同SpaceName下，数据源名称不能为空
        :type Name: str
        :param _Category: 数据源类别：绑定引擎、绑定数据库
        :type Category: str
        :param _Type: 数据源类型:枚举值
        :type Type: str
        :param _OwnerProjectId: 归属项目ID
        :type OwnerProjectId: str
        :param _OwnerProjectName: 归属项目Name
        :type OwnerProjectName: str
        :param _OwnerProjectIdent: 归属项目Name中文
        :type OwnerProjectIdent: str
        :param _BizParams: 业务侧数据源的配置信息扩展
        :type BizParams: str
        :param _Params: 数据源的配置信息，以JSON KV存储，根据每个数据源类型不同，而KV存储信息不同
        :type Params: str
        :param _Description: 数据源描述信息
        :type Description: str
        :param _Display: 数据源展示名，为了可视化查看
        :type Display: str
        :param _DatabaseName: 若数据源列表为绑定数据库，则为db名称
        :type DatabaseName: str
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
        :type Instance: str
        :param _Status: 数据源数据源的可见性，1为可见、0为不可见。默认为1
        :type Status: int
        :param _ClusterId: 数据源所属的业务空间名称
        :type ClusterId: str
        :param _Collect: 是否采集
        :type Collect: str
        :param _COSBucket: cos桶信息
        :type COSBucket: str
        :param _COSRegion: cos region
        :type COSRegion: str
        """
        self._Name = None
        self._Category = None
        self._Type = None
        self._OwnerProjectId = None
        self._OwnerProjectName = None
        self._OwnerProjectIdent = None
        self._BizParams = None
        self._Params = None
        self._Description = None
        self._Display = None
        self._DatabaseName = None
        self._Instance = None
        self._Status = None
        self._ClusterId = None
        self._Collect = None
        self._COSBucket = None
        self._COSRegion = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def OwnerProjectId(self):
        return self._OwnerProjectId

    @OwnerProjectId.setter
    def OwnerProjectId(self, OwnerProjectId):
        self._OwnerProjectId = OwnerProjectId

    @property
    def OwnerProjectName(self):
        return self._OwnerProjectName

    @OwnerProjectName.setter
    def OwnerProjectName(self, OwnerProjectName):
        self._OwnerProjectName = OwnerProjectName

    @property
    def OwnerProjectIdent(self):
        return self._OwnerProjectIdent

    @OwnerProjectIdent.setter
    def OwnerProjectIdent(self, OwnerProjectIdent):
        self._OwnerProjectIdent = OwnerProjectIdent

    @property
    def BizParams(self):
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Display(self):
        return self._Display

    @Display.setter
    def Display(self, Display):
        self._Display = Display

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Collect(self):
        return self._Collect

    @Collect.setter
    def Collect(self, Collect):
        self._Collect = Collect

    @property
    def COSBucket(self):
        return self._COSBucket

    @COSBucket.setter
    def COSBucket(self, COSBucket):
        self._COSBucket = COSBucket

    @property
    def COSRegion(self):
        return self._COSRegion

    @COSRegion.setter
    def COSRegion(self, COSRegion):
        self._COSRegion = COSRegion


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Category = params.get("Category")
        self._Type = params.get("Type")
        self._OwnerProjectId = params.get("OwnerProjectId")
        self._OwnerProjectName = params.get("OwnerProjectName")
        self._OwnerProjectIdent = params.get("OwnerProjectIdent")
        self._BizParams = params.get("BizParams")
        self._Params = params.get("Params")
        self._Description = params.get("Description")
        self._Display = params.get("Display")
        self._DatabaseName = params.get("DatabaseName")
        self._Instance = params.get("Instance")
        self._Status = params.get("Status")
        self._ClusterId = params.get("ClusterId")
        self._Collect = params.get("Collect")
        self._COSBucket = params.get("COSBucket")
        self._COSRegion = params.get("COSRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDataSourceResponse(AbstractModel):
    """CreateDataSource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 主键ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateFolderRequest(AbstractModel):
    """CreateFolder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _FolderName: 文件夹名称
        :type FolderName: str
        :param _ParentsFolderId: 父文件夹ID
        :type ParentsFolderId: str
        """
        self._ProjectId = None
        self._FolderName = None
        self._ParentsFolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderName(self):
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderName = params.get("FolderName")
        self._ParentsFolderId = params.get("ParentsFolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFolderResponse(AbstractModel):
    """CreateFolder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 文件夹Id，null则创建失败
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonId`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonId()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateHiveTableByDDLRequest(AbstractModel):
    """CreateHiveTableByDDL请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceId: 数据源ID
        :type DatasourceId: str
        :param _Database: 数据库
        :type Database: str
        :param _DDLSql: 建hive表ddl
        :type DDLSql: str
        :param _Privilege: 表权限 ，默认为0:项目共享;1:仅个人与管理员
        :type Privilege: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Type: 目标表类型(HIVE或GBASE)
        :type Type: str
        :param _Incharge: 责任人
        :type Incharge: str
        """
        self._DatasourceId = None
        self._Database = None
        self._DDLSql = None
        self._Privilege = None
        self._ProjectId = None
        self._Type = None
        self._Incharge = None

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Database(self):
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def DDLSql(self):
        return self._DDLSql

    @DDLSql.setter
    def DDLSql(self, DDLSql):
        self._DDLSql = DDLSql

    @property
    def Privilege(self):
        return self._Privilege

    @Privilege.setter
    def Privilege(self, Privilege):
        self._Privilege = Privilege

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Incharge(self):
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._Database = params.get("Database")
        self._DDLSql = params.get("DDLSql")
        self._Privilege = params.get("Privilege")
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        self._Incharge = params.get("Incharge")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHiveTableByDDLResponse(AbstractModel):
    """CreateHiveTableByDDL返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 表名称
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateHiveTableRequest(AbstractModel):
    """CreateHiveTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceId: 数据源id
        :type DatasourceId: str
        :param _Database: 数据库
        :type Database: str
        :param _DDLSql: 建hive表ddl
        :type DDLSql: str
        :param _Privilege: 表权限 ，默认为0:项目共享;1:仅个人与管理员
        :type Privilege: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Incharge: 责任人
        :type Incharge: str
        """
        self._DatasourceId = None
        self._Database = None
        self._DDLSql = None
        self._Privilege = None
        self._ProjectId = None
        self._Incharge = None

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Database(self):
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def DDLSql(self):
        return self._DDLSql

    @DDLSql.setter
    def DDLSql(self, DDLSql):
        self._DDLSql = DDLSql

    @property
    def Privilege(self):
        return self._Privilege

    @Privilege.setter
    def Privilege(self, Privilege):
        self._Privilege = Privilege

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Incharge(self):
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._Database = params.get("Database")
        self._DDLSql = params.get("DDLSql")
        self._Privilege = params.get("Privilege")
        self._ProjectId = params.get("ProjectId")
        self._Incharge = params.get("Incharge")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHiveTableResponse(AbstractModel):
    """CreateHiveTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsSuccess: 建表是否成功
        :type IsSuccess: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsSuccess = None
        self._RequestId = None

    @property
    def IsSuccess(self):
        return self._IsSuccess

    @IsSuccess.setter
    def IsSuccess(self, IsSuccess):
        self._IsSuccess = IsSuccess

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsSuccess = params.get("IsSuccess")
        self._RequestId = params.get("RequestId")


class CreateInLongAgentRequest(AbstractModel):
    """CreateInLongAgent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentType: 采集器类型，1：TKE Agent，2：BOSS SDK，默认：1
        :type AgentType: int
        :param _AgentName: 采集器名称
        :type AgentName: str
        :param _ExecutorGroupId: 集成资源组id
        :type ExecutorGroupId: str
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        :param _TkeRegion: TKE集群的地域
        :type TkeRegion: str
        :param _ClusterId: 当AgentType为1时，必填。当AgentType为2时，不用填
        :type ClusterId: str
        """
        self._AgentType = None
        self._AgentName = None
        self._ExecutorGroupId = None
        self._ProjectId = None
        self._TkeRegion = None
        self._ClusterId = None

    @property
    def AgentType(self):
        return self._AgentType

    @AgentType.setter
    def AgentType(self, AgentType):
        self._AgentType = AgentType

    @property
    def AgentName(self):
        return self._AgentName

    @AgentName.setter
    def AgentName(self, AgentName):
        self._AgentName = AgentName

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TkeRegion(self):
        return self._TkeRegion

    @TkeRegion.setter
    def TkeRegion(self, TkeRegion):
        self._TkeRegion = TkeRegion

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._AgentType = params.get("AgentType")
        self._AgentName = params.get("AgentName")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        self._ProjectId = params.get("ProjectId")
        self._TkeRegion = params.get("TkeRegion")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInLongAgentResponse(AbstractModel):
    """CreateInLongAgent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentId: 采集器ID
        :type AgentId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AgentId = None
        self._RequestId = None

    @property
    def AgentId(self):
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AgentId = params.get("AgentId")
        self._RequestId = params.get("RequestId")


class CreateIntegrationNodeRequest(AbstractModel):
    """CreateIntegrationNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NodeInfo: 集成节点信息
        :type NodeInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeInfo`
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型
        :type TaskType: int
        """
        self._NodeInfo = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def NodeInfo(self):
        return self._NodeInfo

    @NodeInfo.setter
    def NodeInfo(self, NodeInfo):
        self._NodeInfo = NodeInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        if params.get("NodeInfo") is not None:
            self._NodeInfo = IntegrationNodeInfo()
            self._NodeInfo._deserialize(params.get("NodeInfo"))
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIntegrationNodeResponse(AbstractModel):
    """CreateIntegrationNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 节点
        :type Id: str
        :param _TaskId: 当前任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._TaskId = None
        self._RequestId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateIntegrationTaskRequest(AbstractModel):
    """CreateIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfo: 任务信息
        :type TaskInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationTaskInfo`
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskInfo = None
        self._ProjectId = None

    @property
    def TaskInfo(self):
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = IntegrationTaskInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIntegrationTaskResponse(AbstractModel):
    """CreateIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateOfflineTaskRequest(AbstractModel):
    """CreateOfflineTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目/工作
        :type ProjectId: str
        :param _CycleStep: 1
        :type CycleStep: int
        :param _DelayTime: 0
        :type DelayTime: int
        :param _EndTime: 2099-12-31 00:00:00
        :type EndTime: str
        :param _Notes: 备注
        :type Notes: str
        :param _StartTime: 当前日期
        :type StartTime: str
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _TypeId: 跟之前调用调度接口保持一致27
        :type TypeId: int
        :param _TaskAction: 默认 ""
        :type TaskAction: str
        :param _TaskMode: 区分画布和表单
        :type TaskMode: str
        """
        self._ProjectId = None
        self._CycleStep = None
        self._DelayTime = None
        self._EndTime = None
        self._Notes = None
        self._StartTime = None
        self._TaskName = None
        self._TypeId = None
        self._TaskAction = None
        self._TaskMode = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def DelayTime(self):
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Notes(self):
        return self._Notes

    @Notes.setter
    def Notes(self, Notes):
        self._Notes = Notes

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TypeId(self):
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def TaskAction(self):
        return self._TaskAction

    @TaskAction.setter
    def TaskAction(self, TaskAction):
        self._TaskAction = TaskAction

    @property
    def TaskMode(self):
        return self._TaskMode

    @TaskMode.setter
    def TaskMode(self, TaskMode):
        self._TaskMode = TaskMode


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CycleStep = params.get("CycleStep")
        self._DelayTime = params.get("DelayTime")
        self._EndTime = params.get("EndTime")
        self._Notes = params.get("Notes")
        self._StartTime = params.get("StartTime")
        self._TaskName = params.get("TaskName")
        self._TypeId = params.get("TypeId")
        self._TaskAction = params.get("TaskAction")
        self._TaskMode = params.get("TaskMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOfflineTaskResponse(AbstractModel):
    """CreateOfflineTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _Data: 结果
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Data = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateOrUpdateResourceRequest(AbstractModel):
    """CreateOrUpdateResource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID，必填项
        :type ProjectId: str
        :param _Files: 文件名，必填项
        :type Files: list of str
        :param _FilePath: 必填项，文件所属路径，资源管理根路径为 /datastudio/resource/项目ID/文件夹名
        :type FilePath: str
        :param _CosBucketName: cos存储桶名字
        :type CosBucketName: str
        :param _CosRegion: cos所属地域
        :type CosRegion: str
        :param _NewFile: 是否为新文件，新增为 true，更新为 false
        :type NewFile: bool
        :param _FilesSize: 必填项，文件大小，与 Files 字段对应
        :type FilesSize: list of str
        """
        self._ProjectId = None
        self._Files = None
        self._FilePath = None
        self._CosBucketName = None
        self._CosRegion = None
        self._NewFile = None
        self._FilesSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Files(self):
        return self._Files

    @Files.setter
    def Files(self, Files):
        self._Files = Files

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def CosBucketName(self):
        return self._CosBucketName

    @CosBucketName.setter
    def CosBucketName(self, CosBucketName):
        self._CosBucketName = CosBucketName

    @property
    def CosRegion(self):
        return self._CosRegion

    @CosRegion.setter
    def CosRegion(self, CosRegion):
        self._CosRegion = CosRegion

    @property
    def NewFile(self):
        return self._NewFile

    @NewFile.setter
    def NewFile(self, NewFile):
        self._NewFile = NewFile

    @property
    def FilesSize(self):
        return self._FilesSize

    @FilesSize.setter
    def FilesSize(self, FilesSize):
        self._FilesSize = FilesSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Files = params.get("Files")
        self._FilePath = params.get("FilePath")
        self._CosBucketName = params.get("CosBucketName")
        self._CosRegion = params.get("CosRegion")
        self._NewFile = params.get("NewFile")
        self._FilesSize = params.get("FilesSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrUpdateResourceResponse(AbstractModel):
    """CreateOrUpdateResource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of UserFileDTO
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = UserFileDTO()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class CreateResourcePathRequest(AbstractModel):
    """CreateResourcePath请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 文件夹名称，如 aaa
        :type Name: str
        :param _FilePath: 文件夹所属父目录，请注意，根目录为 /datastudio/resource
        :type FilePath: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._Name = None
        self._FilePath = None
        self._ProjectId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._FilePath = params.get("FilePath")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateResourcePathResponse(AbstractModel):
    """CreateResourcePath返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 新建成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateRuleRequest(AbstractModel):
    """CreateRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleGroupId: 规则组Id
        :type RuleGroupId: int
        :param _Name: 规则名称
        :type Name: str
        :param _TableId: 数据表ID
        :type TableId: str
        :param _RuleTemplateId: 规则模板列表
        :type RuleTemplateId: int
        :param _Type: 规则类型 1.系统模版, 2.自定义模版, 3.自定义SQL
        :type Type: int
        :param _QualityDim: 规则所属质量维度（1：准确性，2：唯一性，3：完整性，4：一致性，5：及时性，6：有效性
        :type QualityDim: int
        :param _SourceObjectDataTypeName: 源字段详细类型，int、string
        :type SourceObjectDataTypeName: str
        :param _SourceObjectValue: 源字段名称
        :type SourceObjectValue: str
        :param _ConditionType: 检测范围 1.全表   2.条件扫描
        :type ConditionType: int
        :param _ConditionExpression: 条件扫描WHERE条件表达式
        :type ConditionExpression: str
        :param _CustomSql: 自定义SQL
        :type CustomSql: str
        :param _CompareRule: 报警触发条件
        :type CompareRule: :class:`tencentcloud.wedata.v20210820.models.CompareRule`
        :param _AlarmLevel: 报警触发级别 1.低, 2.中, 3.高
        :type AlarmLevel: int
        :param _Description: 规则描述
        :type Description: str
        :param _DatasourceId: 数据源Id
        :type DatasourceId: str
        :param _DatabaseId: 数据库Id
        :type DatabaseId: str
        :param _TargetDatabaseId: 目标库Id
        :type TargetDatabaseId: str
        :param _TargetTableId: 目标表Id
        :type TargetTableId: str
        :param _TargetConditionExpr: 目标过滤条件表达式
        :type TargetConditionExpr: str
        :param _RelConditionExpr: 源字段与目标字段关联条件on表达式
        :type RelConditionExpr: str
        :param _FieldConfig: 自定义模版sql表达式字段替换参数
        :type FieldConfig: :class:`tencentcloud.wedata.v20210820.models.RuleFieldConfig`
        :param _TargetObjectValue: 目标字段名称  CITY
        :type TargetObjectValue: str
        :param _SourceEngineTypes: 该规则支持的执行引擎列表
        :type SourceEngineTypes: list of int non-negative
        """
        self._ProjectId = None
        self._RuleGroupId = None
        self._Name = None
        self._TableId = None
        self._RuleTemplateId = None
        self._Type = None
        self._QualityDim = None
        self._SourceObjectDataTypeName = None
        self._SourceObjectValue = None
        self._ConditionType = None
        self._ConditionExpression = None
        self._CustomSql = None
        self._CompareRule = None
        self._AlarmLevel = None
        self._Description = None
        self._DatasourceId = None
        self._DatabaseId = None
        self._TargetDatabaseId = None
        self._TargetTableId = None
        self._TargetConditionExpr = None
        self._RelConditionExpr = None
        self._FieldConfig = None
        self._TargetObjectValue = None
        self._SourceEngineTypes = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def RuleTemplateId(self):
        return self._RuleTemplateId

    @RuleTemplateId.setter
    def RuleTemplateId(self, RuleTemplateId):
        self._RuleTemplateId = RuleTemplateId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def SourceObjectDataTypeName(self):
        return self._SourceObjectDataTypeName

    @SourceObjectDataTypeName.setter
    def SourceObjectDataTypeName(self, SourceObjectDataTypeName):
        self._SourceObjectDataTypeName = SourceObjectDataTypeName

    @property
    def SourceObjectValue(self):
        return self._SourceObjectValue

    @SourceObjectValue.setter
    def SourceObjectValue(self, SourceObjectValue):
        self._SourceObjectValue = SourceObjectValue

    @property
    def ConditionType(self):
        return self._ConditionType

    @ConditionType.setter
    def ConditionType(self, ConditionType):
        self._ConditionType = ConditionType

    @property
    def ConditionExpression(self):
        return self._ConditionExpression

    @ConditionExpression.setter
    def ConditionExpression(self, ConditionExpression):
        self._ConditionExpression = ConditionExpression

    @property
    def CustomSql(self):
        return self._CustomSql

    @CustomSql.setter
    def CustomSql(self, CustomSql):
        self._CustomSql = CustomSql

    @property
    def CompareRule(self):
        return self._CompareRule

    @CompareRule.setter
    def CompareRule(self, CompareRule):
        self._CompareRule = CompareRule

    @property
    def AlarmLevel(self):
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def TargetDatabaseId(self):
        return self._TargetDatabaseId

    @TargetDatabaseId.setter
    def TargetDatabaseId(self, TargetDatabaseId):
        self._TargetDatabaseId = TargetDatabaseId

    @property
    def TargetTableId(self):
        return self._TargetTableId

    @TargetTableId.setter
    def TargetTableId(self, TargetTableId):
        self._TargetTableId = TargetTableId

    @property
    def TargetConditionExpr(self):
        return self._TargetConditionExpr

    @TargetConditionExpr.setter
    def TargetConditionExpr(self, TargetConditionExpr):
        self._TargetConditionExpr = TargetConditionExpr

    @property
    def RelConditionExpr(self):
        return self._RelConditionExpr

    @RelConditionExpr.setter
    def RelConditionExpr(self, RelConditionExpr):
        self._RelConditionExpr = RelConditionExpr

    @property
    def FieldConfig(self):
        return self._FieldConfig

    @FieldConfig.setter
    def FieldConfig(self, FieldConfig):
        self._FieldConfig = FieldConfig

    @property
    def TargetObjectValue(self):
        return self._TargetObjectValue

    @TargetObjectValue.setter
    def TargetObjectValue(self, TargetObjectValue):
        self._TargetObjectValue = TargetObjectValue

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._Name = params.get("Name")
        self._TableId = params.get("TableId")
        self._RuleTemplateId = params.get("RuleTemplateId")
        self._Type = params.get("Type")
        self._QualityDim = params.get("QualityDim")
        self._SourceObjectDataTypeName = params.get("SourceObjectDataTypeName")
        self._SourceObjectValue = params.get("SourceObjectValue")
        self._ConditionType = params.get("ConditionType")
        self._ConditionExpression = params.get("ConditionExpression")
        self._CustomSql = params.get("CustomSql")
        if params.get("CompareRule") is not None:
            self._CompareRule = CompareRule()
            self._CompareRule._deserialize(params.get("CompareRule"))
        self._AlarmLevel = params.get("AlarmLevel")
        self._Description = params.get("Description")
        self._DatasourceId = params.get("DatasourceId")
        self._DatabaseId = params.get("DatabaseId")
        self._TargetDatabaseId = params.get("TargetDatabaseId")
        self._TargetTableId = params.get("TargetTableId")
        self._TargetConditionExpr = params.get("TargetConditionExpr")
        self._RelConditionExpr = params.get("RelConditionExpr")
        if params.get("FieldConfig") is not None:
            self._FieldConfig = RuleFieldConfig()
            self._FieldConfig._deserialize(params.get("FieldConfig"))
        self._TargetObjectValue = params.get("TargetObjectValue")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRuleResponse(AbstractModel):
    """CreateRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.Rule`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = Rule()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateRuleTemplateRequest(AbstractModel):
    """CreateRuleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 模版类型  1.系统模版   2.自定义模版
        :type Type: int
        :param _Name: 模版名称
        :type Name: str
        :param _QualityDim: 质量检测维度 1.准确性 2.唯一性 3.完整性 4.一致性 5.及时性 6.有效性
        :type QualityDim: int
        :param _SourceObjectType: 源端数据对象类型 1.常量  2.离线表级   2.离线字段级
        :type SourceObjectType: int
        :param _Description: 模板描述
        :type Description: str
        :param _SourceEngineTypes: 源端对应的引擎类型
        :type SourceEngineTypes: list of int non-negative
        :param _MultiSourceFlag: 是否关联其它库表
        :type MultiSourceFlag: bool
        :param _SqlExpression: SQL 表达式
        :type SqlExpression: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WhereFlag: 是否添加where参数
        :type WhereFlag: bool
        """
        self._Type = None
        self._Name = None
        self._QualityDim = None
        self._SourceObjectType = None
        self._Description = None
        self._SourceEngineTypes = None
        self._MultiSourceFlag = None
        self._SqlExpression = None
        self._ProjectId = None
        self._WhereFlag = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def SourceObjectType(self):
        return self._SourceObjectType

    @SourceObjectType.setter
    def SourceObjectType(self, SourceObjectType):
        self._SourceObjectType = SourceObjectType

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes

    @property
    def MultiSourceFlag(self):
        return self._MultiSourceFlag

    @MultiSourceFlag.setter
    def MultiSourceFlag(self, MultiSourceFlag):
        self._MultiSourceFlag = MultiSourceFlag

    @property
    def SqlExpression(self):
        return self._SqlExpression

    @SqlExpression.setter
    def SqlExpression(self, SqlExpression):
        self._SqlExpression = SqlExpression

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WhereFlag(self):
        return self._WhereFlag

    @WhereFlag.setter
    def WhereFlag(self, WhereFlag):
        self._WhereFlag = WhereFlag


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._QualityDim = params.get("QualityDim")
        self._SourceObjectType = params.get("SourceObjectType")
        self._Description = params.get("Description")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        self._MultiSourceFlag = params.get("MultiSourceFlag")
        self._SqlExpression = params.get("SqlExpression")
        self._ProjectId = params.get("ProjectId")
        self._WhereFlag = params.get("WhereFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRuleTemplateResponse(AbstractModel):
    """CreateRuleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 模板Id
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateTaskAlarmRegularRequest(AbstractModel):
    """CreateTaskAlarmRegular请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskAlarmInfo: 告警配置信息
        :type TaskAlarmInfo: :class:`tencentcloud.wedata.v20210820.models.TaskAlarmInfo`
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._TaskAlarmInfo = None
        self._ProjectId = None

    @property
    def TaskAlarmInfo(self):
        return self._TaskAlarmInfo

    @TaskAlarmInfo.setter
    def TaskAlarmInfo(self, TaskAlarmInfo):
        self._TaskAlarmInfo = TaskAlarmInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("TaskAlarmInfo") is not None:
            self._TaskAlarmInfo = TaskAlarmInfo()
            self._TaskAlarmInfo._deserialize(params.get("TaskAlarmInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskAlarmRegularResponse(AbstractModel):
    """CreateTaskAlarmRegular返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlarmId = None
        self._RequestId = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._RequestId = params.get("RequestId")


class CreateTaskRequest(AbstractModel):
    """CreateTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WorkflowId: 工作流id
        :type WorkflowId: str
        :param _TaskName: 任务名
        :type TaskName: str
        :param _TaskType: 26离线同步，30Python，31PySpark，32DLC，33Impala，34Hive SQL，35Shell，36Spark SQL，39Spark，40CDW PG，92MapReduce
        :type TaskType: int
        :param _TaskExt: 扩展属性
        :type TaskExt: list of TaskExtInfo
        """
        self._ProjectId = None
        self._WorkflowId = None
        self._TaskName = None
        self._TaskType = None
        self._TaskExt = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskExt(self):
        return self._TaskExt

    @TaskExt.setter
    def TaskExt(self, TaskExt):
        self._TaskExt = TaskExt


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        self._TaskName = params.get("TaskName")
        self._TaskType = params.get("TaskType")
        if params.get("TaskExt") is not None:
            self._TaskExt = []
            for item in params.get("TaskExt"):
                obj = TaskExtInfo()
                obj._deserialize(item)
                self._TaskExt.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskResponse(AbstractModel):
    """CreateTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回任务Id
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonId`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonId()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateWorkflowRequest(AbstractModel):
    """CreateWorkflow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WorkflowName: 工作流名称
        :type WorkflowName: str
        :param _FolderId: 所属文件夹id
        :type FolderId: str
        """
        self._ProjectId = None
        self._WorkflowName = None
        self._FolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowName = params.get("WorkflowName")
        self._FolderId = params.get("FolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWorkflowResponse(AbstractModel):
    """CreateWorkflow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回工作流Id
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonId`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonId()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CvmAgentStatus(AbstractModel):
    """采集器状态统计

    """

    def __init__(self):
        r"""
        :param _Status: agent状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _Count: 对应状态的agent总数
注意：此字段可能返回 null，表示取不到有效值。
        :type Count: int
        """
        self._Status = None
        self._Count = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DailyScoreInfo(AbstractModel):
    """日评分信息

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期 时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type StatisticsDate: int
        :param _Score: 评分
注意：此字段可能返回 null，表示取不到有效值。
        :type Score: float
        """
        self._StatisticsDate = None
        self._Score = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._Score = params.get("Score")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataCheckStat(AbstractModel):
    """数据监测情况结果

    """

    def __init__(self):
        r"""
        :param _TableTotal: 表总数
        :type TableTotal: int
        :param _ColumnTotal: 字段总数
        :type ColumnTotal: int
        :param _TableConfig: 表配置检测数
        :type TableConfig: int
        :param _ColumnConfig: 字段配置检测数
        :type ColumnConfig: int
        :param _TableExec: 表实际检测数
        :type TableExec: int
        :param _ColumnExec: 字段实际检测数
        :type ColumnExec: int
        """
        self._TableTotal = None
        self._ColumnTotal = None
        self._TableConfig = None
        self._ColumnConfig = None
        self._TableExec = None
        self._ColumnExec = None

    @property
    def TableTotal(self):
        return self._TableTotal

    @TableTotal.setter
    def TableTotal(self, TableTotal):
        self._TableTotal = TableTotal

    @property
    def ColumnTotal(self):
        return self._ColumnTotal

    @ColumnTotal.setter
    def ColumnTotal(self, ColumnTotal):
        self._ColumnTotal = ColumnTotal

    @property
    def TableConfig(self):
        return self._TableConfig

    @TableConfig.setter
    def TableConfig(self, TableConfig):
        self._TableConfig = TableConfig

    @property
    def ColumnConfig(self):
        return self._ColumnConfig

    @ColumnConfig.setter
    def ColumnConfig(self, ColumnConfig):
        self._ColumnConfig = ColumnConfig

    @property
    def TableExec(self):
        return self._TableExec

    @TableExec.setter
    def TableExec(self, TableExec):
        self._TableExec = TableExec

    @property
    def ColumnExec(self):
        return self._ColumnExec

    @ColumnExec.setter
    def ColumnExec(self, ColumnExec):
        self._ColumnExec = ColumnExec


    def _deserialize(self, params):
        self._TableTotal = params.get("TableTotal")
        self._ColumnTotal = params.get("ColumnTotal")
        self._TableConfig = params.get("TableConfig")
        self._ColumnConfig = params.get("ColumnConfig")
        self._TableExec = params.get("TableExec")
        self._ColumnExec = params.get("ColumnExec")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSourceInfo(AbstractModel):
    """数据源对象

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 若数据源列表为绑定数据库，则为db名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _Description: 数据源描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _ID: 数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ID: int
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Instance: str
        :param _Name: 数据源名称，在相同SpaceName下，数据源名称不能为空
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Region: 数据源引擎所属区域
注意：此字段可能返回 null，表示取不到有效值。
        :type Region: str
        :param _Type: 数据源类型:枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _ClusterId: 数据源所属的集群id
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _AppId: 应用ID AppId
注意：此字段可能返回 null，表示取不到有效值。
        :type AppId: int
        :param _BizParams: 业务侧数据源的配置信息扩展
注意：此字段可能返回 null，表示取不到有效值。
        :type BizParams: str
        :param _Category: 数据源类别：绑定引擎、绑定数据库
注意：此字段可能返回 null，表示取不到有效值。
        :type Category: str
        :param _Display: 数据源展示名，为了可视化查看
注意：此字段可能返回 null，表示取不到有效值。
        :type Display: str
        :param _OwnerAccount: 数据源责任人账号ID
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerAccount: str
        :param _Params: 数据源的配置信息，以JSON KV存储，根据每个数据源类型不同，而KV存储信息不同
注意：此字段可能返回 null，表示取不到有效值。
        :type Params: str
        :param _Status: 数据源数据源的可见性，1为可见、0为不可见。默认为1
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _OwnerAccountName: 数据源责任人账号名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerAccountName: str
        :param _ClusterName: 集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _OwnerProjectId: 归属项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerProjectId: str
        :param _OwnerProjectName: 归属项目Name
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerProjectName: str
        :param _OwnerProjectIdent: 归属项目标识
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerProjectIdent: str
        :param _AuthorityProjectName: 授权项目
注意：此字段可能返回 null，表示取不到有效值。
        :type AuthorityProjectName: str
        :param _AuthorityUserName: 授权用户
注意：此字段可能返回 null，表示取不到有效值。
        :type AuthorityUserName: str
        :param _Edit: 是否有编辑权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Edit: bool
        :param _Author: 是否有授权权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Author: bool
        :param _Deliver: 是否有转交权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Deliver: bool
        :param _DataSourceStatus: 数据源状态
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSourceStatus: str
        :param _CreateTime: 时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: int
        :param _ParamsString: Params json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type ParamsString: str
        :param _BizParamsString: BizParams json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type BizParamsString: str
        :param _ModifiedTime: 修改时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifiedTime: int
        """
        self._DatabaseName = None
        self._Description = None
        self._ID = None
        self._Instance = None
        self._Name = None
        self._Region = None
        self._Type = None
        self._ClusterId = None
        self._AppId = None
        self._BizParams = None
        self._Category = None
        self._Display = None
        self._OwnerAccount = None
        self._Params = None
        self._Status = None
        self._OwnerAccountName = None
        self._ClusterName = None
        self._OwnerProjectId = None
        self._OwnerProjectName = None
        self._OwnerProjectIdent = None
        self._AuthorityProjectName = None
        self._AuthorityUserName = None
        self._Edit = None
        self._Author = None
        self._Deliver = None
        self._DataSourceStatus = None
        self._CreateTime = None
        self._ParamsString = None
        self._BizParamsString = None
        self._ModifiedTime = None

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ID(self):
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def BizParams(self):
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Display(self):
        return self._Display

    @Display.setter
    def Display(self, Display):
        self._Display = Display

    @property
    def OwnerAccount(self):
        return self._OwnerAccount

    @OwnerAccount.setter
    def OwnerAccount(self, OwnerAccount):
        self._OwnerAccount = OwnerAccount

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def OwnerAccountName(self):
        return self._OwnerAccountName

    @OwnerAccountName.setter
    def OwnerAccountName(self, OwnerAccountName):
        self._OwnerAccountName = OwnerAccountName

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def OwnerProjectId(self):
        return self._OwnerProjectId

    @OwnerProjectId.setter
    def OwnerProjectId(self, OwnerProjectId):
        self._OwnerProjectId = OwnerProjectId

    @property
    def OwnerProjectName(self):
        return self._OwnerProjectName

    @OwnerProjectName.setter
    def OwnerProjectName(self, OwnerProjectName):
        self._OwnerProjectName = OwnerProjectName

    @property
    def OwnerProjectIdent(self):
        return self._OwnerProjectIdent

    @OwnerProjectIdent.setter
    def OwnerProjectIdent(self, OwnerProjectIdent):
        self._OwnerProjectIdent = OwnerProjectIdent

    @property
    def AuthorityProjectName(self):
        return self._AuthorityProjectName

    @AuthorityProjectName.setter
    def AuthorityProjectName(self, AuthorityProjectName):
        self._AuthorityProjectName = AuthorityProjectName

    @property
    def AuthorityUserName(self):
        return self._AuthorityUserName

    @AuthorityUserName.setter
    def AuthorityUserName(self, AuthorityUserName):
        self._AuthorityUserName = AuthorityUserName

    @property
    def Edit(self):
        return self._Edit

    @Edit.setter
    def Edit(self, Edit):
        self._Edit = Edit

    @property
    def Author(self):
        return self._Author

    @Author.setter
    def Author(self, Author):
        self._Author = Author

    @property
    def Deliver(self):
        return self._Deliver

    @Deliver.setter
    def Deliver(self, Deliver):
        self._Deliver = Deliver

    @property
    def DataSourceStatus(self):
        return self._DataSourceStatus

    @DataSourceStatus.setter
    def DataSourceStatus(self, DataSourceStatus):
        self._DataSourceStatus = DataSourceStatus

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ParamsString(self):
        return self._ParamsString

    @ParamsString.setter
    def ParamsString(self, ParamsString):
        self._ParamsString = ParamsString

    @property
    def BizParamsString(self):
        return self._BizParamsString

    @BizParamsString.setter
    def BizParamsString(self, BizParamsString):
        self._BizParamsString = BizParamsString

    @property
    def ModifiedTime(self):
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._Description = params.get("Description")
        self._ID = params.get("ID")
        self._Instance = params.get("Instance")
        self._Name = params.get("Name")
        self._Region = params.get("Region")
        self._Type = params.get("Type")
        self._ClusterId = params.get("ClusterId")
        self._AppId = params.get("AppId")
        self._BizParams = params.get("BizParams")
        self._Category = params.get("Category")
        self._Display = params.get("Display")
        self._OwnerAccount = params.get("OwnerAccount")
        self._Params = params.get("Params")
        self._Status = params.get("Status")
        self._OwnerAccountName = params.get("OwnerAccountName")
        self._ClusterName = params.get("ClusterName")
        self._OwnerProjectId = params.get("OwnerProjectId")
        self._OwnerProjectName = params.get("OwnerProjectName")
        self._OwnerProjectIdent = params.get("OwnerProjectIdent")
        self._AuthorityProjectName = params.get("AuthorityProjectName")
        self._AuthorityUserName = params.get("AuthorityUserName")
        self._Edit = params.get("Edit")
        self._Author = params.get("Author")
        self._Deliver = params.get("Deliver")
        self._DataSourceStatus = params.get("DataSourceStatus")
        self._CreateTime = params.get("CreateTime")
        self._ParamsString = params.get("ParamsString")
        self._BizParamsString = params.get("BizParamsString")
        self._ModifiedTime = params.get("ModifiedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSourceInfoPage(AbstractModel):
    """查询数据源分页列表

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页页码
注意：此字段可能返回 null，表示取不到有效值。
        :type PageNumber: int
        :param _PageSize: 分页大小
注意：此字段可能返回 null，表示取不到有效值。
        :type PageSize: int
        :param _Rows: 数据源列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Rows: list of DataSourceInfo
        :param _TotalCount: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _TotalPageNumber: 总分页页码
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalPageNumber: int
        """
        self._PageNumber = None
        self._PageSize = None
        self._Rows = None
        self._TotalCount = None
        self._TotalPageNumber = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Rows(self):
        return self._Rows

    @Rows.setter
    def Rows(self, Rows):
        self._Rows = Rows

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPageNumber(self):
        return self._TotalPageNumber

    @TotalPageNumber.setter
    def TotalPageNumber(self, TotalPageNumber):
        self._TotalPageNumber = TotalPageNumber


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Rows") is not None:
            self._Rows = []
            for item in params.get("Rows"):
                obj = DataSourceInfo()
                obj._deserialize(item)
                self._Rows.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._TotalPageNumber = params.get("TotalPageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatabaseInfo(AbstractModel):
    """数据质量数据来源数据库

    """

    def __init__(self):
        r"""
        :param _DatasourceName: 数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceName: str
        :param _DatasourceId: 数据源Id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _DatabaseName: 数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _DatabaseId: 数据库id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _InstanceId: 实例Id
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _DatasourceType: 数据源类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceType: int
        :param _OriginDatabaseName: 数据库原始名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OriginDatabaseName: str
        :param _OriginSchemaName: schema名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OriginSchemaName: str
        """
        self._DatasourceName = None
        self._DatasourceId = None
        self._DatabaseName = None
        self._DatabaseId = None
        self._InstanceId = None
        self._DatasourceType = None
        self._OriginDatabaseName = None
        self._OriginSchemaName = None

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType

    @property
    def OriginDatabaseName(self):
        return self._OriginDatabaseName

    @OriginDatabaseName.setter
    def OriginDatabaseName(self, OriginDatabaseName):
        self._OriginDatabaseName = OriginDatabaseName

    @property
    def OriginSchemaName(self):
        return self._OriginSchemaName

    @OriginSchemaName.setter
    def OriginSchemaName(self, OriginSchemaName):
        self._OriginSchemaName = OriginSchemaName


    def _deserialize(self, params):
        self._DatasourceName = params.get("DatasourceName")
        self._DatasourceId = params.get("DatasourceId")
        self._DatabaseName = params.get("DatabaseName")
        self._DatabaseId = params.get("DatabaseId")
        self._InstanceId = params.get("InstanceId")
        self._DatasourceType = params.get("DatasourceType")
        self._OriginDatabaseName = params.get("OriginDatabaseName")
        self._OriginSchemaName = params.get("OriginSchemaName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasourceBaseInfo(AbstractModel):
    """数据源对象

    """

    def __init__(self):
        r"""
        :param _DatabaseNames: 若数据源列表为绑定数据库，则为db名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseNames: list of str
        :param _Description: 数据源描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _ID: 数据源ID
        :type ID: int
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Instance: str
        :param _Name: 数据源名称，在相同SpaceName下，数据源名称不能为空
        :type Name: str
        :param _Region: 数据源引擎所属区域
注意：此字段可能返回 null，表示取不到有效值。
        :type Region: str
        :param _Type: 数据源类型:枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _ClusterId: 数据源所属的集群id
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _Version: 数据源版本信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Version: str
        """
        self._DatabaseNames = None
        self._Description = None
        self._ID = None
        self._Instance = None
        self._Name = None
        self._Region = None
        self._Type = None
        self._ClusterId = None
        self._Version = None

    @property
    def DatabaseNames(self):
        return self._DatabaseNames

    @DatabaseNames.setter
    def DatabaseNames(self, DatabaseNames):
        self._DatabaseNames = DatabaseNames

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ID(self):
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version


    def _deserialize(self, params):
        self._DatabaseNames = params.get("DatabaseNames")
        self._Description = params.get("Description")
        self._ID = params.get("ID")
        self._Instance = params.get("Instance")
        self._Name = params.get("Name")
        self._Region = params.get("Region")
        self._Type = params.get("Type")
        self._ClusterId = params.get("ClusterId")
        self._Version = params.get("Version")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomFunctionRequest(AbstractModel):
    """DeleteCustomFunction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIdentifier: 集群实例 ID
        :type ClusterIdentifier: str
        :param _FunctionId: 函数 ID
        :type FunctionId: str
        :param _ProjectId: 项目ID，必须填
        :type ProjectId: str
        """
        self._ClusterIdentifier = None
        self._FunctionId = None
        self._ProjectId = None

    @property
    def ClusterIdentifier(self):
        return self._ClusterIdentifier

    @ClusterIdentifier.setter
    def ClusterIdentifier(self, ClusterIdentifier):
        self._ClusterIdentifier = ClusterIdentifier

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ClusterIdentifier = params.get("ClusterIdentifier")
        self._FunctionId = params.get("FunctionId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomFunctionResponse(AbstractModel):
    """DeleteCustomFunction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionId: 函数 ID
注意：此字段可能返回 null，表示取不到有效值。
        :type FunctionId: str
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FunctionId = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DeleteDataSourcesRequest(AbstractModel):
    """DeleteDataSources请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: id列表
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDataSourcesResponse(AbstractModel):
    """DeleteDataSources返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteFolderRequest(AbstractModel):
    """DeleteFolder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _FolderId: 文件夹ID
        :type FolderId: str
        """
        self._ProjectId = None
        self._FolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderId = params.get("FolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFolderResponse(AbstractModel):
    """DeleteFolder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: true代表删除成功，false代表删除失败
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteInLongAgentRequest(AbstractModel):
    """DeleteInLongAgent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentId: 采集器ID
        :type AgentId: str
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        """
        self._AgentId = None
        self._ProjectId = None

    @property
    def AgentId(self):
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._AgentId = params.get("AgentId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteInLongAgentResponse(AbstractModel):
    """DeleteInLongAgent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteIntegrationNodeRequest(AbstractModel):
    """DeleteIntegrationNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 节点id
        :type Id: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Id = None
        self._ProjectId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIntegrationNodeResponse(AbstractModel):
    """DeleteIntegrationNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除返回是否成功标识
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteIntegrationTaskRequest(AbstractModel):
    """DeleteIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIntegrationTaskResponse(AbstractModel):
    """DeleteIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务删除成功与否标识
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteOfflineTaskRequest(AbstractModel):
    """DeleteOfflineTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OperatorName: 操作者name
        :type OperatorName: str
        :param _ProjectId: 项目/工作空间id
        :type ProjectId: str
        :param _TaskId: 任务id
        :type TaskId: str
        :param _VirtualFlag: 虚拟任务标记(跟之前调度接口保持一致默认false)
        :type VirtualFlag: bool
        """
        self._OperatorName = None
        self._ProjectId = None
        self._TaskId = None
        self._VirtualFlag = None

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VirtualFlag(self):
        return self._VirtualFlag

    @VirtualFlag.setter
    def VirtualFlag(self, VirtualFlag):
        self._VirtualFlag = VirtualFlag


    def _deserialize(self, params):
        self._OperatorName = params.get("OperatorName")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._VirtualFlag = params.get("VirtualFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOfflineTaskResponse(AbstractModel):
    """DeleteOfflineTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteResourceRequest(AbstractModel):
    """DeleteResource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _ResourceId: 资源ID
        :type ResourceId: str
        """
        self._ProjectId = None
        self._ResourceId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteResourceResponse(AbstractModel):
    """DeleteResource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteRuleRequest(AbstractModel):
    """DeleteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 质量规则ID
        :type RuleId: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._RuleId = None
        self._ProjectId = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRuleResponse(AbstractModel):
    """DeleteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteRuleTemplateRequest(AbstractModel):
    """DeleteRuleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Ids: 模版Id列表
        :type Ids: list of int non-negative
        """
        self._ProjectId = None
        self._Ids = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRuleTemplateResponse(AbstractModel):
    """DeleteRuleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteTaskAlarmRegularRequest(AbstractModel):
    """DeleteTaskAlarmRegular请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 主键ID
        :type Id: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _TaskType: 任务类型(201表示实时任务，202表示离线任务)
        :type TaskType: int
        """
        self._Id = None
        self._ProjectId = None
        self._TaskId = None
        self._TaskType = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTaskAlarmRegularResponse(AbstractModel):
    """DeleteTaskAlarmRegular返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除结果(true表示删除成功，false表示删除失败)
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteWorkflowNewRequest(AbstractModel):
    """DeleteWorkflowNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkFlowId: 工作流id
        :type WorkFlowId: str
        :param _DeleteMode: true : 删除后下游任务可正常运行
false：删除后下游任务不可运行
        :type DeleteMode: bool
        :param _EnableNotify: true：通知下游任务责任人
false:  不通知下游任务责任人
        :type EnableNotify: bool
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._WorkFlowId = None
        self._DeleteMode = None
        self._EnableNotify = None
        self._ProjectId = None

    @property
    def WorkFlowId(self):
        return self._WorkFlowId

    @WorkFlowId.setter
    def WorkFlowId(self, WorkFlowId):
        self._WorkFlowId = WorkFlowId

    @property
    def DeleteMode(self):
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode

    @property
    def EnableNotify(self):
        return self._EnableNotify

    @EnableNotify.setter
    def EnableNotify(self, EnableNotify):
        self._EnableNotify = EnableNotify

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._WorkFlowId = params.get("WorkFlowId")
        self._DeleteMode = params.get("DeleteMode")
        self._EnableNotify = params.get("EnableNotify")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWorkflowNewResponse(AbstractModel):
    """DeleteWorkflowNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回删除结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DependencyConfig(AbstractModel):
    """依赖配置

    """

    def __init__(self):
        r"""
        :param _DependConfType: 仅五种周期运行依赖配置： HOUR,DAY,WEEK,MONTH,YEAR,CRONTAB,MINUTE
        :type DependConfType: str
        :param _SubordinateCyclicType: 依赖配置从属周期类型，CURRENT_HOUR，PREVIOUS_HOUR，CURRENT_DAY，PREVIOUS_DAY，PREVIOUS_WEEK，PREVIOUS_FRIDAY，PREVIOUS_WEEKEND，CURRENT_MONTH，PREVIOUS_MONTH，PREVIOUS_END_OF_MONTH
     * PREVIOUS_BEGIN_OF_MONTH，ALL_MONTH_OF_YEAR，ALL_DAY_OF_YEAR，CURRENT_YEAR，CURRENT，CURRENT_MINUTE，PREVIOUS_MINUTE_CYCLE，PREVIOUS_HOUR_CYCLE
        :type SubordinateCyclicType: str
        :param _DependencyStrategy: WAITING，等待（默认策略）EXECUTING:执行
        :type DependencyStrategy: str
        :param _ParentTask: 父任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentTask: :class:`tencentcloud.wedata.v20210820.models.TaskInnerInfo`
        :param _SonTask: 子任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type SonTask: :class:`tencentcloud.wedata.v20210820.models.TaskInnerInfo`
        """
        self._DependConfType = None
        self._SubordinateCyclicType = None
        self._DependencyStrategy = None
        self._ParentTask = None
        self._SonTask = None

    @property
    def DependConfType(self):
        return self._DependConfType

    @DependConfType.setter
    def DependConfType(self, DependConfType):
        self._DependConfType = DependConfType

    @property
    def SubordinateCyclicType(self):
        return self._SubordinateCyclicType

    @SubordinateCyclicType.setter
    def SubordinateCyclicType(self, SubordinateCyclicType):
        self._SubordinateCyclicType = SubordinateCyclicType

    @property
    def DependencyStrategy(self):
        return self._DependencyStrategy

    @DependencyStrategy.setter
    def DependencyStrategy(self, DependencyStrategy):
        self._DependencyStrategy = DependencyStrategy

    @property
    def ParentTask(self):
        return self._ParentTask

    @ParentTask.setter
    def ParentTask(self, ParentTask):
        self._ParentTask = ParentTask

    @property
    def SonTask(self):
        return self._SonTask

    @SonTask.setter
    def SonTask(self, SonTask):
        self._SonTask = SonTask


    def _deserialize(self, params):
        self._DependConfType = params.get("DependConfType")
        self._SubordinateCyclicType = params.get("SubordinateCyclicType")
        self._DependencyStrategy = params.get("DependencyStrategy")
        if params.get("ParentTask") is not None:
            self._ParentTask = TaskInnerInfo()
            self._ParentTask._deserialize(params.get("ParentTask"))
        if params.get("SonTask") is not None:
            self._SonTask = TaskInnerInfo()
            self._SonTask._deserialize(params.get("SonTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmEventsRequest(AbstractModel):
    """DescribeAlarmEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件(key可以是：AlarmLevel,AlarmIndicator,KeyWord)
        :type Filters: list of Filter
        :param _OrderFields: 排序字段（AlarmTime）
        :type OrderFields: list of OrderField
        :param _TaskType: 类型(201表示实时，202表示离线)
        :type TaskType: int
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        """
        self._Filters = None
        self._OrderFields = None
        self._TaskType = None
        self._StartTime = None
        self._EndTime = None
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._TaskType = params.get("TaskType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmEventsResponse(AbstractModel):
    """DescribeAlarmEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmEventInfoList: 告警事件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmEventInfoList: list of AlarmEventInfo
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlarmEventInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AlarmEventInfoList(self):
        return self._AlarmEventInfoList

    @AlarmEventInfoList.setter
    def AlarmEventInfoList(self, AlarmEventInfoList):
        self._AlarmEventInfoList = AlarmEventInfoList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlarmEventInfoList") is not None:
            self._AlarmEventInfoList = []
            for item in params.get("AlarmEventInfoList"):
                obj = AlarmEventInfo()
                obj._deserialize(item)
                self._AlarmEventInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAlarmReceiverRequest(AbstractModel):
    """DescribeAlarmReceiver请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: str
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _MessageId: 消息ID
        :type MessageId: str
        :param _TaskType: 类型
        :type TaskType: int
        :param _AlarmRecipient: 告警接收人ID(逗号分隔)
        :type AlarmRecipient: str
        :param _AlarmRecipientName: 告警接收人姓名(逗号分隔)
        :type AlarmRecipientName: str
        :param _AlarmTime: 告警时间
        :type AlarmTime: str
        """
        self._AlarmId = None
        self._PageNumber = None
        self._PageSize = None
        self._ProjectId = None
        self._MessageId = None
        self._TaskType = None
        self._AlarmRecipient = None
        self._AlarmRecipientName = None
        self._AlarmTime = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def MessageId(self):
        return self._MessageId

    @MessageId.setter
    def MessageId(self, MessageId):
        self._MessageId = MessageId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def AlarmRecipient(self):
        return self._AlarmRecipient

    @AlarmRecipient.setter
    def AlarmRecipient(self, AlarmRecipient):
        self._AlarmRecipient = AlarmRecipient

    @property
    def AlarmRecipientName(self):
        return self._AlarmRecipientName

    @AlarmRecipientName.setter
    def AlarmRecipientName(self, AlarmRecipientName):
        self._AlarmRecipientName = AlarmRecipientName

    @property
    def AlarmTime(self):
        return self._AlarmTime

    @AlarmTime.setter
    def AlarmTime(self, AlarmTime):
        self._AlarmTime = AlarmTime


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        self._MessageId = params.get("MessageId")
        self._TaskType = params.get("TaskType")
        self._AlarmRecipient = params.get("AlarmRecipient")
        self._AlarmRecipientName = params.get("AlarmRecipientName")
        self._AlarmTime = params.get("AlarmTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmReceiverResponse(AbstractModel):
    """DescribeAlarmReceiver返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmReceiverInfoList: 告警接收人列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmReceiverInfoList: list of AlarmReceiverInfo
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlarmReceiverInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AlarmReceiverInfoList(self):
        return self._AlarmReceiverInfoList

    @AlarmReceiverInfoList.setter
    def AlarmReceiverInfoList(self, AlarmReceiverInfoList):
        self._AlarmReceiverInfoList = AlarmReceiverInfoList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlarmReceiverInfoList") is not None:
            self._AlarmReceiverInfoList = []
            for item in params.get("AlarmReceiverInfoList"):
                obj = AlarmReceiverInfo()
                obj._deserialize(item)
                self._AlarmReceiverInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeBatchOperateTaskDTO(AbstractModel):
    """批量操作任务列表

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _TaskName: 任务名
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _WorkflowId: 工作流Id
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowId: str
        :param _WorkflowName: 工作流名
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowName: str
        :param _Status: 状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _TaskTypeId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskTypeId: int
        :param _TaskTypeDesc: 任务类型
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskTypeDesc: str
        :param _FolderName: 文件夹名
注意：此字段可能返回 null，表示取不到有效值。
        :type FolderName: str
        :param _FolderId: 文件夹ID
注意：此字段可能返回 null，表示取不到有效值。
        :type FolderId: str
        :param _InCharge: 负责人
注意：此字段可能返回 null，表示取不到有效值。
        :type InCharge: str
        :param _Submit: 是否提交
注意：此字段可能返回 null，表示取不到有效值。
        :type Submit: int
        :param _DataEngine: 引擎：
presto\SparkJob\SparkSql
注意：此字段可能返回 null，表示取不到有效值。
        :type DataEngine: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _CreateTime: 创造时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        """
        self._TaskId = None
        self._TaskName = None
        self._WorkflowId = None
        self._WorkflowName = None
        self._Status = None
        self._TaskTypeId = None
        self._TaskTypeDesc = None
        self._FolderName = None
        self._FolderId = None
        self._InCharge = None
        self._Submit = None
        self._DataEngine = None
        self._UpdateTime = None
        self._CreateTime = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskTypeId(self):
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId

    @property
    def TaskTypeDesc(self):
        return self._TaskTypeDesc

    @TaskTypeDesc.setter
    def TaskTypeDesc(self, TaskTypeDesc):
        self._TaskTypeDesc = TaskTypeDesc

    @property
    def FolderName(self):
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def Submit(self):
        return self._Submit

    @Submit.setter
    def Submit(self, Submit):
        self._Submit = Submit

    @property
    def DataEngine(self):
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._WorkflowId = params.get("WorkflowId")
        self._WorkflowName = params.get("WorkflowName")
        self._Status = params.get("Status")
        self._TaskTypeId = params.get("TaskTypeId")
        self._TaskTypeDesc = params.get("TaskTypeDesc")
        self._FolderName = params.get("FolderName")
        self._FolderId = params.get("FolderId")
        self._InCharge = params.get("InCharge")
        self._Submit = params.get("Submit")
        self._DataEngine = params.get("DataEngine")
        self._UpdateTime = params.get("UpdateTime")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskPage(AbstractModel):
    """批量操作任务列表分页

    """

    def __init__(self):
        r"""
        :param _PageCount: 总页码数
注意：此字段可能返回 null，表示取不到有效值。
        :type PageCount: int
        :param _Items: 内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of DescribeBatchOperateTaskDTO
        :param _TotalCount: 总个数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        """
        self._PageCount = None
        self._Items = None
        self._TotalCount = None

    @property
    def PageCount(self):
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        self._PageCount = params.get("PageCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = DescribeBatchOperateTaskDTO()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskRequest(AbstractModel):
    """DescribeBatchOperateTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Page: 页码
        :type Page: str
        :param _Size: 页号
        :type Size: str
        :param _StatusList: 状态列表
草稿：'NS'，'N','P','R'
运行：''Y'
停止：'F'
冻结：'O'
停止中：'T'
        :type StatusList: list of str
        :param _OwnerNameList: 责任人名列表
        :type OwnerNameList: list of str
        :param _WorkflowIdList: 工作流列表
        :type WorkflowIdList: list of str
        :param _TaskNameFilter: 任务名称搜索
        :type TaskNameFilter: str
        :param _TaskTypeList: 任务类型列表
        :type TaskTypeList: list of str
        :param _FordIdList: 文件夹列表
        :type FordIdList: list of str
        :param _TaskIdFilter: 任务Id搜索
        :type TaskIdFilter: str
        :param _OwnerNameFilter: 责任人搜索
        :type OwnerNameFilter: str
        :param _SortItem: 排序字段：
UpdateTime
CreateTime
        :type SortItem: str
        :param _SortType: asc:升序
desc:降序
        :type SortType: str
        :param _DataEngineList: 引擎类型列表：三种
SparkJob
SparkSql
presto
        :type DataEngineList: list of str
        :param _UserId: 操作人名
        :type UserId: str
        :param _OwnerId: 1
        :type OwnerId: str
        :param _TenantId: 1
        :type TenantId: str
        """
        self._ProjectId = None
        self._Page = None
        self._Size = None
        self._StatusList = None
        self._OwnerNameList = None
        self._WorkflowIdList = None
        self._TaskNameFilter = None
        self._TaskTypeList = None
        self._FordIdList = None
        self._TaskIdFilter = None
        self._OwnerNameFilter = None
        self._SortItem = None
        self._SortType = None
        self._DataEngineList = None
        self._UserId = None
        self._OwnerId = None
        self._TenantId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Page(self):
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def OwnerNameList(self):
        return self._OwnerNameList

    @OwnerNameList.setter
    def OwnerNameList(self, OwnerNameList):
        self._OwnerNameList = OwnerNameList

    @property
    def WorkflowIdList(self):
        return self._WorkflowIdList

    @WorkflowIdList.setter
    def WorkflowIdList(self, WorkflowIdList):
        self._WorkflowIdList = WorkflowIdList

    @property
    def TaskNameFilter(self):
        return self._TaskNameFilter

    @TaskNameFilter.setter
    def TaskNameFilter(self, TaskNameFilter):
        self._TaskNameFilter = TaskNameFilter

    @property
    def TaskTypeList(self):
        return self._TaskTypeList

    @TaskTypeList.setter
    def TaskTypeList(self, TaskTypeList):
        self._TaskTypeList = TaskTypeList

    @property
    def FordIdList(self):
        return self._FordIdList

    @FordIdList.setter
    def FordIdList(self, FordIdList):
        self._FordIdList = FordIdList

    @property
    def TaskIdFilter(self):
        return self._TaskIdFilter

    @TaskIdFilter.setter
    def TaskIdFilter(self, TaskIdFilter):
        self._TaskIdFilter = TaskIdFilter

    @property
    def OwnerNameFilter(self):
        return self._OwnerNameFilter

    @OwnerNameFilter.setter
    def OwnerNameFilter(self, OwnerNameFilter):
        self._OwnerNameFilter = OwnerNameFilter

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def DataEngineList(self):
        return self._DataEngineList

    @DataEngineList.setter
    def DataEngineList(self, DataEngineList):
        self._DataEngineList = DataEngineList

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def OwnerId(self):
        return self._OwnerId

    @OwnerId.setter
    def OwnerId(self, OwnerId):
        self._OwnerId = OwnerId

    @property
    def TenantId(self):
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Page = params.get("Page")
        self._Size = params.get("Size")
        self._StatusList = params.get("StatusList")
        self._OwnerNameList = params.get("OwnerNameList")
        self._WorkflowIdList = params.get("WorkflowIdList")
        self._TaskNameFilter = params.get("TaskNameFilter")
        self._TaskTypeList = params.get("TaskTypeList")
        self._FordIdList = params.get("FordIdList")
        self._TaskIdFilter = params.get("TaskIdFilter")
        self._OwnerNameFilter = params.get("OwnerNameFilter")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._DataEngineList = params.get("DataEngineList")
        self._UserId = params.get("UserId")
        self._OwnerId = params.get("OwnerId")
        self._TenantId = params.get("TenantId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskResponse(AbstractModel):
    """DescribeBatchOperateTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeBatchOperateTaskPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeBatchOperateTaskPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeClusterNamespaceListRequest(AbstractModel):
    """DescribeClusterNamespaceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        """
        self._ClusterId = None
        self._ProjectId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterNamespaceListResponse(AbstractModel):
    """DescribeClusterNamespaceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Namespaces: 命名空间
        :type Namespaces: list of Namespace
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Namespaces = None
        self._RequestId = None

    @property
    def Namespaces(self):
        return self._Namespaces

    @Namespaces.setter
    def Namespaces(self, Namespaces):
        self._Namespaces = Namespaces

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Namespaces") is not None:
            self._Namespaces = []
            for item in params.get("Namespaces"):
                obj = Namespace()
                obj._deserialize(item)
                self._Namespaces.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataBasesRequest(AbstractModel):
    """DescribeDataBases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _DatasourceId: 数据源id
        :type DatasourceId: str
        :param _DsTypes: 数据源类型
        :type DsTypes: list of int non-negative
        """
        self._ProjectId = None
        self._DatasourceId = None
        self._DsTypes = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DsTypes(self):
        return self._DsTypes

    @DsTypes.setter
    def DsTypes(self, DsTypes):
        self._DsTypes = DsTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._DsTypes = params.get("DsTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataBasesResponse(AbstractModel):
    """DescribeDataBases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据来源数据数据库列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of DatabaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DatabaseInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataCheckStatRequest(AbstractModel):
    """DescribeDataCheckStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id
        :type ProjectId: str
        :param _BeginDate: 开始时间，时间戳到秒
        :type BeginDate: str
        :param _EndDate: 结束时间，时间戳到秒
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataCheckStatResponse(AbstractModel):
    """DescribeDataCheckStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataCheckStat`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataCheckStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDataObjectsRequest(AbstractModel):
    """DescribeDataObjects请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceId: 数据来源ID
        :type DatasourceId: str
        :param _TableId: 数据表ID
        :type TableId: str
        :param _RuleGroupId: 质量规则组ID
        :type RuleGroupId: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._DatasourceId = None
        self._TableId = None
        self._RuleGroupId = None
        self._ProjectId = None

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._TableId = params.get("TableId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataObjectsResponse(AbstractModel):
    """DescribeDataObjects返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据对象列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of SourceObject
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = SourceObject()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataSourceInfoListRequest(AbstractModel):
    """DescribeDataSourceInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 工作空间id
        :type ProjectId: str
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 页数
        :type PageSize: int
        :param _Filters: 可选过滤条件，Filter可选配置(参考): "Name": { "type": "string", "description": "数据源名称" }, "Type": { "type": "string", "description": "类型" }, "ClusterId": { "type": "string", "description": "集群id" }, "CategoryId": { "type": "string", "description": "分类，项目或空间id" }
        :type Filters: :class:`tencentcloud.wedata.v20210820.models.Filter`
        :param _OrderFields: 排序配置
        :type OrderFields: :class:`tencentcloud.wedata.v20210820.models.OrderField`
        :param _Type: 数据源类型
        :type Type: str
        :param _DatasourceName: 数据源名称过滤用
        :type DatasourceName: str
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._Type = None
        self._DatasourceName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = Filter()
            self._Filters._deserialize(params.get("Filters"))
        if params.get("OrderFields") is not None:
            self._OrderFields = OrderField()
            self._OrderFields._deserialize(params.get("OrderFields"))
        self._Type = params.get("Type")
        self._DatasourceName = params.get("DatasourceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataSourceInfoListResponse(AbstractModel):
    """DescribeDataSourceInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数。
        :type TotalCount: int
        :param _DatasourceSet: 数据源信息列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceSet: list of DatasourceBaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._DatasourceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DatasourceSet(self):
        return self._DatasourceSet

    @DatasourceSet.setter
    def DatasourceSet(self, DatasourceSet):
        self._DatasourceSet = DatasourceSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DatasourceSet") is not None:
            self._DatasourceSet = []
            for item in params.get("DatasourceSet"):
                obj = DatasourceBaseInfo()
                obj._deserialize(item)
                self._DatasourceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataSourceListRequest(AbstractModel):
    """DescribeDataSourceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 返回数量
        :type PageSize: int
        :param _OrderFields: 排序配置
        :type OrderFields: list of OrderField
        :param _Filters: 可选过滤条件，Filter可选配置(参考): "Name": { "type": "string", "description": "数据源名称" }, "Type": { "type": "string", "description": "类型" }, "ClusterId": { "type": "string", "description": "集群id" }, "CategoryId": { "type": "string", "description": "分类，项目或空间id" }
        :type Filters: list of Filter
        """
        self._PageNumber = None
        self._PageSize = None
        self._OrderFields = None
        self._Filters = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataSourceListResponse(AbstractModel):
    """DescribeDataSourceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据源列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataSourceInfoPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataSourceInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDataSourceWithoutInfoRequest(AbstractModel):
    """DescribeDataSourceWithoutInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OrderFields: 1
        :type OrderFields: list of OrderField
        :param _Filters: 1
        :type Filters: list of Filter
        """
        self._OrderFields = None
        self._Filters = None

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataSourceWithoutInfoResponse(AbstractModel):
    """DescribeDataSourceWithoutInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of DataSourceInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DataSourceInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataTypesRequest(AbstractModel):
    """DescribeDataTypes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceType: 数据源类型，MYSQL|KAFKA等
        :type DatasourceType: str
        :param _ProjectId: 项目ID。
        :type ProjectId: str
        """
        self._DatasourceType = None
        self._ProjectId = None

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._DatasourceType = params.get("DatasourceType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataTypesResponse(AbstractModel):
    """DescribeDataTypes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TypeInfoSet: 字段类型列表。
        :type TypeInfoSet: list of Label
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TypeInfoSet = None
        self._RequestId = None

    @property
    def TypeInfoSet(self):
        return self._TypeInfoSet

    @TypeInfoSet.setter
    def TypeInfoSet(self, TypeInfoSet):
        self._TypeInfoSet = TypeInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TypeInfoSet") is not None:
            self._TypeInfoSet = []
            for item in params.get("TypeInfoSet"):
                obj = Label()
                obj._deserialize(item)
                self._TypeInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDatabaseInfoListRequest(AbstractModel):
    """DescribeDatabaseInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        :param _ConnectionType: 如果是hive这里写rpc，如果是其他类型不传
        :type ConnectionType: str
        """
        self._Filters = None
        self._ConnectionType = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ConnectionType(self):
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ConnectionType = params.get("ConnectionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatabaseInfoListResponse(AbstractModel):
    """DescribeDatabaseInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseInfo: 数据库列表
        :type DatabaseInfo: list of DatabaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DatabaseInfo = None
        self._RequestId = None

    @property
    def DatabaseInfo(self):
        return self._DatabaseInfo

    @DatabaseInfo.setter
    def DatabaseInfo(self, DatabaseInfo):
        self._DatabaseInfo = DatabaseInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DatabaseInfo") is not None:
            self._DatabaseInfo = []
            for item in params.get("DatabaseInfo"):
                obj = DatabaseInfo()
                obj._deserialize(item)
                self._DatabaseInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDatasourceRequest(AbstractModel):
    """DescribeDatasource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 对象唯一ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatasourceResponse(AbstractModel):
    """DescribeDatasource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据源对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataSourceInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataSourceInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDependTasksNewRequest(AbstractModel):
    """DescribeDependTasksNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _Deep: 上游/下游层级1-6级
        :type Deep: int
        :param _Up: 1: 表示查询上游节点；0:表示查询下游节点；2：表示查询上游和下游节点
        :type Up: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _WorkflowId: 任务工作流id
        :type WorkflowId: str
        """
        self._TaskId = None
        self._Deep = None
        self._Up = None
        self._ProjectId = None
        self._WorkflowId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Deep(self):
        return self._Deep

    @Deep.setter
    def Deep(self, Deep):
        self._Deep = Deep

    @property
    def Up(self):
        return self._Up

    @Up.setter
    def Up(self, Up):
        self._Up = Up

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Deep = params.get("Deep")
        self._Up = params.get("Up")
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDependTasksNewResponse(AbstractModel):
    """DescribeDependTasksNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 画布任务和链接信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CanvasInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CanvasInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDimensionScoreRequest(AbstractModel):
    """DescribeDimensionScore请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期 时间戳
        :type StatisticsDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._Filters = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDimensionScoreResponse(AbstractModel):
    """DescribeDimensionScore返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 维度评分
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DimensionScore`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DimensionScore()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeExecStrategyRequest(AbstractModel):
    """DescribeExecStrategy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组Id
        :type RuleGroupId: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._RuleGroupId = None
        self._ProjectId = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExecStrategyResponse(AbstractModel):
    """DescribeExecStrategy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组执行策略
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecStrategy`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecStrategy()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeFolderListData(AbstractModel):
    """文件夹分页信息

    """

    def __init__(self):
        r"""
        :param _Items: 文件夹信息列表
        :type Items: list of Folder
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _PageNumber: 页号
        :type PageNumber: int
        :param _PageSize: 页大小
        :type PageSize: int
        """
        self._Items = None
        self._TotalCount = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = Folder()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderListRequest(AbstractModel):
    """DescribeFolderList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _ParentsFolderId: 文件夹ID
        :type ParentsFolderId: str
        :param _KeyWords: 关键字
        :type KeyWords: str
        :param _PageNumber: 页码，默认1
        :type PageNumber: int
        :param _PageSize: 页大小，默认10
        :type PageSize: int
        """
        self._ProjectId = None
        self._ParentsFolderId = None
        self._KeyWords = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId

    @property
    def KeyWords(self):
        return self._KeyWords

    @KeyWords.setter
    def KeyWords(self, KeyWords):
        self._KeyWords = KeyWords

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ParentsFolderId = params.get("ParentsFolderId")
        self._KeyWords = params.get("KeyWords")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderListResponse(AbstractModel):
    """DescribeFolderList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeFolderListData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeFolderListData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeFolderWorkflowListData(AbstractModel):
    """文件夹分页信息

    """

    def __init__(self):
        r"""
        :param _Items: 工作流信息列表
        :type Items: list of Workflow
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _PageNumber: 页号
        :type PageNumber: int
        :param _PageSize: 页大小
        :type PageSize: int
        """
        self._Items = None
        self._TotalCount = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = Workflow()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderWorkflowListRequest(AbstractModel):
    """DescribeFolderWorkflowList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _ParentsFolderId: 父文件夹ID
        :type ParentsFolderId: str
        :param _KeyWords: 关键字
        :type KeyWords: str
        :param _PageNumber: 页码，默认1
        :type PageNumber: int
        :param _PageSize: 页大小，默认10
        :type PageSize: int
        """
        self._ProjectId = None
        self._ParentsFolderId = None
        self._KeyWords = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId

    @property
    def KeyWords(self):
        return self._KeyWords

    @KeyWords.setter
    def KeyWords(self, KeyWords):
        self._KeyWords = KeyWords

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ParentsFolderId = params.get("ParentsFolderId")
        self._KeyWords = params.get("KeyWords")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderWorkflowListResponse(AbstractModel):
    """DescribeFolderWorkflowList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeFolderWorkflowListData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeFolderWorkflowListData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeFunctionKindsRequest(AbstractModel):
    """DescribeFunctionKinds请求参数结构体

    """


class DescribeFunctionKindsResponse(AbstractModel):
    """DescribeFunctionKinds返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Kinds: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Kinds: list of FunctionTypeOrKind
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Kinds = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Kinds(self):
        return self._Kinds

    @Kinds.setter
    def Kinds(self, Kinds):
        self._Kinds = Kinds

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Kinds") is not None:
            self._Kinds = []
            for item in params.get("Kinds"):
                obj = FunctionTypeOrKind()
                obj._deserialize(item)
                self._Kinds.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeFunctionTypesRequest(AbstractModel):
    """DescribeFunctionTypes请求参数结构体

    """


class DescribeFunctionTypesResponse(AbstractModel):
    """DescribeFunctionTypes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Types: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Types: list of FunctionTypeOrKind
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Types = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Types(self):
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Types") is not None:
            self._Types = []
            for item in params.get("Types"):
                obj = FunctionTypeOrKind()
                obj._deserialize(item)
                self._Types.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeInLongAgentListRequest(AbstractModel):
    """DescribeInLongAgentList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        :param _AgentId: 采集器ID
        :type AgentId: str
        :param _AgentName: Agent Name
        :type AgentName: str
        :param _AgentType: 集群类型，1：TKE Agent，2：BOSS SDK，默认：1，3：CVM，4：自建服务器 【传多个用逗号分割】
        :type AgentType: int
        :param _Status: Agent状态(running运行中，initializing 操作中，failed心跳异常)
        :type Status: str
        :param _VpcId: Vpc Id
        :type VpcId: str
        :param _PageIndex: 分页页码，从1开始，默认：1
        :type PageIndex: int
        :param _PageSize: 分页每页记录数，默认10
        :type PageSize: int
        :param _Like: 名称搜索是否开启模糊匹配，1：开启，0：不开启（精确匹配）
        :type Like: int
        :param _AgentTypes: agent类型【多个用逗号分隔】
        :type AgentTypes: str
        """
        self._ProjectId = None
        self._AgentId = None
        self._AgentName = None
        self._AgentType = None
        self._Status = None
        self._VpcId = None
        self._PageIndex = None
        self._PageSize = None
        self._Like = None
        self._AgentTypes = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AgentId(self):
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def AgentName(self):
        return self._AgentName

    @AgentName.setter
    def AgentName(self, AgentName):
        self._AgentName = AgentName

    @property
    def AgentType(self):
        return self._AgentType

    @AgentType.setter
    def AgentType(self, AgentType):
        self._AgentType = AgentType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Like(self):
        return self._Like

    @Like.setter
    def Like(self, Like):
        self._Like = Like

    @property
    def AgentTypes(self):
        return self._AgentTypes

    @AgentTypes.setter
    def AgentTypes(self, AgentTypes):
        self._AgentTypes = AgentTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._AgentId = params.get("AgentId")
        self._AgentName = params.get("AgentName")
        self._AgentType = params.get("AgentType")
        self._Status = params.get("Status")
        self._VpcId = params.get("VpcId")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Like = params.get("Like")
        self._AgentTypes = params.get("AgentTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInLongAgentListResponse(AbstractModel):
    """DescribeInLongAgentList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Items: 采集器信息列表
        :type Items: list of InLongAgentDetail
        :param _PageIndex: 页码
        :type PageIndex: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _TotalPage: 总页数
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Items = None
        self._PageIndex = None
        self._PageSize = None
        self._TotalCount = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InLongAgentDetail()
                obj._deserialize(item)
                self._Items.append(obj)
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeInLongAgentTaskListRequest(AbstractModel):
    """DescribeInLongAgentTaskList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentId: 采集器ID
        :type AgentId: str
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        """
        self._AgentId = None
        self._ProjectId = None

    @property
    def AgentId(self):
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._AgentId = params.get("AgentId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInLongAgentTaskListResponse(AbstractModel):
    """DescribeInLongAgentTaskList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Items: 采集器关联的集成任务列表
        :type Items: list of InLongAgentTask
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Items = None
        self._RequestId = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InLongAgentTask()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInLongAgentVpcListRequest(AbstractModel):
    """DescribeInLongAgentVpcList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        """
        self._ProjectId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInLongAgentVpcListResponse(AbstractModel):
    """DescribeInLongAgentVpcList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcList: VPC列表
        :type VpcList: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VpcList = None
        self._RequestId = None

    @property
    def VpcList(self):
        return self._VpcList

    @VpcList.setter
    def VpcList(self, VpcList):
        self._VpcList = VpcList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._VpcList = params.get("VpcList")
        self._RequestId = params.get("RequestId")


class DescribeInLongTkeClusterListRequest(AbstractModel):
    """DescribeInLongTkeClusterList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        :param _TkeRegion: TKE集群地域
        :type TkeRegion: str
        :param _ClusterName: 集群名称。
多个名称用逗号连接。
        :type ClusterName: str
        :param _Status: TKE集群状态 (Running 运行中 Creating 创建中 Idling 闲置中 Abnormal 异常 Failed 异常 Deleting 删除中 Scaling 规模调整中 Upgrading 升级中 Isolated 欠费隔离中 NodeUpgrading 节点升级中 Recovering 唤醒中 Activating 激活中 MasterScaling Master扩缩容中 Waiting 等待注册 ClusterLevelUpgrading 调整规格中 ResourceIsolate 隔离中 ResourceIsolated 已隔离 ResourceReverse 冲正中 Trading 集群开通中 ResourceReversal 集群冲正 ClusterLevelTrading 集群变配交易中)
多个状态用逗号连接。
        :type Status: str
        :param _HasAgent: 是否安装Agent，true: 是，false: 否
        :type HasAgent: bool
        :param _ClusterType: 集群类型，托管集群：MANAGED_CLUSTER，独立集群：INDEPENDENT_CLUSTER。
多个集群用逗号连接。
        :type ClusterType: str
        :param _PageIndex: 分页页码，从1开始，默认：1
        :type PageIndex: int
        :param _PageSize: 分页每页记录数，默认10
        :type PageSize: int
        """
        self._ProjectId = None
        self._TkeRegion = None
        self._ClusterName = None
        self._Status = None
        self._HasAgent = None
        self._ClusterType = None
        self._PageIndex = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TkeRegion(self):
        return self._TkeRegion

    @TkeRegion.setter
    def TkeRegion(self, TkeRegion):
        self._TkeRegion = TkeRegion

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def HasAgent(self):
        return self._HasAgent

    @HasAgent.setter
    def HasAgent(self, HasAgent):
        self._HasAgent = HasAgent

    @property
    def ClusterType(self):
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TkeRegion = params.get("TkeRegion")
        self._ClusterName = params.get("ClusterName")
        self._Status = params.get("Status")
        self._HasAgent = params.get("HasAgent")
        self._ClusterType = params.get("ClusterType")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInLongTkeClusterListResponse(AbstractModel):
    """DescribeInLongTkeClusterList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Items: TKE集群信息
        :type Items: list of InLongTkeDetail
        :param _PageIndex: 页码
        :type PageIndex: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _TotalPage: 总页数
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Items = None
        self._PageIndex = None
        self._PageSize = None
        self._TotalCount = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InLongTkeDetail()
                obj._deserialize(item)
                self._Items.append(obj)
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeInstanceLastLogRequest(AbstractModel):
    """DescribeInstanceLastLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLastLogResponse(AbstractModel):
    """DescribeInstanceLastLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 日志
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeInstanceListRequest(AbstractModel):
    """DescribeInstanceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目/工作空间id
        :type ProjectId: str
        :param _PageIndex: 页码
        :type PageIndex: int
        :param _PageSize: 页大小
        :type PageSize: int
        :param _CycleList: 周期列表（如天，一次性），可选
        :type CycleList: list of str
        :param _OwnerList: 责任人
        :type OwnerList: list of str
        :param _InstanceType: 跟之前保持一致
        :type InstanceType: str
        :param _Sort: 排序顺序（asc，desc）
        :type Sort: str
        :param _SortCol: 排序列（costTime 运行耗时，startTime 开始时间，state 实例状态，curRunDate 数据时间）
        :type SortCol: str
        :param _TaskTypeList: 类型列表（如35 shell任务），可选
        :type TaskTypeList: list of int
        :param _StateList: 状态列表（如成功 2，正在执行 1），可选
        :type StateList: list of int
        :param _Keyword: 任务名称
        :type Keyword: str
        """
        self._ProjectId = None
        self._PageIndex = None
        self._PageSize = None
        self._CycleList = None
        self._OwnerList = None
        self._InstanceType = None
        self._Sort = None
        self._SortCol = None
        self._TaskTypeList = None
        self._StateList = None
        self._Keyword = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def CycleList(self):
        return self._CycleList

    @CycleList.setter
    def CycleList(self, CycleList):
        self._CycleList = CycleList

    @property
    def OwnerList(self):
        return self._OwnerList

    @OwnerList.setter
    def OwnerList(self, OwnerList):
        self._OwnerList = OwnerList

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Sort(self):
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def SortCol(self):
        return self._SortCol

    @SortCol.setter
    def SortCol(self, SortCol):
        self._SortCol = SortCol

    @property
    def TaskTypeList(self):
        return self._TaskTypeList

    @TaskTypeList.setter
    def TaskTypeList(self, TaskTypeList):
        self._TaskTypeList = TaskTypeList

    @property
    def StateList(self):
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._CycleList = params.get("CycleList")
        self._OwnerList = params.get("OwnerList")
        self._InstanceType = params.get("InstanceType")
        self._Sort = params.get("Sort")
        self._SortCol = params.get("SortCol")
        self._TaskTypeList = params.get("TaskTypeList")
        self._StateList = params.get("StateList")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceListResponse(AbstractModel):
    """DescribeInstanceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: str
        :param _InstanceList: 实例列表
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceList: list of InstanceList
        :param _TotalCount: 总条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._InstanceList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceList(self):
        return self._InstanceList

    @InstanceList.setter
    def InstanceList(self, InstanceList):
        self._InstanceList = InstanceList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceList") is not None:
            self._InstanceList = []
            for item in params.get("InstanceList"):
                obj = InstanceList()
                obj._deserialize(item)
                self._InstanceList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogListRequest(AbstractModel):
    """DescribeInstanceLogList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogListResponse(AbstractModel):
    """DescribeInstanceLogList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 日志列表
        :type Data: str
        :param _InstanceLogList: 日志列表
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceLogList: list of InstanceLogList
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._InstanceLogList = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceLogList(self):
        return self._InstanceLogList

    @InstanceLogList.setter
    def InstanceLogList(self, InstanceLogList):
        self._InstanceLogList = InstanceLogList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceLogList") is not None:
            self._InstanceLogList = []
            for item in params.get("InstanceLogList"):
                obj = InstanceLogList()
                obj._deserialize(item)
                self._InstanceLogList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogRequest(AbstractModel):
    """DescribeInstanceLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        :param _BrokerIp: 服务器Ip
        :type BrokerIp: str
        :param _OriginFileName: 文件Name
        :type OriginFileName: str
        """
        self._TaskId = None
        self._CurRunDate = None
        self._BrokerIp = None
        self._OriginFileName = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def OriginFileName(self):
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._BrokerIp = params.get("BrokerIp")
        self._OriginFileName = params.get("OriginFileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogResponse(AbstractModel):
    """DescribeInstanceLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回结果
        :type Data: str
        :param _InstanceLogInfo: 返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceLogInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationInstanceLog`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._InstanceLogInfo = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceLogInfo(self):
        return self._InstanceLogInfo

    @InstanceLogInfo.setter
    def InstanceLogInfo(self, InstanceLogInfo):
        self._InstanceLogInfo = InstanceLogInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceLogInfo") is not None:
            self._InstanceLogInfo = IntegrationInstanceLog()
            self._InstanceLogInfo._deserialize(params.get("InstanceLogInfo"))
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogsRequest(AbstractModel):
    """DescribeInstanceLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogsResponse(AbstractModel):
    """DescribeInstanceLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回日志列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of InstanceLog
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = InstanceLog()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstancesRequest(AbstractModel):
    """DescribeInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 页数
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstancesResponse(AbstractModel):
    """DescribeInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: Json 结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationNodeRequest(AbstractModel):
    """DescribeIntegrationNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 节点id
        :type Id: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型
        :type TaskType: int
        """
        self._Id = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationNodeResponse(AbstractModel):
    """DescribeIntegrationNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NodeInfo: 节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeInfo`
        :param _SourceCheckFlag: 上游节点是否已经修改。true 已修改，需要提示；false 没有修改
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceCheckFlag: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NodeInfo = None
        self._SourceCheckFlag = None
        self._RequestId = None

    @property
    def NodeInfo(self):
        return self._NodeInfo

    @NodeInfo.setter
    def NodeInfo(self, NodeInfo):
        self._NodeInfo = NodeInfo

    @property
    def SourceCheckFlag(self):
        return self._SourceCheckFlag

    @SourceCheckFlag.setter
    def SourceCheckFlag(self, SourceCheckFlag):
        self._SourceCheckFlag = SourceCheckFlag

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NodeInfo") is not None:
            self._NodeInfo = IntegrationNodeInfo()
            self._NodeInfo._deserialize(params.get("NodeInfo"))
        self._SourceCheckFlag = params.get("SourceCheckFlag")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsAgentStatusRequest(AbstractModel):
    """DescribeIntegrationStatisticsAgentStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        :param _ExecutorGroupId: 资源组id
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsAgentStatusResponse(AbstractModel):
    """DescribeIntegrationStatisticsAgentStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StatusData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type StatusData: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StatusData = None
        self._RequestId = None

    @property
    def StatusData(self):
        return self._StatusData

    @StatusData.setter
    def StatusData(self, StatusData):
        self._StatusData = StatusData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StatusData = params.get("StatusData")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsInstanceTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsInstanceTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        :param _ExecutorGroupId: 资源组id
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsInstanceTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsInstanceTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TrendsData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsRecordsTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsRecordsTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsRecordsTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsRecordsTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TrendsData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsRequest(AbstractModel):
    """DescribeIntegrationStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsResponse(AbstractModel):
    """DescribeIntegrationStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalTask: 总任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalTask: int
        :param _ProdTask: 生产态任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type ProdTask: int
        :param _DevTask: 开发态任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type DevTask: int
        :param _TotalReadRecords: 总读取条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalReadRecords: int
        :param _TotalWriteRecords: 总写入条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalWriteRecords: int
        :param _TotalErrorRecords: 总脏数据条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalErrorRecords: int
        :param _TotalAlarmEvent: 总告警事件数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalAlarmEvent: int
        :param _IncreaseReadRecords: 当天读取增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseReadRecords: int
        :param _IncreaseWriteRecords: 当天写入增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseWriteRecords: int
        :param _IncreaseErrorRecords: 当天脏数据增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseErrorRecords: int
        :param _IncreaseAlarmEvent: 当天告警事件增长数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseAlarmEvent: int
        :param _AlarmEvent: 告警事件统计
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmEvent: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalTask = None
        self._ProdTask = None
        self._DevTask = None
        self._TotalReadRecords = None
        self._TotalWriteRecords = None
        self._TotalErrorRecords = None
        self._TotalAlarmEvent = None
        self._IncreaseReadRecords = None
        self._IncreaseWriteRecords = None
        self._IncreaseErrorRecords = None
        self._IncreaseAlarmEvent = None
        self._AlarmEvent = None
        self._RequestId = None

    @property
    def TotalTask(self):
        return self._TotalTask

    @TotalTask.setter
    def TotalTask(self, TotalTask):
        self._TotalTask = TotalTask

    @property
    def ProdTask(self):
        return self._ProdTask

    @ProdTask.setter
    def ProdTask(self, ProdTask):
        self._ProdTask = ProdTask

    @property
    def DevTask(self):
        return self._DevTask

    @DevTask.setter
    def DevTask(self, DevTask):
        self._DevTask = DevTask

    @property
    def TotalReadRecords(self):
        return self._TotalReadRecords

    @TotalReadRecords.setter
    def TotalReadRecords(self, TotalReadRecords):
        self._TotalReadRecords = TotalReadRecords

    @property
    def TotalWriteRecords(self):
        return self._TotalWriteRecords

    @TotalWriteRecords.setter
    def TotalWriteRecords(self, TotalWriteRecords):
        self._TotalWriteRecords = TotalWriteRecords

    @property
    def TotalErrorRecords(self):
        return self._TotalErrorRecords

    @TotalErrorRecords.setter
    def TotalErrorRecords(self, TotalErrorRecords):
        self._TotalErrorRecords = TotalErrorRecords

    @property
    def TotalAlarmEvent(self):
        return self._TotalAlarmEvent

    @TotalAlarmEvent.setter
    def TotalAlarmEvent(self, TotalAlarmEvent):
        self._TotalAlarmEvent = TotalAlarmEvent

    @property
    def IncreaseReadRecords(self):
        return self._IncreaseReadRecords

    @IncreaseReadRecords.setter
    def IncreaseReadRecords(self, IncreaseReadRecords):
        self._IncreaseReadRecords = IncreaseReadRecords

    @property
    def IncreaseWriteRecords(self):
        return self._IncreaseWriteRecords

    @IncreaseWriteRecords.setter
    def IncreaseWriteRecords(self, IncreaseWriteRecords):
        self._IncreaseWriteRecords = IncreaseWriteRecords

    @property
    def IncreaseErrorRecords(self):
        return self._IncreaseErrorRecords

    @IncreaseErrorRecords.setter
    def IncreaseErrorRecords(self, IncreaseErrorRecords):
        self._IncreaseErrorRecords = IncreaseErrorRecords

    @property
    def IncreaseAlarmEvent(self):
        return self._IncreaseAlarmEvent

    @IncreaseAlarmEvent.setter
    def IncreaseAlarmEvent(self, IncreaseAlarmEvent):
        self._IncreaseAlarmEvent = IncreaseAlarmEvent

    @property
    def AlarmEvent(self):
        return self._AlarmEvent

    @AlarmEvent.setter
    def AlarmEvent(self, AlarmEvent):
        self._AlarmEvent = AlarmEvent

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalTask = params.get("TotalTask")
        self._ProdTask = params.get("ProdTask")
        self._DevTask = params.get("DevTask")
        self._TotalReadRecords = params.get("TotalReadRecords")
        self._TotalWriteRecords = params.get("TotalWriteRecords")
        self._TotalErrorRecords = params.get("TotalErrorRecords")
        self._TotalAlarmEvent = params.get("TotalAlarmEvent")
        self._IncreaseReadRecords = params.get("IncreaseReadRecords")
        self._IncreaseWriteRecords = params.get("IncreaseWriteRecords")
        self._IncreaseErrorRecords = params.get("IncreaseErrorRecords")
        self._IncreaseAlarmEvent = params.get("IncreaseAlarmEvent")
        self._AlarmEvent = params.get("AlarmEvent")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsTaskStatusRequest(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        :param _ExecutorGroupId: 资源组id
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsTaskStatusResponse(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StatusData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type StatusData: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StatusData = None
        self._RequestId = None

    @property
    def StatusData(self):
        return self._StatusData

    @StatusData.setter
    def StatusData(self, StatusData):
        self._StatusData = StatusData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StatusData = params.get("StatusData")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsTaskStatusTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatusTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        :param _ExecutorGroupId: 资源组id
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsTaskStatusTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatusTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TrendsData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationTaskRequest(AbstractModel):
    """DescribeIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型：201. stream,   202. offline
        :type TaskType: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationTaskResponse(AbstractModel):
    """DescribeIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfo: 任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationTaskInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskInfo = None
        self._RequestId = None

    @property
    def TaskInfo(self):
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = IntegrationTaskInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        self._RequestId = params.get("RequestId")


class DescribeIntegrationTasksRequest(AbstractModel):
    """DescribeIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 分页第n页
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 查询filter
        :type Filters: list of Filter
        :param _OrderFields: 排序字段信息
        :type OrderFields: list of OrderField
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _TaskType: 201. stream, 202. offline 默认实时
        :type TaskType: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._StartTime = None
        self._EndTime = None
        self._TaskType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationTasksResponse(AbstractModel):
    """DescribeIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfoSet: 任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInfoSet: list of IntegrationTaskInfo
        :param _TotalCount: 任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskInfoSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskInfoSet(self):
        return self._TaskInfoSet

    @TaskInfoSet.setter
    def TaskInfoSet(self, TaskInfoSet):
        self._TaskInfoSet = TaskInfoSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfoSet") is not None:
            self._TaskInfoSet = []
            for item in params.get("TaskInfoSet"):
                obj = IntegrationTaskInfo()
                obj._deserialize(item)
                self._TaskInfoSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationVersionNodesInfoRequest(AbstractModel):
    """DescribeIntegrationVersionNodesInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskVersionPath: task version path
        :type TaskVersionPath: str
        :param _TaskVersion: task version
        :type TaskVersion: str
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskVersionPath = None
        self._TaskVersion = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskVersionPath(self):
        return self._TaskVersionPath

    @TaskVersionPath.setter
    def TaskVersionPath(self, TaskVersionPath):
        self._TaskVersionPath = TaskVersionPath

    @property
    def TaskVersion(self):
        return self._TaskVersion

    @TaskVersion.setter
    def TaskVersion(self, TaskVersion):
        self._TaskVersion = TaskVersion


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskVersionPath = params.get("TaskVersionPath")
        self._TaskVersion = params.get("TaskVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationVersionNodesInfoResponse(AbstractModel):
    """DescribeIntegrationVersionNodesInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Nodes: 任务节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Nodes: list of IntegrationNodeInfo
        :param _Mappings: 任务映射信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Mappings: list of IntegrationNodeMapping
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Nodes = None
        self._Mappings = None
        self._TaskId = None
        self._RequestId = None

    @property
    def Nodes(self):
        return self._Nodes

    @Nodes.setter
    def Nodes(self, Nodes):
        self._Nodes = Nodes

    @property
    def Mappings(self):
        return self._Mappings

    @Mappings.setter
    def Mappings(self, Mappings):
        self._Mappings = Mappings

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Nodes") is not None:
            self._Nodes = []
            for item in params.get("Nodes"):
                obj = IntegrationNodeInfo()
                obj._deserialize(item)
                self._Nodes.append(obj)
        if params.get("Mappings") is not None:
            self._Mappings = []
            for item in params.get("Mappings"):
                obj = IntegrationNodeMapping()
                obj._deserialize(item)
                self._Mappings.append(obj)
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DescribeKafkaTopicInfoRequest(AbstractModel):
    """DescribeKafkaTopicInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceId: 数据源id
        :type DatasourceId: str
        :param _Type: 数据源类型
        :type Type: str
        """
        self._DatasourceId = None
        self._Type = None

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeKafkaTopicInfoResponse(AbstractModel):
    """DescribeKafkaTopicInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeMonitorsByPageRequest(AbstractModel):
    """DescribeMonitorsByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _OrderFields: 排序条件
        :type OrderFields: list of OrderField
        :param _PageNumber: 分页序号
        :type PageNumber: int
        """
        self._ProjectId = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._PageNumber = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._PageNumber = params.get("PageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMonitorsByPageResponse(AbstractModel):
    """DescribeMonitorsByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupMonitorPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupMonitorPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOfflineTaskTokenRequest(AbstractModel):
    """DescribeOfflineTaskToken请求参数结构体

    """


class DescribeOfflineTaskTokenResponse(AbstractModel):
    """DescribeOfflineTaskToken返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Token: 长连接临时token
        :type Token: str
        :param _Data: 长连接临时token。与Token相同含义，优先取Data，Data为空时，取Token。
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Token = None
        self._Data = None
        self._RequestId = None

    @property
    def Token(self):
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Token = params.get("Token")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeOperateTasksRequest(AbstractModel):
    """DescribeOperateTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _FolderIdList: 文件夹id，多个文件夹以逗号分隔
        :type FolderIdList: str
        :param _WorkFlowIdList: 工作流id，多个工作流id之间以英文字符逗号分隔
        :type WorkFlowIdList: str
        :param _WorkFlowNameList: 工作流名称，多个工作流名称之间以英文字符逗号分隔
        :type WorkFlowNameList: str
        :param _TaskNameList: 任务名称，多个任务名称之间以英文字符逗号分隔
        :type TaskNameList: str
        :param _TaskIdList: 任务id，多个任务id之间以英文字符逗号分隔
        :type TaskIdList: str
        :param _PageNumber: 页号
        :type PageNumber: str
        :param _PageSize: 分页大小
        :type PageSize: str
        :param _SortItem: 排序字段，支持字段为FirstSubmitTime和FirstRunTime，标识最近提交和首次执行事件
        :type SortItem: str
        :param _SortType: 排序类型。两种取值 DESC、ASC
        :type SortType: str
        :param _InChargeList: 责任人，多个责任人之间以英文字符逗号分隔
        :type InChargeList: str
        :param _TaskTypeIdList: 任务类型Id字符串，多个任务类型id之间以英文字符逗号分隔
        :type TaskTypeIdList: str
        :param _StatusList: 任务状态字符串，多个任务状态之间以英文字符逗号分隔
        :type StatusList: str
        :param _TaskCycleUnitList: 任务周期类型字符串，多个任务周期之间以英文字符逗号分隔
        :type TaskCycleUnitList: str
        :param _ProductNameList: 任务所属产品类型
        :type ProductNameList: str
        :param _SourceServiceId: 数据源id或（仅针对离线同步任务）来源数据源id
        :type SourceServiceId: str
        :param _SourceServiceType: 数据源类型或（仅针对离线同步任务）来源数据源类型
        :type SourceServiceType: str
        :param _TargetServiceId: （仅针对离线同步任务）目标数据源id
        :type TargetServiceId: str
        :param _TargetServiceType: （仅针对离线同步任务）目标数据源类型
        :type TargetServiceType: str
        :param _AlarmType: 告警类型，多个类型以逗号分隔
        :type AlarmType: str
        """
        self._ProjectId = None
        self._FolderIdList = None
        self._WorkFlowIdList = None
        self._WorkFlowNameList = None
        self._TaskNameList = None
        self._TaskIdList = None
        self._PageNumber = None
        self._PageSize = None
        self._SortItem = None
        self._SortType = None
        self._InChargeList = None
        self._TaskTypeIdList = None
        self._StatusList = None
        self._TaskCycleUnitList = None
        self._ProductNameList = None
        self._SourceServiceId = None
        self._SourceServiceType = None
        self._TargetServiceId = None
        self._TargetServiceType = None
        self._AlarmType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderIdList(self):
        return self._FolderIdList

    @FolderIdList.setter
    def FolderIdList(self, FolderIdList):
        self._FolderIdList = FolderIdList

    @property
    def WorkFlowIdList(self):
        return self._WorkFlowIdList

    @WorkFlowIdList.setter
    def WorkFlowIdList(self, WorkFlowIdList):
        self._WorkFlowIdList = WorkFlowIdList

    @property
    def WorkFlowNameList(self):
        return self._WorkFlowNameList

    @WorkFlowNameList.setter
    def WorkFlowNameList(self, WorkFlowNameList):
        self._WorkFlowNameList = WorkFlowNameList

    @property
    def TaskNameList(self):
        return self._TaskNameList

    @TaskNameList.setter
    def TaskNameList(self, TaskNameList):
        self._TaskNameList = TaskNameList

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def InChargeList(self):
        return self._InChargeList

    @InChargeList.setter
    def InChargeList(self, InChargeList):
        self._InChargeList = InChargeList

    @property
    def TaskTypeIdList(self):
        return self._TaskTypeIdList

    @TaskTypeIdList.setter
    def TaskTypeIdList(self, TaskTypeIdList):
        self._TaskTypeIdList = TaskTypeIdList

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def TaskCycleUnitList(self):
        return self._TaskCycleUnitList

    @TaskCycleUnitList.setter
    def TaskCycleUnitList(self, TaskCycleUnitList):
        self._TaskCycleUnitList = TaskCycleUnitList

    @property
    def ProductNameList(self):
        return self._ProductNameList

    @ProductNameList.setter
    def ProductNameList(self, ProductNameList):
        self._ProductNameList = ProductNameList

    @property
    def SourceServiceId(self):
        return self._SourceServiceId

    @SourceServiceId.setter
    def SourceServiceId(self, SourceServiceId):
        self._SourceServiceId = SourceServiceId

    @property
    def SourceServiceType(self):
        return self._SourceServiceType

    @SourceServiceType.setter
    def SourceServiceType(self, SourceServiceType):
        self._SourceServiceType = SourceServiceType

    @property
    def TargetServiceId(self):
        return self._TargetServiceId

    @TargetServiceId.setter
    def TargetServiceId(self, TargetServiceId):
        self._TargetServiceId = TargetServiceId

    @property
    def TargetServiceType(self):
        return self._TargetServiceType

    @TargetServiceType.setter
    def TargetServiceType(self, TargetServiceType):
        self._TargetServiceType = TargetServiceType

    @property
    def AlarmType(self):
        return self._AlarmType

    @AlarmType.setter
    def AlarmType(self, AlarmType):
        self._AlarmType = AlarmType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderIdList = params.get("FolderIdList")
        self._WorkFlowIdList = params.get("WorkFlowIdList")
        self._WorkFlowNameList = params.get("WorkFlowNameList")
        self._TaskNameList = params.get("TaskNameList")
        self._TaskIdList = params.get("TaskIdList")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._InChargeList = params.get("InChargeList")
        self._TaskTypeIdList = params.get("TaskTypeIdList")
        self._StatusList = params.get("StatusList")
        self._TaskCycleUnitList = params.get("TaskCycleUnitList")
        self._ProductNameList = params.get("ProductNameList")
        self._SourceServiceId = params.get("SourceServiceId")
        self._SourceServiceType = params.get("SourceServiceType")
        self._TargetServiceId = params.get("TargetServiceId")
        self._TargetServiceType = params.get("TargetServiceType")
        self._AlarmType = params.get("AlarmType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOperateTasksResponse(AbstractModel):
    """DescribeOperateTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务列表信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskInfoPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TaskInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOrganizationalFunctionsRequest(AbstractModel):
    """DescribeOrganizationalFunctions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 场景类型：开发、使用
        :type Type: str
        :param _ProjectId: 项目 ID
        :type ProjectId: str
        :param _Name: 函数名称
        :type Name: str
        :param _DisplayName: 展示名称
        :type DisplayName: str
        """
        self._Type = None
        self._ProjectId = None
        self._Name = None
        self._DisplayName = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DisplayName(self):
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._ProjectId = params.get("ProjectId")
        self._Name = params.get("Name")
        self._DisplayName = params.get("DisplayName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationalFunctionsResponse(AbstractModel):
    """DescribeOrganizationalFunctions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Content: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Content: list of OrganizationalFunction
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Content = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Content") is not None:
            self._Content = []
            for item in params.get("Content"):
                obj = OrganizationalFunction()
                obj._deserialize(item)
                self._Content.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeProdTasksRequest(AbstractModel):
    """DescribeProdTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        """
        self._ProjectId = None
        self._PageSize = None
        self._PageNumber = None
        self._Filters = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProdTasksResponse(AbstractModel):
    """DescribeProdTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 生产调度任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of ProdSchedulerTask
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ProdSchedulerTask()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProjectRequest(AbstractModel):
    """DescribeProject请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id。一般使用项目Id来查询，与projectName必须存在一个。
        :type ProjectId: str
        :param _DescribeClusters: 是否展示关联集群信息
        :type DescribeClusters: bool
        :param _DescribeExecutors: 是否展示关联执行组的信息，仅部分信息。
        :type DescribeExecutors: bool
        :param _DescribeAdminUsers: 默认不展示项目管理员信息
        :type DescribeAdminUsers: bool
        :param _DescribeMemberCount: 默认不统计项目人员数量
        :type DescribeMemberCount: bool
        :param _DescribeCreator: 默认不查询创建者的信息
        :type DescribeCreator: bool
        :param _ProjectName: 项目名只在租户内唯一，一般用来转化为项目ID。
        :type ProjectName: str
        """
        self._ProjectId = None
        self._DescribeClusters = None
        self._DescribeExecutors = None
        self._DescribeAdminUsers = None
        self._DescribeMemberCount = None
        self._DescribeCreator = None
        self._ProjectName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DescribeClusters(self):
        return self._DescribeClusters

    @DescribeClusters.setter
    def DescribeClusters(self, DescribeClusters):
        self._DescribeClusters = DescribeClusters

    @property
    def DescribeExecutors(self):
        return self._DescribeExecutors

    @DescribeExecutors.setter
    def DescribeExecutors(self, DescribeExecutors):
        self._DescribeExecutors = DescribeExecutors

    @property
    def DescribeAdminUsers(self):
        return self._DescribeAdminUsers

    @DescribeAdminUsers.setter
    def DescribeAdminUsers(self, DescribeAdminUsers):
        self._DescribeAdminUsers = DescribeAdminUsers

    @property
    def DescribeMemberCount(self):
        return self._DescribeMemberCount

    @DescribeMemberCount.setter
    def DescribeMemberCount(self, DescribeMemberCount):
        self._DescribeMemberCount = DescribeMemberCount

    @property
    def DescribeCreator(self):
        return self._DescribeCreator

    @DescribeCreator.setter
    def DescribeCreator(self, DescribeCreator):
        self._DescribeCreator = DescribeCreator

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DescribeClusters = params.get("DescribeClusters")
        self._DescribeExecutors = params.get("DescribeExecutors")
        self._DescribeAdminUsers = params.get("DescribeAdminUsers")
        self._DescribeMemberCount = params.get("DescribeMemberCount")
        self._DescribeCreator = params.get("DescribeCreator")
        self._ProjectName = params.get("ProjectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProjectResponse(AbstractModel):
    """DescribeProject返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeQualityScoreRequest(AbstractModel):
    """DescribeQualityScore请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期
        :type StatisticsDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._ScoreType = None
        self._Filters = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityScoreResponse(AbstractModel):
    """DescribeQualityScore返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 质量评分
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScore`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScore()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeQualityScoreTrendRequest(AbstractModel):
    """DescribeQualityScoreTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsStartDate: 统计开始日期
        :type StatisticsStartDate: int
        :param _StatisticsEndDate: 统计结束日期
        :type StatisticsEndDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        """
        self._StatisticsStartDate = None
        self._StatisticsEndDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._ScoreType = None
        self._Filters = None

    @property
    def StatisticsStartDate(self):
        return self._StatisticsStartDate

    @StatisticsStartDate.setter
    def StatisticsStartDate(self, StatisticsStartDate):
        self._StatisticsStartDate = StatisticsStartDate

    @property
    def StatisticsEndDate(self):
        return self._StatisticsEndDate

    @StatisticsEndDate.setter
    def StatisticsEndDate(self, StatisticsEndDate):
        self._StatisticsEndDate = StatisticsEndDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsStartDate = params.get("StatisticsStartDate")
        self._StatisticsEndDate = params.get("StatisticsEndDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityScoreTrendResponse(AbstractModel):
    """DescribeQualityScoreTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 质量评分趋势视图
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScoreTrend`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScoreTrend()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskInstanceNodeInfoRequest(AbstractModel):
    """DescribeRealTimeTaskInstanceNodeInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 实时任务id
        :type TaskId: str
        :param _ProjectId: 工程id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskInstanceNodeInfoResponse(AbstractModel):
    """DescribeRealTimeTaskInstanceNodeInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RealTimeTaskInstanceNodeInfo: 实时任务实例节点相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :type RealTimeTaskInstanceNodeInfo: :class:`tencentcloud.wedata.v20210820.models.RealTimeTaskInstanceNodeInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RealTimeTaskInstanceNodeInfo = None
        self._RequestId = None

    @property
    def RealTimeTaskInstanceNodeInfo(self):
        return self._RealTimeTaskInstanceNodeInfo

    @RealTimeTaskInstanceNodeInfo.setter
    def RealTimeTaskInstanceNodeInfo(self, RealTimeTaskInstanceNodeInfo):
        self._RealTimeTaskInstanceNodeInfo = RealTimeTaskInstanceNodeInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RealTimeTaskInstanceNodeInfo") is not None:
            self._RealTimeTaskInstanceNodeInfo = RealTimeTaskInstanceNodeInfo()
            self._RealTimeTaskInstanceNodeInfo._deserialize(params.get("RealTimeTaskInstanceNodeInfo"))
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskMetricOverviewRequest(AbstractModel):
    """DescribeRealTimeTaskMetricOverview请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 要查看的实时任务的任务Id
        :type TaskId: str
        :param _ProjectId: 无
        :type ProjectId: str
        :param _StartTime: 开始时间
        :type StartTime: int
        :param _EndTime: 结束时间
        :type EndTime: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskMetricOverviewResponse(AbstractModel):
    """DescribeRealTimeTaskMetricOverview返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalRecordNumOfRead: 总读取记录数
        :type TotalRecordNumOfRead: int
        :param _TotalRecordByteNumOfRead: 总读取字节数
        :type TotalRecordByteNumOfRead: int
        :param _TotalRecordNumOfWrite: 总写入记录数
        :type TotalRecordNumOfWrite: int
        :param _TotalRecordByteNumOfWrite: 总写入字节数 单位字节
        :type TotalRecordByteNumOfWrite: int
        :param _TotalDirtyRecordNum: 总的脏记录数据
        :type TotalDirtyRecordNum: int
        :param _TotalDirtyRecordByte: 总的脏字节数 单位字节
        :type TotalDirtyRecordByte: int
        :param _TotalDuration: 运行时长 单位s
        :type TotalDuration: int
        :param _BeginRunTime: 开始运行时间
        :type BeginRunTime: str
        :param _EndRunTime: 目前运行到的时间
        :type EndRunTime: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalRecordNumOfRead = None
        self._TotalRecordByteNumOfRead = None
        self._TotalRecordNumOfWrite = None
        self._TotalRecordByteNumOfWrite = None
        self._TotalDirtyRecordNum = None
        self._TotalDirtyRecordByte = None
        self._TotalDuration = None
        self._BeginRunTime = None
        self._EndRunTime = None
        self._RequestId = None

    @property
    def TotalRecordNumOfRead(self):
        return self._TotalRecordNumOfRead

    @TotalRecordNumOfRead.setter
    def TotalRecordNumOfRead(self, TotalRecordNumOfRead):
        self._TotalRecordNumOfRead = TotalRecordNumOfRead

    @property
    def TotalRecordByteNumOfRead(self):
        return self._TotalRecordByteNumOfRead

    @TotalRecordByteNumOfRead.setter
    def TotalRecordByteNumOfRead(self, TotalRecordByteNumOfRead):
        self._TotalRecordByteNumOfRead = TotalRecordByteNumOfRead

    @property
    def TotalRecordNumOfWrite(self):
        return self._TotalRecordNumOfWrite

    @TotalRecordNumOfWrite.setter
    def TotalRecordNumOfWrite(self, TotalRecordNumOfWrite):
        self._TotalRecordNumOfWrite = TotalRecordNumOfWrite

    @property
    def TotalRecordByteNumOfWrite(self):
        return self._TotalRecordByteNumOfWrite

    @TotalRecordByteNumOfWrite.setter
    def TotalRecordByteNumOfWrite(self, TotalRecordByteNumOfWrite):
        self._TotalRecordByteNumOfWrite = TotalRecordByteNumOfWrite

    @property
    def TotalDirtyRecordNum(self):
        return self._TotalDirtyRecordNum

    @TotalDirtyRecordNum.setter
    def TotalDirtyRecordNum(self, TotalDirtyRecordNum):
        self._TotalDirtyRecordNum = TotalDirtyRecordNum

    @property
    def TotalDirtyRecordByte(self):
        return self._TotalDirtyRecordByte

    @TotalDirtyRecordByte.setter
    def TotalDirtyRecordByte(self, TotalDirtyRecordByte):
        self._TotalDirtyRecordByte = TotalDirtyRecordByte

    @property
    def TotalDuration(self):
        return self._TotalDuration

    @TotalDuration.setter
    def TotalDuration(self, TotalDuration):
        self._TotalDuration = TotalDuration

    @property
    def BeginRunTime(self):
        return self._BeginRunTime

    @BeginRunTime.setter
    def BeginRunTime(self, BeginRunTime):
        self._BeginRunTime = BeginRunTime

    @property
    def EndRunTime(self):
        return self._EndRunTime

    @EndRunTime.setter
    def EndRunTime(self, EndRunTime):
        self._EndRunTime = EndRunTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalRecordNumOfRead = params.get("TotalRecordNumOfRead")
        self._TotalRecordByteNumOfRead = params.get("TotalRecordByteNumOfRead")
        self._TotalRecordNumOfWrite = params.get("TotalRecordNumOfWrite")
        self._TotalRecordByteNumOfWrite = params.get("TotalRecordByteNumOfWrite")
        self._TotalDirtyRecordNum = params.get("TotalDirtyRecordNum")
        self._TotalDirtyRecordByte = params.get("TotalDirtyRecordByte")
        self._TotalDuration = params.get("TotalDuration")
        self._BeginRunTime = params.get("BeginRunTime")
        self._EndRunTime = params.get("EndRunTime")
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskSpeedRequest(AbstractModel):
    """DescribeRealTimeTaskSpeed请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 无
        :type TaskId: str
        :param _StartTime: 带毫秒的时间戳
        :type StartTime: int
        :param _EndTime: 带毫秒的时间戳
        :type EndTime: int
        :param _Granularity: 粒度，1或者5
        :type Granularity: int
        :param _ProjectId: 无
        :type ProjectId: str
        """
        self._TaskId = None
        self._StartTime = None
        self._EndTime = None
        self._Granularity = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Granularity(self):
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Granularity = params.get("Granularity")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskSpeedResponse(AbstractModel):
    """DescribeRealTimeTaskSpeed返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RecordsSpeedList: 同步速度条/s列表
        :type RecordsSpeedList: list of RecordsSpeed
        :param _BytesSpeedList: 同步速度字节/s列表
        :type BytesSpeedList: list of BytesSpeed
        :param _Data: 同步速度，包括了RecordsSpeedList和BytesSpeedList
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RealTimeTaskSpeed`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RecordsSpeedList = None
        self._BytesSpeedList = None
        self._Data = None
        self._RequestId = None

    @property
    def RecordsSpeedList(self):
        return self._RecordsSpeedList

    @RecordsSpeedList.setter
    def RecordsSpeedList(self, RecordsSpeedList):
        self._RecordsSpeedList = RecordsSpeedList

    @property
    def BytesSpeedList(self):
        return self._BytesSpeedList

    @BytesSpeedList.setter
    def BytesSpeedList(self, BytesSpeedList):
        self._BytesSpeedList = BytesSpeedList

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RecordsSpeedList") is not None:
            self._RecordsSpeedList = []
            for item in params.get("RecordsSpeedList"):
                obj = RecordsSpeed()
                obj._deserialize(item)
                self._RecordsSpeedList.append(obj)
        if params.get("BytesSpeedList") is not None:
            self._BytesSpeedList = []
            for item in params.get("BytesSpeedList"):
                obj = BytesSpeed()
                obj._deserialize(item)
                self._BytesSpeedList.append(obj)
        if params.get("Data") is not None:
            self._Data = RealTimeTaskSpeed()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRelatedInstancesRequest(AbstractModel):
    """DescribeRelatedInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _CurRunDate: 数据时间，格式yyyy-MM-dd HH:mm:ss
        :type CurRunDate: str
        :param _TaskId: 任务id
        :type TaskId: int
        :param _Depth: 距离当前任务的层级距离，-1表示取父节点，1表示子节点
        :type Depth: int
        :param _PageNumber: 页号，默认为1
        :type PageNumber: int
        :param _PageSize: 页大小，默认为10，最大不超过200
        :type PageSize: int
        """
        self._ProjectId = None
        self._CurRunDate = None
        self._TaskId = None
        self._Depth = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Depth(self):
        return self._Depth

    @Depth.setter
    def Depth(self, Depth):
        self._Depth = Depth

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CurRunDate = params.get("CurRunDate")
        self._TaskId = params.get("TaskId")
        self._Depth = params.get("Depth")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRelatedInstancesResponse(AbstractModel):
    """DescribeRelatedInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeTaskInstancesData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTaskInstancesData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeResourceManagePathTreesRequest(AbstractModel):
    """DescribeResourceManagePathTrees请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Name: 名字，供搜索
        :type Name: str
        :param _FileType: 文件类型
        :type FileType: str
        :param _FilePath: 文件路径
        :type FilePath: str
        :param _DirType: 文件夹类型
        :type DirType: str
        """
        self._ProjectId = None
        self._Name = None
        self._FileType = None
        self._FilePath = None
        self._DirType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def FileType(self):
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def DirType(self):
        return self._DirType

    @DirType.setter
    def DirType(self, DirType):
        self._DirType = DirType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Name = params.get("Name")
        self._FileType = params.get("FileType")
        self._FilePath = params.get("FilePath")
        self._DirType = params.get("DirType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourceManagePathTreesResponse(AbstractModel):
    """DescribeResourceManagePathTrees返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of ResourcePathTree
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ResourcePathTree()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRuleDataSourcesRequest(AbstractModel):
    """DescribeRuleDataSources请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _DatasourceId: 数据来源Id
        :type DatasourceId: str
        :param _DsTypes: 数据源类型
        :type DsTypes: list of int non-negative
        """
        self._ProjectId = None
        self._DatasourceId = None
        self._DsTypes = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DsTypes(self):
        return self._DsTypes

    @DsTypes.setter
    def DsTypes(self, DsTypes):
        self._DsTypes = DsTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._DsTypes = params.get("DsTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleDataSourcesResponse(AbstractModel):
    """DescribeRuleDataSources返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据源列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of DatabaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DatabaseInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRuleDimStatRequest(AbstractModel):
    """DescribeRuleDimStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project Id
        :type ProjectId: str
        :param _BeginDate: 开始时间，时间戳到秒
        :type BeginDate: str
        :param _EndDate: 结束时间，时间戳到秒
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleDimStatResponse(AbstractModel):
    """DescribeRuleDimStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleDimStat`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleDimStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecDetailRequest(AbstractModel):
    """DescribeRuleExecDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleExecId: 规则执行id
        :type RuleExecId: int
        """
        self._ProjectId = None
        self._RuleExecId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleExecId = params.get("RuleExecId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecDetailResponse(AbstractModel):
    """DescribeRuleExecDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则执行结果详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultDetail`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecResultDetail()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecExportResultRequest(AbstractModel):
    """DescribeRuleExecExportResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleExecId: 规则执行id
        :type RuleExecId: int
        """
        self._ProjectId = None
        self._RuleExecId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleExecId = params.get("RuleExecId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecExportResultResponse(AbstractModel):
    """DescribeRuleExecExportResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 导出结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecExportResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecExportResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecHistoryRequest(AbstractModel):
    """DescribeRuleExecHistory请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则Id
        :type RuleId: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._RuleId = None
        self._ProjectId = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecHistoryResponse(AbstractModel):
    """DescribeRuleExecHistory返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of RuleExecResult
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RuleExecResult()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRuleExecLogRequest(AbstractModel):
    """DescribeRuleExecLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleExecId: 规则执行Id
        :type RuleExecId: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleGroupExecId: 规则组执行id
        :type RuleGroupExecId: int
        """
        self._RuleExecId = None
        self._ProjectId = None
        self._RuleGroupExecId = None

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId


    def _deserialize(self, params):
        self._RuleExecId = params.get("RuleExecId")
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecLogResponse(AbstractModel):
    """DescribeRuleExecLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则执行日志
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecLog`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecLog()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecResultsByPageRequest(AbstractModel):
    """DescribeRuleExecResultsByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupExecId: 执行规则组ID
        :type RuleGroupExecId: int
        :param _PageNumber: page number
        :type PageNumber: int
        :param _PageSize: page size
        :type PageSize: int
        """
        self._RuleGroupExecId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecResultsByPageResponse(AbstractModel):
    """DescribeRuleExecResultsByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: results
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecResultsRequest(AbstractModel):
    """DescribeRuleExecResults请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupExecId: 规则组执行Id
        :type RuleGroupExecId: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._RuleGroupExecId = None
        self._ProjectId = None

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecResultsResponse(AbstractModel):
    """DescribeRuleExecResults返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecStatRequest(AbstractModel):
    """DescribeRuleExecStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: ProjectId 值
        :type ProjectId: str
        :param _BeginDate: 开始时间，时间戳到秒
        :type BeginDate: str
        :param _EndDate: 结束时间，时间戳到秒
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecStatResponse(AbstractModel):
    """DescribeRuleExecStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecStat`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupExecResultsByPageRequest(AbstractModel):
    """DescribeRuleGroupExecResultsByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupExecResultsByPageResponse(AbstractModel):
    """DescribeRuleGroupExecResultsByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResultPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupExecResultsByPageWithoutAuthRequest(AbstractModel):
    """DescribeRuleGroupExecResultsByPageWithoutAuth请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件，指定表ID过滤字段为 TableIds
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupExecResultsByPageWithoutAuthResponse(AbstractModel):
    """DescribeRuleGroupExecResultsByPageWithoutAuth返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResultPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupRequest(AbstractModel):
    """DescribeRuleGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _DatasourceId: 数据来源ID
        :type DatasourceId: str
        :param _TableId: 数据表Id
        :type TableId: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _DatabaseId: 数据库ID
        :type DatabaseId: str
        """
        self._RuleGroupId = None
        self._DatasourceId = None
        self._TableId = None
        self._ProjectId = None
        self._DatabaseId = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._DatasourceId = params.get("DatasourceId")
        self._TableId = params.get("TableId")
        self._ProjectId = params.get("ProjectId")
        self._DatabaseId = params.get("DatabaseId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupResponse(AbstractModel):
    """DescribeRuleGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据质量规则组详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroup`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroup()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupSubscriptionRequest(AbstractModel):
    """DescribeRuleGroupSubscription请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._RuleGroupId = None
        self._ProjectId = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupSubscriptionResponse(AbstractModel):
    """DescribeRuleGroupSubscription返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组订阅信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupSubscribe`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupSubscribe()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupTableRequest(AbstractModel):
    """DescribeRuleGroupTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableId: 表ID
        :type TableId: str
        """
        self._TableId = None

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupTableResponse(AbstractModel):
    """DescribeRuleGroupTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupTable`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupTable()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupsByPageRequest(AbstractModel):
    """DescribeRuleGroupsByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件,每次请求的Filters的上限为10，Filter.Values的上限为5
        :type Filters: list of Filter
        :param _OrderFields: 排序方式
        :type OrderFields: list of OrderField
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupsByPageResponse(AbstractModel):
    """DescribeRuleGroupsByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleHistoryByPageRequest(AbstractModel):
    """DescribeRuleHistoryByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleHistoryByPageResponse(AbstractModel):
    """DescribeRuleHistoryByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组操作历史列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleHistoryPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleHistoryPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleRequest(AbstractModel):
    """DescribeRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 质量规则ID
        :type RuleId: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._RuleId = None
        self._ProjectId = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleResponse(AbstractModel):
    """DescribeRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.Rule`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = Rule()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTablesByPageRequest(AbstractModel):
    """DescribeRuleTablesByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _PageSize: 分页序号
        :type PageSize: int
        :param _PageNumber: 分页大小
        :type PageNumber: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _OrderFields: 排序条件
        :type OrderFields: list of OrderField
        """
        self._ProjectId = None
        self._PageSize = None
        self._PageNumber = None
        self._Filters = None
        self._OrderFields = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTablesByPageResponse(AbstractModel):
    """DescribeRuleTablesByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 表列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplateRequest(AbstractModel):
    """DescribeRuleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TemplateId: 规则模板Id
        :type TemplateId: int
        """
        self._ProjectId = None
        self._TemplateId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TemplateId(self):
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplateResponse(AbstractModel):
    """DescribeRuleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 模板详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleTemplate`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleTemplate()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplatesByPageRequest(AbstractModel):
    """DescribeRuleTemplatesByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _ProjectId: 工作空间ID
        :type ProjectId: str
        :param _OrderFields: 通用排序字段
        :type OrderFields: list of OrderField
        :param _Filters: 通用过滤条件
        :type Filters: list of Filter
        """
        self._PageNumber = None
        self._PageSize = None
        self._ProjectId = None
        self._OrderFields = None
        self._Filters = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplatesByPageResponse(AbstractModel):
    """DescribeRuleTemplatesByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleTemplatePage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleTemplatePage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplatesRequest(AbstractModel):
    """DescribeRuleTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 模版类型 1.系统模版 2.自定义模版
        :type Type: int
        :param _SourceObjectType: 1.常量 2.离线表级 2.离线字段级
        :type SourceObjectType: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _SourceEngineTypes: 源端对应的引擎类型
        :type SourceEngineTypes: list of int non-negative
        """
        self._Type = None
        self._SourceObjectType = None
        self._ProjectId = None
        self._SourceEngineTypes = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SourceObjectType(self):
        return self._SourceObjectType

    @SourceObjectType.setter
    def SourceObjectType(self, SourceObjectType):
        self._SourceObjectType = SourceObjectType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._SourceObjectType = params.get("SourceObjectType")
        self._ProjectId = params.get("ProjectId")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplatesResponse(AbstractModel):
    """DescribeRuleTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则模版列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of RuleTemplate
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RuleTemplate()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRulesByPageRequest(AbstractModel):
    """DescribeRulesByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRulesByPageResponse(AbstractModel):
    """DescribeRulesByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则质量列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RulePage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RulePage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRulesRequest(AbstractModel):
    """DescribeRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleGroupId: 规则组id
        :type RuleGroupId: int
        :param _EngineType: 该规则运行的执行引擎，不传时会请求该数据源下默认的执行引擎
        :type EngineType: str
        """
        self._ProjectId = None
        self._RuleGroupId = None
        self._EngineType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._EngineType = params.get("EngineType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRulesResponse(AbstractModel):
    """DescribeRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of Rule
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = Rule()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStandardRuleDetailInfoListRequest(AbstractModel):
    """DescribeStandardRuleDetailInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 空间、项目id
        :type ProjectId: str
        :param _Type: 标准分类11编码映射 12数据过滤 13字符串转换 14数据元定义 15正则表达 16术语词典
        :type Type: int
        """
        self._ProjectId = None
        self._Type = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStandardRuleDetailInfoListResponse(AbstractModel):
    """DescribeStandardRuleDetailInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StandardRuleDetailList: 返回值
注意：此字段可能返回 null，表示取不到有效值。
        :type StandardRuleDetailList: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StandardRuleDetailList = None
        self._RequestId = None

    @property
    def StandardRuleDetailList(self):
        return self._StandardRuleDetailList

    @StandardRuleDetailList.setter
    def StandardRuleDetailList(self, StandardRuleDetailList):
        self._StandardRuleDetailList = StandardRuleDetailList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StandardRuleDetailList = params.get("StandardRuleDetailList")
        self._RequestId = params.get("RequestId")


class DescribeStreamTaskLogListRequest(AbstractModel):
    """DescribeStreamTaskLogList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _JobId: 作业ID
        :type JobId: str
        :param _EndTime: 结束时间
        :type EndTime: int
        :param _StartTime: 开始时间
        :type StartTime: int
        :param _Container: container名字
        :type Container: str
        :param _Limit: 条数
        :type Limit: int
        :param _OrderType: 排序类型 desc asc
        :type OrderType: str
        :param _RunningOrderId: 作业运行的实例ID
        :type RunningOrderId: int
        """
        self._ProjectId = None
        self._TaskId = None
        self._JobId = None
        self._EndTime = None
        self._StartTime = None
        self._Container = None
        self._Limit = None
        self._OrderType = None
        self._RunningOrderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderType(self):
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def RunningOrderId(self):
        return self._RunningOrderId

    @RunningOrderId.setter
    def RunningOrderId(self, RunningOrderId):
        self._RunningOrderId = RunningOrderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._JobId = params.get("JobId")
        self._EndTime = params.get("EndTime")
        self._StartTime = params.get("StartTime")
        self._Container = params.get("Container")
        self._Limit = params.get("Limit")
        self._OrderType = params.get("OrderType")
        self._RunningOrderId = params.get("RunningOrderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamTaskLogListResponse(AbstractModel):
    """DescribeStreamTaskLogList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ListOver: 是否是全量
注意：此字段可能返回 null，表示取不到有效值。
        :type ListOver: bool
        :param _LogContentList: 日志集合
注意：此字段可能返回 null，表示取不到有效值。
        :type LogContentList: list of LogContentInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ListOver = None
        self._LogContentList = None
        self._RequestId = None

    @property
    def ListOver(self):
        return self._ListOver

    @ListOver.setter
    def ListOver(self, ListOver):
        self._ListOver = ListOver

    @property
    def LogContentList(self):
        return self._LogContentList

    @LogContentList.setter
    def LogContentList(self, LogContentList):
        self._LogContentList = LogContentList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ListOver = params.get("ListOver")
        if params.get("LogContentList") is not None:
            self._LogContentList = []
            for item in params.get("LogContentList"):
                obj = LogContentInfo()
                obj._deserialize(item)
                self._LogContentList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableInfoListRequest(AbstractModel):
    """DescribeTableInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 表名
        :type Filters: list of Filter
        :param _ConnectionType: 如果是hive这里写rpc，如果是其他类型不传
        :type ConnectionType: str
        :param _Catalog: 数据库源类型
        :type Catalog: str
        """
        self._Filters = None
        self._ConnectionType = None
        self._Catalog = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ConnectionType(self):
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType

    @property
    def Catalog(self):
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ConnectionType = params.get("ConnectionType")
        self._Catalog = params.get("Catalog")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableInfoListResponse(AbstractModel):
    """DescribeTableInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableInfo: 表信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TableInfo: list of TableInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableInfo = None
        self._RequestId = None

    @property
    def TableInfo(self):
        return self._TableInfo

    @TableInfo.setter
    def TableInfo(self, TableInfo):
        self._TableInfo = TableInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableInfo") is not None:
            self._TableInfo = []
            for item in params.get("TableInfo"):
                obj = TableInfo()
                obj._deserialize(item)
                self._TableInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableQualityDetailsRequest(AbstractModel):
    """DescribeTableQualityDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期
        :type StatisticsDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤参数TableName、DatabaseId 、DatabaseName、OwnerUserName
        :type Filters: list of Filter
        :param _OrderFields: 排序参数 排序方式 DESC 或者 ASC，表得分排序 TableScore
        :type OrderFields: list of OrderField
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._DatasourceId = None
        self._ScoreType = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableQualityDetailsResponse(AbstractModel):
    """DescribeTableQualityDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 表质量分详情结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TableQualityDetailPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TableQualityDetailPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTableSchemaInfoRequest(AbstractModel):
    """DescribeTableSchemaInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 表名称
        :type Name: str
        :param _DatabaseName: 数据库名称
        :type DatabaseName: str
        :param _MsType: 表类型
        :type MsType: str
        :param _DatasourceId: 数据源id
        :type DatasourceId: str
        :param _ConnectionType: HIVE传rpc
        :type ConnectionType: str
        :param _SchemaName: 元数据Database下的Schema名称
        :type SchemaName: str
        """
        self._Name = None
        self._DatabaseName = None
        self._MsType = None
        self._DatasourceId = None
        self._ConnectionType = None
        self._SchemaName = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def MsType(self):
        return self._MsType

    @MsType.setter
    def MsType(self, MsType):
        self._MsType = MsType

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ConnectionType(self):
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType

    @property
    def SchemaName(self):
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._DatabaseName = params.get("DatabaseName")
        self._MsType = params.get("MsType")
        self._DatasourceId = params.get("DatasourceId")
        self._ConnectionType = params.get("ConnectionType")
        self._SchemaName = params.get("SchemaName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableSchemaInfoResponse(AbstractModel):
    """DescribeTableSchemaInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SchemaInfoList: 123
注意：此字段可能返回 null，表示取不到有效值。
        :type SchemaInfoList: list of SchemaDetail
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SchemaInfoList = None
        self._RequestId = None

    @property
    def SchemaInfoList(self):
        return self._SchemaInfoList

    @SchemaInfoList.setter
    def SchemaInfoList(self, SchemaInfoList):
        self._SchemaInfoList = SchemaInfoList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SchemaInfoList") is not None:
            self._SchemaInfoList = []
            for item in params.get("SchemaInfoList"):
                obj = SchemaDetail()
                obj._deserialize(item)
                self._SchemaInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableScoreTrendRequest(AbstractModel):
    """DescribeTableScoreTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _StatisticsStartDate: 开始时间 秒级时间戳
        :type StatisticsStartDate: int
        :param _StatisticsEndDate: 结束时间 秒级时间戳
        :type StatisticsEndDate: int
        :param _TableId: 表id
        :type TableId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        """
        self._ProjectId = None
        self._StatisticsStartDate = None
        self._StatisticsEndDate = None
        self._TableId = None
        self._ScoreType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def StatisticsStartDate(self):
        return self._StatisticsStartDate

    @StatisticsStartDate.setter
    def StatisticsStartDate(self, StatisticsStartDate):
        self._StatisticsStartDate = StatisticsStartDate

    @property
    def StatisticsEndDate(self):
        return self._StatisticsEndDate

    @StatisticsEndDate.setter
    def StatisticsEndDate(self, StatisticsEndDate):
        self._StatisticsEndDate = StatisticsEndDate

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._StatisticsStartDate = params.get("StatisticsStartDate")
        self._StatisticsEndDate = params.get("StatisticsEndDate")
        self._TableId = params.get("TableId")
        self._ScoreType = params.get("ScoreType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableScoreTrendResponse(AbstractModel):
    """DescribeTableScoreTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 表得分趋势
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScoreTrend`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScoreTrend()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskAlarmRegulationsRequest(AbstractModel):
    """DescribeTaskAlarmRegulations请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _Filters: 过滤条件(name有RegularStatus、AlarmLevel、AlarmIndicator、RegularName)
        :type Filters: list of Filter
        :param _OrderFields: 排序条件(RegularId)
        :type OrderFields: list of OrderField
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _TaskType: 任务类型(201代表实时任务，202代表离线任务)
        :type TaskType: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._TaskId = None
        self._TaskType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskAlarmRegulationsResponse(AbstractModel):
    """DescribeTaskAlarmRegulations返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskAlarmInfos: 告警规则信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskAlarmInfos: list of TaskAlarmInfo
        :param _TotalCount: 总记录数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskAlarmInfos = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskAlarmInfos(self):
        return self._TaskAlarmInfos

    @TaskAlarmInfos.setter
    def TaskAlarmInfos(self, TaskAlarmInfos):
        self._TaskAlarmInfos = TaskAlarmInfos

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskAlarmInfos") is not None:
            self._TaskAlarmInfos = []
            for item in params.get("TaskAlarmInfos"):
                obj = TaskAlarmInfo()
                obj._deserialize(item)
                self._TaskAlarmInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTaskDetailRequest(AbstractModel):
    """DescribeTaskDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _TaskAlarmStatus: 任务告警状态
        :type TaskAlarmStatus: int
        """
        self._ProjectId = None
        self._TaskId = None
        self._TaskAlarmStatus = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskAlarmStatus(self):
        return self._TaskAlarmStatus

    @TaskAlarmStatus.setter
    def TaskAlarmStatus(self, TaskAlarmStatus):
        self._TaskAlarmStatus = TaskAlarmStatus


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._TaskAlarmStatus = params.get("TaskAlarmStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskDetailResponse(AbstractModel):
    """DescribeTaskDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务详情1
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskInfoData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TaskInfoData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskInstanceReportDetailRequest(AbstractModel):
    """DescribeTaskInstanceReportDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _CurRunDate: 任务实例数据时间
        :type CurRunDate: str
        :param _IssueDate: 任务实例运行时间
        :type IssueDate: str
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None
        self._IssueDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def IssueDate(self):
        return self._IssueDate

    @IssueDate.setter
    def IssueDate(self, IssueDate):
        self._IssueDate = IssueDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._IssueDate = params.get("IssueDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskInstanceReportDetailResponse(AbstractModel):
    """DescribeTaskInstanceReportDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Summary: 任务实例运行指标概览
        :type Summary: :class:`tencentcloud.wedata.v20210820.models.InstanceReportSummary`
        :param _ReadNode: 任务实例读取节点运行指标
        :type ReadNode: :class:`tencentcloud.wedata.v20210820.models.InstanceReportReadNode`
        :param _WriteNode: 任务实例写入节点运行指标
        :type WriteNode: :class:`tencentcloud.wedata.v20210820.models.InstanceReportWriteNode`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Summary = None
        self._ReadNode = None
        self._WriteNode = None
        self._RequestId = None

    @property
    def Summary(self):
        return self._Summary

    @Summary.setter
    def Summary(self, Summary):
        self._Summary = Summary

    @property
    def ReadNode(self):
        return self._ReadNode

    @ReadNode.setter
    def ReadNode(self, ReadNode):
        self._ReadNode = ReadNode

    @property
    def WriteNode(self):
        return self._WriteNode

    @WriteNode.setter
    def WriteNode(self, WriteNode):
        self._WriteNode = WriteNode

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Summary") is not None:
            self._Summary = InstanceReportSummary()
            self._Summary._deserialize(params.get("Summary"))
        if params.get("ReadNode") is not None:
            self._ReadNode = InstanceReportReadNode()
            self._ReadNode._deserialize(params.get("ReadNode"))
        if params.get("WriteNode") is not None:
            self._WriteNode = InstanceReportWriteNode()
            self._WriteNode._deserialize(params.get("WriteNode"))
        self._RequestId = params.get("RequestId")


class DescribeTaskInstanceRequest(AbstractModel):
    """DescribeTaskInstance请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _CurRunDate: 任务实例数据时间
        :type CurRunDate: str
        :param _IssueDate: 任务实例运行时间
        :type IssueDate: str
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None
        self._IssueDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def IssueDate(self):
        return self._IssueDate

    @IssueDate.setter
    def IssueDate(self, IssueDate):
        self._IssueDate = IssueDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._IssueDate = params.get("IssueDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskInstanceResponse(AbstractModel):
    """DescribeTaskInstance返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInstanceDetail: 任务实例详情
        :type TaskInstanceDetail: :class:`tencentcloud.wedata.v20210820.models.TaskInstanceDetail`
        :param _Data: 任务实例详情。与TaskInstanceDetail相同含义，优先取Data，Data为空时，取TaskInstanceDetail
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskInstanceDetail`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskInstanceDetail = None
        self._Data = None
        self._RequestId = None

    @property
    def TaskInstanceDetail(self):
        return self._TaskInstanceDetail

    @TaskInstanceDetail.setter
    def TaskInstanceDetail(self, TaskInstanceDetail):
        self._TaskInstanceDetail = TaskInstanceDetail

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInstanceDetail") is not None:
            self._TaskInstanceDetail = TaskInstanceDetail()
            self._TaskInstanceDetail._deserialize(params.get("TaskInstanceDetail"))
        if params.get("Data") is not None:
            self._Data = TaskInstanceDetail()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskInstancesData(AbstractModel):
    """查询任务实例列表

    """

    def __init__(self):
        r"""
        :param _Items: 实例列表
        :type Items: list of TaskInstanceInfo
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _PageNumber: 页号
        :type PageNumber: int
        :param _PageSize: 页大小
        :type PageSize: int
        """
        self._Items = None
        self._TotalCount = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = TaskInstanceInfo()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskInstancesRequest(AbstractModel):
    """DescribeTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 页号，默认为1
        :type PageNumber: int
        :param _PageSize: 页大小，默认为10，最大不超过200
        :type PageSize: int
        :param _WorkflowIdList: 工作流id列表
        :type WorkflowIdList: list of str
        :param _WorkflowNameList: 工作流名称列表，支持模糊搜索
        :type WorkflowNameList: list of str
        :param _DateFrom: 起始数据时间，格式yyyy-MM-dd HH:mm:ss
        :type DateFrom: str
        :param _DateTo: 结束数据时间，格式yyyy-MM-dd HH:mm:ss
        :type DateTo: str
        :param _TaskIdList: 任务id列表
        :type TaskIdList: list of str
        :param _TaskNameList: 任务名称列表，支持模糊搜索
        :type TaskNameList: list of str
        :param _InChargeList: 责任人名称列表
        :type InChargeList: list of str
        :param _TaskTypeIdList: 任务类型码列表，26离线同步，30Python，31PySpark，32DLC，33Impala，34Hive SQL，35Shell，36Spark SQL，39Spark，40CDW PG，92MapReduce
        :type TaskTypeIdList: list of int
        :param _StateList: 实例状态列表，0等待事件，1等待上游，2等待运行，3运行中，4正在终止，5失败重试，6失败，7成功
        :type StateList: list of str
        :param _TaskCycleUnitList: 周期类型列表，I分钟，H小时，D天，W周，M月，Y年，O一次性，C crontab
        :type TaskCycleUnitList: list of str
        :param _InstanceType: 实例类型，0补录实例，1周期实例，2非周期实例
        :type InstanceType: int
        :param _OrderFields: 排序字段信息列表，ScheduleDateTime / CostTime / StartTime / EndTime
        :type OrderFields: list of OrderField
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._WorkflowIdList = None
        self._WorkflowNameList = None
        self._DateFrom = None
        self._DateTo = None
        self._TaskIdList = None
        self._TaskNameList = None
        self._InChargeList = None
        self._TaskTypeIdList = None
        self._StateList = None
        self._TaskCycleUnitList = None
        self._InstanceType = None
        self._OrderFields = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def WorkflowIdList(self):
        return self._WorkflowIdList

    @WorkflowIdList.setter
    def WorkflowIdList(self, WorkflowIdList):
        self._WorkflowIdList = WorkflowIdList

    @property
    def WorkflowNameList(self):
        return self._WorkflowNameList

    @WorkflowNameList.setter
    def WorkflowNameList(self, WorkflowNameList):
        self._WorkflowNameList = WorkflowNameList

    @property
    def DateFrom(self):
        return self._DateFrom

    @DateFrom.setter
    def DateFrom(self, DateFrom):
        self._DateFrom = DateFrom

    @property
    def DateTo(self):
        return self._DateTo

    @DateTo.setter
    def DateTo(self, DateTo):
        self._DateTo = DateTo

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def TaskNameList(self):
        return self._TaskNameList

    @TaskNameList.setter
    def TaskNameList(self, TaskNameList):
        self._TaskNameList = TaskNameList

    @property
    def InChargeList(self):
        return self._InChargeList

    @InChargeList.setter
    def InChargeList(self, InChargeList):
        self._InChargeList = InChargeList

    @property
    def TaskTypeIdList(self):
        return self._TaskTypeIdList

    @TaskTypeIdList.setter
    def TaskTypeIdList(self, TaskTypeIdList):
        self._TaskTypeIdList = TaskTypeIdList

    @property
    def StateList(self):
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def TaskCycleUnitList(self):
        return self._TaskCycleUnitList

    @TaskCycleUnitList.setter
    def TaskCycleUnitList(self, TaskCycleUnitList):
        self._TaskCycleUnitList = TaskCycleUnitList

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._WorkflowIdList = params.get("WorkflowIdList")
        self._WorkflowNameList = params.get("WorkflowNameList")
        self._DateFrom = params.get("DateFrom")
        self._DateTo = params.get("DateTo")
        self._TaskIdList = params.get("TaskIdList")
        self._TaskNameList = params.get("TaskNameList")
        self._InChargeList = params.get("InChargeList")
        self._TaskTypeIdList = params.get("TaskTypeIdList")
        self._StateList = params.get("StateList")
        self._TaskCycleUnitList = params.get("TaskCycleUnitList")
        self._InstanceType = params.get("InstanceType")
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskInstancesResponse(AbstractModel):
    """DescribeTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeTaskInstancesData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTaskInstancesData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskLockStatusRequest(AbstractModel):
    """DescribeTaskLockStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型：201. stream,   202. offline
        :type TaskType: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskLockStatusResponse(AbstractModel):
    """DescribeTaskLockStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskLockStatus: 任务锁状态信息
        :type TaskLockStatus: :class:`tencentcloud.wedata.v20210820.models.TaskLockStatus`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskLockStatus = None
        self._RequestId = None

    @property
    def TaskLockStatus(self):
        return self._TaskLockStatus

    @TaskLockStatus.setter
    def TaskLockStatus(self, TaskLockStatus):
        self._TaskLockStatus = TaskLockStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskLockStatus") is not None:
            self._TaskLockStatus = TaskLockStatus()
            self._TaskLockStatus._deserialize(params.get("TaskLockStatus"))
        self._RequestId = params.get("RequestId")


class DescribeTaskReportDetailListRequest(AbstractModel):
    """DescribeTaskReportDetailList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目id
        :type ProjectId: str
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _BeginDate: 统计周期的开始日期，格式为 yyyy-MM-dd
        :type BeginDate: str
        :param _EndDate: 统计周期的结束日期，格式为 yyyy-MM-dd
        :type EndDate: str
        :param _StateList: 任务状态，多个状态用逗号连接
        :type StateList: str
        :param _SortItem: 排序字段名
        :type SortItem: str
        :param _SortType: 升序或降序，传ASC或DESC
        :type SortType: str
        :param _PageIndex: 页数，从1开始
        :type PageIndex: int
        :param _PageSize: 每页的记录条数，默认10条
        :type PageSize: int
        """
        self._ProjectId = None
        self._TaskId = None
        self._BeginDate = None
        self._EndDate = None
        self._StateList = None
        self._SortItem = None
        self._SortType = None
        self._PageIndex = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def StateList(self):
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        self._StateList = params.get("StateList")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskReportDetailListResponse(AbstractModel):
    """DescribeTaskReportDetailList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PageIndex: 页码，从1开始
        :type PageIndex: int
        :param _PageSize: 每页的记录数
        :type PageSize: int
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _TotalPage: 总页数
        :type TotalPage: int
        :param _Items: 任务运行指标
        :type Items: list of TaskReportDetail
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PageIndex = None
        self._PageSize = None
        self._TotalCount = None
        self._TotalPage = None
        self._Items = None
        self._RequestId = None

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = TaskReportDetail()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskReportRequest(AbstractModel):
    """DescribeTaskReport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _BeginDate: 统计周期的开始日期，格式为 yyyy-MM-dd
        :type BeginDate: str
        :param _EndDate: 统计周期的结束日期，格式为 yyyy-MM-dd
        :type EndDate: str
        :param _ProjectId: WeData项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._BeginDate = None
        self._EndDate = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskReportResponse(AbstractModel):
    """DescribeTaskReport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalReadRecords: 总读取条数
        :type TotalReadRecords: int
        :param _TotalReadBytes: 总读取字节数，单位为Byte
        :type TotalReadBytes: int
        :param _TotalWriteRecords: 总写入条数
        :type TotalWriteRecords: int
        :param _TotalWriteBytes: 总写入字节数，单位为Byte
        :type TotalWriteBytes: int
        :param _TotalErrorRecords: 总脏数据条数
        :type TotalErrorRecords: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalReadRecords = None
        self._TotalReadBytes = None
        self._TotalWriteRecords = None
        self._TotalWriteBytes = None
        self._TotalErrorRecords = None
        self._RequestId = None

    @property
    def TotalReadRecords(self):
        return self._TotalReadRecords

    @TotalReadRecords.setter
    def TotalReadRecords(self, TotalReadRecords):
        self._TotalReadRecords = TotalReadRecords

    @property
    def TotalReadBytes(self):
        return self._TotalReadBytes

    @TotalReadBytes.setter
    def TotalReadBytes(self, TotalReadBytes):
        self._TotalReadBytes = TotalReadBytes

    @property
    def TotalWriteRecords(self):
        return self._TotalWriteRecords

    @TotalWriteRecords.setter
    def TotalWriteRecords(self, TotalWriteRecords):
        self._TotalWriteRecords = TotalWriteRecords

    @property
    def TotalWriteBytes(self):
        return self._TotalWriteBytes

    @TotalWriteBytes.setter
    def TotalWriteBytes(self, TotalWriteBytes):
        self._TotalWriteBytes = TotalWriteBytes

    @property
    def TotalErrorRecords(self):
        return self._TotalErrorRecords

    @TotalErrorRecords.setter
    def TotalErrorRecords(self, TotalErrorRecords):
        self._TotalErrorRecords = TotalErrorRecords

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalReadRecords = params.get("TotalReadRecords")
        self._TotalReadBytes = params.get("TotalReadBytes")
        self._TotalWriteRecords = params.get("TotalWriteRecords")
        self._TotalWriteBytes = params.get("TotalWriteBytes")
        self._TotalErrorRecords = params.get("TotalErrorRecords")
        self._RequestId = params.get("RequestId")


class DescribeTaskScriptRequest(AbstractModel):
    """DescribeTaskScript请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._ProjectId = None
        self._TaskId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskScriptResponse(AbstractModel):
    """DescribeTaskScript返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务脚本内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskScriptContent`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TaskScriptContent()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTasksByPageRequest(AbstractModel):
    """DescribeTasksByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _PageNumber: 页码，默认1
        :type PageNumber: int
        :param _PageSize: 页大小，默认10
        :type PageSize: int
        """
        self._ProjectId = None
        self._WorkflowId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksByPageResponse(AbstractModel):
    """DescribeTasksByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无1
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskInfoDataPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TaskInfoDataPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTemplateDimCountRequest(AbstractModel):
    """DescribeTemplateDimCount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 模版类型
        :type Type: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._Type = None
        self._ProjectId = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTemplateDimCountResponse(AbstractModel):
    """DescribeTemplateDimCount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 维度统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of DimensionCount
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DimensionCount()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTemplateHistoryRequest(AbstractModel):
    """DescribeTemplateHistory请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTemplateHistoryResponse(AbstractModel):
    """DescribeTemplateHistory返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 分页记录
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleTemplateHistoryPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleTemplateHistoryPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTopTableStatRequest(AbstractModel):
    """DescribeTopTableStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project Id
        :type ProjectId: str
        :param _BeginDate: 开始时间，时间戳到秒
        :type BeginDate: str
        :param _EndDate: 结束时间，时间戳到秒
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopTableStatResponse(AbstractModel):
    """DescribeTopTableStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TopTableStat`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TopTableStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTrendStatRequest(AbstractModel):
    """DescribeTrendStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id
        :type ProjectId: str
        :param _BeginDate: 开始时间，时间戳到秒
        :type BeginDate: str
        :param _EndDate: 结束时间，时间戳到秒
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTrendStatResponse(AbstractModel):
    """DescribeTrendStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: list of RuleExecDateStat
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RuleExecDateStat()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DimensionCount(AbstractModel):
    """维度统计业务视图

    """

    def __init__(self):
        r"""
        :param _DimType: 维度类型1：准确性，2：唯一性，3：完整性，4：一致性，5：及时性，6：有效性
注意：此字段可能返回 null，表示取不到有效值。
        :type DimType: int
        :param _Count: 统计值
注意：此字段可能返回 null，表示取不到有效值。
        :type Count: int
        :param _QualityDim: 维度类型1：准确性，2：唯一性，3：完整性，4：一致性，5：及时性，6：有效性
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityDim: int
        """
        self._DimType = None
        self._Count = None
        self._QualityDim = None

    @property
    def DimType(self):
        warnings.warn("parameter `DimType` is deprecated", DeprecationWarning) 

        return self._DimType

    @DimType.setter
    def DimType(self, DimType):
        warnings.warn("parameter `DimType` is deprecated", DeprecationWarning) 

        self._DimType = DimType

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim


    def _deserialize(self, params):
        self._DimType = params.get("DimType")
        self._Count = params.get("Count")
        self._QualityDim = params.get("QualityDim")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DimensionScore(AbstractModel):
    """维度评分

    """

    def __init__(self):
        r"""
        :param _DimensionScoreList: 维度评分列表
注意：此字段可能返回 null，表示取不到有效值。
        :type DimensionScoreList: list of DimensionScoreInfo
        """
        self._DimensionScoreList = None

    @property
    def DimensionScoreList(self):
        return self._DimensionScoreList

    @DimensionScoreList.setter
    def DimensionScoreList(self, DimensionScoreList):
        self._DimensionScoreList = DimensionScoreList


    def _deserialize(self, params):
        if params.get("DimensionScoreList") is not None:
            self._DimensionScoreList = []
            for item in params.get("DimensionScoreList"):
                obj = DimensionScoreInfo()
                obj._deserialize(item)
                self._DimensionScoreList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DimensionScoreInfo(AbstractModel):
    """维度评分信息

    """

    def __init__(self):
        r"""
        :param _Name: 维度名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Weight: 权重
注意：此字段可能返回 null，表示取不到有效值。
        :type Weight: float
        :param _UserId: 设置人id
注意：此字段可能返回 null，表示取不到有效值。
        :type UserId: int
        :param _UserName: 设置人名
注意：此字段可能返回 null，表示取不到有效值。
        :type UserName: str
        :param _UpdateTime: 更新时间 时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: int
        :param _JoinTableNumber: 参与评估表数量
        :type JoinTableNumber: int
        :param _Score: 评分
        :type Score: float
        """
        self._Name = None
        self._Weight = None
        self._UserId = None
        self._UserName = None
        self._UpdateTime = None
        self._JoinTableNumber = None
        self._Score = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Weight(self):
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def JoinTableNumber(self):
        return self._JoinTableNumber

    @JoinTableNumber.setter
    def JoinTableNumber(self, JoinTableNumber):
        self._JoinTableNumber = JoinTableNumber

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Weight = params.get("Weight")
        self._UserId = params.get("UserId")
        self._UserName = params.get("UserName")
        self._UpdateTime = params.get("UpdateTime")
        self._JoinTableNumber = params.get("JoinTableNumber")
        self._Score = params.get("Score")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DlcDataGovernPolicy(AbstractModel):
    """数据治理配置项

    """

    def __init__(self):
        r"""
        :param _RewriteDataPolicy: 数据排布治理项
注意：此字段可能返回 null，表示取不到有效值。
        :type RewriteDataPolicy: :class:`tencentcloud.wedata.v20210820.models.DlcRewriteDataInfo`
        :param _ExpiredSnapshotsPolicy: 快照过期治理项
注意：此字段可能返回 null，表示取不到有效值。
        :type ExpiredSnapshotsPolicy: :class:`tencentcloud.wedata.v20210820.models.DlcExpiredSnapshotsInfo`
        :param _RemoveOrphanFilesPolicy: 移除孤立文件治理项
注意：此字段可能返回 null，表示取不到有效值。
        :type RemoveOrphanFilesPolicy: :class:`tencentcloud.wedata.v20210820.models.DlcRemoveOrphanFilesInfo`
        :param _MergeManifestsPolicy: 合并元数据Manifests治理项
注意：此字段可能返回 null，表示取不到有效值。
        :type MergeManifestsPolicy: :class:`tencentcloud.wedata.v20210820.models.DlcMergeManifestsInfo`
        :param _InheritDataBase: 是否集成库规则：default（默认继承）、none（不继承）
注意：此字段可能返回 null，表示取不到有效值。
        :type InheritDataBase: str
        :param _RuleType: 治理规则类型，Customize: 自定义；Intelligence: 智能治理
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleType: str
        :param _GovernEngine: 治理引擎
注意：此字段可能返回 null，表示取不到有效值。
        :type GovernEngine: str
        """
        self._RewriteDataPolicy = None
        self._ExpiredSnapshotsPolicy = None
        self._RemoveOrphanFilesPolicy = None
        self._MergeManifestsPolicy = None
        self._InheritDataBase = None
        self._RuleType = None
        self._GovernEngine = None

    @property
    def RewriteDataPolicy(self):
        return self._RewriteDataPolicy

    @RewriteDataPolicy.setter
    def RewriteDataPolicy(self, RewriteDataPolicy):
        self._RewriteDataPolicy = RewriteDataPolicy

    @property
    def ExpiredSnapshotsPolicy(self):
        return self._ExpiredSnapshotsPolicy

    @ExpiredSnapshotsPolicy.setter
    def ExpiredSnapshotsPolicy(self, ExpiredSnapshotsPolicy):
        self._ExpiredSnapshotsPolicy = ExpiredSnapshotsPolicy

    @property
    def RemoveOrphanFilesPolicy(self):
        return self._RemoveOrphanFilesPolicy

    @RemoveOrphanFilesPolicy.setter
    def RemoveOrphanFilesPolicy(self, RemoveOrphanFilesPolicy):
        self._RemoveOrphanFilesPolicy = RemoveOrphanFilesPolicy

    @property
    def MergeManifestsPolicy(self):
        return self._MergeManifestsPolicy

    @MergeManifestsPolicy.setter
    def MergeManifestsPolicy(self, MergeManifestsPolicy):
        self._MergeManifestsPolicy = MergeManifestsPolicy

    @property
    def InheritDataBase(self):
        return self._InheritDataBase

    @InheritDataBase.setter
    def InheritDataBase(self, InheritDataBase):
        self._InheritDataBase = InheritDataBase

    @property
    def RuleType(self):
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType

    @property
    def GovernEngine(self):
        return self._GovernEngine

    @GovernEngine.setter
    def GovernEngine(self, GovernEngine):
        self._GovernEngine = GovernEngine


    def _deserialize(self, params):
        if params.get("RewriteDataPolicy") is not None:
            self._RewriteDataPolicy = DlcRewriteDataInfo()
            self._RewriteDataPolicy._deserialize(params.get("RewriteDataPolicy"))
        if params.get("ExpiredSnapshotsPolicy") is not None:
            self._ExpiredSnapshotsPolicy = DlcExpiredSnapshotsInfo()
            self._ExpiredSnapshotsPolicy._deserialize(params.get("ExpiredSnapshotsPolicy"))
        if params.get("RemoveOrphanFilesPolicy") is not None:
            self._RemoveOrphanFilesPolicy = DlcRemoveOrphanFilesInfo()
            self._RemoveOrphanFilesPolicy._deserialize(params.get("RemoveOrphanFilesPolicy"))
        if params.get("MergeManifestsPolicy") is not None:
            self._MergeManifestsPolicy = DlcMergeManifestsInfo()
            self._MergeManifestsPolicy._deserialize(params.get("MergeManifestsPolicy"))
        self._InheritDataBase = params.get("InheritDataBase")
        self._RuleType = params.get("RuleType")
        self._GovernEngine = params.get("GovernEngine")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DlcExpiredSnapshotsInfo(AbstractModel):
    """快照过期治理项

    """

    def __init__(self):
        r"""
        :param _ExpiredSnapshotsEnable: 是否启用快照过期治理项：enable、none
注意：此字段可能返回 null，表示取不到有效值。
        :type ExpiredSnapshotsEnable: str
        :param _Engine: 用于运行快照过期治理项的引擎名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Engine: str
        :param _RetainLast: 需要保留的最近快照个数
注意：此字段可能返回 null，表示取不到有效值。
        :type RetainLast: int
        :param _BeforeDays: 过期指定天前的快照
注意：此字段可能返回 null，表示取不到有效值。
        :type BeforeDays: int
        :param _MaxConcurrentDeletes: 清理过期快照的并行数
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxConcurrentDeletes: int
        :param _IntervalMin: 快照过期治理运行周期，单位为分钟
注意：此字段可能返回 null，表示取不到有效值。
        :type IntervalMin: int
        """
        self._ExpiredSnapshotsEnable = None
        self._Engine = None
        self._RetainLast = None
        self._BeforeDays = None
        self._MaxConcurrentDeletes = None
        self._IntervalMin = None

    @property
    def ExpiredSnapshotsEnable(self):
        return self._ExpiredSnapshotsEnable

    @ExpiredSnapshotsEnable.setter
    def ExpiredSnapshotsEnable(self, ExpiredSnapshotsEnable):
        self._ExpiredSnapshotsEnable = ExpiredSnapshotsEnable

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def RetainLast(self):
        return self._RetainLast

    @RetainLast.setter
    def RetainLast(self, RetainLast):
        self._RetainLast = RetainLast

    @property
    def BeforeDays(self):
        return self._BeforeDays

    @BeforeDays.setter
    def BeforeDays(self, BeforeDays):
        self._BeforeDays = BeforeDays

    @property
    def MaxConcurrentDeletes(self):
        return self._MaxConcurrentDeletes

    @MaxConcurrentDeletes.setter
    def MaxConcurrentDeletes(self, MaxConcurrentDeletes):
        self._MaxConcurrentDeletes = MaxConcurrentDeletes

    @property
    def IntervalMin(self):
        return self._IntervalMin

    @IntervalMin.setter
    def IntervalMin(self, IntervalMin):
        self._IntervalMin = IntervalMin


    def _deserialize(self, params):
        self._ExpiredSnapshotsEnable = params.get("ExpiredSnapshotsEnable")
        self._Engine = params.get("Engine")
        self._RetainLast = params.get("RetainLast")
        self._BeforeDays = params.get("BeforeDays")
        self._MaxConcurrentDeletes = params.get("MaxConcurrentDeletes")
        self._IntervalMin = params.get("IntervalMin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DlcMergeManifestsInfo(AbstractModel):
    """合并元数据Manifests治理项

    """

    def __init__(self):
        r"""
        :param _MergeManifestsEnable: 是否启用合并元数据Manifests文件治理项：enable、none
注意：此字段可能返回 null，表示取不到有效值。
        :type MergeManifestsEnable: str
        :param _Engine: 用于运行合并元数据Manifests文件治理项的引擎名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Engine: str
        :param _IntervalMin: 合并元数据Manifests文件治理运行周期，单位为分钟
注意：此字段可能返回 null，表示取不到有效值。
        :type IntervalMin: int
        """
        self._MergeManifestsEnable = None
        self._Engine = None
        self._IntervalMin = None

    @property
    def MergeManifestsEnable(self):
        return self._MergeManifestsEnable

    @MergeManifestsEnable.setter
    def MergeManifestsEnable(self, MergeManifestsEnable):
        self._MergeManifestsEnable = MergeManifestsEnable

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def IntervalMin(self):
        return self._IntervalMin

    @IntervalMin.setter
    def IntervalMin(self, IntervalMin):
        self._IntervalMin = IntervalMin


    def _deserialize(self, params):
        self._MergeManifestsEnable = params.get("MergeManifestsEnable")
        self._Engine = params.get("Engine")
        self._IntervalMin = params.get("IntervalMin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DlcRemoveOrphanFilesInfo(AbstractModel):
    """移除孤立文件治理项

    """

    def __init__(self):
        r"""
        :param _RemoveOrphanFilesEnable: 是否启用移除孤立文件治理项：enable、none
注意：此字段可能返回 null，表示取不到有效值。
        :type RemoveOrphanFilesEnable: str
        :param _Engine: 用于运行移除孤立文件治理项的引擎名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Engine: str
        :param _BeforeDays: 移除指定天前的孤立文件
注意：此字段可能返回 null，表示取不到有效值。
        :type BeforeDays: int
        :param _MaxConcurrentDeletes: 移除孤立文件的并行数
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxConcurrentDeletes: int
        :param _IntervalMin: 移除孤立文件治理运行周期，单位为分钟
注意：此字段可能返回 null，表示取不到有效值。
        :type IntervalMin: int
        """
        self._RemoveOrphanFilesEnable = None
        self._Engine = None
        self._BeforeDays = None
        self._MaxConcurrentDeletes = None
        self._IntervalMin = None

    @property
    def RemoveOrphanFilesEnable(self):
        return self._RemoveOrphanFilesEnable

    @RemoveOrphanFilesEnable.setter
    def RemoveOrphanFilesEnable(self, RemoveOrphanFilesEnable):
        self._RemoveOrphanFilesEnable = RemoveOrphanFilesEnable

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def BeforeDays(self):
        return self._BeforeDays

    @BeforeDays.setter
    def BeforeDays(self, BeforeDays):
        self._BeforeDays = BeforeDays

    @property
    def MaxConcurrentDeletes(self):
        return self._MaxConcurrentDeletes

    @MaxConcurrentDeletes.setter
    def MaxConcurrentDeletes(self, MaxConcurrentDeletes):
        self._MaxConcurrentDeletes = MaxConcurrentDeletes

    @property
    def IntervalMin(self):
        return self._IntervalMin

    @IntervalMin.setter
    def IntervalMin(self, IntervalMin):
        self._IntervalMin = IntervalMin


    def _deserialize(self, params):
        self._RemoveOrphanFilesEnable = params.get("RemoveOrphanFilesEnable")
        self._Engine = params.get("Engine")
        self._BeforeDays = params.get("BeforeDays")
        self._MaxConcurrentDeletes = params.get("MaxConcurrentDeletes")
        self._IntervalMin = params.get("IntervalMin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DlcRewriteDataInfo(AbstractModel):
    """数据排布治理项

    """

    def __init__(self):
        r"""
        :param _RewriteDataEnable: 是否启用数据重排布治理项：enable（启动）、disable（不启用，默认）
注意：此字段可能返回 null，表示取不到有效值。
        :type RewriteDataEnable: str
        :param _Engine: 用于运行数据重排布治理项的引擎名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Engine: str
        :param _MinInputFiles: 重排布任务执行的文件个数
注意：此字段可能返回 null，表示取不到有效值。
        :type MinInputFiles: int
        :param _TargetFileSizeBytes: 数据重排布写后的数据文件大小，单位为字节
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetFileSizeBytes: int
        :param _IntervalMin: 数据重排布治理运行周期，单位为分钟
注意：此字段可能返回 null，表示取不到有效值。
        :type IntervalMin: int
        """
        self._RewriteDataEnable = None
        self._Engine = None
        self._MinInputFiles = None
        self._TargetFileSizeBytes = None
        self._IntervalMin = None

    @property
    def RewriteDataEnable(self):
        return self._RewriteDataEnable

    @RewriteDataEnable.setter
    def RewriteDataEnable(self, RewriteDataEnable):
        self._RewriteDataEnable = RewriteDataEnable

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def MinInputFiles(self):
        return self._MinInputFiles

    @MinInputFiles.setter
    def MinInputFiles(self, MinInputFiles):
        self._MinInputFiles = MinInputFiles

    @property
    def TargetFileSizeBytes(self):
        return self._TargetFileSizeBytes

    @TargetFileSizeBytes.setter
    def TargetFileSizeBytes(self, TargetFileSizeBytes):
        self._TargetFileSizeBytes = TargetFileSizeBytes

    @property
    def IntervalMin(self):
        return self._IntervalMin

    @IntervalMin.setter
    def IntervalMin(self, IntervalMin):
        self._IntervalMin = IntervalMin


    def _deserialize(self, params):
        self._RewriteDataEnable = params.get("RewriteDataEnable")
        self._Engine = params.get("Engine")
        self._MinInputFiles = params.get("MinInputFiles")
        self._TargetFileSizeBytes = params.get("TargetFileSizeBytes")
        self._IntervalMin = params.get("IntervalMin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DryRunDIOfflineTaskRequest(AbstractModel):
    """DryRunDIOfflineTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _ResourceGroup: 资源组Id
        :type ResourceGroup: str
        :param _TaskTypeId: 默认 27
        :type TaskTypeId: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._ResourceGroup = None
        self._TaskTypeId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceGroup(self):
        return self._ResourceGroup

    @ResourceGroup.setter
    def ResourceGroup(self, ResourceGroup):
        self._ResourceGroup = ResourceGroup

    @property
    def TaskTypeId(self):
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._ResourceGroup = params.get("ResourceGroup")
        self._TaskTypeId = params.get("TaskTypeId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DryRunDIOfflineTaskResponse(AbstractModel):
    """DryRunDIOfflineTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CurrentRunDate: 数据时间
        :type CurrentRunDate: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Status: 任务状态
        :type Status: str
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _TaskInstanceKey: 任务实例唯一key
        :type TaskInstanceKey: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CurrentRunDate = None
        self._ProjectId = None
        self._Status = None
        self._TaskId = None
        self._TaskInstanceKey = None
        self._RequestId = None

    @property
    def CurrentRunDate(self):
        return self._CurrentRunDate

    @CurrentRunDate.setter
    def CurrentRunDate(self, CurrentRunDate):
        self._CurrentRunDate = CurrentRunDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskInstanceKey(self):
        return self._TaskInstanceKey

    @TaskInstanceKey.setter
    def TaskInstanceKey(self, TaskInstanceKey):
        self._TaskInstanceKey = TaskInstanceKey

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CurrentRunDate = params.get("CurrentRunDate")
        self._ProjectId = params.get("ProjectId")
        self._Status = params.get("Status")
        self._TaskId = params.get("TaskId")
        self._TaskInstanceKey = params.get("TaskInstanceKey")
        self._RequestId = params.get("RequestId")


class ExportTaskInfo(AbstractModel):
    """数据导出任务详情

    """

    def __init__(self):
        r"""
        :param _ExportTaskId: 导出任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type ExportTaskId: int
        :param _TaskType: 导出任务类型(1.全部,2.触发行,3.通过行)
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskType: int
        :param _OperatorId: 任务创建人 id
注意：此字段可能返回 null，表示取不到有效值。
        :type OperatorId: int
        :param _OperatorName: 任务创建人昵称
注意：此字段可能返回 null，表示取不到有效值。
        :type OperatorName: str
        :param _CreateTime: 任务创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _Status: 导出状态(1.已提交 2.导出中 3.导出成功 4.导出失败)
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _SchedulerTaskId: 调度任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type SchedulerTaskId: str
        :param _SchedulerCurRunDate: 调度时间
注意：此字段可能返回 null，表示取不到有效值。
        :type SchedulerCurRunDate: str
        :param _FilePath: 文件相对路径
注意：此字段可能返回 null，表示取不到有效值。
        :type FilePath: str
        """
        self._ExportTaskId = None
        self._TaskType = None
        self._OperatorId = None
        self._OperatorName = None
        self._CreateTime = None
        self._Status = None
        self._SchedulerTaskId = None
        self._SchedulerCurRunDate = None
        self._FilePath = None

    @property
    def ExportTaskId(self):
        return self._ExportTaskId

    @ExportTaskId.setter
    def ExportTaskId(self, ExportTaskId):
        self._ExportTaskId = ExportTaskId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def OperatorId(self):
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def SchedulerTaskId(self):
        return self._SchedulerTaskId

    @SchedulerTaskId.setter
    def SchedulerTaskId(self, SchedulerTaskId):
        self._SchedulerTaskId = SchedulerTaskId

    @property
    def SchedulerCurRunDate(self):
        return self._SchedulerCurRunDate

    @SchedulerCurRunDate.setter
    def SchedulerCurRunDate(self, SchedulerCurRunDate):
        self._SchedulerCurRunDate = SchedulerCurRunDate

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath


    def _deserialize(self, params):
        self._ExportTaskId = params.get("ExportTaskId")
        self._TaskType = params.get("TaskType")
        self._OperatorId = params.get("OperatorId")
        self._OperatorName = params.get("OperatorName")
        self._CreateTime = params.get("CreateTime")
        self._Status = params.get("Status")
        self._SchedulerTaskId = params.get("SchedulerTaskId")
        self._SchedulerCurRunDate = params.get("SchedulerCurRunDate")
        self._FilePath = params.get("FilePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FieldConfig(AbstractModel):
    """字段变量

    """

    def __init__(self):
        r"""
        :param _FieldKey: 字段key
注意：此字段可能返回 null，表示取不到有效值。
        :type FieldKey: str
        :param _FieldValue: 字段值
注意：此字段可能返回 null，表示取不到有效值。
        :type FieldValue: str
        :param _FieldDataType: 字段值类型
注意：此字段可能返回 null，表示取不到有效值。
        :type FieldDataType: str
        """
        self._FieldKey = None
        self._FieldValue = None
        self._FieldDataType = None

    @property
    def FieldKey(self):
        return self._FieldKey

    @FieldKey.setter
    def FieldKey(self, FieldKey):
        self._FieldKey = FieldKey

    @property
    def FieldValue(self):
        return self._FieldValue

    @FieldValue.setter
    def FieldValue(self, FieldValue):
        self._FieldValue = FieldValue

    @property
    def FieldDataType(self):
        return self._FieldDataType

    @FieldDataType.setter
    def FieldDataType(self, FieldDataType):
        self._FieldDataType = FieldDataType


    def _deserialize(self, params):
        self._FieldKey = params.get("FieldKey")
        self._FieldValue = params.get("FieldValue")
        self._FieldDataType = params.get("FieldDataType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    """通用过滤器

    """

    def __init__(self):
        r"""
        :param _Name: 过滤字段名称
        :type Name: str
        :param _Values: 过滤值列表
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Folder(AbstractModel):
    """文件夹信息

    """

    def __init__(self):
        r"""
        :param _Id: 文件ID
        :type Id: str
        :param _Name: 文件夹名称
        :type Name: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _ProjectId: 所属项目id
        :type ProjectId: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        """
        self._Id = None
        self._Name = None
        self._CreateTime = None
        self._ProjectId = None
        self._UpdateTime = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._CreateTime = params.get("CreateTime")
        self._ProjectId = params.get("ProjectId")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ForceSucInstancesRequest(AbstractModel):
    """ForceSucInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Instances: 实例嵌套集合
        :type Instances: list of InstanceInfo
        """
        self._ProjectId = None
        self._Instances = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ForceSucInstancesResponse(AbstractModel):
    """ForceSucInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回实例批量终止结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class FreezeTasksByMultiWorkflowRequest(AbstractModel):
    """FreezeTasksByMultiWorkflow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkFlowIds: 工作流Id集合
        :type WorkFlowIds: list of str
        """
        self._WorkFlowIds = None

    @property
    def WorkFlowIds(self):
        return self._WorkFlowIds

    @WorkFlowIds.setter
    def WorkFlowIds(self, WorkFlowIds):
        self._WorkFlowIds = WorkFlowIds


    def _deserialize(self, params):
        self._WorkFlowIds = params.get("WorkFlowIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreezeTasksByMultiWorkflowResponse(AbstractModel):
    """FreezeTasksByMultiWorkflow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class FreezeTasksRequest(AbstractModel):
    """FreezeTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Tasks: 任务列表
        :type Tasks: list of SimpleTaskInfo
        :param _OperateIsInform: 任务操作是否消息通知下游任务责任人
        :type OperateIsInform: bool
        """
        self._Tasks = None
        self._OperateIsInform = None

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def OperateIsInform(self):
        return self._OperateIsInform

    @OperateIsInform.setter
    def OperateIsInform(self, OperateIsInform):
        self._OperateIsInform = OperateIsInform


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = SimpleTaskInfo()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._OperateIsInform = params.get("OperateIsInform")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreezeTasksResponse(AbstractModel):
    """FreezeTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class FunctionResource(AbstractModel):
    """函数资源信息

    """

    def __init__(self):
        r"""
        :param _Path: 资源路径
注意：此字段可能返回 null，表示取不到有效值。
        :type Path: str
        :param _Name: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Id: 资源唯一标识
        :type Id: str
        :param _Md5: 资源 MD5 值
注意：此字段可能返回 null，表示取不到有效值。
        :type Md5: str
        :param _Type: 默认是 hdfs
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Path = None
        self._Name = None
        self._Id = None
        self._Md5 = None
        self._Type = None

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Path = params.get("Path")
        self._Name = params.get("Name")
        self._Id = params.get("Id")
        self._Md5 = params.get("Md5")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FunctionTypeOrKind(AbstractModel):
    """函数类型或函数分类

    """

    def __init__(self):
        r"""
        :param _Name: 无
        :type Name: str
        :param _ZhName: 无
        :type ZhName: str
        :param _EnName: 无
        :type EnName: str
        """
        self._Name = None
        self._ZhName = None
        self._EnName = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ZhName(self):
        return self._ZhName

    @ZhName.setter
    def ZhName(self, ZhName):
        self._ZhName = ZhName

    @property
    def EnName(self):
        return self._EnName

    @EnName.setter
    def EnName(self, EnName):
        self._EnName = EnName


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._ZhName = params.get("ZhName")
        self._EnName = params.get("EnName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FunctionVersion(AbstractModel):
    """函数提交版本信息

    """

    def __init__(self):
        r"""
        :param _Tag: 版本号：V0 V1 V2
        :type Tag: str
        :param _UserId: 提交人 ID
        :type UserId: str
        :param _Type: 变更类型：ADD、MODIFY
        :type Type: str
        :param _Comment: 备注
        :type Comment: str
        :param _Timestamp: 提交时间: UTC 秒数
        :type Timestamp: str
        :param _UserName: 提交人名称
注意：此字段可能返回 null，表示取不到有效值。
        :type UserName: str
        :param _Content: 版本内容：json string 格式
注意：此字段可能返回 null，表示取不到有效值。
        :type Content: str
        """
        self._Tag = None
        self._UserId = None
        self._Type = None
        self._Comment = None
        self._Timestamp = None
        self._UserName = None
        self._Content = None

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Timestamp(self):
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Tag = params.get("Tag")
        self._UserId = params.get("UserId")
        self._Type = params.get("Type")
        self._Comment = params.get("Comment")
        self._Timestamp = params.get("Timestamp")
        self._UserName = params.get("UserName")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenHiveTableDDLSqlRequest(AbstractModel):
    """GenHiveTableDDLSql请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _SinkDatabase: 目标数据库
        :type SinkDatabase: str
        :param _Id: 节点id
        :type Id: str
        :param _MsType: 元数据类型(MYSQL、ORACLE)
        :type MsType: str
        :param _DatasourceId: 数据源id
        :type DatasourceId: str
        :param _SourceDatabase: 来源库
        :type SourceDatabase: str
        :param _TableName: 来源表
        :type TableName: str
        :param _SinkType: 目标表元数据类型(HIVE、GBASE)
        :type SinkType: str
        :param _SchemaName: schema名称
        :type SchemaName: str
        :param _SourceFieldInfoList: 上游节点的字段信息
        :type SourceFieldInfoList: list of SourceFieldInfo
        :param _Partitions: 分区字段
        :type Partitions: list of Partition
        :param _Properties: 建表属性
        :type Properties: list of Property
        :param _TableMode: 建表模式，0:向导模式，1:ddl
        :type TableMode: int
        :param _TableVersion: DLC表版本，v1/v2
        :type TableVersion: str
        :param _UpsertFlag: 是否upsert写入
        :type UpsertFlag: bool
        :param _TableComment: 表描述信息
        :type TableComment: str
        :param _AddDataFiles: 增加的文件数量阈值, 超过值将触发小文件合并
        :type AddDataFiles: int
        :param _AddEqualityDeletes: 增加的Equality delete数量阈值, 超过值将触发小文件合并
        :type AddEqualityDeletes: int
        :param _AddPositionDeletes: 增加的Position delete数量阈值, 超过值将触发小文件合并
        :type AddPositionDeletes: int
        :param _AddDeleteFiles: 增加的delete file数量阈值
        :type AddDeleteFiles: int
        :param _TargetDatasourceId: 下游节点数据源ID
        :type TargetDatasourceId: str
        :param _UpsertKeys: dlc upsert主键
        :type UpsertKeys: list of str
        :param _TableBaseInfo: dlc表治理信息
        :type TableBaseInfo: :class:`tencentcloud.wedata.v20210820.models.TableBaseInfo`
        """
        self._ProjectId = None
        self._SinkDatabase = None
        self._Id = None
        self._MsType = None
        self._DatasourceId = None
        self._SourceDatabase = None
        self._TableName = None
        self._SinkType = None
        self._SchemaName = None
        self._SourceFieldInfoList = None
        self._Partitions = None
        self._Properties = None
        self._TableMode = None
        self._TableVersion = None
        self._UpsertFlag = None
        self._TableComment = None
        self._AddDataFiles = None
        self._AddEqualityDeletes = None
        self._AddPositionDeletes = None
        self._AddDeleteFiles = None
        self._TargetDatasourceId = None
        self._UpsertKeys = None
        self._TableBaseInfo = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SinkDatabase(self):
        return self._SinkDatabase

    @SinkDatabase.setter
    def SinkDatabase(self, SinkDatabase):
        self._SinkDatabase = SinkDatabase

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def MsType(self):
        return self._MsType

    @MsType.setter
    def MsType(self, MsType):
        self._MsType = MsType

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def SourceDatabase(self):
        return self._SourceDatabase

    @SourceDatabase.setter
    def SourceDatabase(self, SourceDatabase):
        self._SourceDatabase = SourceDatabase

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def SinkType(self):
        return self._SinkType

    @SinkType.setter
    def SinkType(self, SinkType):
        self._SinkType = SinkType

    @property
    def SchemaName(self):
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def SourceFieldInfoList(self):
        return self._SourceFieldInfoList

    @SourceFieldInfoList.setter
    def SourceFieldInfoList(self, SourceFieldInfoList):
        self._SourceFieldInfoList = SourceFieldInfoList

    @property
    def Partitions(self):
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Properties(self):
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def TableMode(self):
        return self._TableMode

    @TableMode.setter
    def TableMode(self, TableMode):
        self._TableMode = TableMode

    @property
    def TableVersion(self):
        return self._TableVersion

    @TableVersion.setter
    def TableVersion(self, TableVersion):
        self._TableVersion = TableVersion

    @property
    def UpsertFlag(self):
        return self._UpsertFlag

    @UpsertFlag.setter
    def UpsertFlag(self, UpsertFlag):
        self._UpsertFlag = UpsertFlag

    @property
    def TableComment(self):
        return self._TableComment

    @TableComment.setter
    def TableComment(self, TableComment):
        self._TableComment = TableComment

    @property
    def AddDataFiles(self):
        return self._AddDataFiles

    @AddDataFiles.setter
    def AddDataFiles(self, AddDataFiles):
        self._AddDataFiles = AddDataFiles

    @property
    def AddEqualityDeletes(self):
        return self._AddEqualityDeletes

    @AddEqualityDeletes.setter
    def AddEqualityDeletes(self, AddEqualityDeletes):
        self._AddEqualityDeletes = AddEqualityDeletes

    @property
    def AddPositionDeletes(self):
        return self._AddPositionDeletes

    @AddPositionDeletes.setter
    def AddPositionDeletes(self, AddPositionDeletes):
        self._AddPositionDeletes = AddPositionDeletes

    @property
    def AddDeleteFiles(self):
        return self._AddDeleteFiles

    @AddDeleteFiles.setter
    def AddDeleteFiles(self, AddDeleteFiles):
        self._AddDeleteFiles = AddDeleteFiles

    @property
    def TargetDatasourceId(self):
        return self._TargetDatasourceId

    @TargetDatasourceId.setter
    def TargetDatasourceId(self, TargetDatasourceId):
        self._TargetDatasourceId = TargetDatasourceId

    @property
    def UpsertKeys(self):
        return self._UpsertKeys

    @UpsertKeys.setter
    def UpsertKeys(self, UpsertKeys):
        self._UpsertKeys = UpsertKeys

    @property
    def TableBaseInfo(self):
        return self._TableBaseInfo

    @TableBaseInfo.setter
    def TableBaseInfo(self, TableBaseInfo):
        self._TableBaseInfo = TableBaseInfo


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._SinkDatabase = params.get("SinkDatabase")
        self._Id = params.get("Id")
        self._MsType = params.get("MsType")
        self._DatasourceId = params.get("DatasourceId")
        self._SourceDatabase = params.get("SourceDatabase")
        self._TableName = params.get("TableName")
        self._SinkType = params.get("SinkType")
        self._SchemaName = params.get("SchemaName")
        if params.get("SourceFieldInfoList") is not None:
            self._SourceFieldInfoList = []
            for item in params.get("SourceFieldInfoList"):
                obj = SourceFieldInfo()
                obj._deserialize(item)
                self._SourceFieldInfoList.append(obj)
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = Partition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        self._TableMode = params.get("TableMode")
        self._TableVersion = params.get("TableVersion")
        self._UpsertFlag = params.get("UpsertFlag")
        self._TableComment = params.get("TableComment")
        self._AddDataFiles = params.get("AddDataFiles")
        self._AddEqualityDeletes = params.get("AddEqualityDeletes")
        self._AddPositionDeletes = params.get("AddPositionDeletes")
        self._AddDeleteFiles = params.get("AddDeleteFiles")
        self._TargetDatasourceId = params.get("TargetDatasourceId")
        self._UpsertKeys = params.get("UpsertKeys")
        if params.get("TableBaseInfo") is not None:
            self._TableBaseInfo = TableBaseInfo()
            self._TableBaseInfo._deserialize(params.get("TableBaseInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenHiveTableDDLSqlResponse(AbstractModel):
    """GenHiveTableDDLSql返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DDLSql: 生成的ddl语句
        :type DDLSql: str
        :param _Data: 生成的ddl语句。与DDLSql相同含义，优先取Data，如果Data为空，则取DDLSql。
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DDLSql = None
        self._Data = None
        self._RequestId = None

    @property
    def DDLSql(self):
        return self._DDLSql

    @DDLSql.setter
    def DDLSql(self, DDLSql):
        self._DDLSql = DDLSql

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DDLSql = params.get("DDLSql")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class GeneralTaskParam(AbstractModel):
    """Spark SQL配置参数

    """

    def __init__(self):
        r"""
        :param _Type: 通用任务参数类型,例：SPARK_SQL
        :type Type: str
        :param _Value: 通用任务参数内容,直接作用于任务的参数。不同参数用;
分割
        :type Value: str
        """
        self._Type = None
        self._Value = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetIntegrationNodeColumnSchemaRequest(AbstractModel):
    """GetIntegrationNodeColumnSchema请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ColumnContent: 字段示例（json格式）
        :type ColumnContent: str
        :param _DatasourceType: 数据源类型
        :type DatasourceType: str
        """
        self._ColumnContent = None
        self._DatasourceType = None

    @property
    def ColumnContent(self):
        return self._ColumnContent

    @ColumnContent.setter
    def ColumnContent(self, ColumnContent):
        self._ColumnContent = ColumnContent

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType


    def _deserialize(self, params):
        self._ColumnContent = params.get("ColumnContent")
        self._DatasourceType = params.get("DatasourceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetIntegrationNodeColumnSchemaResponse(AbstractModel):
    """GetIntegrationNodeColumnSchema返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Schemas: 字段列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Schemas: list of IntegrationNodeSchema
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Schemas = None
        self._RequestId = None

    @property
    def Schemas(self):
        return self._Schemas

    @Schemas.setter
    def Schemas(self, Schemas):
        self._Schemas = Schemas

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Schemas") is not None:
            self._Schemas = []
            for item in params.get("Schemas"):
                obj = IntegrationNodeSchema()
                obj._deserialize(item)
                self._Schemas.append(obj)
        self._RequestId = params.get("RequestId")


class GetOfflineDIInstanceListRequest(AbstractModel):
    """GetOfflineDIInstanceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageIndex: 第几页
        :type PageIndex: int
        :param _PageSize: 每页几条
        :type PageSize: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _SearchCondition: 无
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.SearchConditionNew`
        """
        self._PageIndex = None
        self._PageSize = None
        self._ProjectId = None
        self._SearchCondition = None

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition


    def _deserialize(self, params):
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = SearchConditionNew()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetOfflineDIInstanceListResponse(AbstractModel):
    """GetOfflineDIInstanceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 总条数
        :type Total: int
        :param _List: 实例详情
        :type List: list of OfflineInstance
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = OfflineInstance()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class GetOfflineInstanceListRequest(AbstractModel):
    """GetOfflineInstanceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageIndex: 第几页
        :type PageIndex: str
        :param _PageSize: 每页几条
        :type PageSize: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _SearchCondition: 无
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.SearchCondition`
        """
        self._PageIndex = None
        self._PageSize = None
        self._ProjectId = None
        self._SearchCondition = None

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition


    def _deserialize(self, params):
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = SearchCondition()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetOfflineInstanceListResponse(AbstractModel):
    """GetOfflineInstanceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 总条数
        :type Total: int
        :param _List: 实例详情
        :type List: list of OfflineInstance
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = OfflineInstance()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class InLongAgentDetail(AbstractModel):
    """采集器详细信息

    """

    def __init__(self):
        r"""
        :param _AgentId: Agent ID
        :type AgentId: str
        :param _AgentName: Agent Name
        :type AgentName: str
        :param _Status: Agent状态(running运行中，initializing 操作中，failed心跳异常)
        :type Status: str
        :param _StatusDesc: Agent状态描述
注意：此字段可能返回 null，表示取不到有效值。
        :type StatusDesc: str
        :param _AgentType: 集群类型，1：TKE Agent，2：BOSS SDK，默认：1
        :type AgentType: int
        :param _Source: 采集来源
        :type Source: str
        :param _VpcId: VPC
        :type VpcId: str
        :param _ExecutorGroupId: 集成资源组Id
        :type ExecutorGroupId: str
        :param _ExecutorGroupName: 集成资源组名称
        :type ExecutorGroupName: str
        :param _TaskCount: 关联任务数
        :type TaskCount: int
        :param _AgentGroupId: 采集器组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentGroupId: str
        :param _CvmAgentStatusList: agent状态统计
注意：此字段可能返回 null，表示取不到有效值。
        :type CvmAgentStatusList: list of CvmAgentStatus
        :param _AgentTotal: agent数量
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentTotal: int
        :param _LifeDays: 生命周期
注意：此字段可能返回 null，表示取不到有效值。
        :type LifeDays: int
        """
        self._AgentId = None
        self._AgentName = None
        self._Status = None
        self._StatusDesc = None
        self._AgentType = None
        self._Source = None
        self._VpcId = None
        self._ExecutorGroupId = None
        self._ExecutorGroupName = None
        self._TaskCount = None
        self._AgentGroupId = None
        self._CvmAgentStatusList = None
        self._AgentTotal = None
        self._LifeDays = None

    @property
    def AgentId(self):
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def AgentName(self):
        return self._AgentName

    @AgentName.setter
    def AgentName(self, AgentName):
        self._AgentName = AgentName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StatusDesc(self):
        return self._StatusDesc

    @StatusDesc.setter
    def StatusDesc(self, StatusDesc):
        self._StatusDesc = StatusDesc

    @property
    def AgentType(self):
        return self._AgentType

    @AgentType.setter
    def AgentType(self, AgentType):
        self._AgentType = AgentType

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId

    @property
    def ExecutorGroupName(self):
        return self._ExecutorGroupName

    @ExecutorGroupName.setter
    def ExecutorGroupName(self, ExecutorGroupName):
        self._ExecutorGroupName = ExecutorGroupName

    @property
    def TaskCount(self):
        return self._TaskCount

    @TaskCount.setter
    def TaskCount(self, TaskCount):
        self._TaskCount = TaskCount

    @property
    def AgentGroupId(self):
        return self._AgentGroupId

    @AgentGroupId.setter
    def AgentGroupId(self, AgentGroupId):
        self._AgentGroupId = AgentGroupId

    @property
    def CvmAgentStatusList(self):
        return self._CvmAgentStatusList

    @CvmAgentStatusList.setter
    def CvmAgentStatusList(self, CvmAgentStatusList):
        self._CvmAgentStatusList = CvmAgentStatusList

    @property
    def AgentTotal(self):
        return self._AgentTotal

    @AgentTotal.setter
    def AgentTotal(self, AgentTotal):
        self._AgentTotal = AgentTotal

    @property
    def LifeDays(self):
        return self._LifeDays

    @LifeDays.setter
    def LifeDays(self, LifeDays):
        self._LifeDays = LifeDays


    def _deserialize(self, params):
        self._AgentId = params.get("AgentId")
        self._AgentName = params.get("AgentName")
        self._Status = params.get("Status")
        self._StatusDesc = params.get("StatusDesc")
        self._AgentType = params.get("AgentType")
        self._Source = params.get("Source")
        self._VpcId = params.get("VpcId")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        self._ExecutorGroupName = params.get("ExecutorGroupName")
        self._TaskCount = params.get("TaskCount")
        self._AgentGroupId = params.get("AgentGroupId")
        if params.get("CvmAgentStatusList") is not None:
            self._CvmAgentStatusList = []
            for item in params.get("CvmAgentStatusList"):
                obj = CvmAgentStatus()
                obj._deserialize(item)
                self._CvmAgentStatusList.append(obj)
        self._AgentTotal = params.get("AgentTotal")
        self._LifeDays = params.get("LifeDays")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InLongAgentTask(AbstractModel):
    """采集器关联的集成任务

    """

    def __init__(self):
        r"""
        :param _TaskId: 集成任务ID
        :type TaskId: str
        :param _TaskName: 集成任务名称
        :type TaskName: str
        :param _TaskStatus: 集成任务状态
        :type TaskStatus: str
        """
        self._TaskId = None
        self._TaskName = None
        self._TaskStatus = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._TaskStatus = params.get("TaskStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InLongTkeDetail(AbstractModel):
    """TKE集群信息详情

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _Status: TKE集群状态 (Running 运行中 Creating 创建中 Idling 闲置中 Abnormal 异常)
        :type Status: str
        :param _HasAgent: 是否安装Agent，true: 是，false: 否
        :type HasAgent: bool
        :param _AgentId: 采集器ID
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentId: str
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _TkeRegion: TKE集群区域ID
        :type TkeRegion: str
        :param _ClusterType: 集群类型，托管集群：MANAGED_CLUSTER，独立集群：INDEPENDENT_CLUSTER
        :type ClusterType: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._Status = None
        self._HasAgent = None
        self._AgentId = None
        self._VpcId = None
        self._TkeRegion = None
        self._ClusterType = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def HasAgent(self):
        return self._HasAgent

    @HasAgent.setter
    def HasAgent(self, HasAgent):
        self._HasAgent = HasAgent

    @property
    def AgentId(self):
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def TkeRegion(self):
        return self._TkeRegion

    @TkeRegion.setter
    def TkeRegion(self, TkeRegion):
        self._TkeRegion = TkeRegion

    @property
    def ClusterType(self):
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._Status = params.get("Status")
        self._HasAgent = params.get("HasAgent")
        self._AgentId = params.get("AgentId")
        self._VpcId = params.get("VpcId")
        self._TkeRegion = params.get("TkeRegion")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceInfo(AbstractModel):
    """实例请求实体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceList(AbstractModel):
    """离线运维实例列表

    """

    def __init__(self):
        r"""
        :param _CostTime: 耗费时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CostTime: str
        :param _CurRunDate: 数据时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CurRunDate: str
        :param _CycleType: 周期类型
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleType: str
        :param _DoFlag: 是否补录
注意：此字段可能返回 null，表示取不到有效值。
        :type DoFlag: int
        :param _InCharge: 责任人
注意：此字段可能返回 null，表示取不到有效值。
        :type InCharge: str
        :param _LastLog: 日志
注意：此字段可能返回 null，表示取不到有效值。
        :type LastLog: str
        :param _SchedulerDesc: 调度计划
注意：此字段可能返回 null，表示取不到有效值。
        :type SchedulerDesc: str
        :param _StartTime: 开始启动时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _State: 实例状态
注意：此字段可能返回 null，表示取不到有效值。
        :type State: str
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _TaskName: 任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _TryLimit: 尝试运行次数
注意：此字段可能返回 null，表示取不到有效值。
        :type TryLimit: int
        """
        self._CostTime = None
        self._CurRunDate = None
        self._CycleType = None
        self._DoFlag = None
        self._InCharge = None
        self._LastLog = None
        self._SchedulerDesc = None
        self._StartTime = None
        self._State = None
        self._TaskId = None
        self._TaskName = None
        self._TryLimit = None

    @property
    def CostTime(self):
        return self._CostTime

    @CostTime.setter
    def CostTime(self, CostTime):
        self._CostTime = CostTime

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def CycleType(self):
        return self._CycleType

    @CycleType.setter
    def CycleType(self, CycleType):
        self._CycleType = CycleType

    @property
    def DoFlag(self):
        return self._DoFlag

    @DoFlag.setter
    def DoFlag(self, DoFlag):
        self._DoFlag = DoFlag

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def LastLog(self):
        return self._LastLog

    @LastLog.setter
    def LastLog(self, LastLog):
        self._LastLog = LastLog

    @property
    def SchedulerDesc(self):
        return self._SchedulerDesc

    @SchedulerDesc.setter
    def SchedulerDesc(self, SchedulerDesc):
        self._SchedulerDesc = SchedulerDesc

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TryLimit(self):
        return self._TryLimit

    @TryLimit.setter
    def TryLimit(self, TryLimit):
        self._TryLimit = TryLimit


    def _deserialize(self, params):
        self._CostTime = params.get("CostTime")
        self._CurRunDate = params.get("CurRunDate")
        self._CycleType = params.get("CycleType")
        self._DoFlag = params.get("DoFlag")
        self._InCharge = params.get("InCharge")
        self._LastLog = params.get("LastLog")
        self._SchedulerDesc = params.get("SchedulerDesc")
        self._StartTime = params.get("StartTime")
        self._State = params.get("State")
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._TryLimit = params.get("TryLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceLog(AbstractModel):
    """实例日志实体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        :param _Tries: 尝试运行次数
注意：此字段可能返回 null，表示取不到有效值。
        :type Tries: str
        :param _LastUpdate: 日志更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastUpdate: str
        :param _BrokerIp: 日志所在节点
        :type BrokerIp: str
        :param _OriginFileName: 文件名  含全路径
        :type OriginFileName: str
        :param _CreateTime: 日志创建时间
        :type CreateTime: str
        :param _InstanceLogType: 实例日志类型, run: 运行; kill: 终止
        :type InstanceLogType: str
        :param _CostTime: 运行耗时
        :type CostTime: float
        """
        self._TaskId = None
        self._CurRunDate = None
        self._Tries = None
        self._LastUpdate = None
        self._BrokerIp = None
        self._OriginFileName = None
        self._CreateTime = None
        self._InstanceLogType = None
        self._CostTime = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def Tries(self):
        return self._Tries

    @Tries.setter
    def Tries(self, Tries):
        self._Tries = Tries

    @property
    def LastUpdate(self):
        return self._LastUpdate

    @LastUpdate.setter
    def LastUpdate(self, LastUpdate):
        self._LastUpdate = LastUpdate

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def OriginFileName(self):
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def InstanceLogType(self):
        return self._InstanceLogType

    @InstanceLogType.setter
    def InstanceLogType(self, InstanceLogType):
        self._InstanceLogType = InstanceLogType

    @property
    def CostTime(self):
        return self._CostTime

    @CostTime.setter
    def CostTime(self, CostTime):
        self._CostTime = CostTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._Tries = params.get("Tries")
        self._LastUpdate = params.get("LastUpdate")
        self._BrokerIp = params.get("BrokerIp")
        self._OriginFileName = params.get("OriginFileName")
        self._CreateTime = params.get("CreateTime")
        self._InstanceLogType = params.get("InstanceLogType")
        self._CostTime = params.get("CostTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceLogList(AbstractModel):
    """实例日志信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _CurRunDate: 数据时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CurRunDate: str
        :param _Tries: 重试次数
注意：此字段可能返回 null，表示取不到有效值。
        :type Tries: str
        :param _LastUpdate: 最后更新事件
注意：此字段可能返回 null，表示取不到有效值。
        :type LastUpdate: str
        :param _BrokerIp: 节点ip
注意：此字段可能返回 null，表示取不到有效值。
        :type BrokerIp: str
        :param _FileSize: 文件大小
注意：此字段可能返回 null，表示取不到有效值。
        :type FileSize: str
        :param _OriginFileName: 原始文件名
注意：此字段可能返回 null，表示取不到有效值。
        :type OriginFileName: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _InstanceLogType: 实例日志类型
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceLogType: str
        :param _TaskName: 任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _CostTime: 耗费时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CostTime: str
        """
        self._TaskId = None
        self._CurRunDate = None
        self._Tries = None
        self._LastUpdate = None
        self._BrokerIp = None
        self._FileSize = None
        self._OriginFileName = None
        self._CreateTime = None
        self._InstanceLogType = None
        self._TaskName = None
        self._CostTime = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def Tries(self):
        return self._Tries

    @Tries.setter
    def Tries(self, Tries):
        self._Tries = Tries

    @property
    def LastUpdate(self):
        return self._LastUpdate

    @LastUpdate.setter
    def LastUpdate(self, LastUpdate):
        self._LastUpdate = LastUpdate

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def FileSize(self):
        return self._FileSize

    @FileSize.setter
    def FileSize(self, FileSize):
        self._FileSize = FileSize

    @property
    def OriginFileName(self):
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def InstanceLogType(self):
        return self._InstanceLogType

    @InstanceLogType.setter
    def InstanceLogType(self, InstanceLogType):
        self._InstanceLogType = InstanceLogType

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def CostTime(self):
        return self._CostTime

    @CostTime.setter
    def CostTime(self, CostTime):
        self._CostTime = CostTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._Tries = params.get("Tries")
        self._LastUpdate = params.get("LastUpdate")
        self._BrokerIp = params.get("BrokerIp")
        self._FileSize = params.get("FileSize")
        self._OriginFileName = params.get("OriginFileName")
        self._CreateTime = params.get("CreateTime")
        self._InstanceLogType = params.get("InstanceLogType")
        self._TaskName = params.get("TaskName")
        self._CostTime = params.get("CostTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceNodeInfo(AbstractModel):
    """查询实时任务实例当前的节点信息

    """

    def __init__(self):
        r"""
        :param _NodeType: 读取节点SOURCE 写入节点SINK
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeType: str
        :param _NodeId: 节点id
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeId: str
        :param _NodeName: 节点名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeName: str
        """
        self._NodeType = None
        self._NodeId = None
        self._NodeName = None

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeId(self):
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName


    def _deserialize(self, params):
        self._NodeType = params.get("NodeType")
        self._NodeId = params.get("NodeId")
        self._NodeName = params.get("NodeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceReportReadNode(AbstractModel):
    """离线任务实例读取节点的运行指标

    """

    def __init__(self):
        r"""
        :param _NodeName: 节点名称
        :type NodeName: str
        :param _DataSource: 数据来源
        :type DataSource: str
        :param _TotalReadRecords: 总条数
        :type TotalReadRecords: int
        :param _TotalReadBytes: 总字节数
        :type TotalReadBytes: int
        :param _RecordSpeed: 速度（条/秒）
        :type RecordSpeed: int
        :param _ByteSpeed: 吞吐（Byte/秒）
        :type ByteSpeed: float
        :param _TotalErrorRecords: 脏数据条数
        :type TotalErrorRecords: int
        """
        self._NodeName = None
        self._DataSource = None
        self._TotalReadRecords = None
        self._TotalReadBytes = None
        self._RecordSpeed = None
        self._ByteSpeed = None
        self._TotalErrorRecords = None

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def DataSource(self):
        return self._DataSource

    @DataSource.setter
    def DataSource(self, DataSource):
        self._DataSource = DataSource

    @property
    def TotalReadRecords(self):
        return self._TotalReadRecords

    @TotalReadRecords.setter
    def TotalReadRecords(self, TotalReadRecords):
        self._TotalReadRecords = TotalReadRecords

    @property
    def TotalReadBytes(self):
        return self._TotalReadBytes

    @TotalReadBytes.setter
    def TotalReadBytes(self, TotalReadBytes):
        self._TotalReadBytes = TotalReadBytes

    @property
    def RecordSpeed(self):
        return self._RecordSpeed

    @RecordSpeed.setter
    def RecordSpeed(self, RecordSpeed):
        self._RecordSpeed = RecordSpeed

    @property
    def ByteSpeed(self):
        return self._ByteSpeed

    @ByteSpeed.setter
    def ByteSpeed(self, ByteSpeed):
        self._ByteSpeed = ByteSpeed

    @property
    def TotalErrorRecords(self):
        return self._TotalErrorRecords

    @TotalErrorRecords.setter
    def TotalErrorRecords(self, TotalErrorRecords):
        self._TotalErrorRecords = TotalErrorRecords


    def _deserialize(self, params):
        self._NodeName = params.get("NodeName")
        self._DataSource = params.get("DataSource")
        self._TotalReadRecords = params.get("TotalReadRecords")
        self._TotalReadBytes = params.get("TotalReadBytes")
        self._RecordSpeed = params.get("RecordSpeed")
        self._ByteSpeed = params.get("ByteSpeed")
        self._TotalErrorRecords = params.get("TotalErrorRecords")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceReportSummary(AbstractModel):
    """离线任务实例运行指标概览

    """

    def __init__(self):
        r"""
        :param _TotalReadRecords: 总读取记录数
        :type TotalReadRecords: int
        :param _TotalReadBytes: 总读取字节数
        :type TotalReadBytes: int
        :param _TotalWriteRecords: 总写入记录数
        :type TotalWriteRecords: int
        :param _TotalWriteBytes: 总写入字节数
        :type TotalWriteBytes: int
        :param _RecordSpeed: 速率（条/秒）
        :type RecordSpeed: int
        :param _ByteSpeed: 流量（Byte/秒）
        :type ByteSpeed: float
        :param _TotalErrorRecords: 脏数据记录数
        :type TotalErrorRecords: int
        :param _TotalErrorBytes: 脏数据字节数
        :type TotalErrorBytes: int
        :param _TotalRunDuration: 任务运行总时长
        :type TotalRunDuration: int
        :param _BeginRunTime: 任务开始运行时间
        :type BeginRunTime: str
        :param _EndRunTime: 任务结束运行时间
        :type EndRunTime: str
        """
        self._TotalReadRecords = None
        self._TotalReadBytes = None
        self._TotalWriteRecords = None
        self._TotalWriteBytes = None
        self._RecordSpeed = None
        self._ByteSpeed = None
        self._TotalErrorRecords = None
        self._TotalErrorBytes = None
        self._TotalRunDuration = None
        self._BeginRunTime = None
        self._EndRunTime = None

    @property
    def TotalReadRecords(self):
        return self._TotalReadRecords

    @TotalReadRecords.setter
    def TotalReadRecords(self, TotalReadRecords):
        self._TotalReadRecords = TotalReadRecords

    @property
    def TotalReadBytes(self):
        return self._TotalReadBytes

    @TotalReadBytes.setter
    def TotalReadBytes(self, TotalReadBytes):
        self._TotalReadBytes = TotalReadBytes

    @property
    def TotalWriteRecords(self):
        return self._TotalWriteRecords

    @TotalWriteRecords.setter
    def TotalWriteRecords(self, TotalWriteRecords):
        self._TotalWriteRecords = TotalWriteRecords

    @property
    def TotalWriteBytes(self):
        return self._TotalWriteBytes

    @TotalWriteBytes.setter
    def TotalWriteBytes(self, TotalWriteBytes):
        self._TotalWriteBytes = TotalWriteBytes

    @property
    def RecordSpeed(self):
        return self._RecordSpeed

    @RecordSpeed.setter
    def RecordSpeed(self, RecordSpeed):
        self._RecordSpeed = RecordSpeed

    @property
    def ByteSpeed(self):
        return self._ByteSpeed

    @ByteSpeed.setter
    def ByteSpeed(self, ByteSpeed):
        self._ByteSpeed = ByteSpeed

    @property
    def TotalErrorRecords(self):
        return self._TotalErrorRecords

    @TotalErrorRecords.setter
    def TotalErrorRecords(self, TotalErrorRecords):
        self._TotalErrorRecords = TotalErrorRecords

    @property
    def TotalErrorBytes(self):
        return self._TotalErrorBytes

    @TotalErrorBytes.setter
    def TotalErrorBytes(self, TotalErrorBytes):
        self._TotalErrorBytes = TotalErrorBytes

    @property
    def TotalRunDuration(self):
        return self._TotalRunDuration

    @TotalRunDuration.setter
    def TotalRunDuration(self, TotalRunDuration):
        self._TotalRunDuration = TotalRunDuration

    @property
    def BeginRunTime(self):
        return self._BeginRunTime

    @BeginRunTime.setter
    def BeginRunTime(self, BeginRunTime):
        self._BeginRunTime = BeginRunTime

    @property
    def EndRunTime(self):
        return self._EndRunTime

    @EndRunTime.setter
    def EndRunTime(self, EndRunTime):
        self._EndRunTime = EndRunTime


    def _deserialize(self, params):
        self._TotalReadRecords = params.get("TotalReadRecords")
        self._TotalReadBytes = params.get("TotalReadBytes")
        self._TotalWriteRecords = params.get("TotalWriteRecords")
        self._TotalWriteBytes = params.get("TotalWriteBytes")
        self._RecordSpeed = params.get("RecordSpeed")
        self._ByteSpeed = params.get("ByteSpeed")
        self._TotalErrorRecords = params.get("TotalErrorRecords")
        self._TotalErrorBytes = params.get("TotalErrorBytes")
        self._TotalRunDuration = params.get("TotalRunDuration")
        self._BeginRunTime = params.get("BeginRunTime")
        self._EndRunTime = params.get("EndRunTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceReportWriteNode(AbstractModel):
    """离线任务实例写入节点的运行指标

    """

    def __init__(self):
        r"""
        :param _NodeName: 节点名称
        :type NodeName: str
        :param _DataSource: 数据来源
        :type DataSource: str
        :param _TotalWriteRecords: 总条数
        :type TotalWriteRecords: int
        :param _TotalWriteBytes: 总字节数
        :type TotalWriteBytes: int
        :param _RecordSpeed: 速度（条/秒）
        :type RecordSpeed: int
        :param _ByteSpeed: 吞吐（Byte/秒）
        :type ByteSpeed: float
        :param _TotalErrorRecords: 脏数据条数
        :type TotalErrorRecords: int
        """
        self._NodeName = None
        self._DataSource = None
        self._TotalWriteRecords = None
        self._TotalWriteBytes = None
        self._RecordSpeed = None
        self._ByteSpeed = None
        self._TotalErrorRecords = None

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def DataSource(self):
        return self._DataSource

    @DataSource.setter
    def DataSource(self, DataSource):
        self._DataSource = DataSource

    @property
    def TotalWriteRecords(self):
        return self._TotalWriteRecords

    @TotalWriteRecords.setter
    def TotalWriteRecords(self, TotalWriteRecords):
        self._TotalWriteRecords = TotalWriteRecords

    @property
    def TotalWriteBytes(self):
        return self._TotalWriteBytes

    @TotalWriteBytes.setter
    def TotalWriteBytes(self, TotalWriteBytes):
        self._TotalWriteBytes = TotalWriteBytes

    @property
    def RecordSpeed(self):
        return self._RecordSpeed

    @RecordSpeed.setter
    def RecordSpeed(self, RecordSpeed):
        self._RecordSpeed = RecordSpeed

    @property
    def ByteSpeed(self):
        return self._ByteSpeed

    @ByteSpeed.setter
    def ByteSpeed(self, ByteSpeed):
        self._ByteSpeed = ByteSpeed

    @property
    def TotalErrorRecords(self):
        return self._TotalErrorRecords

    @TotalErrorRecords.setter
    def TotalErrorRecords(self, TotalErrorRecords):
        self._TotalErrorRecords = TotalErrorRecords


    def _deserialize(self, params):
        self._NodeName = params.get("NodeName")
        self._DataSource = params.get("DataSource")
        self._TotalWriteRecords = params.get("TotalWriteRecords")
        self._TotalWriteBytes = params.get("TotalWriteBytes")
        self._RecordSpeed = params.get("RecordSpeed")
        self._ByteSpeed = params.get("ByteSpeed")
        self._TotalErrorRecords = params.get("TotalErrorRecords")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IntegrationInstanceLog(AbstractModel):
    """实例日志信息

    """

    def __init__(self):
        r"""
        :param _LogInfo: 任务日志信息
注意：此字段可能返回 null，表示取不到有效值。
        :type LogInfo: str
        """
        self._LogInfo = None

    @property
    def LogInfo(self):
        return self._LogInfo

    @LogInfo.setter
    def LogInfo(self, LogInfo):
        self._LogInfo = LogInfo


    def _deserialize(self, params):
        self._LogInfo = params.get("LogInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IntegrationNodeDetail(AbstractModel):
    """集成节点详情

    """

    def __init__(self):
        r"""
        :param _Name: 集成节点名称
        :type Name: str
        :param _NodeType: 集成节点类型
        :type NodeType: str
        :param _DataSourceType: 节点数据源类型
        :type DataSourceType: str
        :param _Description: 节点描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _DatasourceId: 数据源id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _Config: 节点配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Config: list of RecordField
        :param _ExtConfig: 节点扩展配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtConfig: list of RecordField
        :param _Schema: 节点schema
注意：此字段可能返回 null，表示取不到有效值。
        :type Schema: list of IntegrationNodeSchema
        :param _NodeMapping: 节点映射
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeMapping: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeMapping`
        :param _OwnerUin: owner uin
        :type OwnerUin: str
        """
        self._Name = None
        self._NodeType = None
        self._DataSourceType = None
        self._Description = None
        self._DatasourceId = None
        self._Config = None
        self._ExtConfig = None
        self._Schema = None
        self._NodeMapping = None
        self._OwnerUin = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def DataSourceType(self):
        return self._DataSourceType

    @DataSourceType.setter
    def DataSourceType(self, DataSourceType):
        self._DataSourceType = DataSourceType

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Config(self):
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def ExtConfig(self):
        return self._ExtConfig

    @ExtConfig.setter
    def ExtConfig(self, ExtConfig):
        self._ExtConfig = ExtConfig

    @property
    def Schema(self):
        return self._Schema

    @Schema.setter
    def Schema(self, Schema):
        self._Schema = Schema

    @property
    def NodeMapping(self):
        return self._NodeMapping

    @NodeMapping.setter
    def NodeMapping(self, NodeMapping):
        self._NodeMapping = NodeMapping

    @property
    def OwnerUin(self):
        return self._OwnerUin

    @OwnerUin.setter
    def OwnerUin(self, OwnerUin):
        self._OwnerUin = OwnerUin


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._NodeType = params.get("NodeType")
        self._DataSourceType = params.get("DataSourceType")
        self._Description = params.get("Description")
        self._DatasourceId = params.get("DatasourceId")
        if params.get("Config") is not None:
            self._Config = []
            for item in params.get("Config"):
                obj = RecordField()
                obj._deserialize(item)
                self._Config.append(obj)
        if params.get("ExtConfig") is not None:
            self._ExtConfig = []
            for item in params.get("ExtConfig"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtConfig.append(obj)
        if params.get("Schema") is not None:
            self._Schema = []
            for item in params.get("Schema"):
                obj = IntegrationNodeSchema()
                obj._deserialize(item)
                self._Schema.append(obj)
        if params.get("NodeMapping") is not None:
            self._NodeMapping = IntegrationNodeMapping()
            self._NodeMapping._deserialize(params.get("NodeMapping"))
        self._OwnerUin = params.get("OwnerUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IntegrationNodeInfo(AbstractModel):
    """集成节点

    """

    def __init__(self):
        r"""
        :param _Id: 集成节点id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _TaskId: 集成节点所属任务id
        :type TaskId: str
        :param _Name: 集成节点名称
        :type Name: str
        :param _NodeType: 集成节点类型
        :type NodeType: str
        :param _DataSourceType: 节点数据源类型
        :type DataSourceType: str
        :param _Description: 节点描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _DatasourceId: 数据源id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _Config: 节点配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Config: list of RecordField
        :param _ExtConfig: 节点扩展配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtConfig: list of RecordField
        :param _Schema: 节点schema
注意：此字段可能返回 null，表示取不到有效值。
        :type Schema: list of IntegrationNodeSchema
        :param _NodeMapping: 节点映射
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeMapping: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeMapping`
        :param _AppId: 应用id
        :type AppId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _CreatorUin: 创建人uin
注意：此字段可能返回 null，表示取不到有效值。
        :type CreatorUin: str
        :param _OperatorUin: 操作人uin
注意：此字段可能返回 null，表示取不到有效值。
        :type OperatorUin: str
        :param _OwnerUin: owner uin
        :type OwnerUin: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        """
        self._Id = None
        self._TaskId = None
        self._Name = None
        self._NodeType = None
        self._DataSourceType = None
        self._Description = None
        self._DatasourceId = None
        self._Config = None
        self._ExtConfig = None
        self._Schema = None
        self._NodeMapping = None
        self._AppId = None
        self._ProjectId = None
        self._CreatorUin = None
        self._OperatorUin = None
        self._OwnerUin = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def DataSourceType(self):
        return self._DataSourceType

    @DataSourceType.setter
    def DataSourceType(self, DataSourceType):
        self._DataSourceType = DataSourceType

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Config(self):
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def ExtConfig(self):
        return self._ExtConfig

    @ExtConfig.setter
    def ExtConfig(self, ExtConfig):
        self._ExtConfig = ExtConfig

    @property
    def Schema(self):
        return self._Schema

    @Schema.setter
    def Schema(self, Schema):
        self._Schema = Schema

    @property
    def NodeMapping(self):
        return self._NodeMapping

    @NodeMapping.setter
    def NodeMapping(self, NodeMapping):
        self._NodeMapping = NodeMapping

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CreatorUin(self):
        return self._CreatorUin

    @CreatorUin.setter
    def CreatorUin(self, CreatorUin):
        self._CreatorUin = CreatorUin

    @property
    def OperatorUin(self):
        return self._OperatorUin

    @OperatorUin.setter
    def OperatorUin(self, OperatorUin):
        self._OperatorUin = OperatorUin

    @property
    def OwnerUin(self):
        return self._OwnerUin

    @OwnerUin.setter
    def OwnerUin(self, OwnerUin):
        self._OwnerUin = OwnerUin

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._TaskId = params.get("TaskId")
        self._Name = params.get("Name")
        self._NodeType = params.get("NodeType")
        self._DataSourceType = params.get("DataSourceType")
        self._Description = params.get("Description")
        self._DatasourceId = params.get("DatasourceId")
        if params.get("Config") is not None:
            self._Config = []
            for item in params.get("Config"):
                obj = RecordField()
                obj._deserialize(item)
                self._Config.append(obj)
        if params.get("ExtConfig") is not None:
            self._ExtConfig = []
            for item in params.get("ExtConfig"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtConfig.append(obj)
        if params.get("Schema") is not None:
            self._Schema = []
            for item in params.get("Schema"):
                obj = IntegrationNodeSchema()
                obj._deserialize(item)
                self._Schema.append(obj)
        if params.get("NodeMapping") is not None:
            self._NodeMapping = IntegrationNodeMapping()
            self._NodeMapping._deserialize(params.get("NodeMapping"))
        self._AppId = params.get("AppId")
        self._ProjectId = params.get("ProjectId")
        self._CreatorUin = params.get("CreatorUin")
        self._OperatorUin = params.get("OperatorUin")
        self._OwnerUin = params.get("OwnerUin")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IntegrationNodeMapping(AbstractModel):
    """集成节点映射

    """

    def __init__(self):
        r"""
        :param _SourceId: 源节点id
        :type SourceId: str
        :param _SinkId: 目标节点id
        :type SinkId: str
        :param _SourceSchema: 源节点schema
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceSchema: list of IntegrationNodeSchema
        :param _SchemaMappings: 节点schema映射
注意：此字段可能返回 null，表示取不到有效值。
        :type SchemaMappings: list of IntegrationNodeSchemaMapping
        :param _ExtConfig: 节点映射扩展信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtConfig: list of RecordField
        """
        self._SourceId = None
        self._SinkId = None
        self._SourceSchema = None
        self._SchemaMappings = None
        self._ExtConfig = None

    @property
    def SourceId(self):
        return self._SourceId

    @SourceId.setter
    def SourceId(self, SourceId):
        self._SourceId = SourceId

    @property
    def SinkId(self):
        return self._SinkId

    @SinkId.setter
    def SinkId(self, SinkId):
        self._SinkId = SinkId

    @property
    def SourceSchema(self):
        return self._SourceSchema

    @SourceSchema.setter
    def SourceSchema(self, SourceSchema):
        self._SourceSchema = SourceSchema

    @property
    def SchemaMappings(self):
        return self._SchemaMappings

    @SchemaMappings.setter
    def SchemaMappings(self, SchemaMappings):
        self._SchemaMappings = SchemaMappings

    @property
    def ExtConfig(self):
        return self._ExtConfig

    @ExtConfig.setter
    def ExtConfig(self, ExtConfig):
        self._ExtConfig = ExtConfig


    def _deserialize(self, params):
        self._SourceId = params.get("SourceId")
        self._SinkId = params.get("SinkId")
        if params.get("SourceSchema") is not None:
            self._SourceSchema = []
            for item in params.get("SourceSchema"):
                obj = IntegrationNodeSchema()
                obj._deserialize(item)
                self._SourceSchema.append(obj)
        if params.get("SchemaMappings") is not None:
            self._SchemaMappings = []
            for item in params.get("SchemaMappings"):
                obj = IntegrationNodeSchemaMapping()
                obj._deserialize(item)
                self._SchemaMappings.append(obj)
        if params.get("ExtConfig") is not None:
            self._ExtConfig = []
            for item in params.get("ExtConfig"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtConfig.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IntegrationNodeSchema(AbstractModel):
    """集成节点schema

    """

    def __init__(self):
        r"""
        :param _Id: schema id
        :type Id: str
        :param _Name: schema名称
        :type Name: str
        :param _Type: schema类型
        :type Type: str
        :param _Value: schema值
注意：此字段可能返回 null，表示取不到有效值。
        :type Value: str
        :param _Properties: schema拓展属性
注意：此字段可能返回 null，表示取不到有效值。
        :type Properties: list of RecordField
        :param _Alias: schema别名
注意：此字段可能返回 null，表示取不到有效值。
        :type Alias: str
        """
        self._Id = None
        self._Name = None
        self._Type = None
        self._Value = None
        self._Properties = None
        self._Alias = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Properties(self):
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def Alias(self):
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Value = params.get("Value")
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = RecordField()
                obj._deserialize(item)
                self._Properties.append(obj)
        self._Alias = params.get("Alias")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IntegrationNodeSchemaMapping(AbstractModel):
    """集成节点schema映射

    """

    def __init__(self):
        r"""
        :param _SourceSchemaId: 源schema id
        :type SourceSchemaId: str
        :param _SinkSchemaId: 目标schema id
        :type SinkSchemaId: str
        """
        self._SourceSchemaId = None
        self._SinkSchemaId = None

    @property
    def SourceSchemaId(self):
        return self._SourceSchemaId

    @SourceSchemaId.setter
    def SourceSchemaId(self, SourceSchemaId):
        self._SourceSchemaId = SourceSchemaId

    @property
    def SinkSchemaId(self):
        return self._SinkSchemaId

    @SinkSchemaId.setter
    def SinkSchemaId(self, SinkSchemaId):
        self._SinkSchemaId = SinkSchemaId


    def _deserialize(self, params):
        self._SourceSchemaId = params.get("SourceSchemaId")
        self._SinkSchemaId = params.get("SinkSchemaId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IntegrationStatisticsTrendResult(AbstractModel):
    """数据集成大屏趋势图统计结果

    """

    def __init__(self):
        r"""
        :param _StatisticName: 统计属性名称
注意：此字段可能返回 null，表示取不到有效值。
        :type StatisticName: list of str
        :param _StatisticValue: 统计值
注意：此字段可能返回 null，表示取不到有效值。
        :type StatisticValue: list of int
        :param _StatisticType: 统计项目
注意：此字段可能返回 null，表示取不到有效值。
        :type StatisticType: str
        """
        self._StatisticName = None
        self._StatisticValue = None
        self._StatisticType = None

    @property
    def StatisticName(self):
        return self._StatisticName

    @StatisticName.setter
    def StatisticName(self, StatisticName):
        self._StatisticName = StatisticName

    @property
    def StatisticValue(self):
        return self._StatisticValue

    @StatisticValue.setter
    def StatisticValue(self, StatisticValue):
        self._StatisticValue = StatisticValue

    @property
    def StatisticType(self):
        return self._StatisticType

    @StatisticType.setter
    def StatisticType(self, StatisticType):
        self._StatisticType = StatisticType


    def _deserialize(self, params):
        self._StatisticName = params.get("StatisticName")
        self._StatisticValue = params.get("StatisticValue")
        self._StatisticType = params.get("StatisticType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IntegrationTaskInfo(AbstractModel):
    """集成任务

    """

    def __init__(self):
        r"""
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _Description: 任务描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _SyncType: 同步类型1.解决方案(整库迁移),2.单表同步
        :type SyncType: int
        :param _TaskType: 201.实时,202.离线
        :type TaskType: int
        :param _WorkflowId: 任务所属工作流id
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowId: str
        :param _TaskId: 任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _ScheduleTaskId: 任务调度id(oceanus or us等作业id)
注意：此字段可能返回 null，表示取不到有效值。
        :type ScheduleTaskId: str
        :param _TaskGroupId: 任务组id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskGroupId: str
        :param _ProjectId: 项目id
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _CreatorUin: 创建人uin
注意：此字段可能返回 null，表示取不到有效值。
        :type CreatorUin: str
        :param _OperatorUin: 操作人uin
注意：此字段可能返回 null，表示取不到有效值。
        :type OperatorUin: str
        :param _OwnerUin: owner uin
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerUin: str
        :param _AppId: 应用id
注意：此字段可能返回 null，表示取不到有效值。
        :type AppId: str
        :param _Status: 任务状态1.初始化,2.操作中,3.运行中,4.暂停,5.任务停止中,6.停止,7.执行失败,8.已删除,9.已锁定,10.配置过期,11.提交中,12.提交成功,13.提交失败
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _Nodes: 节点列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Nodes: list of IntegrationNodeInfo
        :param _ExecutorId: 执行资源id
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutorId: str
        :param _Config: 任务配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Config: list of RecordField
        :param _ExtConfig: 任务扩展配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtConfig: list of RecordField
        :param _ExecuteContext: 任务执行context信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecuteContext: list of RecordField
        :param _Mappings: 节点映射
注意：此字段可能返回 null，表示取不到有效值。
        :type Mappings: list of IntegrationNodeMapping
        :param _TaskMode: 任务模式：1.画布模式，2.flink jar
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskMode: str
        :param _Incharge: 责任人
注意：此字段可能返回 null，表示取不到有效值。
        :type Incharge: str
        :param _OfflineTaskAddEntity: 离线新增参数
注意：此字段可能返回 null，表示取不到有效值。
        :type OfflineTaskAddEntity: :class:`tencentcloud.wedata.v20210820.models.OfflineTaskAddParam`
        :param _ExecutorGroupName: group name
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutorGroupName: str
        :param _InLongManagerUrl: url
注意：此字段可能返回 null，表示取不到有效值。
        :type InLongManagerUrl: str
        :param _InLongStreamId: stream id
注意：此字段可能返回 null，表示取不到有效值。
        :type InLongStreamId: str
        :param _InLongManagerVersion: version
注意：此字段可能返回 null，表示取不到有效值。
        :type InLongManagerVersion: str
        :param _DataProxyUrl: dataproxy url
注意：此字段可能返回 null，表示取不到有效值。
        :type DataProxyUrl: list of str
        :param _Submit: 任务版本是否已提交运维
注意：此字段可能返回 null，表示取不到有效值。
        :type Submit: bool
        :param _InputDatasourceType: MYSQL
注意：此字段可能返回 null，表示取不到有效值。
        :type InputDatasourceType: str
        :param _OutputDatasourceType: DLC
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputDatasourceType: str
        :param _NumRecordsIn: 读取条数
注意：此字段可能返回 null，表示取不到有效值。
        :type NumRecordsIn: int
        :param _NumRecordsOut: 写入条数
注意：此字段可能返回 null，表示取不到有效值。
        :type NumRecordsOut: int
        :param _ReaderDelay: 读取延迟
注意：此字段可能返回 null，表示取不到有效值。
        :type ReaderDelay: float
        :param _NumRestarts: 重启次数
注意：此字段可能返回 null，表示取不到有效值。
        :type NumRestarts: int
        :param _CreateTime: 任务创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 任务更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _LastRunTime: 任务最后一次运行时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastRunTime: str
        :param _StopTime: 任务停止时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StopTime: str
        :param _HasVersion: 作业是否已提交
注意：此字段可能返回 null，表示取不到有效值。
        :type HasVersion: bool
        :param _Locked: 任务是否被锁定
注意：此字段可能返回 null，表示取不到有效值。
        :type Locked: bool
        :param _Locker: 任务锁定人
注意：此字段可能返回 null，表示取不到有效值。
        :type Locker: str
        :param _RunningCu: 耗费资源量
注意：此字段可能返回 null，表示取不到有效值。
        :type RunningCu: float
        :param _TaskAlarmRegularList: 该任务关联的告警规则
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskAlarmRegularList: list of str
        """
        self._TaskName = None
        self._Description = None
        self._SyncType = None
        self._TaskType = None
        self._WorkflowId = None
        self._TaskId = None
        self._ScheduleTaskId = None
        self._TaskGroupId = None
        self._ProjectId = None
        self._CreatorUin = None
        self._OperatorUin = None
        self._OwnerUin = None
        self._AppId = None
        self._Status = None
        self._Nodes = None
        self._ExecutorId = None
        self._Config = None
        self._ExtConfig = None
        self._ExecuteContext = None
        self._Mappings = None
        self._TaskMode = None
        self._Incharge = None
        self._OfflineTaskAddEntity = None
        self._ExecutorGroupName = None
        self._InLongManagerUrl = None
        self._InLongStreamId = None
        self._InLongManagerVersion = None
        self._DataProxyUrl = None
        self._Submit = None
        self._InputDatasourceType = None
        self._OutputDatasourceType = None
        self._NumRecordsIn = None
        self._NumRecordsOut = None
        self._ReaderDelay = None
        self._NumRestarts = None
        self._CreateTime = None
        self._UpdateTime = None
        self._LastRunTime = None
        self._StopTime = None
        self._HasVersion = None
        self._Locked = None
        self._Locker = None
        self._RunningCu = None
        self._TaskAlarmRegularList = None

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SyncType(self):
        return self._SyncType

    @SyncType.setter
    def SyncType(self, SyncType):
        self._SyncType = SyncType

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ScheduleTaskId(self):
        return self._ScheduleTaskId

    @ScheduleTaskId.setter
    def ScheduleTaskId(self, ScheduleTaskId):
        self._ScheduleTaskId = ScheduleTaskId

    @property
    def TaskGroupId(self):
        return self._TaskGroupId

    @TaskGroupId.setter
    def TaskGroupId(self, TaskGroupId):
        self._TaskGroupId = TaskGroupId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CreatorUin(self):
        return self._CreatorUin

    @CreatorUin.setter
    def CreatorUin(self, CreatorUin):
        self._CreatorUin = CreatorUin

    @property
    def OperatorUin(self):
        return self._OperatorUin

    @OperatorUin.setter
    def OperatorUin(self, OperatorUin):
        self._OperatorUin = OperatorUin

    @property
    def OwnerUin(self):
        return self._OwnerUin

    @OwnerUin.setter
    def OwnerUin(self, OwnerUin):
        self._OwnerUin = OwnerUin

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Nodes(self):
        return self._Nodes

    @Nodes.setter
    def Nodes(self, Nodes):
        self._Nodes = Nodes

    @property
    def ExecutorId(self):
        return self._ExecutorId

    @ExecutorId.setter
    def ExecutorId(self, ExecutorId):
        self._ExecutorId = ExecutorId

    @property
    def Config(self):
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def ExtConfig(self):
        return self._ExtConfig

    @ExtConfig.setter
    def ExtConfig(self, ExtConfig):
        self._ExtConfig = ExtConfig

    @property
    def ExecuteContext(self):
        return self._ExecuteContext

    @ExecuteContext.setter
    def ExecuteContext(self, ExecuteContext):
        self._ExecuteContext = ExecuteContext

    @property
    def Mappings(self):
        return self._Mappings

    @Mappings.setter
    def Mappings(self, Mappings):
        self._Mappings = Mappings

    @property
    def TaskMode(self):
        return self._TaskMode

    @TaskMode.setter
    def TaskMode(self, TaskMode):
        self._TaskMode = TaskMode

    @property
    def Incharge(self):
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge

    @property
    def OfflineTaskAddEntity(self):
        return self._OfflineTaskAddEntity

    @OfflineTaskAddEntity.setter
    def OfflineTaskAddEntity(self, OfflineTaskAddEntity):
        self._OfflineTaskAddEntity = OfflineTaskAddEntity

    @property
    def ExecutorGroupName(self):
        return self._ExecutorGroupName

    @ExecutorGroupName.setter
    def ExecutorGroupName(self, ExecutorGroupName):
        self._ExecutorGroupName = ExecutorGroupName

    @property
    def InLongManagerUrl(self):
        return self._InLongManagerUrl

    @InLongManagerUrl.setter
    def InLongManagerUrl(self, InLongManagerUrl):
        self._InLongManagerUrl = InLongManagerUrl

    @property
    def InLongStreamId(self):
        return self._InLongStreamId

    @InLongStreamId.setter
    def InLongStreamId(self, InLongStreamId):
        self._InLongStreamId = InLongStreamId

    @property
    def InLongManagerVersion(self):
        return self._InLongManagerVersion

    @InLongManagerVersion.setter
    def InLongManagerVersion(self, InLongManagerVersion):
        self._InLongManagerVersion = InLongManagerVersion

    @property
    def DataProxyUrl(self):
        return self._DataProxyUrl

    @DataProxyUrl.setter
    def DataProxyUrl(self, DataProxyUrl):
        self._DataProxyUrl = DataProxyUrl

    @property
    def Submit(self):
        return self._Submit

    @Submit.setter
    def Submit(self, Submit):
        self._Submit = Submit

    @property
    def InputDatasourceType(self):
        return self._InputDatasourceType

    @InputDatasourceType.setter
    def InputDatasourceType(self, InputDatasourceType):
        self._InputDatasourceType = InputDatasourceType

    @property
    def OutputDatasourceType(self):
        return self._OutputDatasourceType

    @OutputDatasourceType.setter
    def OutputDatasourceType(self, OutputDatasourceType):
        self._OutputDatasourceType = OutputDatasourceType

    @property
    def NumRecordsIn(self):
        return self._NumRecordsIn

    @NumRecordsIn.setter
    def NumRecordsIn(self, NumRecordsIn):
        self._NumRecordsIn = NumRecordsIn

    @property
    def NumRecordsOut(self):
        return self._NumRecordsOut

    @NumRecordsOut.setter
    def NumRecordsOut(self, NumRecordsOut):
        self._NumRecordsOut = NumRecordsOut

    @property
    def ReaderDelay(self):
        return self._ReaderDelay

    @ReaderDelay.setter
    def ReaderDelay(self, ReaderDelay):
        self._ReaderDelay = ReaderDelay

    @property
    def NumRestarts(self):
        return self._NumRestarts

    @NumRestarts.setter
    def NumRestarts(self, NumRestarts):
        self._NumRestarts = NumRestarts

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def LastRunTime(self):
        return self._LastRunTime

    @LastRunTime.setter
    def LastRunTime(self, LastRunTime):
        self._LastRunTime = LastRunTime

    @property
    def StopTime(self):
        return self._StopTime

    @StopTime.setter
    def StopTime(self, StopTime):
        self._StopTime = StopTime

    @property
    def HasVersion(self):
        return self._HasVersion

    @HasVersion.setter
    def HasVersion(self, HasVersion):
        self._HasVersion = HasVersion

    @property
    def Locked(self):
        return self._Locked

    @Locked.setter
    def Locked(self, Locked):
        self._Locked = Locked

    @property
    def Locker(self):
        return self._Locker

    @Locker.setter
    def Locker(self, Locker):
        self._Locker = Locker

    @property
    def RunningCu(self):
        return self._RunningCu

    @RunningCu.setter
    def RunningCu(self, RunningCu):
        self._RunningCu = RunningCu

    @property
    def TaskAlarmRegularList(self):
        return self._TaskAlarmRegularList

    @TaskAlarmRegularList.setter
    def TaskAlarmRegularList(self, TaskAlarmRegularList):
        self._TaskAlarmRegularList = TaskAlarmRegularList


    def _deserialize(self, params):
        self._TaskName = params.get("TaskName")
        self._Description = params.get("Description")
        self._SyncType = params.get("SyncType")
        self._TaskType = params.get("TaskType")
        self._WorkflowId = params.get("WorkflowId")
        self._TaskId = params.get("TaskId")
        self._ScheduleTaskId = params.get("ScheduleTaskId")
        self._TaskGroupId = params.get("TaskGroupId")
        self._ProjectId = params.get("ProjectId")
        self._CreatorUin = params.get("CreatorUin")
        self._OperatorUin = params.get("OperatorUin")
        self._OwnerUin = params.get("OwnerUin")
        self._AppId = params.get("AppId")
        self._Status = params.get("Status")
        if params.get("Nodes") is not None:
            self._Nodes = []
            for item in params.get("Nodes"):
                obj = IntegrationNodeInfo()
                obj._deserialize(item)
                self._Nodes.append(obj)
        self._ExecutorId = params.get("ExecutorId")
        if params.get("Config") is not None:
            self._Config = []
            for item in params.get("Config"):
                obj = RecordField()
                obj._deserialize(item)
                self._Config.append(obj)
        if params.get("ExtConfig") is not None:
            self._ExtConfig = []
            for item in params.get("ExtConfig"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtConfig.append(obj)
        if params.get("ExecuteContext") is not None:
            self._ExecuteContext = []
            for item in params.get("ExecuteContext"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExecuteContext.append(obj)
        if params.get("Mappings") is not None:
            self._Mappings = []
            for item in params.get("Mappings"):
                obj = IntegrationNodeMapping()
                obj._deserialize(item)
                self._Mappings.append(obj)
        self._TaskMode = params.get("TaskMode")
        self._Incharge = params.get("Incharge")
        if params.get("OfflineTaskAddEntity") is not None:
            self._OfflineTaskAddEntity = OfflineTaskAddParam()
            self._OfflineTaskAddEntity._deserialize(params.get("OfflineTaskAddEntity"))
        self._ExecutorGroupName = params.get("ExecutorGroupName")
        self._InLongManagerUrl = params.get("InLongManagerUrl")
        self._InLongStreamId = params.get("InLongStreamId")
        self._InLongManagerVersion = params.get("InLongManagerVersion")
        self._DataProxyUrl = params.get("DataProxyUrl")
        self._Submit = params.get("Submit")
        self._InputDatasourceType = params.get("InputDatasourceType")
        self._OutputDatasourceType = params.get("OutputDatasourceType")
        self._NumRecordsIn = params.get("NumRecordsIn")
        self._NumRecordsOut = params.get("NumRecordsOut")
        self._ReaderDelay = params.get("ReaderDelay")
        self._NumRestarts = params.get("NumRestarts")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._LastRunTime = params.get("LastRunTime")
        self._StopTime = params.get("StopTime")
        self._HasVersion = params.get("HasVersion")
        self._Locked = params.get("Locked")
        self._Locker = params.get("Locker")
        self._RunningCu = params.get("RunningCu")
        self._TaskAlarmRegularList = params.get("TaskAlarmRegularList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KillInstancesRequest(AbstractModel):
    """KillInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Instances: 实例嵌套集合
        :type Instances: list of InstanceInfo
        """
        self._ProjectId = None
        self._Instances = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KillInstancesResponse(AbstractModel):
    """KillInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回实例批量终止结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class Label(AbstractModel):
    """标签类型

    """

    def __init__(self):
        r"""
        :param _Value: 类型值。
        :type Value: str
        :param _Text: 类型名称。
        :type Text: str
        """
        self._Value = None
        self._Text = None

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Value = params.get("Value")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LockIntegrationTaskRequest(AbstractModel):
    """LockIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LockIntegrationTaskResponse(AbstractModel):
    """LockIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作成功与否标识
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class LogContent(AbstractModel):
    """实时任务日志内容

    """

    def __init__(self):
        r"""
        :param _Time: 日志时间戳，单位毫秒
注意：此字段可能返回 null，表示取不到有效值。
        :type Time: int
        :param _PkgId: 日志包id
注意：此字段可能返回 null，表示取不到有效值。
        :type PkgId: str
        :param _Log: 日志内容
        :type Log: str
        """
        self._Time = None
        self._PkgId = None
        self._Log = None

    @property
    def Time(self):
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def PkgId(self):
        return self._PkgId

    @PkgId.setter
    def PkgId(self, PkgId):
        self._PkgId = PkgId

    @property
    def Log(self):
        return self._Log

    @Log.setter
    def Log(self, Log):
        self._Log = Log


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._PkgId = params.get("PkgId")
        self._Log = params.get("Log")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LogContentInfo(AbstractModel):
    """日志内容实体

    """

    def __init__(self):
        r"""
        :param _Log: 日志内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Log: str
        :param _PkgId: 日志组Id
注意：此字段可能返回 null，表示取不到有效值。
        :type PkgId: str
        :param _PkgLogId: 日志Id
注意：此字段可能返回 null，表示取不到有效值。
        :type PkgLogId: str
        :param _Time: 时间
注意：此字段可能返回 null，表示取不到有效值。
        :type Time: int
        :param _ContainerName: 日志所属的容器名
注意：此字段可能返回 null，表示取不到有效值。
        :type ContainerName: str
        """
        self._Log = None
        self._PkgId = None
        self._PkgLogId = None
        self._Time = None
        self._ContainerName = None

    @property
    def Log(self):
        return self._Log

    @Log.setter
    def Log(self, Log):
        self._Log = Log

    @property
    def PkgId(self):
        return self._PkgId

    @PkgId.setter
    def PkgId(self, PkgId):
        self._PkgId = PkgId

    @property
    def PkgLogId(self):
        return self._PkgLogId

    @PkgLogId.setter
    def PkgLogId(self, PkgLogId):
        self._PkgLogId = PkgLogId

    @property
    def Time(self):
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def ContainerName(self):
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName


    def _deserialize(self, params):
        self._Log = params.get("Log")
        self._PkgId = params.get("PkgId")
        self._PkgLogId = params.get("PkgLogId")
        self._Time = params.get("Time")
        self._ContainerName = params.get("ContainerName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MakeUpTasksNewRequest(AbstractModel):
    """MakeUpTasksNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 补录的当前任务的taskId数组
        :type TaskIdList: list of str
        :param _StartTime: 补录开始时间
        :type StartTime: str
        :param _EndTime: 补录结束时间
        :type EndTime: str
        :param _MakeUpType: 补录选项标识，1表示当前任务；2表示当前及下游任务；3表示下游任务
        :type MakeUpType: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _CheckParent: true: 检查父任务实例状态；false: 不检查父任务实例状态
        :type CheckParent: bool
        """
        self._TaskIdList = None
        self._StartTime = None
        self._EndTime = None
        self._MakeUpType = None
        self._ProjectId = None
        self._CheckParent = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MakeUpType(self):
        return self._MakeUpType

    @MakeUpType.setter
    def MakeUpType(self, MakeUpType):
        self._MakeUpType = MakeUpType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CheckParent(self):
        return self._CheckParent

    @CheckParent.setter
    def CheckParent(self, CheckParent):
        self._CheckParent = CheckParent


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MakeUpType = params.get("MakeUpType")
        self._ProjectId = params.get("ProjectId")
        self._CheckParent = params.get("CheckParent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MakeUpTasksNewResponse(AbstractModel):
    """MakeUpTasksNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class MakeUpWorkflowNewRequest(AbstractModel):
    """MakeUpWorkflowNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkFlowId: 工作流id
        :type WorkFlowId: str
        :param _StartTime: 补录开始时间
        :type StartTime: str
        :param _EndTime: 补录结束时间
        :type EndTime: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._WorkFlowId = None
        self._StartTime = None
        self._EndTime = None
        self._ProjectId = None

    @property
    def WorkFlowId(self):
        return self._WorkFlowId

    @WorkFlowId.setter
    def WorkFlowId(self, WorkFlowId):
        self._WorkFlowId = WorkFlowId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._WorkFlowId = params.get("WorkFlowId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MakeUpWorkflowNewResponse(AbstractModel):
    """MakeUpWorkflowNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回补录成功或失败的任务数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyDataSourceRequest(AbstractModel):
    """ModifyDataSource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 数据源名称，在相同SpaceName下，数据源名称不能为空
        :type Name: str
        :param _Category: 数据源类别：绑定引擎、绑定数据库
        :type Category: str
        :param _Type: 数据源类型:枚举值
        :type Type: str
        :param _ID: 数据源ID
        :type ID: int
        :param _BizParams: 业务侧数据源的配置信息扩展
        :type BizParams: str
        :param _Params: 数据源的配置信息，以JSON KV存储，根据每个数据源类型不同，而KV存储信息不同
        :type Params: str
        :param _Description: 数据源描述信息
        :type Description: str
        :param _Display: 数据源展示名，为了可视化查看
        :type Display: str
        :param _DatabaseName: 若数据源列表为绑定数据库，则为db名称
        :type DatabaseName: str
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
        :type Instance: str
        :param _Status: 数据源数据源的可见性，1为可见、0为不可见。默认为1
        :type Status: int
        :param _ClusterId: 数据源所属的业务空间名称
        :type ClusterId: str
        :param _Collect: 是否采集
        :type Collect: str
        :param _OwnerProjectId: 项目id
        :type OwnerProjectId: str
        :param _OwnerProjectName: 项目名称
        :type OwnerProjectName: str
        :param _OwnerProjectIdent: 项目中文名
        :type OwnerProjectIdent: str
        :param _COSBucket: cos bucket
        :type COSBucket: str
        :param _COSRegion: cos region
        :type COSRegion: str
        """
        self._Name = None
        self._Category = None
        self._Type = None
        self._ID = None
        self._BizParams = None
        self._Params = None
        self._Description = None
        self._Display = None
        self._DatabaseName = None
        self._Instance = None
        self._Status = None
        self._ClusterId = None
        self._Collect = None
        self._OwnerProjectId = None
        self._OwnerProjectName = None
        self._OwnerProjectIdent = None
        self._COSBucket = None
        self._COSRegion = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ID(self):
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def BizParams(self):
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Display(self):
        return self._Display

    @Display.setter
    def Display(self, Display):
        self._Display = Display

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Collect(self):
        return self._Collect

    @Collect.setter
    def Collect(self, Collect):
        self._Collect = Collect

    @property
    def OwnerProjectId(self):
        return self._OwnerProjectId

    @OwnerProjectId.setter
    def OwnerProjectId(self, OwnerProjectId):
        self._OwnerProjectId = OwnerProjectId

    @property
    def OwnerProjectName(self):
        return self._OwnerProjectName

    @OwnerProjectName.setter
    def OwnerProjectName(self, OwnerProjectName):
        self._OwnerProjectName = OwnerProjectName

    @property
    def OwnerProjectIdent(self):
        return self._OwnerProjectIdent

    @OwnerProjectIdent.setter
    def OwnerProjectIdent(self, OwnerProjectIdent):
        self._OwnerProjectIdent = OwnerProjectIdent

    @property
    def COSBucket(self):
        return self._COSBucket

    @COSBucket.setter
    def COSBucket(self, COSBucket):
        self._COSBucket = COSBucket

    @property
    def COSRegion(self):
        return self._COSRegion

    @COSRegion.setter
    def COSRegion(self, COSRegion):
        self._COSRegion = COSRegion


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Category = params.get("Category")
        self._Type = params.get("Type")
        self._ID = params.get("ID")
        self._BizParams = params.get("BizParams")
        self._Params = params.get("Params")
        self._Description = params.get("Description")
        self._Display = params.get("Display")
        self._DatabaseName = params.get("DatabaseName")
        self._Instance = params.get("Instance")
        self._Status = params.get("Status")
        self._ClusterId = params.get("ClusterId")
        self._Collect = params.get("Collect")
        self._OwnerProjectId = params.get("OwnerProjectId")
        self._OwnerProjectName = params.get("OwnerProjectName")
        self._OwnerProjectIdent = params.get("OwnerProjectIdent")
        self._COSBucket = params.get("COSBucket")
        self._COSRegion = params.get("COSRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDataSourceResponse(AbstractModel):
    """ModifyDataSource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyDimensionWeightRequest(AbstractModel):
    """ModifyDimensionWeight请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WeightInfoList: 权重信息列表
        :type WeightInfoList: list of WeightInfo
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _Refresh: 是否重刷历史数据
        :type Refresh: bool
        """
        self._WeightInfoList = None
        self._ProjectId = None
        self._Refresh = None

    @property
    def WeightInfoList(self):
        return self._WeightInfoList

    @WeightInfoList.setter
    def WeightInfoList(self, WeightInfoList):
        self._WeightInfoList = WeightInfoList

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Refresh(self):
        return self._Refresh

    @Refresh.setter
    def Refresh(self, Refresh):
        self._Refresh = Refresh


    def _deserialize(self, params):
        if params.get("WeightInfoList") is not None:
            self._WeightInfoList = []
            for item in params.get("WeightInfoList"):
                obj = WeightInfo()
                obj._deserialize(item)
                self._WeightInfoList.append(obj)
        self._ProjectId = params.get("ProjectId")
        self._Refresh = params.get("Refresh")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDimensionWeightResponse(AbstractModel):
    """ModifyDimensionWeight返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 更新权重是否成功
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyExecStrategyRequest(AbstractModel):
    """ModifyExecStrategy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _MonitorType: 监控类型 1.未配置, 2.关联生产调度, 3.离线周期检测
        :type MonitorType: int
        :param _ExecQueue: 计算队列
        :type ExecQueue: str
        :param _ExecutorGroupId: 执行资源组ID
        :type ExecutorGroupId: str
        :param _ExecutorGroupName: 执行资源组名称
        :type ExecutorGroupName: str
        :param _Tasks: 关联的生产调度任务列表
        :type Tasks: list of ProdSchedulerTask
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _StartTime: 离线周期模式下,生效日期-开始时间
        :type StartTime: str
        :param _EndTime: 离线周期模式下,生效日期-结束时间
        :type EndTime: str
        :param _CycleType: 离线周期模式下,调度周期 
MINUTE_CYCLE:I,
HOUR_CYCLE:H,
DAY_CYCLE:D,
WEEK_CYCLE:W,
MONTH_CYCLE:M
        :type CycleType: str
        :param _CycleStep: 离线周期模式下,调度步长
        :type CycleStep: int
        :param _TaskAction: 离线周期模式下,指定时间
        :type TaskAction: str
        :param _DelayTime: 延时执行时间，单位分钟，可选: <0-1439
        :type DelayTime: int
        :param _DatabaseId: 数据库Id
        :type DatabaseId: str
        :param _DatasourceId: 数据源Id
        :type DatasourceId: str
        :param _TableId: 数据表Id
        :type TableId: str
        :param _ExecEngineType: 运行的执行引擎，不传时会请求该数据源下默认的执行引擎
        :type ExecEngineType: str
        """
        self._RuleGroupId = None
        self._MonitorType = None
        self._ExecQueue = None
        self._ExecutorGroupId = None
        self._ExecutorGroupName = None
        self._Tasks = None
        self._ProjectId = None
        self._StartTime = None
        self._EndTime = None
        self._CycleType = None
        self._CycleStep = None
        self._TaskAction = None
        self._DelayTime = None
        self._DatabaseId = None
        self._DatasourceId = None
        self._TableId = None
        self._ExecEngineType = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType

    @property
    def ExecQueue(self):
        return self._ExecQueue

    @ExecQueue.setter
    def ExecQueue(self, ExecQueue):
        self._ExecQueue = ExecQueue

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId

    @property
    def ExecutorGroupName(self):
        return self._ExecutorGroupName

    @ExecutorGroupName.setter
    def ExecutorGroupName(self, ExecutorGroupName):
        self._ExecutorGroupName = ExecutorGroupName

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CycleType(self):
        return self._CycleType

    @CycleType.setter
    def CycleType(self, CycleType):
        self._CycleType = CycleType

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def TaskAction(self):
        return self._TaskAction

    @TaskAction.setter
    def TaskAction(self, TaskAction):
        self._TaskAction = TaskAction

    @property
    def DelayTime(self):
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def ExecEngineType(self):
        return self._ExecEngineType

    @ExecEngineType.setter
    def ExecEngineType(self, ExecEngineType):
        self._ExecEngineType = ExecEngineType


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._MonitorType = params.get("MonitorType")
        self._ExecQueue = params.get("ExecQueue")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        self._ExecutorGroupName = params.get("ExecutorGroupName")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = ProdSchedulerTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._ProjectId = params.get("ProjectId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._CycleType = params.get("CycleType")
        self._CycleStep = params.get("CycleStep")
        self._TaskAction = params.get("TaskAction")
        self._DelayTime = params.get("DelayTime")
        self._DatabaseId = params.get("DatabaseId")
        self._DatasourceId = params.get("DatasourceId")
        self._TableId = params.get("TableId")
        self._ExecEngineType = params.get("ExecEngineType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyExecStrategyResponse(AbstractModel):
    """ModifyExecStrategy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyFolderRequest(AbstractModel):
    """ModifyFolder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _FolderName: 文件夹名称
        :type FolderName: str
        :param _FolderId: 文件夹Id
        :type FolderId: str
        :param _ParentsFolderId: 父文件夹ID
        :type ParentsFolderId: str
        """
        self._ProjectId = None
        self._FolderName = None
        self._FolderId = None
        self._ParentsFolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderName(self):
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderName = params.get("FolderName")
        self._FolderId = params.get("FolderId")
        self._ParentsFolderId = params.get("ParentsFolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyFolderResponse(AbstractModel):
    """ModifyFolder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: true代表成功，false代表失败
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyIntegrationNodeRequest(AbstractModel):
    """ModifyIntegrationNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NodeInfo: 集成节点信息
        :type NodeInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeInfo`
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _TaskMode: 区分画布模式和表单模式
        :type TaskMode: int
        """
        self._NodeInfo = None
        self._ProjectId = None
        self._TaskType = None
        self._TaskMode = None

    @property
    def NodeInfo(self):
        return self._NodeInfo

    @NodeInfo.setter
    def NodeInfo(self, NodeInfo):
        self._NodeInfo = NodeInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskMode(self):
        return self._TaskMode

    @TaskMode.setter
    def TaskMode(self, TaskMode):
        self._TaskMode = TaskMode


    def _deserialize(self, params):
        if params.get("NodeInfo") is not None:
            self._NodeInfo = IntegrationNodeInfo()
            self._NodeInfo._deserialize(params.get("NodeInfo"))
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        self._TaskMode = params.get("TaskMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyIntegrationNodeResponse(AbstractModel):
    """ModifyIntegrationNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 节点id
        :type Id: str
        :param _TaskId: 任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._TaskId = None
        self._RequestId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ModifyIntegrationTaskRequest(AbstractModel):
    """ModifyIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfo: 任务信息
        :type TaskInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationTaskInfo`
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RollbackFlag: 默认false . 为true时表示走回滚节点逻辑
        :type RollbackFlag: bool
        """
        self._TaskInfo = None
        self._ProjectId = None
        self._RollbackFlag = None

    @property
    def TaskInfo(self):
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RollbackFlag(self):
        return self._RollbackFlag

    @RollbackFlag.setter
    def RollbackFlag(self, RollbackFlag):
        self._RollbackFlag = RollbackFlag


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = IntegrationTaskInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        self._ProjectId = params.get("ProjectId")
        self._RollbackFlag = params.get("RollbackFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyIntegrationTaskResponse(AbstractModel):
    """ModifyIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ModifyMonitorStatusRequest(AbstractModel):
    """ModifyMonitorStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _MonitorStatus: 监控开关状态
        :type MonitorStatus: bool
        """
        self._ProjectId = None
        self._RuleGroupId = None
        self._MonitorStatus = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def MonitorStatus(self):
        return self._MonitorStatus

    @MonitorStatus.setter
    def MonitorStatus(self, MonitorStatus):
        self._MonitorStatus = MonitorStatus


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._MonitorStatus = params.get("MonitorStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyMonitorStatusResponse(AbstractModel):
    """ModifyMonitorStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 监控状态修改成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyRuleGroupSubscriptionRequest(AbstractModel):
    """ModifyRuleGroupSubscription请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _Receivers: 订阅人信息
        :type Receivers: list of SubscribeReceiver
        :param _SubscribeType: 订阅类型
        :type SubscribeType: list of int non-negative
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _DatabaseId: 数据库Id
        :type DatabaseId: str
        :param _DatasourceId: 数据源Id
        :type DatasourceId: str
        :param _TableId: 数据表Id
        :type TableId: str
        :param _WebHooks: 群机器人webhook信息
        :type WebHooks: list of SubscribeWebHook
        """
        self._RuleGroupId = None
        self._Receivers = None
        self._SubscribeType = None
        self._ProjectId = None
        self._DatabaseId = None
        self._DatasourceId = None
        self._TableId = None
        self._WebHooks = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def Receivers(self):
        return self._Receivers

    @Receivers.setter
    def Receivers(self, Receivers):
        self._Receivers = Receivers

    @property
    def SubscribeType(self):
        return self._SubscribeType

    @SubscribeType.setter
    def SubscribeType(self, SubscribeType):
        self._SubscribeType = SubscribeType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def WebHooks(self):
        return self._WebHooks

    @WebHooks.setter
    def WebHooks(self, WebHooks):
        self._WebHooks = WebHooks


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        if params.get("Receivers") is not None:
            self._Receivers = []
            for item in params.get("Receivers"):
                obj = SubscribeReceiver()
                obj._deserialize(item)
                self._Receivers.append(obj)
        self._SubscribeType = params.get("SubscribeType")
        self._ProjectId = params.get("ProjectId")
        self._DatabaseId = params.get("DatabaseId")
        self._DatasourceId = params.get("DatasourceId")
        self._TableId = params.get("TableId")
        if params.get("WebHooks") is not None:
            self._WebHooks = []
            for item in params.get("WebHooks"):
                obj = SubscribeWebHook()
                obj._deserialize(item)
                self._WebHooks.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRuleGroupSubscriptionResponse(AbstractModel):
    """ModifyRuleGroupSubscription返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyRuleRequest(AbstractModel):
    """ModifyRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _Name: 规则名称
        :type Name: str
        :param _TableId: 数据表ID
        :type TableId: str
        :param _RuleTemplateId: 规则模板ID
        :type RuleTemplateId: int
        :param _Type: 规则类型 1.系统模版, 2.自定义模版, 3.自定义SQL
        :type Type: int
        :param _QualityDim: 规则所属质量维度（1：准确性，2：唯一性，3：完整性，4：一致性，5：及时性，6：有效性
        :type QualityDim: int
        :param _SourceObjectDataTypeName: 源字段详细类型，int、string
        :type SourceObjectDataTypeName: str
        :param _SourceObjectValue: 源字段名称
        :type SourceObjectValue: str
        :param _ConditionType: 检测范围 1.全表   2.条件扫描
        :type ConditionType: int
        :param _ConditionExpression: 条件扫描WHERE条件表达式
        :type ConditionExpression: str
        :param _CustomSql: 自定义SQL
        :type CustomSql: str
        :param _CompareRule: 报警触发条件
        :type CompareRule: :class:`tencentcloud.wedata.v20210820.models.CompareRule`
        :param _AlarmLevel: 报警触发级别 1.低, 2.中, 3.高
        :type AlarmLevel: int
        :param _Description: 规则描述
        :type Description: str
        :param _TargetDatabaseId: 目标库Id
        :type TargetDatabaseId: str
        :param _TargetTableId: 目标表Id
        :type TargetTableId: str
        :param _TargetConditionExpr: 目标过滤条件表达式
        :type TargetConditionExpr: str
        :param _RelConditionExpr: 源字段与目标字段关联条件on表达式
        :type RelConditionExpr: str
        :param _FieldConfig: 自定义模版sql表达式字段替换参数
        :type FieldConfig: :class:`tencentcloud.wedata.v20210820.models.RuleFieldConfig`
        :param _TargetObjectValue: 目标字段名称  CITY
        :type TargetObjectValue: str
        :param _SourceEngineTypes: 该规则适配的执行引擎
        :type SourceEngineTypes: list of int non-negative
        """
        self._ProjectId = None
        self._RuleId = None
        self._RuleGroupId = None
        self._Name = None
        self._TableId = None
        self._RuleTemplateId = None
        self._Type = None
        self._QualityDim = None
        self._SourceObjectDataTypeName = None
        self._SourceObjectValue = None
        self._ConditionType = None
        self._ConditionExpression = None
        self._CustomSql = None
        self._CompareRule = None
        self._AlarmLevel = None
        self._Description = None
        self._TargetDatabaseId = None
        self._TargetTableId = None
        self._TargetConditionExpr = None
        self._RelConditionExpr = None
        self._FieldConfig = None
        self._TargetObjectValue = None
        self._SourceEngineTypes = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def RuleTemplateId(self):
        return self._RuleTemplateId

    @RuleTemplateId.setter
    def RuleTemplateId(self, RuleTemplateId):
        self._RuleTemplateId = RuleTemplateId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def SourceObjectDataTypeName(self):
        return self._SourceObjectDataTypeName

    @SourceObjectDataTypeName.setter
    def SourceObjectDataTypeName(self, SourceObjectDataTypeName):
        self._SourceObjectDataTypeName = SourceObjectDataTypeName

    @property
    def SourceObjectValue(self):
        return self._SourceObjectValue

    @SourceObjectValue.setter
    def SourceObjectValue(self, SourceObjectValue):
        self._SourceObjectValue = SourceObjectValue

    @property
    def ConditionType(self):
        return self._ConditionType

    @ConditionType.setter
    def ConditionType(self, ConditionType):
        self._ConditionType = ConditionType

    @property
    def ConditionExpression(self):
        return self._ConditionExpression

    @ConditionExpression.setter
    def ConditionExpression(self, ConditionExpression):
        self._ConditionExpression = ConditionExpression

    @property
    def CustomSql(self):
        return self._CustomSql

    @CustomSql.setter
    def CustomSql(self, CustomSql):
        self._CustomSql = CustomSql

    @property
    def CompareRule(self):
        return self._CompareRule

    @CompareRule.setter
    def CompareRule(self, CompareRule):
        self._CompareRule = CompareRule

    @property
    def AlarmLevel(self):
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def TargetDatabaseId(self):
        return self._TargetDatabaseId

    @TargetDatabaseId.setter
    def TargetDatabaseId(self, TargetDatabaseId):
        self._TargetDatabaseId = TargetDatabaseId

    @property
    def TargetTableId(self):
        return self._TargetTableId

    @TargetTableId.setter
    def TargetTableId(self, TargetTableId):
        self._TargetTableId = TargetTableId

    @property
    def TargetConditionExpr(self):
        return self._TargetConditionExpr

    @TargetConditionExpr.setter
    def TargetConditionExpr(self, TargetConditionExpr):
        self._TargetConditionExpr = TargetConditionExpr

    @property
    def RelConditionExpr(self):
        return self._RelConditionExpr

    @RelConditionExpr.setter
    def RelConditionExpr(self, RelConditionExpr):
        self._RelConditionExpr = RelConditionExpr

    @property
    def FieldConfig(self):
        return self._FieldConfig

    @FieldConfig.setter
    def FieldConfig(self, FieldConfig):
        self._FieldConfig = FieldConfig

    @property
    def TargetObjectValue(self):
        return self._TargetObjectValue

    @TargetObjectValue.setter
    def TargetObjectValue(self, TargetObjectValue):
        self._TargetObjectValue = TargetObjectValue

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleId = params.get("RuleId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._Name = params.get("Name")
        self._TableId = params.get("TableId")
        self._RuleTemplateId = params.get("RuleTemplateId")
        self._Type = params.get("Type")
        self._QualityDim = params.get("QualityDim")
        self._SourceObjectDataTypeName = params.get("SourceObjectDataTypeName")
        self._SourceObjectValue = params.get("SourceObjectValue")
        self._ConditionType = params.get("ConditionType")
        self._ConditionExpression = params.get("ConditionExpression")
        self._CustomSql = params.get("CustomSql")
        if params.get("CompareRule") is not None:
            self._CompareRule = CompareRule()
            self._CompareRule._deserialize(params.get("CompareRule"))
        self._AlarmLevel = params.get("AlarmLevel")
        self._Description = params.get("Description")
        self._TargetDatabaseId = params.get("TargetDatabaseId")
        self._TargetTableId = params.get("TargetTableId")
        self._TargetConditionExpr = params.get("TargetConditionExpr")
        self._RelConditionExpr = params.get("RelConditionExpr")
        if params.get("FieldConfig") is not None:
            self._FieldConfig = RuleFieldConfig()
            self._FieldConfig._deserialize(params.get("FieldConfig"))
        self._TargetObjectValue = params.get("TargetObjectValue")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRuleResponse(AbstractModel):
    """ModifyRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否更新成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyRuleTemplateRequest(AbstractModel):
    """ModifyRuleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模版ID
        :type TemplateId: int
        :param _Type: 模版类型  1.系统模版   2.自定义模版
        :type Type: int
        :param _Name: 模版名称
        :type Name: str
        :param _QualityDim: 质量检测维度 1.准确性 2.唯一性 3.完整性 4.一致性 5.及时性 6.有效性
        :type QualityDim: int
        :param _SourceObjectType: 源端数据对象类型 1.常量  2.离线表级   2.离线字段级
        :type SourceObjectType: int
        :param _Description: 描述
        :type Description: str
        :param _SourceEngineTypes: 源端对应的引擎类型
        :type SourceEngineTypes: list of int non-negative
        :param _MultiSourceFlag: 是否关联其它库表
        :type MultiSourceFlag: bool
        :param _SqlExpression: SQL 表达式
        :type SqlExpression: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WhereFlag: 是否添加where参数
        :type WhereFlag: bool
        """
        self._TemplateId = None
        self._Type = None
        self._Name = None
        self._QualityDim = None
        self._SourceObjectType = None
        self._Description = None
        self._SourceEngineTypes = None
        self._MultiSourceFlag = None
        self._SqlExpression = None
        self._ProjectId = None
        self._WhereFlag = None

    @property
    def TemplateId(self):
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def SourceObjectType(self):
        return self._SourceObjectType

    @SourceObjectType.setter
    def SourceObjectType(self, SourceObjectType):
        self._SourceObjectType = SourceObjectType

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes

    @property
    def MultiSourceFlag(self):
        return self._MultiSourceFlag

    @MultiSourceFlag.setter
    def MultiSourceFlag(self, MultiSourceFlag):
        self._MultiSourceFlag = MultiSourceFlag

    @property
    def SqlExpression(self):
        return self._SqlExpression

    @SqlExpression.setter
    def SqlExpression(self, SqlExpression):
        self._SqlExpression = SqlExpression

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WhereFlag(self):
        return self._WhereFlag

    @WhereFlag.setter
    def WhereFlag(self, WhereFlag):
        self._WhereFlag = WhereFlag


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._QualityDim = params.get("QualityDim")
        self._SourceObjectType = params.get("SourceObjectType")
        self._Description = params.get("Description")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        self._MultiSourceFlag = params.get("MultiSourceFlag")
        self._SqlExpression = params.get("SqlExpression")
        self._ProjectId = params.get("ProjectId")
        self._WhereFlag = params.get("WhereFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRuleTemplateResponse(AbstractModel):
    """ModifyRuleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 修改成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyTaskAlarmRegularRequest(AbstractModel):
    """ModifyTaskAlarmRegular请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 主键ID
        :type Id: str
        :param _TaskAlarmInfo: 规则信息
        :type TaskAlarmInfo: :class:`tencentcloud.wedata.v20210820.models.TaskAlarmInfo`
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._Id = None
        self._TaskAlarmInfo = None
        self._ProjectId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskAlarmInfo(self):
        return self._TaskAlarmInfo

    @TaskAlarmInfo.setter
    def TaskAlarmInfo(self, TaskAlarmInfo):
        self._TaskAlarmInfo = TaskAlarmInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        if params.get("TaskAlarmInfo") is not None:
            self._TaskAlarmInfo = TaskAlarmInfo()
            self._TaskAlarmInfo._deserialize(params.get("TaskAlarmInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTaskAlarmRegularResponse(AbstractModel):
    """ModifyTaskAlarmRegular返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 判断是否修改成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyTaskInfoRequest(AbstractModel):
    """ModifyTaskInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _DelayTime: 执行时间，单位分钟，天/周/月/年调度才有。比如天调度，每天的02:00点执行一次，delayTime就是120分钟
        :type DelayTime: int
        :param _StartupTime: 启动时间
        :type StartupTime: int
        :param _SelfDepend: 自依赖类型  1:有序串行 一次一个 排队, 2: 无序串行 一次一个 不排队， 3:并行 一次多个
        :type SelfDepend: int
        :param _StartTime: 生效开始时间，格式 yyyy-MM-dd HH:mm:ss
        :type StartTime: str
        :param _EndTime: 生效结束时间，格式 yyyy-MM-dd HH:mm:ss
        :type EndTime: str
        :param _TaskAction: 调度配置-弹性周期配置，小时/周/月/年调度才有，小时任务指定每天的0点3点4点跑，则为'0,3,4'。
        :type TaskAction: str
        :param _CycleType: "周期类型  0:crontab类型, 1:分钟，2:小时，3:天，4:周，5:月，6:一次性，7:用户驱动，10:弹性周期 周,11:弹性周期 月,12:年,13:即时触发Instant类型，与正常周期调度任务逻辑隔离
        :type CycleType: int
        :param _CycleStep: 步长，间隔时间，最小1
        :type CycleStep: int
        :param _CrontabExpression: cron表达式  周期类型为crontab调度才需要
        :type CrontabExpression: str
        :param _ExecutionStartTime: 执行时间左闭区间，格式：HH:mm  小时调度才有，例如小时任务, 每日固定区间生效
        :type ExecutionStartTime: str
        :param _ExecutionEndTime: 执行时间右闭区间，格式：HH:mm  小时调度才有，例如小时任务, 每日固定区间生效
        :type ExecutionEndTime: str
        :param _TaskName: 新的任务名
        :type TaskName: str
        :param _RetryWait: 失败重试间隔,单位分钟，创建任务的时候已经给了默认值
        :type RetryWait: int
        :param _TryLimit: 失败重试次数，创建任务的时候已经给了默认值
        :type TryLimit: int
        :param _Retriable: 是否可重试，1代表可以重试
        :type Retriable: int
        :param _RunPriority: 运行优先级，4高 5中 6低
        :type RunPriority: int
        :param _TaskExt: 任务的扩展配置
        :type TaskExt: list of TaskExtInfo
        :param _ResourceGroup: 执行资源组id，需要去资源管理服务上创建调度资源组，并且绑定cvm机器
        :type ResourceGroup: str
        :param _YarnQueue: 资源池队列名称
        :type YarnQueue: str
        :param _BrokerIp: 资源组下具体执行机，any 表示可以跑在任意一台。
        :type BrokerIp: str
        :param _InCharge: 责任人
        :type InCharge: str
        :param _Notes: 任务备注
        :type Notes: str
        :param _TaskParamInfos: 任务参数
        :type TaskParamInfos: list of ParamInfo
        :param _SourceServer: 源数据源
        :type SourceServer: str
        :param _TargetServer: 目标数据源
        :type TargetServer: str
        :param _DependencyWorkflow: 是否支持工作流依赖 yes / no 默认 no
        :type DependencyWorkflow: str
        :param _DependencyConfigDTOs: 依赖配置
        :type DependencyConfigDTOs: list of DependencyConfig
        """
        self._ProjectId = None
        self._TaskId = None
        self._DelayTime = None
        self._StartupTime = None
        self._SelfDepend = None
        self._StartTime = None
        self._EndTime = None
        self._TaskAction = None
        self._CycleType = None
        self._CycleStep = None
        self._CrontabExpression = None
        self._ExecutionStartTime = None
        self._ExecutionEndTime = None
        self._TaskName = None
        self._RetryWait = None
        self._TryLimit = None
        self._Retriable = None
        self._RunPriority = None
        self._TaskExt = None
        self._ResourceGroup = None
        self._YarnQueue = None
        self._BrokerIp = None
        self._InCharge = None
        self._Notes = None
        self._TaskParamInfos = None
        self._SourceServer = None
        self._TargetServer = None
        self._DependencyWorkflow = None
        self._DependencyConfigDTOs = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DelayTime(self):
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def StartupTime(self):
        return self._StartupTime

    @StartupTime.setter
    def StartupTime(self, StartupTime):
        self._StartupTime = StartupTime

    @property
    def SelfDepend(self):
        return self._SelfDepend

    @SelfDepend.setter
    def SelfDepend(self, SelfDepend):
        self._SelfDepend = SelfDepend

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TaskAction(self):
        return self._TaskAction

    @TaskAction.setter
    def TaskAction(self, TaskAction):
        self._TaskAction = TaskAction

    @property
    def CycleType(self):
        return self._CycleType

    @CycleType.setter
    def CycleType(self, CycleType):
        self._CycleType = CycleType

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def CrontabExpression(self):
        return self._CrontabExpression

    @CrontabExpression.setter
    def CrontabExpression(self, CrontabExpression):
        self._CrontabExpression = CrontabExpression

    @property
    def ExecutionStartTime(self):
        return self._ExecutionStartTime

    @ExecutionStartTime.setter
    def ExecutionStartTime(self, ExecutionStartTime):
        self._ExecutionStartTime = ExecutionStartTime

    @property
    def ExecutionEndTime(self):
        return self._ExecutionEndTime

    @ExecutionEndTime.setter
    def ExecutionEndTime(self, ExecutionEndTime):
        self._ExecutionEndTime = ExecutionEndTime

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def RetryWait(self):
        return self._RetryWait

    @RetryWait.setter
    def RetryWait(self, RetryWait):
        self._RetryWait = RetryWait

    @property
    def TryLimit(self):
        return self._TryLimit

    @TryLimit.setter
    def TryLimit(self, TryLimit):
        self._TryLimit = TryLimit

    @property
    def Retriable(self):
        return self._Retriable

    @Retriable.setter
    def Retriable(self, Retriable):
        self._Retriable = Retriable

    @property
    def RunPriority(self):
        return self._RunPriority

    @RunPriority.setter
    def RunPriority(self, RunPriority):
        self._RunPriority = RunPriority

    @property
    def TaskExt(self):
        return self._TaskExt

    @TaskExt.setter
    def TaskExt(self, TaskExt):
        self._TaskExt = TaskExt

    @property
    def ResourceGroup(self):
        return self._ResourceGroup

    @ResourceGroup.setter
    def ResourceGroup(self, ResourceGroup):
        self._ResourceGroup = ResourceGroup

    @property
    def YarnQueue(self):
        return self._YarnQueue

    @YarnQueue.setter
    def YarnQueue(self, YarnQueue):
        self._YarnQueue = YarnQueue

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def Notes(self):
        return self._Notes

    @Notes.setter
    def Notes(self, Notes):
        self._Notes = Notes

    @property
    def TaskParamInfos(self):
        return self._TaskParamInfos

    @TaskParamInfos.setter
    def TaskParamInfos(self, TaskParamInfos):
        self._TaskParamInfos = TaskParamInfos

    @property
    def SourceServer(self):
        return self._SourceServer

    @SourceServer.setter
    def SourceServer(self, SourceServer):
        self._SourceServer = SourceServer

    @property
    def TargetServer(self):
        return self._TargetServer

    @TargetServer.setter
    def TargetServer(self, TargetServer):
        self._TargetServer = TargetServer

    @property
    def DependencyWorkflow(self):
        return self._DependencyWorkflow

    @DependencyWorkflow.setter
    def DependencyWorkflow(self, DependencyWorkflow):
        self._DependencyWorkflow = DependencyWorkflow

    @property
    def DependencyConfigDTOs(self):
        return self._DependencyConfigDTOs

    @DependencyConfigDTOs.setter
    def DependencyConfigDTOs(self, DependencyConfigDTOs):
        self._DependencyConfigDTOs = DependencyConfigDTOs


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._DelayTime = params.get("DelayTime")
        self._StartupTime = params.get("StartupTime")
        self._SelfDepend = params.get("SelfDepend")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TaskAction = params.get("TaskAction")
        self._CycleType = params.get("CycleType")
        self._CycleStep = params.get("CycleStep")
        self._CrontabExpression = params.get("CrontabExpression")
        self._ExecutionStartTime = params.get("ExecutionStartTime")
        self._ExecutionEndTime = params.get("ExecutionEndTime")
        self._TaskName = params.get("TaskName")
        self._RetryWait = params.get("RetryWait")
        self._TryLimit = params.get("TryLimit")
        self._Retriable = params.get("Retriable")
        self._RunPriority = params.get("RunPriority")
        if params.get("TaskExt") is not None:
            self._TaskExt = []
            for item in params.get("TaskExt"):
                obj = TaskExtInfo()
                obj._deserialize(item)
                self._TaskExt.append(obj)
        self._ResourceGroup = params.get("ResourceGroup")
        self._YarnQueue = params.get("YarnQueue")
        self._BrokerIp = params.get("BrokerIp")
        self._InCharge = params.get("InCharge")
        self._Notes = params.get("Notes")
        if params.get("TaskParamInfos") is not None:
            self._TaskParamInfos = []
            for item in params.get("TaskParamInfos"):
                obj = ParamInfo()
                obj._deserialize(item)
                self._TaskParamInfos.append(obj)
        self._SourceServer = params.get("SourceServer")
        self._TargetServer = params.get("TargetServer")
        self._DependencyWorkflow = params.get("DependencyWorkflow")
        if params.get("DependencyConfigDTOs") is not None:
            self._DependencyConfigDTOs = []
            for item in params.get("DependencyConfigDTOs"):
                obj = DependencyConfig()
                obj._deserialize(item)
                self._DependencyConfigDTOs.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTaskInfoResponse(AbstractModel):
    """ModifyTaskInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 执行结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyTaskLinksRequest(AbstractModel):
    """ModifyTaskLinks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskFrom: 父任务ID
        :type TaskFrom: str
        :param _TaskTo: 子任务ID
        :type TaskTo: str
        :param _WorkflowId: 子任务工作流
        :type WorkflowId: str
        :param _RealFromWorkflowId: 父任务工作流
        :type RealFromWorkflowId: str
        :param _LinkDependencyType: 父子任务之间的依赖关系
        :type LinkDependencyType: str
        """
        self._ProjectId = None
        self._TaskFrom = None
        self._TaskTo = None
        self._WorkflowId = None
        self._RealFromWorkflowId = None
        self._LinkDependencyType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskFrom(self):
        return self._TaskFrom

    @TaskFrom.setter
    def TaskFrom(self, TaskFrom):
        self._TaskFrom = TaskFrom

    @property
    def TaskTo(self):
        return self._TaskTo

    @TaskTo.setter
    def TaskTo(self, TaskTo):
        self._TaskTo = TaskTo

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def RealFromWorkflowId(self):
        return self._RealFromWorkflowId

    @RealFromWorkflowId.setter
    def RealFromWorkflowId(self, RealFromWorkflowId):
        self._RealFromWorkflowId = RealFromWorkflowId

    @property
    def LinkDependencyType(self):
        return self._LinkDependencyType

    @LinkDependencyType.setter
    def LinkDependencyType(self, LinkDependencyType):
        self._LinkDependencyType = LinkDependencyType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskFrom = params.get("TaskFrom")
        self._TaskTo = params.get("TaskTo")
        self._WorkflowId = params.get("WorkflowId")
        self._RealFromWorkflowId = params.get("RealFromWorkflowId")
        self._LinkDependencyType = params.get("LinkDependencyType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTaskLinksResponse(AbstractModel):
    """ModifyTaskLinks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 成功或者失败
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyTaskNameRequest(AbstractModel):
    """ModifyTaskName请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskName: 名称
        :type TaskName: str
        :param _TaskId: id
        :type TaskId: str
        :param _ProjectId: 项目/工作空间id
        :type ProjectId: str
        :param _Notes: 备注
        :type Notes: str
        """
        self._TaskName = None
        self._TaskId = None
        self._ProjectId = None
        self._Notes = None

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Notes(self):
        return self._Notes

    @Notes.setter
    def Notes(self, Notes):
        self._Notes = Notes


    def _deserialize(self, params):
        self._TaskName = params.get("TaskName")
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._Notes = params.get("Notes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTaskNameResponse(AbstractModel):
    """ModifyTaskName返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyTaskScriptRequest(AbstractModel):
    """ModifyTaskScript请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _ScriptContent: 脚本内容 base64编码
        :type ScriptContent: str
        :param _IntegrationNodeDetails: 集成任务脚本配置
        :type IntegrationNodeDetails: list of IntegrationNodeDetail
        """
        self._ProjectId = None
        self._TaskId = None
        self._ScriptContent = None
        self._IntegrationNodeDetails = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ScriptContent(self):
        return self._ScriptContent

    @ScriptContent.setter
    def ScriptContent(self, ScriptContent):
        self._ScriptContent = ScriptContent

    @property
    def IntegrationNodeDetails(self):
        return self._IntegrationNodeDetails

    @IntegrationNodeDetails.setter
    def IntegrationNodeDetails(self, IntegrationNodeDetails):
        self._IntegrationNodeDetails = IntegrationNodeDetails


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._ScriptContent = params.get("ScriptContent")
        if params.get("IntegrationNodeDetails") is not None:
            self._IntegrationNodeDetails = []
            for item in params.get("IntegrationNodeDetails"):
                obj = IntegrationNodeDetail()
                obj._deserialize(item)
                self._IntegrationNodeDetails.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTaskScriptResponse(AbstractModel):
    """ModifyTaskScript返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonContent`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonContent()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyWorkflowInfoRequest(AbstractModel):
    """ModifyWorkflowInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WorkflowId: 工作流id
        :type WorkflowId: str
        :param _Owner: 责任人
        :type Owner: str
        :param _OwnerId: 责任人id
        :type OwnerId: str
        :param _WorkflowDesc: 备注
        :type WorkflowDesc: str
        :param _WorkflowName: 工作流名称
        :type WorkflowName: str
        :param _FolderId: 所属文件夹id
        :type FolderId: str
        :param _UserGroupId: 工作流所属用户分组id  若有多个,分号隔开: a;b;c
        :type UserGroupId: str
        :param _UserGroupName: 工作流所属用户分组名称  若有多个,分号隔开: a;b;c
        :type UserGroupName: str
        :param _WorkflowParams: 工作流参数列表
        :type WorkflowParams: list of ParamInfo
        :param _GeneralTaskParams: 用于配置优化参数（线程、内存、CPU核数等），仅作用于Spark SQL节点。多个参数用英文分号分隔。
        :type GeneralTaskParams: list of GeneralTaskParam
        """
        self._ProjectId = None
        self._WorkflowId = None
        self._Owner = None
        self._OwnerId = None
        self._WorkflowDesc = None
        self._WorkflowName = None
        self._FolderId = None
        self._UserGroupId = None
        self._UserGroupName = None
        self._WorkflowParams = None
        self._GeneralTaskParams = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def Owner(self):
        return self._Owner

    @Owner.setter
    def Owner(self, Owner):
        self._Owner = Owner

    @property
    def OwnerId(self):
        return self._OwnerId

    @OwnerId.setter
    def OwnerId(self, OwnerId):
        self._OwnerId = OwnerId

    @property
    def WorkflowDesc(self):
        return self._WorkflowDesc

    @WorkflowDesc.setter
    def WorkflowDesc(self, WorkflowDesc):
        self._WorkflowDesc = WorkflowDesc

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def UserGroupId(self):
        return self._UserGroupId

    @UserGroupId.setter
    def UserGroupId(self, UserGroupId):
        self._UserGroupId = UserGroupId

    @property
    def UserGroupName(self):
        return self._UserGroupName

    @UserGroupName.setter
    def UserGroupName(self, UserGroupName):
        self._UserGroupName = UserGroupName

    @property
    def WorkflowParams(self):
        return self._WorkflowParams

    @WorkflowParams.setter
    def WorkflowParams(self, WorkflowParams):
        self._WorkflowParams = WorkflowParams

    @property
    def GeneralTaskParams(self):
        return self._GeneralTaskParams

    @GeneralTaskParams.setter
    def GeneralTaskParams(self, GeneralTaskParams):
        self._GeneralTaskParams = GeneralTaskParams


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        self._Owner = params.get("Owner")
        self._OwnerId = params.get("OwnerId")
        self._WorkflowDesc = params.get("WorkflowDesc")
        self._WorkflowName = params.get("WorkflowName")
        self._FolderId = params.get("FolderId")
        self._UserGroupId = params.get("UserGroupId")
        self._UserGroupName = params.get("UserGroupName")
        if params.get("WorkflowParams") is not None:
            self._WorkflowParams = []
            for item in params.get("WorkflowParams"):
                obj = ParamInfo()
                obj._deserialize(item)
                self._WorkflowParams.append(obj)
        if params.get("GeneralTaskParams") is not None:
            self._GeneralTaskParams = []
            for item in params.get("GeneralTaskParams"):
                obj = GeneralTaskParam()
                obj._deserialize(item)
                self._GeneralTaskParams.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyWorkflowInfoResponse(AbstractModel):
    """ModifyWorkflowInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: true代表成功，false代表失败
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyWorkflowScheduleRequest(AbstractModel):
    """ModifyWorkflowSchedule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WorkflowId: 工作流id
        :type WorkflowId: str
        :param _DelayTime: 延迟时间，单位分钟
        :type DelayTime: int
        :param _StartupTime: 启动时间
        :type StartupTime: int
        :param _SelfDepend: 自依赖类型  1:有序串行 一次一个 排队, 2: 无序串行 一次一个 不排队， 3:并行 一次多个
        :type SelfDepend: int
        :param _CycleType: "周期类型  0:crontab类型, 1:分钟，2:小时，3:天，4:周，5:月，6:一次性，7:用户驱动，10:弹性周期 周,11:弹性周期 月,12:年,13:即时触发Instant类型，与正常周期调度任务逻辑隔离
        :type CycleType: int
        :param _CycleStep: 步长，间隔时间，最小1
        :type CycleStep: int
        :param _StartTime: 生效开始时间，格式 yyyy-MM-dd HH:mm:ss
        :type StartTime: str
        :param _EndTime: 生效结束时间，格式 yyyy-MM-dd HH:mm:ss
        :type EndTime: str
        :param _TaskAction: 调度配置-弹性周期配置，小时/周/月/年调度才有，小时任务指定每天的0点3点4点跑，则为'0,3,4'。
        :type TaskAction: str
        :param _CrontabExpression: cron表达式  周期类型为crontab调度才需要
        :type CrontabExpression: str
        :param _ExecutionStartTime: 执行时间左闭区间，格式：HH:mm  小时调度才有，例如小时任务, 每日固定区间生效
        :type ExecutionStartTime: str
        :param _ExecutionEndTime: 执行时间右闭区间，格式：HH:mm  小时调度才有，例如小时任务, 每日固定区间生效
        :type ExecutionEndTime: str
        :param _DependencyWorkflow: 工作流依赖 ,yes 或者no
        :type DependencyWorkflow: str
        """
        self._ProjectId = None
        self._WorkflowId = None
        self._DelayTime = None
        self._StartupTime = None
        self._SelfDepend = None
        self._CycleType = None
        self._CycleStep = None
        self._StartTime = None
        self._EndTime = None
        self._TaskAction = None
        self._CrontabExpression = None
        self._ExecutionStartTime = None
        self._ExecutionEndTime = None
        self._DependencyWorkflow = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def DelayTime(self):
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def StartupTime(self):
        return self._StartupTime

    @StartupTime.setter
    def StartupTime(self, StartupTime):
        self._StartupTime = StartupTime

    @property
    def SelfDepend(self):
        return self._SelfDepend

    @SelfDepend.setter
    def SelfDepend(self, SelfDepend):
        self._SelfDepend = SelfDepend

    @property
    def CycleType(self):
        return self._CycleType

    @CycleType.setter
    def CycleType(self, CycleType):
        self._CycleType = CycleType

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TaskAction(self):
        return self._TaskAction

    @TaskAction.setter
    def TaskAction(self, TaskAction):
        self._TaskAction = TaskAction

    @property
    def CrontabExpression(self):
        return self._CrontabExpression

    @CrontabExpression.setter
    def CrontabExpression(self, CrontabExpression):
        self._CrontabExpression = CrontabExpression

    @property
    def ExecutionStartTime(self):
        return self._ExecutionStartTime

    @ExecutionStartTime.setter
    def ExecutionStartTime(self, ExecutionStartTime):
        self._ExecutionStartTime = ExecutionStartTime

    @property
    def ExecutionEndTime(self):
        return self._ExecutionEndTime

    @ExecutionEndTime.setter
    def ExecutionEndTime(self, ExecutionEndTime):
        self._ExecutionEndTime = ExecutionEndTime

    @property
    def DependencyWorkflow(self):
        return self._DependencyWorkflow

    @DependencyWorkflow.setter
    def DependencyWorkflow(self, DependencyWorkflow):
        self._DependencyWorkflow = DependencyWorkflow


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        self._DelayTime = params.get("DelayTime")
        self._StartupTime = params.get("StartupTime")
        self._SelfDepend = params.get("SelfDepend")
        self._CycleType = params.get("CycleType")
        self._CycleStep = params.get("CycleStep")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TaskAction = params.get("TaskAction")
        self._CrontabExpression = params.get("CrontabExpression")
        self._ExecutionStartTime = params.get("ExecutionStartTime")
        self._ExecutionEndTime = params.get("ExecutionEndTime")
        self._DependencyWorkflow = params.get("DependencyWorkflow")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyWorkflowScheduleResponse(AbstractModel):
    """ModifyWorkflowSchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 执行结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class Namespace(AbstractModel):
    """命名空间

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Status: 当前状态
        :type Status: str
        :param _CreatedAt: 创建时间
        :type CreatedAt: str
        """
        self._Name = None
        self._Status = None
        self._CreatedAt = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreatedAt(self):
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Status = params.get("Status")
        self._CreatedAt = params.get("CreatedAt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OfflineInstance(AbstractModel):
    """离线实例

    """

    def __init__(self):
        r"""
        :param _CreateUin: 创建账号
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateUin: str
        :param _OperatorUin: 操作账号
注意：此字段可能返回 null，表示取不到有效值。
        :type OperatorUin: str
        :param _OwnerUin: 主账号
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerUin: str
        :param _AppId: 账号
注意：此字段可能返回 null，表示取不到有效值。
        :type AppId: str
        :param _WorkspaceId: 项目Id
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkspaceId: str
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        :param _IssueId: 下发时间
        :type IssueId: str
        :param _InlongTaskId: 资源组id
注意：此字段可能返回 null，表示取不到有效值。
        :type InlongTaskId: str
        :param _ResourceGroup: 资源组
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroup: str
        :param _TaskRunType: 实例类型
        :type TaskRunType: int
        :param _State: 实例状态
        :type State: str
        :param _StartTime: 开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 最后更新时间
        :type UpdateTime: str
        :param _InstanceKey: 唯一key
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceKey: str
        """
        self._CreateUin = None
        self._OperatorUin = None
        self._OwnerUin = None
        self._AppId = None
        self._WorkspaceId = None
        self._TaskId = None
        self._CurRunDate = None
        self._IssueId = None
        self._InlongTaskId = None
        self._ResourceGroup = None
        self._TaskRunType = None
        self._State = None
        self._StartTime = None
        self._EndTime = None
        self._CreateTime = None
        self._UpdateTime = None
        self._InstanceKey = None

    @property
    def CreateUin(self):
        return self._CreateUin

    @CreateUin.setter
    def CreateUin(self, CreateUin):
        self._CreateUin = CreateUin

    @property
    def OperatorUin(self):
        return self._OperatorUin

    @OperatorUin.setter
    def OperatorUin(self, OperatorUin):
        self._OperatorUin = OperatorUin

    @property
    def OwnerUin(self):
        return self._OwnerUin

    @OwnerUin.setter
    def OwnerUin(self, OwnerUin):
        self._OwnerUin = OwnerUin

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def WorkspaceId(self):
        return self._WorkspaceId

    @WorkspaceId.setter
    def WorkspaceId(self, WorkspaceId):
        self._WorkspaceId = WorkspaceId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def IssueId(self):
        return self._IssueId

    @IssueId.setter
    def IssueId(self, IssueId):
        self._IssueId = IssueId

    @property
    def InlongTaskId(self):
        return self._InlongTaskId

    @InlongTaskId.setter
    def InlongTaskId(self, InlongTaskId):
        self._InlongTaskId = InlongTaskId

    @property
    def ResourceGroup(self):
        return self._ResourceGroup

    @ResourceGroup.setter
    def ResourceGroup(self, ResourceGroup):
        self._ResourceGroup = ResourceGroup

    @property
    def TaskRunType(self):
        return self._TaskRunType

    @TaskRunType.setter
    def TaskRunType(self, TaskRunType):
        self._TaskRunType = TaskRunType

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def InstanceKey(self):
        return self._InstanceKey

    @InstanceKey.setter
    def InstanceKey(self, InstanceKey):
        self._InstanceKey = InstanceKey


    def _deserialize(self, params):
        self._CreateUin = params.get("CreateUin")
        self._OperatorUin = params.get("OperatorUin")
        self._OwnerUin = params.get("OwnerUin")
        self._AppId = params.get("AppId")
        self._WorkspaceId = params.get("WorkspaceId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._IssueId = params.get("IssueId")
        self._InlongTaskId = params.get("InlongTaskId")
        self._ResourceGroup = params.get("ResourceGroup")
        self._TaskRunType = params.get("TaskRunType")
        self._State = params.get("State")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._InstanceKey = params.get("InstanceKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OfflineTaskAddParam(AbstractModel):
    """离线任务新增参数

    """

    def __init__(self):
        r"""
        :param _WorkflowName: 名称
        :type WorkflowName: str
        :param _DependencyWorkflow: 依赖
        :type DependencyWorkflow: str
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _CycleType: 周期
        :type CycleType: int
        :param _CycleStep: 周期间隔
        :type CycleStep: int
        :param _DelayTime: 延迟时间
        :type DelayTime: int
        :param _CrontabExpression: crontab
注意：此字段可能返回 null，表示取不到有效值。
        :type CrontabExpression: str
        :param _RetryWait: 重试等待
        :type RetryWait: int
        :param _Retriable: 是否可以重试
        :type Retriable: int
        :param _TryLimit: 重试限制
        :type TryLimit: int
        :param _RunPriority: 优先级
        :type RunPriority: int
        :param _ProductName: 产品名称
        :type ProductName: str
        :param _SelfDepend: 1 有序串行 一次一个，排队 orderly 
2 无序串行 一次一个，不排队 serial  
3 并行 一次多个 parallel
        :type SelfDepend: int
        :param _TaskAction: 周任务：1是周天，2是周1，7是周6 。
月任务：如具体1，3号则写 "1,3"，指定月末不可和具体号数一起输入，仅能为 "L"
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskAction: str
        :param _ExecutionEndTime: 调度执行结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutionEndTime: str
        :param _ExecutionStartTime: 调度执行开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutionStartTime: str
        """
        self._WorkflowName = None
        self._DependencyWorkflow = None
        self._StartTime = None
        self._EndTime = None
        self._CycleType = None
        self._CycleStep = None
        self._DelayTime = None
        self._CrontabExpression = None
        self._RetryWait = None
        self._Retriable = None
        self._TryLimit = None
        self._RunPriority = None
        self._ProductName = None
        self._SelfDepend = None
        self._TaskAction = None
        self._ExecutionEndTime = None
        self._ExecutionStartTime = None

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def DependencyWorkflow(self):
        return self._DependencyWorkflow

    @DependencyWorkflow.setter
    def DependencyWorkflow(self, DependencyWorkflow):
        self._DependencyWorkflow = DependencyWorkflow

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CycleType(self):
        return self._CycleType

    @CycleType.setter
    def CycleType(self, CycleType):
        self._CycleType = CycleType

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def DelayTime(self):
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def CrontabExpression(self):
        return self._CrontabExpression

    @CrontabExpression.setter
    def CrontabExpression(self, CrontabExpression):
        self._CrontabExpression = CrontabExpression

    @property
    def RetryWait(self):
        return self._RetryWait

    @RetryWait.setter
    def RetryWait(self, RetryWait):
        self._RetryWait = RetryWait

    @property
    def Retriable(self):
        return self._Retriable

    @Retriable.setter
    def Retriable(self, Retriable):
        self._Retriable = Retriable

    @property
    def TryLimit(self):
        return self._TryLimit

    @TryLimit.setter
    def TryLimit(self, TryLimit):
        self._TryLimit = TryLimit

    @property
    def RunPriority(self):
        return self._RunPriority

    @RunPriority.setter
    def RunPriority(self, RunPriority):
        self._RunPriority = RunPriority

    @property
    def ProductName(self):
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def SelfDepend(self):
        return self._SelfDepend

    @SelfDepend.setter
    def SelfDepend(self, SelfDepend):
        self._SelfDepend = SelfDepend

    @property
    def TaskAction(self):
        return self._TaskAction

    @TaskAction.setter
    def TaskAction(self, TaskAction):
        self._TaskAction = TaskAction

    @property
    def ExecutionEndTime(self):
        return self._ExecutionEndTime

    @ExecutionEndTime.setter
    def ExecutionEndTime(self, ExecutionEndTime):
        self._ExecutionEndTime = ExecutionEndTime

    @property
    def ExecutionStartTime(self):
        return self._ExecutionStartTime

    @ExecutionStartTime.setter
    def ExecutionStartTime(self, ExecutionStartTime):
        self._ExecutionStartTime = ExecutionStartTime


    def _deserialize(self, params):
        self._WorkflowName = params.get("WorkflowName")
        self._DependencyWorkflow = params.get("DependencyWorkflow")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._CycleType = params.get("CycleType")
        self._CycleStep = params.get("CycleStep")
        self._DelayTime = params.get("DelayTime")
        self._CrontabExpression = params.get("CrontabExpression")
        self._RetryWait = params.get("RetryWait")
        self._Retriable = params.get("Retriable")
        self._TryLimit = params.get("TryLimit")
        self._RunPriority = params.get("RunPriority")
        self._ProductName = params.get("ProductName")
        self._SelfDepend = params.get("SelfDepend")
        self._TaskAction = params.get("TaskAction")
        self._ExecutionEndTime = params.get("ExecutionEndTime")
        self._ExecutionStartTime = params.get("ExecutionStartTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OperateResult(AbstractModel):
    """操作结果

    """

    def __init__(self):
        r"""
        :param _Result: 操作结果；true表示成功；false表示失败
        :type Result: bool
        :param _ErrorId: 错误编号
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorId: str
        :param _ErrorDesc: 操作信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorDesc: str
        """
        self._Result = None
        self._ErrorId = None
        self._ErrorDesc = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrorId(self):
        return self._ErrorId

    @ErrorId.setter
    def ErrorId(self, ErrorId):
        self._ErrorId = ErrorId

    @property
    def ErrorDesc(self):
        return self._ErrorDesc

    @ErrorDesc.setter
    def ErrorDesc(self, ErrorDesc):
        self._ErrorDesc = ErrorDesc


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._ErrorId = params.get("ErrorId")
        self._ErrorDesc = params.get("ErrorDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrderField(AbstractModel):
    """通用排序字段

    """

    def __init__(self):
        r"""
        :param _Name: 排序字段名称
        :type Name: str
        :param _Direction: 排序方向：ASC|DESC
        :type Direction: str
        """
        self._Name = None
        self._Direction = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Direction(self):
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Direction = params.get("Direction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrganizationalFunction(AbstractModel):
    """包含层级信息的函数

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _DisplayName: 展示名称
        :type DisplayName: str
        :param _LayerPath: 层级路径
        :type LayerPath: str
        :param _ParentLayerPath: 上级层级路径
        :type ParentLayerPath: str
        :param _Type: 函数类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Kind: 函数分类：窗口函数、聚合函数、日期函数......
注意：此字段可能返回 null，表示取不到有效值。
        :type Kind: str
        :param _Category: 函数种类：系统函数、自定义函数
注意：此字段可能返回 null，表示取不到有效值。
        :type Category: str
        :param _Status: 函数状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _Description: 函数说明
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Usage: 函数用法
注意：此字段可能返回 null，表示取不到有效值。
        :type Usage: str
        :param _ParamDesc: 函数参数说明
注意：此字段可能返回 null，表示取不到有效值。
        :type ParamDesc: str
        :param _ReturnDesc: 函数返回值说明
注意：此字段可能返回 null，表示取不到有效值。
        :type ReturnDesc: str
        :param _Example: 函数示例
注意：此字段可能返回 null，表示取不到有效值。
        :type Example: str
        :param _ClusterIdentifier: 集群实例引擎 ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterIdentifier: str
        :param _FuncId: 函数 ID
注意：此字段可能返回 null，表示取不到有效值。
        :type FuncId: str
        :param _ClassName: 函数类名
注意：此字段可能返回 null，表示取不到有效值。
        :type ClassName: str
        :param _ResourceList: 函数资源列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceList: list of FunctionVersion
        :param _OperatorUserIds: 操作人 ID 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type OperatorUserIds: list of int
        :param _OwnerUserIds: 公有云 Owner ID 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerUserIds: list of int
        :param _DbName: 数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DbName: str
        :param _SubmitErrorMsg: 提交失败错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :type SubmitErrorMsg: str
        """
        self._Name = None
        self._DisplayName = None
        self._LayerPath = None
        self._ParentLayerPath = None
        self._Type = None
        self._Kind = None
        self._Category = None
        self._Status = None
        self._Description = None
        self._Usage = None
        self._ParamDesc = None
        self._ReturnDesc = None
        self._Example = None
        self._ClusterIdentifier = None
        self._FuncId = None
        self._ClassName = None
        self._ResourceList = None
        self._OperatorUserIds = None
        self._OwnerUserIds = None
        self._DbName = None
        self._SubmitErrorMsg = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DisplayName(self):
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def LayerPath(self):
        return self._LayerPath

    @LayerPath.setter
    def LayerPath(self, LayerPath):
        self._LayerPath = LayerPath

    @property
    def ParentLayerPath(self):
        return self._ParentLayerPath

    @ParentLayerPath.setter
    def ParentLayerPath(self, ParentLayerPath):
        self._ParentLayerPath = ParentLayerPath

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Kind(self):
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Usage(self):
        return self._Usage

    @Usage.setter
    def Usage(self, Usage):
        self._Usage = Usage

    @property
    def ParamDesc(self):
        return self._ParamDesc

    @ParamDesc.setter
    def ParamDesc(self, ParamDesc):
        self._ParamDesc = ParamDesc

    @property
    def ReturnDesc(self):
        return self._ReturnDesc

    @ReturnDesc.setter
    def ReturnDesc(self, ReturnDesc):
        self._ReturnDesc = ReturnDesc

    @property
    def Example(self):
        return self._Example

    @Example.setter
    def Example(self, Example):
        self._Example = Example

    @property
    def ClusterIdentifier(self):
        return self._ClusterIdentifier

    @ClusterIdentifier.setter
    def ClusterIdentifier(self, ClusterIdentifier):
        self._ClusterIdentifier = ClusterIdentifier

    @property
    def FuncId(self):
        return self._FuncId

    @FuncId.setter
    def FuncId(self, FuncId):
        self._FuncId = FuncId

    @property
    def ClassName(self):
        return self._ClassName

    @ClassName.setter
    def ClassName(self, ClassName):
        self._ClassName = ClassName

    @property
    def ResourceList(self):
        return self._ResourceList

    @ResourceList.setter
    def ResourceList(self, ResourceList):
        self._ResourceList = ResourceList

    @property
    def OperatorUserIds(self):
        return self._OperatorUserIds

    @OperatorUserIds.setter
    def OperatorUserIds(self, OperatorUserIds):
        self._OperatorUserIds = OperatorUserIds

    @property
    def OwnerUserIds(self):
        return self._OwnerUserIds

    @OwnerUserIds.setter
    def OwnerUserIds(self, OwnerUserIds):
        self._OwnerUserIds = OwnerUserIds

    @property
    def DbName(self):
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def SubmitErrorMsg(self):
        return self._SubmitErrorMsg

    @SubmitErrorMsg.setter
    def SubmitErrorMsg(self, SubmitErrorMsg):
        self._SubmitErrorMsg = SubmitErrorMsg


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._DisplayName = params.get("DisplayName")
        self._LayerPath = params.get("LayerPath")
        self._ParentLayerPath = params.get("ParentLayerPath")
        self._Type = params.get("Type")
        self._Kind = params.get("Kind")
        self._Category = params.get("Category")
        self._Status = params.get("Status")
        self._Description = params.get("Description")
        self._Usage = params.get("Usage")
        self._ParamDesc = params.get("ParamDesc")
        self._ReturnDesc = params.get("ReturnDesc")
        self._Example = params.get("Example")
        self._ClusterIdentifier = params.get("ClusterIdentifier")
        self._FuncId = params.get("FuncId")
        self._ClassName = params.get("ClassName")
        if params.get("ResourceList") is not None:
            self._ResourceList = []
            for item in params.get("ResourceList"):
                obj = FunctionVersion()
                obj._deserialize(item)
                self._ResourceList.append(obj)
        self._OperatorUserIds = params.get("OperatorUserIds")
        self._OwnerUserIds = params.get("OwnerUserIds")
        self._DbName = params.get("DbName")
        self._SubmitErrorMsg = params.get("SubmitErrorMsg")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParamInfo(AbstractModel):
    """参数参数

    """

    def __init__(self):
        r"""
        :param _ParamKey: 参数名
        :type ParamKey: str
        :param _ParamValue: 参数值
        :type ParamValue: str
        """
        self._ParamKey = None
        self._ParamValue = None

    @property
    def ParamKey(self):
        return self._ParamKey

    @ParamKey.setter
    def ParamKey(self, ParamKey):
        self._ParamKey = ParamKey

    @property
    def ParamValue(self):
        return self._ParamValue

    @ParamValue.setter
    def ParamValue(self, ParamValue):
        self._ParamValue = ParamValue


    def _deserialize(self, params):
        self._ParamKey = params.get("ParamKey")
        self._ParamValue = params.get("ParamValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Partition(AbstractModel):
    """分区参数

    """

    def __init__(self):
        r"""
        :param _Transform: 分区转换策略
        :type Transform: str
        :param _Name: 分区字段名
        :type Name: str
        :param _TransformArgs: 策略参数
        :type TransformArgs: list of str
        """
        self._Transform = None
        self._Name = None
        self._TransformArgs = None

    @property
    def Transform(self):
        return self._Transform

    @Transform.setter
    def Transform(self, Transform):
        self._Transform = Transform

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TransformArgs(self):
        return self._TransformArgs

    @TransformArgs.setter
    def TransformArgs(self, TransformArgs):
        self._TransformArgs = TransformArgs


    def _deserialize(self, params):
        self._Transform = params.get("Transform")
        self._Name = params.get("Name")
        self._TransformArgs = params.get("TransformArgs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProdSchedulerTask(AbstractModel):
    """数据质量生产调度任务业务实体

    """

    def __init__(self):
        r"""
        :param _WorkflowId: 生产调度任务工作流ID
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowId: str
        :param _TaskId: 生产调度任务Id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _TaskName: 生产调度任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        """
        self._WorkflowId = None
        self._TaskId = None
        self._TaskName = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Property(AbstractModel):
    """dlc建表属性

    """

    def __init__(self):
        r"""
        :param _Key: key值
        :type Key: str
        :param _Value: value值
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QualityScore(AbstractModel):
    """质量评分

    """

    def __init__(self):
        r"""
        :param _CompositeScore: 综合分数
注意：此字段可能返回 null，表示取不到有效值。
        :type CompositeScore: float
        :param _ScoringDistribution: 评分分布
注意：此字段可能返回 null，表示取不到有效值。
        :type ScoringDistribution: list of TableScoreStatisticsInfo
        :param _TotalTableNumber: 总表数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalTableNumber: int
        """
        self._CompositeScore = None
        self._ScoringDistribution = None
        self._TotalTableNumber = None

    @property
    def CompositeScore(self):
        return self._CompositeScore

    @CompositeScore.setter
    def CompositeScore(self, CompositeScore):
        self._CompositeScore = CompositeScore

    @property
    def ScoringDistribution(self):
        return self._ScoringDistribution

    @ScoringDistribution.setter
    def ScoringDistribution(self, ScoringDistribution):
        self._ScoringDistribution = ScoringDistribution

    @property
    def TotalTableNumber(self):
        return self._TotalTableNumber

    @TotalTableNumber.setter
    def TotalTableNumber(self, TotalTableNumber):
        self._TotalTableNumber = TotalTableNumber


    def _deserialize(self, params):
        self._CompositeScore = params.get("CompositeScore")
        if params.get("ScoringDistribution") is not None:
            self._ScoringDistribution = []
            for item in params.get("ScoringDistribution"):
                obj = TableScoreStatisticsInfo()
                obj._deserialize(item)
                self._ScoringDistribution.append(obj)
        self._TotalTableNumber = params.get("TotalTableNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QualityScoreTrend(AbstractModel):
    """质量评分趋势

    """

    def __init__(self):
        r"""
        :param _AverageScore: 周期平均分
注意：此字段可能返回 null，表示取不到有效值。
        :type AverageScore: float
        :param _DailyScoreList: 日评分列表
注意：此字段可能返回 null，表示取不到有效值。
        :type DailyScoreList: list of DailyScoreInfo
        """
        self._AverageScore = None
        self._DailyScoreList = None

    @property
    def AverageScore(self):
        return self._AverageScore

    @AverageScore.setter
    def AverageScore(self, AverageScore):
        self._AverageScore = AverageScore

    @property
    def DailyScoreList(self):
        return self._DailyScoreList

    @DailyScoreList.setter
    def DailyScoreList(self, DailyScoreList):
        self._DailyScoreList = DailyScoreList


    def _deserialize(self, params):
        self._AverageScore = params.get("AverageScore")
        if params.get("DailyScoreList") is not None:
            self._DailyScoreList = []
            for item in params.get("DailyScoreList"):
                obj = DailyScoreInfo()
                obj._deserialize(item)
                self._DailyScoreList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RealTimeTaskInstanceNodeInfo(AbstractModel):
    """实时任务实例当前的节点信息

    """

    def __init__(self):
        r"""
        :param _TaskName: 任务名
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _TaskId: 任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _InstanceNodeInfoList: 实时任务实例节点信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceNodeInfoList: list of InstanceNodeInfo
        """
        self._TaskName = None
        self._TaskId = None
        self._InstanceNodeInfoList = None

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def InstanceNodeInfoList(self):
        return self._InstanceNodeInfoList

    @InstanceNodeInfoList.setter
    def InstanceNodeInfoList(self, InstanceNodeInfoList):
        self._InstanceNodeInfoList = InstanceNodeInfoList


    def _deserialize(self, params):
        self._TaskName = params.get("TaskName")
        self._TaskId = params.get("TaskId")
        if params.get("InstanceNodeInfoList") is not None:
            self._InstanceNodeInfoList = []
            for item in params.get("InstanceNodeInfoList"):
                obj = InstanceNodeInfo()
                obj._deserialize(item)
                self._InstanceNodeInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RealTimeTaskSpeed(AbstractModel):
    """实时任务同步速度趋势

    """

    def __init__(self):
        r"""
        :param _RecordsSpeedList: 同步速度条/s列表
        :type RecordsSpeedList: list of RecordsSpeed
        :param _BytesSpeedList: 同步速度字节/s列表
        :type BytesSpeedList: list of BytesSpeed
        """
        self._RecordsSpeedList = None
        self._BytesSpeedList = None

    @property
    def RecordsSpeedList(self):
        return self._RecordsSpeedList

    @RecordsSpeedList.setter
    def RecordsSpeedList(self, RecordsSpeedList):
        self._RecordsSpeedList = RecordsSpeedList

    @property
    def BytesSpeedList(self):
        return self._BytesSpeedList

    @BytesSpeedList.setter
    def BytesSpeedList(self, BytesSpeedList):
        self._BytesSpeedList = BytesSpeedList


    def _deserialize(self, params):
        if params.get("RecordsSpeedList") is not None:
            self._RecordsSpeedList = []
            for item in params.get("RecordsSpeedList"):
                obj = RecordsSpeed()
                obj._deserialize(item)
                self._RecordsSpeedList.append(obj)
        if params.get("BytesSpeedList") is not None:
            self._BytesSpeedList = []
            for item in params.get("BytesSpeedList"):
                obj = BytesSpeed()
                obj._deserialize(item)
                self._BytesSpeedList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RecordField(AbstractModel):
    """通用记录字段

    """

    def __init__(self):
        r"""
        :param _Name: 字段名称
        :type Name: str
        :param _Value: 字段值
        :type Value: str
        """
        self._Name = None
        self._Value = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RecordsSpeed(AbstractModel):
    """实时任务同步速度 条/s

    """

    def __init__(self):
        r"""
        :param _NodeType: 节点类型
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeType: str
        :param _NodeName: 节点名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeName: str
        :param _Values: 速度值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Values: list of SpeedValue
        """
        self._NodeType = None
        self._NodeName = None
        self._Values = None

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._NodeType = params.get("NodeType")
        self._NodeName = params.get("NodeName")
        if params.get("Values") is not None:
            self._Values = []
            for item in params.get("Values"):
                obj = SpeedValue()
                obj._deserialize(item)
                self._Values.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegisterEventListenerRequest(AbstractModel):
    """RegisterEventListener请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Key: 关键字，如果是任务，则传任务Id
        :type Key: str
        :param _EventName: 事件名称
        :type EventName: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _Type: 事件类型，默认 REST_API
        :type Type: str
        :param _Properties: 配置信息，比如最长等待时间1天配置json：{"maxWaitEventTime":1,"maxWaitEventTimeUnit":"DAYS"}
        :type Properties: str
        """
        self._Key = None
        self._EventName = None
        self._ProjectId = None
        self._Type = None
        self._Properties = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def EventName(self):
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Properties(self):
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._EventName = params.get("EventName")
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        self._Properties = params.get("Properties")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegisterEventListenerResponse(AbstractModel):
    """RegisterEventListener返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 成功或者失败
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchReturn`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchReturn()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class RegisterEventRequest(AbstractModel):
    """RegisterEvent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Name: 事件名称，支持英文、数字和下划线，最长20个字符, 不能以数字下划线开头。
        :type Name: str
        :param _EventSubType: 事件分割类型，周期类型: DAY，HOUR，MIN，SECOND
        :type EventSubType: str
        :param _EventBroadcastType: 广播：BROADCAST,单播：SINGLE
        :type EventBroadcastType: str
        :param _TimeUnit: 周期类型为天和小时为HOURS ，周期类型为分钟 ：MINUTES,周期类型为秒：SECONDS
        :type TimeUnit: str
        :param _Owner: TBDS 事件所属人
        :type Owner: str
        :param _EventType: 事件类型，默认值：TIME_SERIES
        :type EventType: str
        :param _DimensionFormat: 对应day： yyyyMMdd，对应HOUR：yyyyMMddHH，对应MIN：yyyyMMddHHmm，对应SECOND：yyyyMMddHHmmss
        :type DimensionFormat: str
        :param _TimeToLive: 存活时间
        :type TimeToLive: int
        :param _Description: 事件描述
        :type Description: str
        """
        self._ProjectId = None
        self._Name = None
        self._EventSubType = None
        self._EventBroadcastType = None
        self._TimeUnit = None
        self._Owner = None
        self._EventType = None
        self._DimensionFormat = None
        self._TimeToLive = None
        self._Description = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def EventSubType(self):
        return self._EventSubType

    @EventSubType.setter
    def EventSubType(self, EventSubType):
        self._EventSubType = EventSubType

    @property
    def EventBroadcastType(self):
        return self._EventBroadcastType

    @EventBroadcastType.setter
    def EventBroadcastType(self, EventBroadcastType):
        self._EventBroadcastType = EventBroadcastType

    @property
    def TimeUnit(self):
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def Owner(self):
        return self._Owner

    @Owner.setter
    def Owner(self, Owner):
        self._Owner = Owner

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def DimensionFormat(self):
        return self._DimensionFormat

    @DimensionFormat.setter
    def DimensionFormat(self, DimensionFormat):
        self._DimensionFormat = DimensionFormat

    @property
    def TimeToLive(self):
        return self._TimeToLive

    @TimeToLive.setter
    def TimeToLive(self, TimeToLive):
        self._TimeToLive = TimeToLive

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Name = params.get("Name")
        self._EventSubType = params.get("EventSubType")
        self._EventBroadcastType = params.get("EventBroadcastType")
        self._TimeUnit = params.get("TimeUnit")
        self._Owner = params.get("Owner")
        self._EventType = params.get("EventType")
        self._DimensionFormat = params.get("DimensionFormat")
        self._TimeToLive = params.get("TimeToLive")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegisterEventResponse(AbstractModel):
    """RegisterEvent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 成功或者失败
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchReturn`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchReturn()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class RerunInstancesRequest(AbstractModel):
    """RerunInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Instances: 实例嵌套集合
        :type Instances: list of InstanceInfo
        :param _CheckFather: 检查父任务类型, true: 检查父任务; false: 不检查父任务
        :type CheckFather: bool
        :param _RerunType: 重跑类型, 1: 自身; 3: 孩子; 2: 自身以及孩子
        :type RerunType: str
        :param _DependentWay: 实例依赖方式, 1: 自依赖; 2: 任务依赖; 3: 自依赖及父子依赖
        :type DependentWay: str
        :param _SkipEventListening: 重跑忽略事件监听与否
        :type SkipEventListening: bool
        :param _SonInstanceType: 下游实例范围 1: 所在工作流 2: 所在项目 3: 所有跨工作流依赖的项目
        :type SonInstanceType: str
        """
        self._ProjectId = None
        self._Instances = None
        self._CheckFather = None
        self._RerunType = None
        self._DependentWay = None
        self._SkipEventListening = None
        self._SonInstanceType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CheckFather(self):
        return self._CheckFather

    @CheckFather.setter
    def CheckFather(self, CheckFather):
        self._CheckFather = CheckFather

    @property
    def RerunType(self):
        return self._RerunType

    @RerunType.setter
    def RerunType(self, RerunType):
        self._RerunType = RerunType

    @property
    def DependentWay(self):
        return self._DependentWay

    @DependentWay.setter
    def DependentWay(self, DependentWay):
        self._DependentWay = DependentWay

    @property
    def SkipEventListening(self):
        return self._SkipEventListening

    @SkipEventListening.setter
    def SkipEventListening(self, SkipEventListening):
        self._SkipEventListening = SkipEventListening

    @property
    def SonInstanceType(self):
        return self._SonInstanceType

    @SonInstanceType.setter
    def SonInstanceType(self, SonInstanceType):
        self._SonInstanceType = SonInstanceType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CheckFather = params.get("CheckFather")
        self._RerunType = params.get("RerunType")
        self._DependentWay = params.get("DependentWay")
        self._SkipEventListening = params.get("SkipEventListening")
        self._SonInstanceType = params.get("SonInstanceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RerunInstancesResponse(AbstractModel):
    """RerunInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回实例批量终止结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ResourcePathTree(AbstractModel):
    """资源管理目录树节点

    """

    def __init__(self):
        r"""
        :param _Name: 资源名字
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _IsLeaf: 是否为叶子节点
注意：此字段可能返回 null，表示取不到有效值。
        :type IsLeaf: bool
        :param _ResourceId: 资源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceId: str
        :param _LocalPath: 本地路径
注意：此字段可能返回 null，表示取不到有效值。
        :type LocalPath: str
        :param _RemotePath: 远程路径
注意：此字段可能返回 null，表示取不到有效值。
        :type RemotePath: str
        :param _FileExtensionType: 文件类型
注意：此字段可能返回 null，表示取不到有效值。
        :type FileExtensionType: str
        :param _Size: 文件大小
注意：此字段可能返回 null，表示取不到有效值。
        :type Size: int
        :param _Md5Value: 文件MD5值
注意：此字段可能返回 null，表示取不到有效值。
        :type Md5Value: str
        :param _OwnerName: 文件拥有者名字
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerName: str
        :param _UpdateUser: 更新人
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateUser: str
        :param _UpdateUserId: 文件更新人uin
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateUserId: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: int
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: int
        :param _CosBucket: Cos存储桶名
注意：此字段可能返回 null，表示取不到有效值。
        :type CosBucket: str
        :param _CosRegion: Cos地域
注意：此字段可能返回 null，表示取不到有效值。
        :type CosRegion: str
        :param _ExtraInfo: 额外信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtraInfo: str
        """
        self._Name = None
        self._IsLeaf = None
        self._ResourceId = None
        self._LocalPath = None
        self._RemotePath = None
        self._FileExtensionType = None
        self._Size = None
        self._Md5Value = None
        self._OwnerName = None
        self._UpdateUser = None
        self._UpdateUserId = None
        self._CreateTime = None
        self._UpdateTime = None
        self._CosBucket = None
        self._CosRegion = None
        self._ExtraInfo = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def IsLeaf(self):
        return self._IsLeaf

    @IsLeaf.setter
    def IsLeaf(self, IsLeaf):
        self._IsLeaf = IsLeaf

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def LocalPath(self):
        return self._LocalPath

    @LocalPath.setter
    def LocalPath(self, LocalPath):
        self._LocalPath = LocalPath

    @property
    def RemotePath(self):
        return self._RemotePath

    @RemotePath.setter
    def RemotePath(self, RemotePath):
        self._RemotePath = RemotePath

    @property
    def FileExtensionType(self):
        return self._FileExtensionType

    @FileExtensionType.setter
    def FileExtensionType(self, FileExtensionType):
        self._FileExtensionType = FileExtensionType

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Md5Value(self):
        return self._Md5Value

    @Md5Value.setter
    def Md5Value(self, Md5Value):
        self._Md5Value = Md5Value

    @property
    def OwnerName(self):
        return self._OwnerName

    @OwnerName.setter
    def OwnerName(self, OwnerName):
        self._OwnerName = OwnerName

    @property
    def UpdateUser(self):
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateUserId(self):
        return self._UpdateUserId

    @UpdateUserId.setter
    def UpdateUserId(self, UpdateUserId):
        self._UpdateUserId = UpdateUserId

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def CosBucket(self):
        return self._CosBucket

    @CosBucket.setter
    def CosBucket(self, CosBucket):
        self._CosBucket = CosBucket

    @property
    def CosRegion(self):
        return self._CosRegion

    @CosRegion.setter
    def CosRegion(self, CosRegion):
        self._CosRegion = CosRegion

    @property
    def ExtraInfo(self):
        return self._ExtraInfo

    @ExtraInfo.setter
    def ExtraInfo(self, ExtraInfo):
        self._ExtraInfo = ExtraInfo


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._IsLeaf = params.get("IsLeaf")
        self._ResourceId = params.get("ResourceId")
        self._LocalPath = params.get("LocalPath")
        self._RemotePath = params.get("RemotePath")
        self._FileExtensionType = params.get("FileExtensionType")
        self._Size = params.get("Size")
        self._Md5Value = params.get("Md5Value")
        self._OwnerName = params.get("OwnerName")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateUserId = params.get("UpdateUserId")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._CosBucket = params.get("CosBucket")
        self._CosRegion = params.get("CosRegion")
        self._ExtraInfo = params.get("ExtraInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartInLongAgentRequest(AbstractModel):
    """RestartInLongAgent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentId: 采集器ID
        :type AgentId: str
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        """
        self._AgentId = None
        self._ProjectId = None

    @property
    def AgentId(self):
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._AgentId = params.get("AgentId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartInLongAgentResponse(AbstractModel):
    """RestartInLongAgent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResumeIntegrationTaskRequest(AbstractModel):
    """ResumeIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _Event: 事件类型(START, STOP, SUSPEND, RESUME, COMMIT, TIMESTAMP)
        :type Event: str
        :param _ExtConfig: 额外参数
        :type ExtConfig: list of RecordField
        """
        self._TaskId = None
        self._ProjectId = None
        self._Event = None
        self._ExtConfig = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Event(self):
        return self._Event

    @Event.setter
    def Event(self, Event):
        self._Event = Event

    @property
    def ExtConfig(self):
        return self._ExtConfig

    @ExtConfig.setter
    def ExtConfig(self, ExtConfig):
        self._ExtConfig = ExtConfig


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._Event = params.get("Event")
        if params.get("ExtConfig") is not None:
            self._ExtConfig = []
            for item in params.get("ExtConfig"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtConfig.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResumeIntegrationTaskResponse(AbstractModel):
    """ResumeIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作成功与否标识
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class RobAndLockIntegrationTaskRequest(AbstractModel):
    """RobAndLockIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型：201. stream,   202. offline
        :type TaskType: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RobAndLockIntegrationTaskResponse(AbstractModel):
    """RobAndLockIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RobLockState: 抢锁状态
        :type RobLockState: :class:`tencentcloud.wedata.v20210820.models.RobLockState`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RobLockState = None
        self._RequestId = None

    @property
    def RobLockState(self):
        return self._RobLockState

    @RobLockState.setter
    def RobLockState(self, RobLockState):
        self._RobLockState = RobLockState

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RobLockState") is not None:
            self._RobLockState = RobLockState()
            self._RobLockState._deserialize(params.get("RobLockState"))
        self._RequestId = params.get("RequestId")


class RobLockState(AbstractModel):
    """抢锁状态：是否可以抢锁和当前持锁人

    """

    def __init__(self):
        r"""
        :param _IsRob: 是否可以抢锁
        :type IsRob: bool
        :param _Locker: 当前持锁人
        :type Locker: str
        """
        self._IsRob = None
        self._Locker = None

    @property
    def IsRob(self):
        return self._IsRob

    @IsRob.setter
    def IsRob(self, IsRob):
        self._IsRob = IsRob

    @property
    def Locker(self):
        return self._Locker

    @Locker.setter
    def Locker(self, Locker):
        self._Locker = Locker


    def _deserialize(self, params):
        self._IsRob = params.get("IsRob")
        self._Locker = params.get("Locker")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Rule(AbstractModel):
    """数据质量规则

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: int
        :param _RuleGroupId: 规则组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleGroupId: int
        :param _TableId: 数据表Id
注意：此字段可能返回 null，表示取不到有效值。
        :type TableId: str
        :param _Name: 规则名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Type: 规则类型 1.系统模版, 2.自定义模版, 3.自定义SQL
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: int
        :param _RuleTemplateId: 规则模板Id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleTemplateId: int
        :param _RuleTemplateContent: 规则模板概述
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleTemplateContent: str
        :param _QualityDim: 规则所属质量维度 1：准确性，2：唯一性，3：完整性，4：一致性，5：及时性，6：有效性
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityDim: int
        :param _SourceObjectType: 规则适用的源数据对象类型（1：常量，2：离线表级，3：离线字段级别）
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceObjectType: int
        :param _SourceObjectDataType: 规则适用的源数据对象类型（1：数值，2：字符串）
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceObjectDataType: int
        :param _SourceObjectDataTypeName: 源字段详细类型，INT、STRING
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceObjectDataTypeName: str
        :param _SourceObjectValue: 源字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceObjectValue: str
        :param _ConditionType: 检测范围 1.全表, 2.条件扫描
注意：此字段可能返回 null，表示取不到有效值。
        :type ConditionType: int
        :param _ConditionExpression: 条件扫描WHERE条件表达式
注意：此字段可能返回 null，表示取不到有效值。
        :type ConditionExpression: str
        :param _CustomSql: 自定义SQL
注意：此字段可能返回 null，表示取不到有效值。
        :type CustomSql: str
        :param _CompareRule: 报警触发条件
注意：此字段可能返回 null，表示取不到有效值。
        :type CompareRule: :class:`tencentcloud.wedata.v20210820.models.CompareRule`
        :param _AlarmLevel: 报警触发级别 1.低, 2.中, 3.高
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmLevel: int
        :param _Description: 规则描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Operator: 规则配置人
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: str
        :param _TargetDatabaseId: 目标库Id
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetDatabaseId: str
        :param _TargetDatabaseName: 目标库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetDatabaseName: str
        :param _TargetTableId: 目标表Id
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetTableId: str
        :param _TargetTableName: 目标表名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetTableName: str
        :param _TargetConditionExpr: 目标字段过滤条件表达式
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetConditionExpr: str
        :param _RelConditionExpr: 源字段与目标字段关联条件on表达式
注意：此字段可能返回 null，表示取不到有效值。
        :type RelConditionExpr: str
        :param _FieldConfig: 自定义模版sql表达式参数
注意：此字段可能返回 null，表示取不到有效值。
        :type FieldConfig: :class:`tencentcloud.wedata.v20210820.models.RuleFieldConfig`
        :param _MultiSourceFlag: 是否关联多表
注意：此字段可能返回 null，表示取不到有效值。
        :type MultiSourceFlag: bool
        :param _WhereFlag: 是否where参数
注意：此字段可能返回 null，表示取不到有效值。
        :type WhereFlag: bool
        :param _TemplateSql: 模版原始SQL
注意：此字段可能返回 null，表示取不到有效值。
        :type TemplateSql: str
        :param _SubQualityDim: 模版子维度：0.父维度类型,1.一致性: 枚举范围一致性,2.一致性：数值范围一致性,3.一致性：字段数据相关性
注意：此字段可能返回 null，表示取不到有效值。
        :type SubQualityDim: int
        :param _TargetObjectType: 规则适用的目标数据对象类型（1：常量，2：离线表级，3：离线字段级别）
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetObjectType: int
        :param _TargetObjectDataType: 规则适用的目标数据对象类型（1：数值，2：字符串）
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetObjectDataType: int
        :param _TargetObjectDataTypeName: 目标字段详细类型，INT、STRING
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetObjectDataTypeName: str
        :param _TargetObjectValue: 目标字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetObjectValue: str
        :param _SourceEngineTypes: 源端对应的引擎类型
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceEngineTypes: list of int non-negative
        """
        self._RuleId = None
        self._RuleGroupId = None
        self._TableId = None
        self._Name = None
        self._Type = None
        self._RuleTemplateId = None
        self._RuleTemplateContent = None
        self._QualityDim = None
        self._SourceObjectType = None
        self._SourceObjectDataType = None
        self._SourceObjectDataTypeName = None
        self._SourceObjectValue = None
        self._ConditionType = None
        self._ConditionExpression = None
        self._CustomSql = None
        self._CompareRule = None
        self._AlarmLevel = None
        self._Description = None
        self._Operator = None
        self._TargetDatabaseId = None
        self._TargetDatabaseName = None
        self._TargetTableId = None
        self._TargetTableName = None
        self._TargetConditionExpr = None
        self._RelConditionExpr = None
        self._FieldConfig = None
        self._MultiSourceFlag = None
        self._WhereFlag = None
        self._TemplateSql = None
        self._SubQualityDim = None
        self._TargetObjectType = None
        self._TargetObjectDataType = None
        self._TargetObjectDataTypeName = None
        self._TargetObjectValue = None
        self._SourceEngineTypes = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def RuleTemplateId(self):
        return self._RuleTemplateId

    @RuleTemplateId.setter
    def RuleTemplateId(self, RuleTemplateId):
        self._RuleTemplateId = RuleTemplateId

    @property
    def RuleTemplateContent(self):
        return self._RuleTemplateContent

    @RuleTemplateContent.setter
    def RuleTemplateContent(self, RuleTemplateContent):
        self._RuleTemplateContent = RuleTemplateContent

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def SourceObjectType(self):
        return self._SourceObjectType

    @SourceObjectType.setter
    def SourceObjectType(self, SourceObjectType):
        self._SourceObjectType = SourceObjectType

    @property
    def SourceObjectDataType(self):
        return self._SourceObjectDataType

    @SourceObjectDataType.setter
    def SourceObjectDataType(self, SourceObjectDataType):
        self._SourceObjectDataType = SourceObjectDataType

    @property
    def SourceObjectDataTypeName(self):
        return self._SourceObjectDataTypeName

    @SourceObjectDataTypeName.setter
    def SourceObjectDataTypeName(self, SourceObjectDataTypeName):
        self._SourceObjectDataTypeName = SourceObjectDataTypeName

    @property
    def SourceObjectValue(self):
        return self._SourceObjectValue

    @SourceObjectValue.setter
    def SourceObjectValue(self, SourceObjectValue):
        self._SourceObjectValue = SourceObjectValue

    @property
    def ConditionType(self):
        return self._ConditionType

    @ConditionType.setter
    def ConditionType(self, ConditionType):
        self._ConditionType = ConditionType

    @property
    def ConditionExpression(self):
        return self._ConditionExpression

    @ConditionExpression.setter
    def ConditionExpression(self, ConditionExpression):
        self._ConditionExpression = ConditionExpression

    @property
    def CustomSql(self):
        return self._CustomSql

    @CustomSql.setter
    def CustomSql(self, CustomSql):
        self._CustomSql = CustomSql

    @property
    def CompareRule(self):
        return self._CompareRule

    @CompareRule.setter
    def CompareRule(self, CompareRule):
        self._CompareRule = CompareRule

    @property
    def AlarmLevel(self):
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def TargetDatabaseId(self):
        return self._TargetDatabaseId

    @TargetDatabaseId.setter
    def TargetDatabaseId(self, TargetDatabaseId):
        self._TargetDatabaseId = TargetDatabaseId

    @property
    def TargetDatabaseName(self):
        return self._TargetDatabaseName

    @TargetDatabaseName.setter
    def TargetDatabaseName(self, TargetDatabaseName):
        self._TargetDatabaseName = TargetDatabaseName

    @property
    def TargetTableId(self):
        return self._TargetTableId

    @TargetTableId.setter
    def TargetTableId(self, TargetTableId):
        self._TargetTableId = TargetTableId

    @property
    def TargetTableName(self):
        return self._TargetTableName

    @TargetTableName.setter
    def TargetTableName(self, TargetTableName):
        self._TargetTableName = TargetTableName

    @property
    def TargetConditionExpr(self):
        return self._TargetConditionExpr

    @TargetConditionExpr.setter
    def TargetConditionExpr(self, TargetConditionExpr):
        self._TargetConditionExpr = TargetConditionExpr

    @property
    def RelConditionExpr(self):
        return self._RelConditionExpr

    @RelConditionExpr.setter
    def RelConditionExpr(self, RelConditionExpr):
        self._RelConditionExpr = RelConditionExpr

    @property
    def FieldConfig(self):
        return self._FieldConfig

    @FieldConfig.setter
    def FieldConfig(self, FieldConfig):
        self._FieldConfig = FieldConfig

    @property
    def MultiSourceFlag(self):
        return self._MultiSourceFlag

    @MultiSourceFlag.setter
    def MultiSourceFlag(self, MultiSourceFlag):
        self._MultiSourceFlag = MultiSourceFlag

    @property
    def WhereFlag(self):
        return self._WhereFlag

    @WhereFlag.setter
    def WhereFlag(self, WhereFlag):
        self._WhereFlag = WhereFlag

    @property
    def TemplateSql(self):
        return self._TemplateSql

    @TemplateSql.setter
    def TemplateSql(self, TemplateSql):
        self._TemplateSql = TemplateSql

    @property
    def SubQualityDim(self):
        return self._SubQualityDim

    @SubQualityDim.setter
    def SubQualityDim(self, SubQualityDim):
        self._SubQualityDim = SubQualityDim

    @property
    def TargetObjectType(self):
        return self._TargetObjectType

    @TargetObjectType.setter
    def TargetObjectType(self, TargetObjectType):
        self._TargetObjectType = TargetObjectType

    @property
    def TargetObjectDataType(self):
        return self._TargetObjectDataType

    @TargetObjectDataType.setter
    def TargetObjectDataType(self, TargetObjectDataType):
        self._TargetObjectDataType = TargetObjectDataType

    @property
    def TargetObjectDataTypeName(self):
        return self._TargetObjectDataTypeName

    @TargetObjectDataTypeName.setter
    def TargetObjectDataTypeName(self, TargetObjectDataTypeName):
        self._TargetObjectDataTypeName = TargetObjectDataTypeName

    @property
    def TargetObjectValue(self):
        return self._TargetObjectValue

    @TargetObjectValue.setter
    def TargetObjectValue(self, TargetObjectValue):
        self._TargetObjectValue = TargetObjectValue

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._TableId = params.get("TableId")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._RuleTemplateId = params.get("RuleTemplateId")
        self._RuleTemplateContent = params.get("RuleTemplateContent")
        self._QualityDim = params.get("QualityDim")
        self._SourceObjectType = params.get("SourceObjectType")
        self._SourceObjectDataType = params.get("SourceObjectDataType")
        self._SourceObjectDataTypeName = params.get("SourceObjectDataTypeName")
        self._SourceObjectValue = params.get("SourceObjectValue")
        self._ConditionType = params.get("ConditionType")
        self._ConditionExpression = params.get("ConditionExpression")
        self._CustomSql = params.get("CustomSql")
        if params.get("CompareRule") is not None:
            self._CompareRule = CompareRule()
            self._CompareRule._deserialize(params.get("CompareRule"))
        self._AlarmLevel = params.get("AlarmLevel")
        self._Description = params.get("Description")
        self._Operator = params.get("Operator")
        self._TargetDatabaseId = params.get("TargetDatabaseId")
        self._TargetDatabaseName = params.get("TargetDatabaseName")
        self._TargetTableId = params.get("TargetTableId")
        self._TargetTableName = params.get("TargetTableName")
        self._TargetConditionExpr = params.get("TargetConditionExpr")
        self._RelConditionExpr = params.get("RelConditionExpr")
        if params.get("FieldConfig") is not None:
            self._FieldConfig = RuleFieldConfig()
            self._FieldConfig._deserialize(params.get("FieldConfig"))
        self._MultiSourceFlag = params.get("MultiSourceFlag")
        self._WhereFlag = params.get("WhereFlag")
        self._TemplateSql = params.get("TemplateSql")
        self._SubQualityDim = params.get("SubQualityDim")
        self._TargetObjectType = params.get("TargetObjectType")
        self._TargetObjectDataType = params.get("TargetObjectDataType")
        self._TargetObjectDataTypeName = params.get("TargetObjectDataTypeName")
        self._TargetObjectValue = params.get("TargetObjectValue")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleConfig(AbstractModel):
    """规则配置

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: int
        :param _ConditionType: 规则检测范围类型 1.全表  2.条件扫描
注意：此字段可能返回 null，表示取不到有效值。
        :type ConditionType: int
        :param _Condition: 检测范围表达式
注意：此字段可能返回 null，表示取不到有效值。
        :type Condition: str
        :param _TargetCondition: 目标检测范围表达式
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetCondition: str
        """
        self._RuleId = None
        self._ConditionType = None
        self._Condition = None
        self._TargetCondition = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ConditionType(self):
        return self._ConditionType

    @ConditionType.setter
    def ConditionType(self, ConditionType):
        self._ConditionType = ConditionType

    @property
    def Condition(self):
        return self._Condition

    @Condition.setter
    def Condition(self, Condition):
        self._Condition = Condition

    @property
    def TargetCondition(self):
        return self._TargetCondition

    @TargetCondition.setter
    def TargetCondition(self, TargetCondition):
        self._TargetCondition = TargetCondition


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ConditionType = params.get("ConditionType")
        self._Condition = params.get("Condition")
        self._TargetCondition = params.get("TargetCondition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleDimCnt(AbstractModel):
    """RuleDimCnt 规则维度统计

    """

    def __init__(self):
        r"""
        :param _Dim: 1：准确性，2：唯一性，3：完整性，4：一致性，5：及时性，6：有效性
        :type Dim: int
        :param _Cnt: count 数
        :type Cnt: int
        """
        self._Dim = None
        self._Cnt = None

    @property
    def Dim(self):
        return self._Dim

    @Dim.setter
    def Dim(self, Dim):
        self._Dim = Dim

    @property
    def Cnt(self):
        return self._Cnt

    @Cnt.setter
    def Cnt(self, Cnt):
        self._Cnt = Cnt


    def _deserialize(self, params):
        self._Dim = params.get("Dim")
        self._Cnt = params.get("Cnt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleDimStat(AbstractModel):
    """规则维度数统计

    """

    def __init__(self):
        r"""
        :param _TotalCnt: 总数
        :type TotalCnt: int
        :param _DimCntList: 维度统计数
        :type DimCntList: list of RuleDimCnt
        """
        self._TotalCnt = None
        self._DimCntList = None

    @property
    def TotalCnt(self):
        return self._TotalCnt

    @TotalCnt.setter
    def TotalCnt(self, TotalCnt):
        self._TotalCnt = TotalCnt

    @property
    def DimCntList(self):
        return self._DimCntList

    @DimCntList.setter
    def DimCntList(self, DimCntList):
        self._DimCntList = DimCntList


    def _deserialize(self, params):
        self._TotalCnt = params.get("TotalCnt")
        if params.get("DimCntList") is not None:
            self._DimCntList = []
            for item in params.get("DimCntList"):
                obj = RuleDimCnt()
                obj._deserialize(item)
                self._DimCntList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleExecConfig(AbstractModel):
    """规则执行配置

    """

    def __init__(self):
        r"""
        :param _QueueName: 计算队列名称
注意：此字段可能返回 null，表示取不到有效值。
        :type QueueName: str
        :param _ExecutorGroupId: 执行资源组
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutorGroupId: str
        :param _EngineType: 运行的执行引擎，不传时会请求该数据源下默认的执行引擎
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineType: str
        """
        self._QueueName = None
        self._ExecutorGroupId = None
        self._EngineType = None

    @property
    def QueueName(self):
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType


    def _deserialize(self, params):
        self._QueueName = params.get("QueueName")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        self._EngineType = params.get("EngineType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleExecDateStat(AbstractModel):
    """概览趋势结果

    """

    def __init__(self):
        r"""
        :param _StatDate: 统计日期
        :type StatDate: str
        :param _AlarmCnt: 告警数
        :type AlarmCnt: int
        :param _PipelineCnt: 阻塞数
        :type PipelineCnt: int
        """
        self._StatDate = None
        self._AlarmCnt = None
        self._PipelineCnt = None

    @property
    def StatDate(self):
        return self._StatDate

    @StatDate.setter
    def StatDate(self, StatDate):
        self._StatDate = StatDate

    @property
    def AlarmCnt(self):
        return self._AlarmCnt

    @AlarmCnt.setter
    def AlarmCnt(self, AlarmCnt):
        self._AlarmCnt = AlarmCnt

    @property
    def PipelineCnt(self):
        return self._PipelineCnt

    @PipelineCnt.setter
    def PipelineCnt(self, PipelineCnt):
        self._PipelineCnt = PipelineCnt


    def _deserialize(self, params):
        self._StatDate = params.get("StatDate")
        self._AlarmCnt = params.get("AlarmCnt")
        self._PipelineCnt = params.get("PipelineCnt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleExecExportResult(AbstractModel):
    """规则执行结果导出结果

    """

    def __init__(self):
        r"""
        :param _RuleExecId: 规则执行id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleExecId: int
        :param _ExportTasks: 导出任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ExportTasks: list of ExportTaskInfo
        """
        self._RuleExecId = None
        self._ExportTasks = None

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId

    @property
    def ExportTasks(self):
        return self._ExportTasks

    @ExportTasks.setter
    def ExportTasks(self, ExportTasks):
        self._ExportTasks = ExportTasks


    def _deserialize(self, params):
        self._RuleExecId = params.get("RuleExecId")
        if params.get("ExportTasks") is not None:
            self._ExportTasks = []
            for item in params.get("ExportTasks"):
                obj = ExportTaskInfo()
                obj._deserialize(item)
                self._ExportTasks.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleExecLog(AbstractModel):
    """规则执行日志

    """

    def __init__(self):
        r"""
        :param _Finished: 是否完成
注意：此字段可能返回 null，表示取不到有效值。
        :type Finished: bool
        :param _Log: 内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Log: str
        """
        self._Finished = None
        self._Log = None

    @property
    def Finished(self):
        return self._Finished

    @Finished.setter
    def Finished(self, Finished):
        self._Finished = Finished

    @property
    def Log(self):
        return self._Log

    @Log.setter
    def Log(self, Log):
        self._Log = Log


    def _deserialize(self, params):
        self._Finished = params.get("Finished")
        self._Log = params.get("Log")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleExecResult(AbstractModel):
    """规则执行结果

    """

    def __init__(self):
        r"""
        :param _RuleExecId: 规则执行ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleExecId: int
        :param _RuleGroupExecId: 规则组执行ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleGroupExecId: int
        :param _RuleGroupId: 规则组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleGroupId: int
        :param _RuleId: 规则ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: int
        :param _RuleName: 规则名称
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleName: str
        :param _RuleType: 规则类型 1.系统模版, 2.自定义模版, 3.自定义SQL
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleType: int
        :param _SourceObjectDataTypeName: 源字段详细类型，int string
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceObjectDataTypeName: str
        :param _SourceObjectValue: 源字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceObjectValue: str
        :param _ConditionExpression: 条件扫描WHERE条件表达式
注意：此字段可能返回 null，表示取不到有效值。
        :type ConditionExpression: str
        :param _ExecResultStatus: 检测结果（1:检测通过，2：触发规则，3：检测失败）
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecResultStatus: int
        :param _TriggerResult: 触发结果，告警发送成功, 阻断任务成功
注意：此字段可能返回 null，表示取不到有效值。
        :type TriggerResult: str
        :param _CompareResult: 对比结果
注意：此字段可能返回 null，表示取不到有效值。
        :type CompareResult: :class:`tencentcloud.wedata.v20210820.models.CompareResult`
        :param _TemplateName: 模版名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TemplateName: str
        :param _QualityDim: 质量维度
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityDim: int
        :param _TargetDBTableName: 目标表-库表名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetDBTableName: str
        :param _TargetObjectValue: 目标表-字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetObjectValue: str
        :param _TargetObjectDataType: 目标表-字段类型
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetObjectDataType: str
        :param _FieldConfig: 自定义模版sql表达式参数
注意：此字段可能返回 null，表示取不到有效值。
        :type FieldConfig: :class:`tencentcloud.wedata.v20210820.models.RuleFieldConfig`
        :param _RelConditionExpr: 源字段与目标字段关联条件on表达式
注意：此字段可能返回 null，表示取不到有效值。
        :type RelConditionExpr: str
        :param _StartTime: 执行时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _AlarmLevel: 1/2/3:低/中/高
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmLevel: int
        """
        self._RuleExecId = None
        self._RuleGroupExecId = None
        self._RuleGroupId = None
        self._RuleId = None
        self._RuleName = None
        self._RuleType = None
        self._SourceObjectDataTypeName = None
        self._SourceObjectValue = None
        self._ConditionExpression = None
        self._ExecResultStatus = None
        self._TriggerResult = None
        self._CompareResult = None
        self._TemplateName = None
        self._QualityDim = None
        self._TargetDBTableName = None
        self._TargetObjectValue = None
        self._TargetObjectDataType = None
        self._FieldConfig = None
        self._RelConditionExpr = None
        self._StartTime = None
        self._AlarmLevel = None

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleType(self):
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType

    @property
    def SourceObjectDataTypeName(self):
        return self._SourceObjectDataTypeName

    @SourceObjectDataTypeName.setter
    def SourceObjectDataTypeName(self, SourceObjectDataTypeName):
        self._SourceObjectDataTypeName = SourceObjectDataTypeName

    @property
    def SourceObjectValue(self):
        return self._SourceObjectValue

    @SourceObjectValue.setter
    def SourceObjectValue(self, SourceObjectValue):
        self._SourceObjectValue = SourceObjectValue

    @property
    def ConditionExpression(self):
        return self._ConditionExpression

    @ConditionExpression.setter
    def ConditionExpression(self, ConditionExpression):
        self._ConditionExpression = ConditionExpression

    @property
    def ExecResultStatus(self):
        return self._ExecResultStatus

    @ExecResultStatus.setter
    def ExecResultStatus(self, ExecResultStatus):
        self._ExecResultStatus = ExecResultStatus

    @property
    def TriggerResult(self):
        return self._TriggerResult

    @TriggerResult.setter
    def TriggerResult(self, TriggerResult):
        self._TriggerResult = TriggerResult

    @property
    def CompareResult(self):
        return self._CompareResult

    @CompareResult.setter
    def CompareResult(self, CompareResult):
        self._CompareResult = CompareResult

    @property
    def TemplateName(self):
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def TargetDBTableName(self):
        return self._TargetDBTableName

    @TargetDBTableName.setter
    def TargetDBTableName(self, TargetDBTableName):
        self._TargetDBTableName = TargetDBTableName

    @property
    def TargetObjectValue(self):
        return self._TargetObjectValue

    @TargetObjectValue.setter
    def TargetObjectValue(self, TargetObjectValue):
        self._TargetObjectValue = TargetObjectValue

    @property
    def TargetObjectDataType(self):
        return self._TargetObjectDataType

    @TargetObjectDataType.setter
    def TargetObjectDataType(self, TargetObjectDataType):
        self._TargetObjectDataType = TargetObjectDataType

    @property
    def FieldConfig(self):
        return self._FieldConfig

    @FieldConfig.setter
    def FieldConfig(self, FieldConfig):
        self._FieldConfig = FieldConfig

    @property
    def RelConditionExpr(self):
        return self._RelConditionExpr

    @RelConditionExpr.setter
    def RelConditionExpr(self, RelConditionExpr):
        self._RelConditionExpr = RelConditionExpr

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def AlarmLevel(self):
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel


    def _deserialize(self, params):
        self._RuleExecId = params.get("RuleExecId")
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._RuleType = params.get("RuleType")
        self._SourceObjectDataTypeName = params.get("SourceObjectDataTypeName")
        self._SourceObjectValue = params.get("SourceObjectValue")
        self._ConditionExpression = params.get("ConditionExpression")
        self._ExecResultStatus = params.get("ExecResultStatus")
        self._TriggerResult = params.get("TriggerResult")
        if params.get("CompareResult") is not None:
            self._CompareResult = CompareResult()
            self._CompareResult._deserialize(params.get("CompareResult"))
        self._TemplateName = params.get("TemplateName")
        self._QualityDim = params.get("QualityDim")
        self._TargetDBTableName = params.get("TargetDBTableName")
        self._TargetObjectValue = params.get("TargetObjectValue")
        self._TargetObjectDataType = params.get("TargetObjectDataType")
        if params.get("FieldConfig") is not None:
            self._FieldConfig = RuleFieldConfig()
            self._FieldConfig._deserialize(params.get("FieldConfig"))
        self._RelConditionExpr = params.get("RelConditionExpr")
        self._StartTime = params.get("StartTime")
        self._AlarmLevel = params.get("AlarmLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleExecResultDetail(AbstractModel):
    """规则执行结果详情

    """

    def __init__(self):
        r"""
        :param _DatasourceId: 数据源id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: int
        :param _DatasourceName: 数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceName: str
        :param _DatabaseId: 数据库guid
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _DatabaseName: 数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _InstanceId: 实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _TableId: 表guid
注意：此字段可能返回 null，表示取不到有效值。
        :type TableId: str
        :param _TableName: 表名
注意：此字段可能返回 null，表示取不到有效值。
        :type TableName: str
        :param _RuleExecResult: 规则执行记录
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleExecResult: :class:`tencentcloud.wedata.v20210820.models.RuleExecResult`
        :param _TableOwnerUserId: 表负责人userId
注意：此字段可能返回 null，表示取不到有效值。
        :type TableOwnerUserId: int
        :param _DatasourceType: 2.HIVE 3.DLC
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceType: int
        """
        self._DatasourceId = None
        self._DatasourceName = None
        self._DatabaseId = None
        self._DatabaseName = None
        self._InstanceId = None
        self._TableId = None
        self._TableName = None
        self._RuleExecResult = None
        self._TableOwnerUserId = None
        self._DatasourceType = None

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def RuleExecResult(self):
        return self._RuleExecResult

    @RuleExecResult.setter
    def RuleExecResult(self, RuleExecResult):
        self._RuleExecResult = RuleExecResult

    @property
    def TableOwnerUserId(self):
        return self._TableOwnerUserId

    @TableOwnerUserId.setter
    def TableOwnerUserId(self, TableOwnerUserId):
        self._TableOwnerUserId = TableOwnerUserId

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._DatasourceName = params.get("DatasourceName")
        self._DatabaseId = params.get("DatabaseId")
        self._DatabaseName = params.get("DatabaseName")
        self._InstanceId = params.get("InstanceId")
        self._TableId = params.get("TableId")
        self._TableName = params.get("TableName")
        if params.get("RuleExecResult") is not None:
            self._RuleExecResult = RuleExecResult()
            self._RuleExecResult._deserialize(params.get("RuleExecResult"))
        self._TableOwnerUserId = params.get("TableOwnerUserId")
        self._DatasourceType = params.get("DatasourceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleExecResultPage(AbstractModel):
    """规则执行结果分页

    """

    def __init__(self):
        r"""
        :param _TotalCount: 记录数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _Items: 规则执行结果
        :type Items: list of RuleExecResult
        """
        self._TotalCount = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = RuleExecResult()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleExecStat(AbstractModel):
    """规则运行情况结果

    """

    def __init__(self):
        r"""
        :param _TotalCnt: 规则运行总数
        :type TotalCnt: int
        :param _LastTotalCnt: 环比规则运行总数
注意：此字段可能返回 null，表示取不到有效值。
        :type LastTotalCnt: int
        :param _TotalCntRatio: 规则运行总数占比
        :type TotalCntRatio: float
        :param _LastTotalCntRatio: 规则运行总数环比变化
注意：此字段可能返回 null，表示取不到有效值。
        :type LastTotalCntRatio: float
        :param _TriggerCnt: 规则触发数
        :type TriggerCnt: int
        :param _LastTriggerCnt: 环比规则触发数
注意：此字段可能返回 null，表示取不到有效值。
        :type LastTriggerCnt: int
        :param _TriggerCntRatio: 触发占总数占比
        :type TriggerCntRatio: float
        :param _LastTriggerCntRatio: 环比规则触发数变化
注意：此字段可能返回 null，表示取不到有效值。
        :type LastTriggerCntRatio: float
        :param _AlarmCnt: 规则报警数
        :type AlarmCnt: int
        :param _LastAlarmCnt: 环比规则报警数
注意：此字段可能返回 null，表示取不到有效值。
        :type LastAlarmCnt: int
        :param _AlarmCntRatio: 报警占总数占比
        :type AlarmCntRatio: float
        :param _LastAlarmCntRatio: 环比报警数变化
注意：此字段可能返回 null，表示取不到有效值。
        :type LastAlarmCntRatio: float
        :param _PipelineCnt: 阻塞发生数
        :type PipelineCnt: int
        :param _LastPipelineCnt: 环比阻塞发生数
注意：此字段可能返回 null，表示取不到有效值。
        :type LastPipelineCnt: int
        :param _PipelineCntRatio: 阻塞占总数占比
        :type PipelineCntRatio: float
        :param _LastPipelineCntRatio: 环比阻塞发生数变化
注意：此字段可能返回 null，表示取不到有效值。
        :type LastPipelineCntRatio: float
        """
        self._TotalCnt = None
        self._LastTotalCnt = None
        self._TotalCntRatio = None
        self._LastTotalCntRatio = None
        self._TriggerCnt = None
        self._LastTriggerCnt = None
        self._TriggerCntRatio = None
        self._LastTriggerCntRatio = None
        self._AlarmCnt = None
        self._LastAlarmCnt = None
        self._AlarmCntRatio = None
        self._LastAlarmCntRatio = None
        self._PipelineCnt = None
        self._LastPipelineCnt = None
        self._PipelineCntRatio = None
        self._LastPipelineCntRatio = None

    @property
    def TotalCnt(self):
        return self._TotalCnt

    @TotalCnt.setter
    def TotalCnt(self, TotalCnt):
        self._TotalCnt = TotalCnt

    @property
    def LastTotalCnt(self):
        return self._LastTotalCnt

    @LastTotalCnt.setter
    def LastTotalCnt(self, LastTotalCnt):
        self._LastTotalCnt = LastTotalCnt

    @property
    def TotalCntRatio(self):
        return self._TotalCntRatio

    @TotalCntRatio.setter
    def TotalCntRatio(self, TotalCntRatio):
        self._TotalCntRatio = TotalCntRatio

    @property
    def LastTotalCntRatio(self):
        return self._LastTotalCntRatio

    @LastTotalCntRatio.setter
    def LastTotalCntRatio(self, LastTotalCntRatio):
        self._LastTotalCntRatio = LastTotalCntRatio

    @property
    def TriggerCnt(self):
        return self._TriggerCnt

    @TriggerCnt.setter
    def TriggerCnt(self, TriggerCnt):
        self._TriggerCnt = TriggerCnt

    @property
    def LastTriggerCnt(self):
        return self._LastTriggerCnt

    @LastTriggerCnt.setter
    def LastTriggerCnt(self, LastTriggerCnt):
        self._LastTriggerCnt = LastTriggerCnt

    @property
    def TriggerCntRatio(self):
        return self._TriggerCntRatio

    @TriggerCntRatio.setter
    def TriggerCntRatio(self, TriggerCntRatio):
        self._TriggerCntRatio = TriggerCntRatio

    @property
    def LastTriggerCntRatio(self):
        return self._LastTriggerCntRatio

    @LastTriggerCntRatio.setter
    def LastTriggerCntRatio(self, LastTriggerCntRatio):
        self._LastTriggerCntRatio = LastTriggerCntRatio

    @property
    def AlarmCnt(self):
        return self._AlarmCnt

    @AlarmCnt.setter
    def AlarmCnt(self, AlarmCnt):
        self._AlarmCnt = AlarmCnt

    @property
    def LastAlarmCnt(self):
        return self._LastAlarmCnt

    @LastAlarmCnt.setter
    def LastAlarmCnt(self, LastAlarmCnt):
        self._LastAlarmCnt = LastAlarmCnt

    @property
    def AlarmCntRatio(self):
        return self._AlarmCntRatio

    @AlarmCntRatio.setter
    def AlarmCntRatio(self, AlarmCntRatio):
        self._AlarmCntRatio = AlarmCntRatio

    @property
    def LastAlarmCntRatio(self):
        return self._LastAlarmCntRatio

    @LastAlarmCntRatio.setter
    def LastAlarmCntRatio(self, LastAlarmCntRatio):
        self._LastAlarmCntRatio = LastAlarmCntRatio

    @property
    def PipelineCnt(self):
        return self._PipelineCnt

    @PipelineCnt.setter
    def PipelineCnt(self, PipelineCnt):
        self._PipelineCnt = PipelineCnt

    @property
    def LastPipelineCnt(self):
        return self._LastPipelineCnt

    @LastPipelineCnt.setter
    def LastPipelineCnt(self, LastPipelineCnt):
        self._LastPipelineCnt = LastPipelineCnt

    @property
    def PipelineCntRatio(self):
        return self._PipelineCntRatio

    @PipelineCntRatio.setter
    def PipelineCntRatio(self, PipelineCntRatio):
        self._PipelineCntRatio = PipelineCntRatio

    @property
    def LastPipelineCntRatio(self):
        return self._LastPipelineCntRatio

    @LastPipelineCntRatio.setter
    def LastPipelineCntRatio(self, LastPipelineCntRatio):
        self._LastPipelineCntRatio = LastPipelineCntRatio


    def _deserialize(self, params):
        self._TotalCnt = params.get("TotalCnt")
        self._LastTotalCnt = params.get("LastTotalCnt")
        self._TotalCntRatio = params.get("TotalCntRatio")
        self._LastTotalCntRatio = params.get("LastTotalCntRatio")
        self._TriggerCnt = params.get("TriggerCnt")
        self._LastTriggerCnt = params.get("LastTriggerCnt")
        self._TriggerCntRatio = params.get("TriggerCntRatio")
        self._LastTriggerCntRatio = params.get("LastTriggerCntRatio")
        self._AlarmCnt = params.get("AlarmCnt")
        self._LastAlarmCnt = params.get("LastAlarmCnt")
        self._AlarmCntRatio = params.get("AlarmCntRatio")
        self._LastAlarmCntRatio = params.get("LastAlarmCntRatio")
        self._PipelineCnt = params.get("PipelineCnt")
        self._LastPipelineCnt = params.get("LastPipelineCnt")
        self._PipelineCntRatio = params.get("PipelineCntRatio")
        self._LastPipelineCntRatio = params.get("LastPipelineCntRatio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleFieldConfig(AbstractModel):
    """规则变量替换

    """

    def __init__(self):
        r"""
        :param _WhereConfig: where变量
注意：此字段可能返回 null，表示取不到有效值。
        :type WhereConfig: list of FieldConfig
        :param _TableConfig: 库表变量
注意：此字段可能返回 null，表示取不到有效值。
        :type TableConfig: list of TableConfig
        """
        self._WhereConfig = None
        self._TableConfig = None

    @property
    def WhereConfig(self):
        return self._WhereConfig

    @WhereConfig.setter
    def WhereConfig(self, WhereConfig):
        self._WhereConfig = WhereConfig

    @property
    def TableConfig(self):
        return self._TableConfig

    @TableConfig.setter
    def TableConfig(self, TableConfig):
        self._TableConfig = TableConfig


    def _deserialize(self, params):
        if params.get("WhereConfig") is not None:
            self._WhereConfig = []
            for item in params.get("WhereConfig"):
                obj = FieldConfig()
                obj._deserialize(item)
                self._WhereConfig.append(obj)
        if params.get("TableConfig") is not None:
            self._TableConfig = []
            for item in params.get("TableConfig"):
                obj = TableConfig()
                obj._deserialize(item)
                self._TableConfig.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleGroup(AbstractModel):
    """数据质量规则组

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组Id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleGroupId: int
        :param _DatasourceId: 数据源Id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _DatasourceName: 数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceName: str
        :param _DatasourceType: 数据源类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceType: int
        :param _MonitorType: 监控类型 1.未配置, 2.关联生产调度, 3.离线周期检测
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorType: int
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _TableName: 关联数据表名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TableName: str
        :param _TableId: 关联数据表Id
注意：此字段可能返回 null，表示取不到有效值。
        :type TableId: str
        :param _TableOwnerName: 关联数据表负责人
注意：此字段可能返回 null，表示取不到有效值。
        :type TableOwnerName: str
        :param _ExecStrategy: 执行策略
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecStrategy: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecStrategy`
        :param _Subscription: 执行策略
注意：此字段可能返回 null，表示取不到有效值。
        :type Subscription: :class:`tencentcloud.wedata.v20210820.models.RuleGroupSubscribe`
        :param _DatabaseId: 数据库id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _DatabaseName: 数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _Permission: 是否有权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Permission: bool
        :param _RuleCount: 已经配置的规则数量
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleCount: int
        :param _MonitorStatus: 监控状态
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorStatus: bool
        :param _TableOwnerUserId: 表负责人UserId
注意：此字段可能返回 null，表示取不到有效值。
        :type TableOwnerUserId: int
        :param _InstanceId: 实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        """
        self._RuleGroupId = None
        self._DatasourceId = None
        self._DatasourceName = None
        self._DatasourceType = None
        self._MonitorType = None
        self._UpdateTime = None
        self._TableName = None
        self._TableId = None
        self._TableOwnerName = None
        self._ExecStrategy = None
        self._Subscription = None
        self._DatabaseId = None
        self._DatabaseName = None
        self._Permission = None
        self._RuleCount = None
        self._MonitorStatus = None
        self._TableOwnerUserId = None
        self._InstanceId = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def TableOwnerName(self):
        return self._TableOwnerName

    @TableOwnerName.setter
    def TableOwnerName(self, TableOwnerName):
        self._TableOwnerName = TableOwnerName

    @property
    def ExecStrategy(self):
        return self._ExecStrategy

    @ExecStrategy.setter
    def ExecStrategy(self, ExecStrategy):
        self._ExecStrategy = ExecStrategy

    @property
    def Subscription(self):
        return self._Subscription

    @Subscription.setter
    def Subscription(self, Subscription):
        self._Subscription = Subscription

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Permission(self):
        return self._Permission

    @Permission.setter
    def Permission(self, Permission):
        self._Permission = Permission

    @property
    def RuleCount(self):
        return self._RuleCount

    @RuleCount.setter
    def RuleCount(self, RuleCount):
        self._RuleCount = RuleCount

    @property
    def MonitorStatus(self):
        return self._MonitorStatus

    @MonitorStatus.setter
    def MonitorStatus(self, MonitorStatus):
        self._MonitorStatus = MonitorStatus

    @property
    def TableOwnerUserId(self):
        return self._TableOwnerUserId

    @TableOwnerUserId.setter
    def TableOwnerUserId(self, TableOwnerUserId):
        self._TableOwnerUserId = TableOwnerUserId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._DatasourceId = params.get("DatasourceId")
        self._DatasourceName = params.get("DatasourceName")
        self._DatasourceType = params.get("DatasourceType")
        self._MonitorType = params.get("MonitorType")
        self._UpdateTime = params.get("UpdateTime")
        self._TableName = params.get("TableName")
        self._TableId = params.get("TableId")
        self._TableOwnerName = params.get("TableOwnerName")
        if params.get("ExecStrategy") is not None:
            self._ExecStrategy = RuleGroupExecStrategy()
            self._ExecStrategy._deserialize(params.get("ExecStrategy"))
        if params.get("Subscription") is not None:
            self._Subscription = RuleGroupSubscribe()
            self._Subscription._deserialize(params.get("Subscription"))
        self._DatabaseId = params.get("DatabaseId")
        self._DatabaseName = params.get("DatabaseName")
        self._Permission = params.get("Permission")
        self._RuleCount = params.get("RuleCount")
        self._MonitorStatus = params.get("MonitorStatus")
        self._TableOwnerUserId = params.get("TableOwnerUserId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleGroupExecResult(AbstractModel):
    """规则组执行结果

    """

    def __init__(self):
        r"""
        :param _RuleGroupExecId: 规则组执行ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleGroupExecId: int
        :param _RuleGroupId: 规则组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleGroupId: int
        :param _TriggerType: 执行触发类型（1：手动触发， 2：调度事中触发，3：周期调度触发）
注意：此字段可能返回 null，表示取不到有效值。
        :type TriggerType: int
        :param _ExecTime: 执行时间 yyyy-MM-dd HH:mm:ss
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecTime: str
        :param _Status: 执行状态（1.已提交 2.检测中 3.正常 4.异常）
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _AlarmRuleCount: 异常规则数
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmRuleCount: int
        :param _TotalRuleCount: 总规则数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalRuleCount: int
        :param _TableOwnerName: 源表负责人
注意：此字段可能返回 null，表示取不到有效值。
        :type TableOwnerName: str
        :param _TableName: 源表名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TableName: str
        :param _TableId: 表id
注意：此字段可能返回 null，表示取不到有效值。
        :type TableId: str
        :param _DatabaseId: 数据库id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _DatasourceId: 数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _Permission: 有无权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Permission: bool
        :param _ExecDetail: 执行详情，调度计划或者关联生产任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecDetail: str
        :param _EngineType: 实际执行引擎
注意：此字段可能返回 null，表示取不到有效值。
        :type EngineType: str
        """
        self._RuleGroupExecId = None
        self._RuleGroupId = None
        self._TriggerType = None
        self._ExecTime = None
        self._Status = None
        self._AlarmRuleCount = None
        self._TotalRuleCount = None
        self._TableOwnerName = None
        self._TableName = None
        self._TableId = None
        self._DatabaseId = None
        self._DatasourceId = None
        self._Permission = None
        self._ExecDetail = None
        self._EngineType = None

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def ExecTime(self):
        return self._ExecTime

    @ExecTime.setter
    def ExecTime(self, ExecTime):
        self._ExecTime = ExecTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def AlarmRuleCount(self):
        return self._AlarmRuleCount

    @AlarmRuleCount.setter
    def AlarmRuleCount(self, AlarmRuleCount):
        self._AlarmRuleCount = AlarmRuleCount

    @property
    def TotalRuleCount(self):
        return self._TotalRuleCount

    @TotalRuleCount.setter
    def TotalRuleCount(self, TotalRuleCount):
        self._TotalRuleCount = TotalRuleCount

    @property
    def TableOwnerName(self):
        return self._TableOwnerName

    @TableOwnerName.setter
    def TableOwnerName(self, TableOwnerName):
        self._TableOwnerName = TableOwnerName

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Permission(self):
        return self._Permission

    @Permission.setter
    def Permission(self, Permission):
        self._Permission = Permission

    @property
    def ExecDetail(self):
        return self._ExecDetail

    @ExecDetail.setter
    def ExecDetail(self, ExecDetail):
        self._ExecDetail = ExecDetail

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType


    def _deserialize(self, params):
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._TriggerType = params.get("TriggerType")
        self._ExecTime = params.get("ExecTime")
        self._Status = params.get("Status")
        self._AlarmRuleCount = params.get("AlarmRuleCount")
        self._TotalRuleCount = params.get("TotalRuleCount")
        self._TableOwnerName = params.get("TableOwnerName")
        self._TableName = params.get("TableName")
        self._TableId = params.get("TableId")
        self._DatabaseId = params.get("DatabaseId")
        self._DatasourceId = params.get("DatasourceId")
        self._Permission = params.get("Permission")
        self._ExecDetail = params.get("ExecDetail")
        self._EngineType = params.get("EngineType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleGroupExecResultPage(AbstractModel):
    """规则组执行结果分页

    """

    def __init__(self):
        r"""
        :param _TotalCount: 记录数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _Items: 规则组执行结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of RuleGroupExecResult
        """
        self._TotalCount = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = RuleGroupExecResult()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleGroupExecStrategy(AbstractModel):
    """质量规则执行策略

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组Id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleGroupId: int
        :param _MonitorType: 监控类型 1.未配置, 2.关联生产调度, 3.离线周期检测
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorType: int
        :param _ExecQueue: 计算队列
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecQueue: str
        :param _ExecutorGroupId: 执行资源组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutorGroupId: str
        :param _ExecutorGroupName: 执行资源组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecutorGroupName: str
        :param _Tasks: 关联的生产调度任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Tasks: list of ProdSchedulerTask
        :param _StartTime: 周期开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 周期结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        :param _CycleType: 调度周期类型
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleType: str
        :param _DelayTime: 延迟调度时间
注意：此字段可能返回 null，表示取不到有效值。
        :type DelayTime: int
        :param _CycleStep: 间隔
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleStep: int
        :param _TaskAction: 时间指定
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskAction: str
        :param _ExecEngineType: 运行的执行引擎，不传时会请求该数据源下默认的执行引擎
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecEngineType: str
        :param _ExecPlan: 执行计划
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecPlan: str
        """
        self._RuleGroupId = None
        self._MonitorType = None
        self._ExecQueue = None
        self._ExecutorGroupId = None
        self._ExecutorGroupName = None
        self._Tasks = None
        self._StartTime = None
        self._EndTime = None
        self._CycleType = None
        self._DelayTime = None
        self._CycleStep = None
        self._TaskAction = None
        self._ExecEngineType = None
        self._ExecPlan = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType

    @property
    def ExecQueue(self):
        return self._ExecQueue

    @ExecQueue.setter
    def ExecQueue(self, ExecQueue):
        self._ExecQueue = ExecQueue

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId

    @property
    def ExecutorGroupName(self):
        return self._ExecutorGroupName

    @ExecutorGroupName.setter
    def ExecutorGroupName(self, ExecutorGroupName):
        self._ExecutorGroupName = ExecutorGroupName

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CycleType(self):
        return self._CycleType

    @CycleType.setter
    def CycleType(self, CycleType):
        self._CycleType = CycleType

    @property
    def DelayTime(self):
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def TaskAction(self):
        return self._TaskAction

    @TaskAction.setter
    def TaskAction(self, TaskAction):
        self._TaskAction = TaskAction

    @property
    def ExecEngineType(self):
        return self._ExecEngineType

    @ExecEngineType.setter
    def ExecEngineType(self, ExecEngineType):
        self._ExecEngineType = ExecEngineType

    @property
    def ExecPlan(self):
        return self._ExecPlan

    @ExecPlan.setter
    def ExecPlan(self, ExecPlan):
        self._ExecPlan = ExecPlan


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._MonitorType = params.get("MonitorType")
        self._ExecQueue = params.get("ExecQueue")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        self._ExecutorGroupName = params.get("ExecutorGroupName")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = ProdSchedulerTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._CycleType = params.get("CycleType")
        self._DelayTime = params.get("DelayTime")
        self._CycleStep = params.get("CycleStep")
        self._TaskAction = params.get("TaskAction")
        self._ExecEngineType = params.get("ExecEngineType")
        self._ExecPlan = params.get("ExecPlan")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleGroupMonitor(AbstractModel):
    """规则组监控业务视图

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleGroupId: int
        :param _TableId: 表guid
注意：此字段可能返回 null，表示取不到有效值。
        :type TableId: str
        :param _DatasourceId: 数据源id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: int
        :param _DatabaseId: 数据库guid
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _MonitorType: 监控类型 1.未配置, 2.关联生产调度, 3.离线周期检测
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorType: int
        :param _MonitorStatus: 监控状态 0.false 1.true
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorStatus: int
        :param _CreateUserId: 规则组创建人id
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateUserId: int
        :param _CreateUserName: 规则组创建人昵称
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateUserName: str
        :param _CreateTime: 规则创建时间 yyyy-MM-dd HH:mm:ss
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        """
        self._RuleGroupId = None
        self._TableId = None
        self._DatasourceId = None
        self._DatabaseId = None
        self._MonitorType = None
        self._MonitorStatus = None
        self._CreateUserId = None
        self._CreateUserName = None
        self._CreateTime = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType

    @property
    def MonitorStatus(self):
        return self._MonitorStatus

    @MonitorStatus.setter
    def MonitorStatus(self, MonitorStatus):
        self._MonitorStatus = MonitorStatus

    @property
    def CreateUserId(self):
        return self._CreateUserId

    @CreateUserId.setter
    def CreateUserId(self, CreateUserId):
        self._CreateUserId = CreateUserId

    @property
    def CreateUserName(self):
        return self._CreateUserName

    @CreateUserName.setter
    def CreateUserName(self, CreateUserName):
        self._CreateUserName = CreateUserName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._TableId = params.get("TableId")
        self._DatasourceId = params.get("DatasourceId")
        self._DatabaseId = params.get("DatabaseId")
        self._MonitorType = params.get("MonitorType")
        self._MonitorStatus = params.get("MonitorStatus")
        self._CreateUserId = params.get("CreateUserId")
        self._CreateUserName = params.get("CreateUserName")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleGroupMonitorPage(AbstractModel):
    """规则组监控业务分页视图

    """

    def __init__(self):
        r"""
        :param _TotalCount: 记录总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _Items: 记录
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of RuleGroupMonitor
        """
        self._TotalCount = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = RuleGroupMonitor()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleGroupPage(AbstractModel):
    """规则组分页

    """

    def __init__(self):
        r"""
        :param _TotalCount: 记录数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _Items: 规则组列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of RuleGroup
        """
        self._TotalCount = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = RuleGroup()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleGroupSchedulerInfo(AbstractModel):
    """规则组调度信息

    """

    def __init__(self):
        r"""
        :param _Id: 规则组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: int
        :param _MonitorType: 1:未配置 2:关联生产调度 3:离线周期检测
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorType: int
        :param _StartTime: 开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        :param _CycleType: 循环类型简写
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleType: str
        :param _CycleStep: 循环步长
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleStep: int
        :param _CycleDesc: 循环类型
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleDesc: str
        :param _TaskAction: 离线周期检测下指定时间
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskAction: str
        :param _DelayTime: 离线周期检测下延迟时间
注意：此字段可能返回 null，表示取不到有效值。
        :type DelayTime: int
        :param _CycleTaskId: 离线周期检测下注册到任务调度的任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleTaskId: str
        :param _AssociateTaskIds: 关联生产调度下关联的任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type AssociateTaskIds: list of str
        """
        self._Id = None
        self._MonitorType = None
        self._StartTime = None
        self._EndTime = None
        self._CycleType = None
        self._CycleStep = None
        self._CycleDesc = None
        self._TaskAction = None
        self._DelayTime = None
        self._CycleTaskId = None
        self._AssociateTaskIds = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CycleType(self):
        return self._CycleType

    @CycleType.setter
    def CycleType(self, CycleType):
        self._CycleType = CycleType

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def CycleDesc(self):
        return self._CycleDesc

    @CycleDesc.setter
    def CycleDesc(self, CycleDesc):
        self._CycleDesc = CycleDesc

    @property
    def TaskAction(self):
        return self._TaskAction

    @TaskAction.setter
    def TaskAction(self, TaskAction):
        self._TaskAction = TaskAction

    @property
    def DelayTime(self):
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def CycleTaskId(self):
        return self._CycleTaskId

    @CycleTaskId.setter
    def CycleTaskId(self, CycleTaskId):
        self._CycleTaskId = CycleTaskId

    @property
    def AssociateTaskIds(self):
        return self._AssociateTaskIds

    @AssociateTaskIds.setter
    def AssociateTaskIds(self, AssociateTaskIds):
        self._AssociateTaskIds = AssociateTaskIds


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._MonitorType = params.get("MonitorType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._CycleType = params.get("CycleType")
        self._CycleStep = params.get("CycleStep")
        self._CycleDesc = params.get("CycleDesc")
        self._TaskAction = params.get("TaskAction")
        self._DelayTime = params.get("DelayTime")
        self._CycleTaskId = params.get("CycleTaskId")
        self._AssociateTaskIds = params.get("AssociateTaskIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleGroupSubscribe(AbstractModel):
    """数据质量规则组订阅信息

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组Id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleGroupId: int
        :param _Receivers: 订阅接收人列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Receivers: list of SubscribeReceiver
        :param _SubscribeType: 订阅方式 1.邮件email  2.短信sms
注意：此字段可能返回 null，表示取不到有效值。
        :type SubscribeType: list of int non-negative
        :param _WebHooks: 群机器人配置的webhook信息
注意：此字段可能返回 null，表示取不到有效值。
        :type WebHooks: list of SubscribeWebHook
        """
        self._RuleGroupId = None
        self._Receivers = None
        self._SubscribeType = None
        self._WebHooks = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def Receivers(self):
        return self._Receivers

    @Receivers.setter
    def Receivers(self, Receivers):
        self._Receivers = Receivers

    @property
    def SubscribeType(self):
        return self._SubscribeType

    @SubscribeType.setter
    def SubscribeType(self, SubscribeType):
        self._SubscribeType = SubscribeType

    @property
    def WebHooks(self):
        return self._WebHooks

    @WebHooks.setter
    def WebHooks(self, WebHooks):
        self._WebHooks = WebHooks


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        if params.get("Receivers") is not None:
            self._Receivers = []
            for item in params.get("Receivers"):
                obj = SubscribeReceiver()
                obj._deserialize(item)
                self._Receivers.append(obj)
        self._SubscribeType = params.get("SubscribeType")
        if params.get("WebHooks") is not None:
            self._WebHooks = []
            for item in params.get("WebHooks"):
                obj = SubscribeWebHook()
                obj._deserialize(item)
                self._WebHooks.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleGroupTable(AbstractModel):
    """表绑定规则组信息

    """

    def __init__(self):
        r"""
        :param _TableInfo: 表信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TableInfo: :class:`tencentcloud.wedata.v20210820.models.RuleGroupTableInnerInfo`
        :param _RuleGroups: 规则组调度信息
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleGroups: list of RuleGroupSchedulerInfo
        :param _Subscriptions: 订阅者信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Subscriptions: list of RuleGroupSubscribe
        """
        self._TableInfo = None
        self._RuleGroups = None
        self._Subscriptions = None

    @property
    def TableInfo(self):
        return self._TableInfo

    @TableInfo.setter
    def TableInfo(self, TableInfo):
        self._TableInfo = TableInfo

    @property
    def RuleGroups(self):
        return self._RuleGroups

    @RuleGroups.setter
    def RuleGroups(self, RuleGroups):
        self._RuleGroups = RuleGroups

    @property
    def Subscriptions(self):
        return self._Subscriptions

    @Subscriptions.setter
    def Subscriptions(self, Subscriptions):
        self._Subscriptions = Subscriptions


    def _deserialize(self, params):
        if params.get("TableInfo") is not None:
            self._TableInfo = RuleGroupTableInnerInfo()
            self._TableInfo._deserialize(params.get("TableInfo"))
        if params.get("RuleGroups") is not None:
            self._RuleGroups = []
            for item in params.get("RuleGroups"):
                obj = RuleGroupSchedulerInfo()
                obj._deserialize(item)
                self._RuleGroups.append(obj)
        if params.get("Subscriptions") is not None:
            self._Subscriptions = []
            for item in params.get("Subscriptions"):
                obj = RuleGroupSubscribe()
                obj._deserialize(item)
                self._Subscriptions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleGroupTableInnerInfo(AbstractModel):
    """规则组关联表信息

    """

    def __init__(self):
        r"""
        :param _TableId: 表ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TableId: str
        :param _TableName: 表名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TableName: str
        :param _InstanceId: 实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _DatasourceId: 数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _DatasourceName: 数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceName: str
        :param _DatasourceType: 数据源类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceType: int
        :param _DatabaseId: 数据库ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _DatabaseName: 数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _ProjectId: 项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: int
        :param _UserId: 责任人ID
注意：此字段可能返回 null，表示取不到有效值。
        :type UserId: int
        """
        self._TableId = None
        self._TableName = None
        self._InstanceId = None
        self._DatasourceId = None
        self._DatasourceName = None
        self._DatasourceType = None
        self._DatabaseId = None
        self._DatabaseName = None
        self._ProjectId = None
        self._UserId = None

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        self._TableName = params.get("TableName")
        self._InstanceId = params.get("InstanceId")
        self._DatasourceId = params.get("DatasourceId")
        self._DatasourceName = params.get("DatasourceName")
        self._DatasourceType = params.get("DatasourceType")
        self._DatabaseId = params.get("DatabaseId")
        self._DatabaseName = params.get("DatabaseName")
        self._ProjectId = params.get("ProjectId")
        self._UserId = params.get("UserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleHistory(AbstractModel):
    """规则操作记录业务

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: int
        :param _AlterTime: 变更时间 yyyy-MM-dd HH:mm:ss
注意：此字段可能返回 null，表示取不到有效值。
        :type AlterTime: str
        :param _AlterContent: 变更内容
注意：此字段可能返回 null，表示取不到有效值。
        :type AlterContent: str
        :param _OperatorUserId: 操作账号UId
注意：此字段可能返回 null，表示取不到有效值。
        :type OperatorUserId: int
        :param _OperatorName: 操作人名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OperatorName: str
        """
        self._RuleId = None
        self._AlterTime = None
        self._AlterContent = None
        self._OperatorUserId = None
        self._OperatorName = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def AlterTime(self):
        return self._AlterTime

    @AlterTime.setter
    def AlterTime(self, AlterTime):
        self._AlterTime = AlterTime

    @property
    def AlterContent(self):
        return self._AlterContent

    @AlterContent.setter
    def AlterContent(self, AlterContent):
        self._AlterContent = AlterContent

    @property
    def OperatorUserId(self):
        return self._OperatorUserId

    @OperatorUserId.setter
    def OperatorUserId(self, OperatorUserId):
        self._OperatorUserId = OperatorUserId

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._AlterTime = params.get("AlterTime")
        self._AlterContent = params.get("AlterContent")
        self._OperatorUserId = params.get("OperatorUserId")
        self._OperatorName = params.get("OperatorName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleHistoryPage(AbstractModel):
    """数据质量规则操作历史分页

    """

    def __init__(self):
        r"""
        :param _TotalCount: 记录数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _Items: 规则操作历史列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of RuleHistory
        """
        self._TotalCount = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = RuleHistory()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RulePage(AbstractModel):
    """数据质量规则分页

    """

    def __init__(self):
        r"""
        :param _TotalCount: 记录数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _Items: 规则列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of Rule
        """
        self._TotalCount = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = Rule()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleTemplate(AbstractModel):
    """规则模版

    """

    def __init__(self):
        r"""
        :param _RuleTemplateId: 规则模版ID
        :type RuleTemplateId: int
        :param _Name: 规则模版名称
        :type Name: str
        :param _Description: 规则模版描述
        :type Description: str
        :param _Type: 模版类型（1：系统模版，2：自定义）
        :type Type: int
        :param _SourceObjectType: 规则适用的源数据对象类型（1：常量，2：离线表级，3：离线字段级别）
        :type SourceObjectType: int
        :param _SourceObjectDataType: 规则适用的源数据对象类型（1：数值，2：字符串）
        :type SourceObjectDataType: int
        :param _SourceContent: 规则模版源侧内容，区分引擎，JSON 结构
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceContent: str
        :param _SourceEngineTypes: 源数据适用类型
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceEngineTypes: list of int non-negative
        :param _QualityDim: 规则所属质量维度（1：准确性，2：唯一性，3：完整性，4：一致性，5：及时性，6：有效性）
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityDim: int
        :param _CompareType: 规则支持的比较方式类型（1：固定值比较，大于、小于，大于等于等 2：波动值比较，绝对值、上升、下降）
注意：此字段可能返回 null，表示取不到有效值。
        :type CompareType: int
        :param _CitationCount: 引用次数
注意：此字段可能返回 null，表示取不到有效值。
        :type CitationCount: int
        :param _UserId: 创建人id
注意：此字段可能返回 null，表示取不到有效值。
        :type UserId: int
        :param _UserName: 创建人昵称
注意：此字段可能返回 null，表示取不到有效值。
        :type UserName: str
        :param _UpdateTime: 更新时间yyyy-MM-dd HH:mm:ss
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _WhereFlag: 是否添加where参数
注意：此字段可能返回 null，表示取不到有效值。
        :type WhereFlag: bool
        :param _MultiSourceFlag: 是否关联多个库表
注意：此字段可能返回 null，表示取不到有效值。
        :type MultiSourceFlag: bool
        :param _SqlExpression: 自定义模板SQL表达式
注意：此字段可能返回 null，表示取不到有效值。
        :type SqlExpression: str
        :param _SubQualityDim: 模版子维度，0.父维度类型,1.一致性: 枚举范围一致性,2.一致性：数值范围一致性,3.一致性：字段数据相关性
注意：此字段可能返回 null，表示取不到有效值。
        :type SubQualityDim: int
        """
        self._RuleTemplateId = None
        self._Name = None
        self._Description = None
        self._Type = None
        self._SourceObjectType = None
        self._SourceObjectDataType = None
        self._SourceContent = None
        self._SourceEngineTypes = None
        self._QualityDim = None
        self._CompareType = None
        self._CitationCount = None
        self._UserId = None
        self._UserName = None
        self._UpdateTime = None
        self._WhereFlag = None
        self._MultiSourceFlag = None
        self._SqlExpression = None
        self._SubQualityDim = None

    @property
    def RuleTemplateId(self):
        return self._RuleTemplateId

    @RuleTemplateId.setter
    def RuleTemplateId(self, RuleTemplateId):
        self._RuleTemplateId = RuleTemplateId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SourceObjectType(self):
        return self._SourceObjectType

    @SourceObjectType.setter
    def SourceObjectType(self, SourceObjectType):
        self._SourceObjectType = SourceObjectType

    @property
    def SourceObjectDataType(self):
        return self._SourceObjectDataType

    @SourceObjectDataType.setter
    def SourceObjectDataType(self, SourceObjectDataType):
        self._SourceObjectDataType = SourceObjectDataType

    @property
    def SourceContent(self):
        return self._SourceContent

    @SourceContent.setter
    def SourceContent(self, SourceContent):
        self._SourceContent = SourceContent

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def CompareType(self):
        return self._CompareType

    @CompareType.setter
    def CompareType(self, CompareType):
        self._CompareType = CompareType

    @property
    def CitationCount(self):
        return self._CitationCount

    @CitationCount.setter
    def CitationCount(self, CitationCount):
        self._CitationCount = CitationCount

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def WhereFlag(self):
        return self._WhereFlag

    @WhereFlag.setter
    def WhereFlag(self, WhereFlag):
        self._WhereFlag = WhereFlag

    @property
    def MultiSourceFlag(self):
        return self._MultiSourceFlag

    @MultiSourceFlag.setter
    def MultiSourceFlag(self, MultiSourceFlag):
        self._MultiSourceFlag = MultiSourceFlag

    @property
    def SqlExpression(self):
        return self._SqlExpression

    @SqlExpression.setter
    def SqlExpression(self, SqlExpression):
        self._SqlExpression = SqlExpression

    @property
    def SubQualityDim(self):
        return self._SubQualityDim

    @SubQualityDim.setter
    def SubQualityDim(self, SubQualityDim):
        self._SubQualityDim = SubQualityDim


    def _deserialize(self, params):
        self._RuleTemplateId = params.get("RuleTemplateId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._Type = params.get("Type")
        self._SourceObjectType = params.get("SourceObjectType")
        self._SourceObjectDataType = params.get("SourceObjectDataType")
        self._SourceContent = params.get("SourceContent")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        self._QualityDim = params.get("QualityDim")
        self._CompareType = params.get("CompareType")
        self._CitationCount = params.get("CitationCount")
        self._UserId = params.get("UserId")
        self._UserName = params.get("UserName")
        self._UpdateTime = params.get("UpdateTime")
        self._WhereFlag = params.get("WhereFlag")
        self._MultiSourceFlag = params.get("MultiSourceFlag")
        self._SqlExpression = params.get("SqlExpression")
        self._SubQualityDim = params.get("SubQualityDim")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleTemplateHistory(AbstractModel):
    """规则模版变更历史记录视图

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模版ID
        :type TemplateId: int
        :param _Version: 版本
        :type Version: int
        :param _UserId: 用户Id
        :type UserId: int
        :param _UserName: 用户昵称
        :type UserName: str
        :param _AlterType: 变更类型1.新增2.修改3.删除
        :type AlterType: int
        :param _AlterContent: 变更内容
        :type AlterContent: str
        """
        self._TemplateId = None
        self._Version = None
        self._UserId = None
        self._UserName = None
        self._AlterType = None
        self._AlterContent = None

    @property
    def TemplateId(self):
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def AlterType(self):
        return self._AlterType

    @AlterType.setter
    def AlterType(self, AlterType):
        self._AlterType = AlterType

    @property
    def AlterContent(self):
        return self._AlterContent

    @AlterContent.setter
    def AlterContent(self, AlterContent):
        self._AlterContent = AlterContent


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._Version = params.get("Version")
        self._UserId = params.get("UserId")
        self._UserName = params.get("UserName")
        self._AlterType = params.get("AlterType")
        self._AlterContent = params.get("AlterContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleTemplateHistoryPage(AbstractModel):
    """规则模版分页

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总记录数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _Items: 记录列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of RuleTemplateHistory
        """
        self._TotalCount = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = RuleTemplateHistory()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RuleTemplatePage(AbstractModel):
    """RuleTemplatePage 结果

    """

    def __init__(self):
        r"""
        :param _TotalCount: 记录数
        :type TotalCount: int
        :param _Items: 模版列表
        :type Items: list of RuleTemplate
        """
        self._TotalCount = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = RuleTemplate()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RunTaskRequest(AbstractModel):
    """RunTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._ProjectId = None
        self._TaskId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RunTaskResponse(AbstractModel):
    """RunTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 运行成功或者失败
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class RunnerRuleExecResult(AbstractModel):
    """规则执行结果

    """

    def __init__(self):
        r"""
        :param _RuleId: rule id
        :type RuleId: int
        :param _RuleExecId: rule exec id
        :type RuleExecId: int
        :param _State: exec state
        :type State: str
        :param _Data: 结果
        :type Data: list of str
        """
        self._RuleId = None
        self._RuleExecId = None
        self._State = None
        self._Data = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RuleExecId = params.get("RuleExecId")
        self._State = params.get("State")
        self._Data = params.get("Data")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SaveCustomFunctionRequest(AbstractModel):
    """SaveCustomFunction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionId: 函数唯一标识
        :type FunctionId: str
        :param _Kind: 分类：窗口函数、聚合函数、日期函数......
        :type Kind: str
        :param _ClusterIdentifier: 集群引擎实例
        :type ClusterIdentifier: str
        :param _ClassName: 类名
        :type ClassName: str
        :param _ResourceList: 资源列表
        :type ResourceList: list of FunctionResource
        :param _Description: 函数说明
        :type Description: str
        :param _Usage: 用法
        :type Usage: str
        :param _ParamDesc: 参数说明
        :type ParamDesc: str
        :param _ReturnDesc: 返回值说明
        :type ReturnDesc: str
        :param _Example: 示例
        :type Example: str
        """
        self._FunctionId = None
        self._Kind = None
        self._ClusterIdentifier = None
        self._ClassName = None
        self._ResourceList = None
        self._Description = None
        self._Usage = None
        self._ParamDesc = None
        self._ReturnDesc = None
        self._Example = None

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def Kind(self):
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def ClusterIdentifier(self):
        return self._ClusterIdentifier

    @ClusterIdentifier.setter
    def ClusterIdentifier(self, ClusterIdentifier):
        self._ClusterIdentifier = ClusterIdentifier

    @property
    def ClassName(self):
        return self._ClassName

    @ClassName.setter
    def ClassName(self, ClassName):
        self._ClassName = ClassName

    @property
    def ResourceList(self):
        return self._ResourceList

    @ResourceList.setter
    def ResourceList(self, ResourceList):
        self._ResourceList = ResourceList

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Usage(self):
        return self._Usage

    @Usage.setter
    def Usage(self, Usage):
        self._Usage = Usage

    @property
    def ParamDesc(self):
        return self._ParamDesc

    @ParamDesc.setter
    def ParamDesc(self, ParamDesc):
        self._ParamDesc = ParamDesc

    @property
    def ReturnDesc(self):
        return self._ReturnDesc

    @ReturnDesc.setter
    def ReturnDesc(self, ReturnDesc):
        self._ReturnDesc = ReturnDesc

    @property
    def Example(self):
        return self._Example

    @Example.setter
    def Example(self, Example):
        self._Example = Example


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._Kind = params.get("Kind")
        self._ClusterIdentifier = params.get("ClusterIdentifier")
        self._ClassName = params.get("ClassName")
        if params.get("ResourceList") is not None:
            self._ResourceList = []
            for item in params.get("ResourceList"):
                obj = FunctionResource()
                obj._deserialize(item)
                self._ResourceList.append(obj)
        self._Description = params.get("Description")
        self._Usage = params.get("Usage")
        self._ParamDesc = params.get("ParamDesc")
        self._ReturnDesc = params.get("ReturnDesc")
        self._Example = params.get("Example")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SaveCustomFunctionResponse(AbstractModel):
    """SaveCustomFunction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionId: 函数唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :type FunctionId: str
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FunctionId = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class SchedulerTaskInstanceInfo(AbstractModel):
    """集成离线任务实例信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 实例运行时间
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SchemaDetail(AbstractModel):
    """元数据字段信息

    """

    def __init__(self):
        r"""
        :param _ColumnKey: 列
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnKey: str
        :param _Description: 描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Name: 名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Type: 类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._ColumnKey = None
        self._Description = None
        self._Name = None
        self._Type = None

    @property
    def ColumnKey(self):
        return self._ColumnKey

    @ColumnKey.setter
    def ColumnKey(self, ColumnKey):
        self._ColumnKey = ColumnKey

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._ColumnKey = params.get("ColumnKey")
        self._Description = params.get("Description")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScriptInfoResponse(AbstractModel):
    """开发空间-脚本相关响应

    """

    def __init__(self):
        r"""
        :param _ResourceId: 资源id
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceId: str
        :param _FileName: 脚本名称
注意：此字段可能返回 null，表示取不到有效值。
        :type FileName: str
        :param _FileExtensionType: 文件扩展名类型
注意：此字段可能返回 null，表示取不到有效值。
        :type FileExtensionType: str
        :param _Type: 文件类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Md5Value: md5值
注意：此字段可能返回 null，表示取不到有效值。
        :type Md5Value: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _Size: 文件大小
注意：此字段可能返回 null，表示取不到有效值。
        :type Size: float
        :param _LocalPath: 本地路径
注意：此字段可能返回 null，表示取不到有效值。
        :type LocalPath: str
        :param _RemotePath: 远程路径
注意：此字段可能返回 null，表示取不到有效值。
        :type RemotePath: str
        :param _OwnerName: 用户名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerName: str
        :param _Owner: 用户id
注意：此字段可能返回 null，表示取不到有效值。
        :type Owner: str
        :param _PathDepth: 路径深度
注意：此字段可能返回 null，表示取不到有效值。
        :type PathDepth: int
        :param _ProjectId: 项目id
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _ExtraInfo: 附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtraInfo: str
        :param _LocalTempPath: 本地临时文件路径
注意：此字段可能返回 null，表示取不到有效值。
        :type LocalTempPath: str
        :param _ZipPath: 本地压缩文件路径
注意：此字段可能返回 null，表示取不到有效值。
        :type ZipPath: str
        :param _Bucket: cos桶名
注意：此字段可能返回 null，表示取不到有效值。
        :type Bucket: str
        :param _Region: cos地区
注意：此字段可能返回 null，表示取不到有效值。
        :type Region: str
        """
        self._ResourceId = None
        self._FileName = None
        self._FileExtensionType = None
        self._Type = None
        self._Md5Value = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Size = None
        self._LocalPath = None
        self._RemotePath = None
        self._OwnerName = None
        self._Owner = None
        self._PathDepth = None
        self._ProjectId = None
        self._ExtraInfo = None
        self._LocalTempPath = None
        self._ZipPath = None
        self._Bucket = None
        self._Region = None

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def FileName(self):
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def FileExtensionType(self):
        return self._FileExtensionType

    @FileExtensionType.setter
    def FileExtensionType(self, FileExtensionType):
        self._FileExtensionType = FileExtensionType

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Md5Value(self):
        return self._Md5Value

    @Md5Value.setter
    def Md5Value(self, Md5Value):
        self._Md5Value = Md5Value

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def LocalPath(self):
        return self._LocalPath

    @LocalPath.setter
    def LocalPath(self, LocalPath):
        self._LocalPath = LocalPath

    @property
    def RemotePath(self):
        return self._RemotePath

    @RemotePath.setter
    def RemotePath(self, RemotePath):
        self._RemotePath = RemotePath

    @property
    def OwnerName(self):
        return self._OwnerName

    @OwnerName.setter
    def OwnerName(self, OwnerName):
        self._OwnerName = OwnerName

    @property
    def Owner(self):
        return self._Owner

    @Owner.setter
    def Owner(self, Owner):
        self._Owner = Owner

    @property
    def PathDepth(self):
        return self._PathDepth

    @PathDepth.setter
    def PathDepth(self, PathDepth):
        self._PathDepth = PathDepth

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ExtraInfo(self):
        return self._ExtraInfo

    @ExtraInfo.setter
    def ExtraInfo(self, ExtraInfo):
        self._ExtraInfo = ExtraInfo

    @property
    def LocalTempPath(self):
        return self._LocalTempPath

    @LocalTempPath.setter
    def LocalTempPath(self, LocalTempPath):
        self._LocalTempPath = LocalTempPath

    @property
    def ZipPath(self):
        return self._ZipPath

    @ZipPath.setter
    def ZipPath(self, ZipPath):
        self._ZipPath = ZipPath

    @property
    def Bucket(self):
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._ResourceId = params.get("ResourceId")
        self._FileName = params.get("FileName")
        self._FileExtensionType = params.get("FileExtensionType")
        self._Type = params.get("Type")
        self._Md5Value = params.get("Md5Value")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Size = params.get("Size")
        self._LocalPath = params.get("LocalPath")
        self._RemotePath = params.get("RemotePath")
        self._OwnerName = params.get("OwnerName")
        self._Owner = params.get("Owner")
        self._PathDepth = params.get("PathDepth")
        self._ProjectId = params.get("ProjectId")
        self._ExtraInfo = params.get("ExtraInfo")
        self._LocalTempPath = params.get("LocalTempPath")
        self._ZipPath = params.get("ZipPath")
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScriptRequestInfo(AbstractModel):
    """开发空间-上传脚本请求

    """

    def __init__(self):
        r"""
        :param _FilePath: 脚本路径
        :type FilePath: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _Version: 脚本版本
        :type Version: str
        :param _Operation: 操作类型
        :type Operation: str
        :param _ExtraInfo: 额外信息
        :type ExtraInfo: str
        :param _BucketName: 桶名称
        :type BucketName: str
        :param _Region: 所属地区
        :type Region: str
        :param _FileExtensionType: 文件扩展类型
        :type FileExtensionType: str
        """
        self._FilePath = None
        self._ProjectId = None
        self._Version = None
        self._Operation = None
        self._ExtraInfo = None
        self._BucketName = None
        self._Region = None
        self._FileExtensionType = None

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Operation(self):
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def ExtraInfo(self):
        return self._ExtraInfo

    @ExtraInfo.setter
    def ExtraInfo(self, ExtraInfo):
        self._ExtraInfo = ExtraInfo

    @property
    def BucketName(self):
        return self._BucketName

    @BucketName.setter
    def BucketName(self, BucketName):
        self._BucketName = BucketName

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def FileExtensionType(self):
        return self._FileExtensionType

    @FileExtensionType.setter
    def FileExtensionType(self, FileExtensionType):
        self._FileExtensionType = FileExtensionType


    def _deserialize(self, params):
        self._FilePath = params.get("FilePath")
        self._ProjectId = params.get("ProjectId")
        self._Version = params.get("Version")
        self._Operation = params.get("Operation")
        self._ExtraInfo = params.get("ExtraInfo")
        self._BucketName = params.get("BucketName")
        self._Region = params.get("Region")
        self._FileExtensionType = params.get("FileExtensionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SearchCondition(AbstractModel):
    """查询实例条件

    """

    def __init__(self):
        r"""
        :param _Instance: 查询框架，必选
        :type Instance: :class:`tencentcloud.wedata.v20210820.models.SearchConditionInstance`
        :param _Keyword: 查询关键字（任务Id精确匹配，任务名称模糊匹配），可选
        :type Keyword: str
        :param _Sort: 排序顺序（asc，desc）
        :type Sort: str
        :param _SortCol: 排序列（costTime 运行耗时，startTime 开始时间，state 实例状态，curRunDate 数据时间）
        :type SortCol: str
        """
        self._Instance = None
        self._Keyword = None
        self._Sort = None
        self._SortCol = None

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Sort(self):
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def SortCol(self):
        return self._SortCol

    @SortCol.setter
    def SortCol(self, SortCol):
        self._SortCol = SortCol


    def _deserialize(self, params):
        if params.get("Instance") is not None:
            self._Instance = SearchConditionInstance()
            self._Instance._deserialize(params.get("Instance"))
        self._Keyword = params.get("Keyword")
        self._Sort = params.get("Sort")
        self._SortCol = params.get("SortCol")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SearchConditionInstance(AbstractModel):
    """查询框架

    """

    def __init__(self):
        r"""
        :param _ExecutionSpace: 执行空间 "DRY_RUN"
        :type ExecutionSpace: int
        :param _ProductName: 产品名称，可选
        :type ProductName: int
        :param _ResourceGroup: 资源组
        :type ResourceGroup: int
        """
        self._ExecutionSpace = None
        self._ProductName = None
        self._ResourceGroup = None

    @property
    def ExecutionSpace(self):
        return self._ExecutionSpace

    @ExecutionSpace.setter
    def ExecutionSpace(self, ExecutionSpace):
        self._ExecutionSpace = ExecutionSpace

    @property
    def ProductName(self):
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def ResourceGroup(self):
        return self._ResourceGroup

    @ResourceGroup.setter
    def ResourceGroup(self, ResourceGroup):
        self._ResourceGroup = ResourceGroup


    def _deserialize(self, params):
        self._ExecutionSpace = params.get("ExecutionSpace")
        self._ProductName = params.get("ProductName")
        self._ResourceGroup = params.get("ResourceGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SearchConditionInstanceNew(AbstractModel):
    """搜索条件

    """

    def __init__(self):
        r"""
        :param _ExecutionSpace: 执行空间 "DRY_RUN"
        :type ExecutionSpace: str
        :param _ProductName: 产品名称，可选
        :type ProductName: str
        :param _ResourceGroup: 资源组
        :type ResourceGroup: str
        """
        self._ExecutionSpace = None
        self._ProductName = None
        self._ResourceGroup = None

    @property
    def ExecutionSpace(self):
        return self._ExecutionSpace

    @ExecutionSpace.setter
    def ExecutionSpace(self, ExecutionSpace):
        self._ExecutionSpace = ExecutionSpace

    @property
    def ProductName(self):
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def ResourceGroup(self):
        return self._ResourceGroup

    @ResourceGroup.setter
    def ResourceGroup(self, ResourceGroup):
        self._ResourceGroup = ResourceGroup


    def _deserialize(self, params):
        self._ExecutionSpace = params.get("ExecutionSpace")
        self._ProductName = params.get("ProductName")
        self._ResourceGroup = params.get("ResourceGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SearchConditionNew(AbstractModel):
    """查询实例条件(新)

    """

    def __init__(self):
        r"""
        :param _Instance: 查询框架，必选
        :type Instance: :class:`tencentcloud.wedata.v20210820.models.SearchConditionInstanceNew`
        :param _Keyword: 查询关键字（任务Id精确匹配，任务名称模糊匹配），可选
        :type Keyword: str
        :param _Sort: 排序顺序（asc，desc）
        :type Sort: str
        :param _SortCol: 排序列（costTime 运行耗时，startTime 开始时间，state 实例状态，curRunDate 数据时间）
        :type SortCol: str
        """
        self._Instance = None
        self._Keyword = None
        self._Sort = None
        self._SortCol = None

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Sort(self):
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def SortCol(self):
        return self._SortCol

    @SortCol.setter
    def SortCol(self, SortCol):
        self._SortCol = SortCol


    def _deserialize(self, params):
        if params.get("Instance") is not None:
            self._Instance = SearchConditionInstanceNew()
            self._Instance._deserialize(params.get("Instance"))
        self._Keyword = params.get("Keyword")
        self._Sort = params.get("Sort")
        self._SortCol = params.get("SortCol")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetTaskAlarmNewRequest(AbstractModel):
    """SetTaskAlarmNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmInfoList: 设置任务超时告警和失败告警信息
        :type AlarmInfoList: list of AlarmInfo
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._AlarmInfoList = None
        self._ProjectId = None

    @property
    def AlarmInfoList(self):
        return self._AlarmInfoList

    @AlarmInfoList.setter
    def AlarmInfoList(self, AlarmInfoList):
        self._AlarmInfoList = AlarmInfoList

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("AlarmInfoList") is not None:
            self._AlarmInfoList = []
            for item in params.get("AlarmInfoList"):
                obj = AlarmInfo()
                obj._deserialize(item)
                self._AlarmInfoList.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetTaskAlarmNewResponse(AbstractModel):
    """SetTaskAlarmNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class SimpleTaskInfo(AbstractModel):
    """简单Task信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _TaskName: 任务名
        :type TaskName: str
        """
        self._TaskId = None
        self._TaskName = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SourceFieldInfo(AbstractModel):
    """上游节点字段信息

    """

    def __init__(self):
        r"""
        :param _FieldName: 字段名称
        :type FieldName: str
        :param _FieldType: 字段类型
        :type FieldType: str
        :param _Alias: 字段别名
        :type Alias: str
        :param _Comment: 字段描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Comment: str
        """
        self._FieldName = None
        self._FieldType = None
        self._Alias = None
        self._Comment = None

    @property
    def FieldName(self):
        return self._FieldName

    @FieldName.setter
    def FieldName(self, FieldName):
        self._FieldName = FieldName

    @property
    def FieldType(self):
        return self._FieldType

    @FieldType.setter
    def FieldType(self, FieldType):
        self._FieldType = FieldType

    @property
    def Alias(self):
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._FieldName = params.get("FieldName")
        self._FieldType = params.get("FieldType")
        self._Alias = params.get("Alias")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SourceObject(AbstractModel):
    """数据质量数据对象

    """

    def __init__(self):
        r"""
        :param _SourceObjectDataTypeName: 源字段详细类型，int、string
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceObjectDataTypeName: str
        :param _SourceObjectValue: 源字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceObjectValue: str
        :param _ObjectDataTypeName: 源字段详细类型，int、string
注意：此字段可能返回 null，表示取不到有效值。
        :type ObjectDataTypeName: str
        :param _ObjectValue: 源字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ObjectValue: str
        :param _ObjectType: 对象类型 1.常量  2.离线表级   3.离线字段级
注意：此字段可能返回 null，表示取不到有效值。
        :type ObjectType: int
        """
        self._SourceObjectDataTypeName = None
        self._SourceObjectValue = None
        self._ObjectDataTypeName = None
        self._ObjectValue = None
        self._ObjectType = None

    @property
    def SourceObjectDataTypeName(self):
        warnings.warn("parameter `SourceObjectDataTypeName` is deprecated", DeprecationWarning) 

        return self._SourceObjectDataTypeName

    @SourceObjectDataTypeName.setter
    def SourceObjectDataTypeName(self, SourceObjectDataTypeName):
        warnings.warn("parameter `SourceObjectDataTypeName` is deprecated", DeprecationWarning) 

        self._SourceObjectDataTypeName = SourceObjectDataTypeName

    @property
    def SourceObjectValue(self):
        warnings.warn("parameter `SourceObjectValue` is deprecated", DeprecationWarning) 

        return self._SourceObjectValue

    @SourceObjectValue.setter
    def SourceObjectValue(self, SourceObjectValue):
        warnings.warn("parameter `SourceObjectValue` is deprecated", DeprecationWarning) 

        self._SourceObjectValue = SourceObjectValue

    @property
    def ObjectDataTypeName(self):
        return self._ObjectDataTypeName

    @ObjectDataTypeName.setter
    def ObjectDataTypeName(self, ObjectDataTypeName):
        self._ObjectDataTypeName = ObjectDataTypeName

    @property
    def ObjectValue(self):
        return self._ObjectValue

    @ObjectValue.setter
    def ObjectValue(self, ObjectValue):
        self._ObjectValue = ObjectValue

    @property
    def ObjectType(self):
        return self._ObjectType

    @ObjectType.setter
    def ObjectType(self, ObjectType):
        self._ObjectType = ObjectType


    def _deserialize(self, params):
        self._SourceObjectDataTypeName = params.get("SourceObjectDataTypeName")
        self._SourceObjectValue = params.get("SourceObjectValue")
        self._ObjectDataTypeName = params.get("ObjectDataTypeName")
        self._ObjectValue = params.get("ObjectValue")
        self._ObjectType = params.get("ObjectType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SpeedValue(AbstractModel):
    """速度值对象

    """

    def __init__(self):
        r"""
        :param _Time: 带毫秒的时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type Time: int
        :param _Speed: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Speed: float
        """
        self._Time = None
        self._Speed = None

    @property
    def Time(self):
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Speed(self):
        return self._Speed

    @Speed.setter
    def Speed(self, Speed):
        self._Speed = Speed


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._Speed = params.get("Speed")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StartIntegrationTaskRequest(AbstractModel):
    """StartIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _Event: 事件类型(START, STOP, SUSPEND, RESUME, COMMIT, TIMESTAMP)
        :type Event: str
        :param _ExtConfig: 额外参数
        :type ExtConfig: list of RecordField
        """
        self._TaskId = None
        self._ProjectId = None
        self._Event = None
        self._ExtConfig = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Event(self):
        return self._Event

    @Event.setter
    def Event(self, Event):
        self._Event = Event

    @property
    def ExtConfig(self):
        return self._ExtConfig

    @ExtConfig.setter
    def ExtConfig(self, ExtConfig):
        self._ExtConfig = ExtConfig


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._Event = params.get("Event")
        if params.get("ExtConfig") is not None:
            self._ExtConfig = []
            for item in params.get("ExtConfig"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtConfig.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StartIntegrationTaskResponse(AbstractModel):
    """StartIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作成功与否标识
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class StopIntegrationTaskRequest(AbstractModel):
    """StopIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopIntegrationTaskResponse(AbstractModel):
    """StopIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作成功与否标识
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class SubmitCustomFunctionRequest(AbstractModel):
    """SubmitCustomFunction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionId: 函数唯一标识
        :type FunctionId: str
        :param _ClusterIdentifier: 集群实例 ID
        :type ClusterIdentifier: str
        :param _Comment: 备注信息
        :type Comment: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._FunctionId = None
        self._ClusterIdentifier = None
        self._Comment = None
        self._ProjectId = None

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ClusterIdentifier(self):
        return self._ClusterIdentifier

    @ClusterIdentifier.setter
    def ClusterIdentifier(self, ClusterIdentifier):
        self._ClusterIdentifier = ClusterIdentifier

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ClusterIdentifier = params.get("ClusterIdentifier")
        self._Comment = params.get("Comment")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SubmitCustomFunctionResponse(AbstractModel):
    """SubmitCustomFunction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionId: 函数唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :type FunctionId: str
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FunctionId = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class SubmitTaskRequest(AbstractModel):
    """SubmitTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _VersionRemark: 版本备注
        :type VersionRemark: str
        :param _StartScheduling: 是否启动调度
        :type StartScheduling: bool
        """
        self._ProjectId = None
        self._TaskId = None
        self._VersionRemark = None
        self._StartScheduling = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VersionRemark(self):
        return self._VersionRemark

    @VersionRemark.setter
    def VersionRemark(self, VersionRemark):
        self._VersionRemark = VersionRemark

    @property
    def StartScheduling(self):
        return self._StartScheduling

    @StartScheduling.setter
    def StartScheduling(self, StartScheduling):
        self._StartScheduling = StartScheduling


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._VersionRemark = params.get("VersionRemark")
        self._StartScheduling = params.get("StartScheduling")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SubmitTaskResponse(AbstractModel):
    """SubmitTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 成功或者失败
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class SubmitWorkflow(AbstractModel):
    """提交工作流实体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 被提交的任务id集合
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskIds: list of str
        :param _Result: 执行结果
        :type Result: bool
        :param _ErrorDesc: 执行情况备注
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorDesc: str
        :param _ErrorId: 执行情况id
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorId: str
        """
        self._TaskIds = None
        self._Result = None
        self._ErrorDesc = None
        self._ErrorId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrorDesc(self):
        return self._ErrorDesc

    @ErrorDesc.setter
    def ErrorDesc(self, ErrorDesc):
        self._ErrorDesc = ErrorDesc

    @property
    def ErrorId(self):
        return self._ErrorId

    @ErrorId.setter
    def ErrorId(self, ErrorId):
        self._ErrorId = ErrorId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._Result = params.get("Result")
        self._ErrorDesc = params.get("ErrorDesc")
        self._ErrorId = params.get("ErrorId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SubmitWorkflowRequest(AbstractModel):
    """SubmitWorkflow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WorkflowId: 工作流id
        :type WorkflowId: str
        :param _VersionRemark: 提交的版本备注
        :type VersionRemark: str
        :param _StartScheduling: 是否启动调度
        :type StartScheduling: bool
        """
        self._ProjectId = None
        self._WorkflowId = None
        self._VersionRemark = None
        self._StartScheduling = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def VersionRemark(self):
        return self._VersionRemark

    @VersionRemark.setter
    def VersionRemark(self, VersionRemark):
        self._VersionRemark = VersionRemark

    @property
    def StartScheduling(self):
        return self._StartScheduling

    @StartScheduling.setter
    def StartScheduling(self, StartScheduling):
        self._StartScheduling = StartScheduling


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        self._VersionRemark = params.get("VersionRemark")
        self._StartScheduling = params.get("StartScheduling")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SubmitWorkflowResponse(AbstractModel):
    """SubmitWorkflow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 执行结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.SubmitWorkflow`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, Reque