from django.conf import settings as django_settings

DJANGO_OUTBOX_PATTERN = getattr(django_settings, "DJANGO_OUTBOX_PATTERN", {})

DEFAULT_CONNECTION_CLASS = DJANGO_OUTBOX_PATTERN.get("DEFAULT_CONNECTION_CLASS", "stomp.StompConnection12")
DEFAULT_CONSUMER_LISTENER_CLASS = DJANGO_OUTBOX_PATTERN.get(
    "DEFAULT_CONSUMER_LISTENER_CLASS", "django_outbox_pattern.listeners.ConsumerListener"
)
DEFAULT_GENERATE_HEADERS = DJANGO_OUTBOX_PATTERN.get(
    "DEFAULT_GENERATE_HEADERS", "django_outbox_pattern.headers.generate_headers"
)
DEFAULT_MAXIMUM_BACKOFF = DJANGO_OUTBOX_PATTERN.get("DEFAULT_MAXIMUM_BACKOFF", 3600)
DEFAULT_MAXIMUM_RETRY_ATTEMPTS = DJANGO_OUTBOX_PATTERN.get("DEFAULT_MAXIMUM_RETRY_ATTEMPTS", 50)
DEFAULT_PAUSE_FOR_RETRY = DJANGO_OUTBOX_PATTERN.get("DEFAULT_PAUSE_FOR_RETRY", 240)
DEFAULT_WAIT_RETRY = DJANGO_OUTBOX_PATTERN.get("DEFAULT_WAIT_RETRY", 60)
DEFAULT_PRODUCER_LISTENER_CLASS = DJANGO_OUTBOX_PATTERN.get(
    "DEFAULT_PRODUCER_LISTENER_CLASS", "django_outbox_pattern.listeners.ProducerListener"
)
DEFAULT_PUBLISHED_CLASS = DJANGO_OUTBOX_PATTERN.get("DEFAULT_PUBLISHED_CLASS", "django_outbox_pattern.models.Published")
DEFAULT_PUBLISHED_CHUNK_SIZE = int(DJANGO_OUTBOX_PATTERN.get("DEFAULT_PUBLISHED_CHUNK_SIZE", 200))
DEFAULT_RECEIVED_CLASS = DJANGO_OUTBOX_PATTERN.get("DEFAULT_RECEIVED_CLASS", "django_outbox_pattern.models.Received")
DEFAULT_STOMP_HOST_AND_PORTS = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_HOST_AND_PORTS", [("127.0.0.1", 61613)])
DEFAULT_STOMP_QUEUE_HEADERS = DJANGO_OUTBOX_PATTERN.get(
    "DEFAULT_STOMP_QUEUE_HEADERS", {"durable": "true", "auto-delete": "false", "prefetch-count": "1"}
)
DEFAULT_STOMP_HEARTBEATS = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_HEARTBEATS", (10000, 10000))
DEFAULT_STOMP_VHOST = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_VHOST", "/")
DEFAULT_STOMP_USERNAME = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_USERNAME", "guest")
DEFAULT_STOMP_PASSCODE = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_PASSCODE", "guest")
DEFAULT_STOMP_USE_SSL = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_USE_SSL", False)
DEFAULT_STOMP_KEY_FILE = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_KEY_FILE", None)
DEFAULT_STOMP_CERT_FILE = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_CERT_FILE", None)
DEFAULT_STOMP_CA_CERTS = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_CA_CERTS", None)
DEFAULT_STOMP_CERT_VALIDATOR = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_CERT_VALIDATOR", None)
DEFAULT_STOMP_SSL_VERSION = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_SSL_VERSION", None)
DEFAULT_STOMP_SSL_PASSWORD = DJANGO_OUTBOX_PATTERN.get("DEFAULT_STOMP_SSL_PASSWORD", None)
DEFAULT_EXCLUSIVE_QUEUE = DJANGO_OUTBOX_PATTERN.get("DEFAULT_EXCLUSIVE_QUEUE", False)
DEFAULT_CONSUMER_PROCESS_MSG_ON_BACKGROUND = DJANGO_OUTBOX_PATTERN.get(
    "DEFAULT_CONSUMER_PROCESS_MSG_ON_BACKGROUND", False
)
DAYS_TO_KEEP_DATA = DJANGO_OUTBOX_PATTERN.get("DAYS_TO_KEEP_DATA", 30)
REMOVE_DATA_CACHE_TTL = DJANGO_OUTBOX_PATTERN.get("REMOVE_DATA_CACHE_TTL", 86400)
OUTBOX_PATTERN_PUBLISHER_CACHE_KEY = DJANGO_OUTBOX_PATTERN.get(
    "OUTBOX_PATTERN_PUBLISHER_CACHE_KEY", "remove_old_messages_django_outbox_pattern_publisher"
)
OUTBOX_PATTERN_CONSUMER_CACHE_KEY = DJANGO_OUTBOX_PATTERN.get(
    "OUTBOX_PATTERN_CONSUMER_CACHE_KEY", "remove_old_messages_django_outbox_pattern_consumer"
)
DEFAULT_PRODUCER_WAITING_TIME = int(DJANGO_OUTBOX_PATTERN.get("DEFAULT_PRODUCER_WAITING_TIME", 1))
