#
#  Copyright MindBridge Analytics Inc. all rights reserved.
#
#  This material is confidential and may not be copied, distributed,
#  reversed engineered, decompiled or otherwise disseminated without
#  the prior written consent of MindBridge Analytics Inc.
#

from collections.abc import Generator
from typing import Any, Union
from pydantic import ConfigDict, Field, field_validator, model_validator
from mindbridgeapi.common_validators import (
    _convert_userinfo_to_useritem,
    _warning_if_extra_fields,
)
from mindbridgeapi.engagement_item import EngagementItem
from mindbridgeapi.generated_pydantic_model.model import (
    ApiOrganizationCreateOnly,
    ApiOrganizationRead,
    ApiOrganizationUpdate,
)


def _empty_engagements() -> Generator[EngagementItem, None, None]:
    """Empty generator function

    This returns an empty generator function, it's use is to ensure engagements is not
    None for the OrganizationItem class
    """
    yield from ()


class OrganizationItem(ApiOrganizationRead):
    engagements: Generator[EngagementItem, None, None] = Field(
        default_factory=_empty_engagements, exclude=True
    )

    model_config = ConfigDict(
        extra="allow",
        validate_assignment=True,
        validate_default=True,
        validate_return=True,
    )
    _a = model_validator(mode="after")(_warning_if_extra_fields)
    _b = field_validator("*")(_convert_userinfo_to_useritem)

    def _get_post_json(
        self, out_class: type[Union[ApiOrganizationCreateOnly, ApiOrganizationUpdate]]
    ) -> dict[str, Any]:
        in_class_dict = self.model_dump()
        out_class_object = out_class.model_validate(in_class_dict)
        return out_class_object.model_dump(
            mode="json", by_alias=True, exclude_none=True
        )

    @property
    def create_json(self) -> dict[str, Any]:
        return self._get_post_json(out_class=ApiOrganizationCreateOnly)

    @property
    def update_json(self) -> dict[str, Any]:
        return self._get_post_json(out_class=ApiOrganizationUpdate)
