# coding: utf-8

"""
    Maxpanda API V1

    The Maxpanda API documentation for version 1  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from maxpanda_python_sdk.api_client import ApiClient


class WorkOrdersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def work_orders_create_workorder(self, body, **kwargs):  # noqa: E501
        """Submit a workorder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_create_workorder(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Workorder body: Workorder details to be submitted (required)
        :return: WorkOrderCreateUpdateResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.work_orders_create_workorder_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.work_orders_create_workorder_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def work_orders_create_workorder_with_http_info(self, body, **kwargs):  # noqa: E501
        """Submit a workorder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_create_workorder_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Workorder body: Workorder details to be submitted (required)
        :return: WorkOrderCreateUpdateResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method work_orders_create_workorder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `work_orders_create_workorder`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/v1/WorkOrder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkOrderCreateUpdateResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def work_orders_delete_work_order_task(self, work_order_id, work_order_task_id, id_company, **kwargs):  # noqa: E501
        """Delete Task of Workorder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_delete_work_order_task(work_order_id, work_order_task_id, id_company, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int work_order_id: Id of workorder (required)
        :param int work_order_task_id: Task Id of workorder (required)
        :param int id_company: Company Id (required)
        :return: PageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.work_orders_delete_work_order_task_with_http_info(work_order_id, work_order_task_id, id_company, **kwargs)  # noqa: E501
        else:
            (data) = self.work_orders_delete_work_order_task_with_http_info(work_order_id, work_order_task_id, id_company, **kwargs)  # noqa: E501
            return data

    def work_orders_delete_work_order_task_with_http_info(self, work_order_id, work_order_task_id, id_company, **kwargs):  # noqa: E501
        """Delete Task of Workorder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_delete_work_order_task_with_http_info(work_order_id, work_order_task_id, id_company, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int work_order_id: Id of workorder (required)
        :param int work_order_task_id: Task Id of workorder (required)
        :param int id_company: Company Id (required)
        :return: PageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['work_order_id', 'work_order_task_id', 'id_company']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method work_orders_delete_work_order_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'work_order_id' is set
        if ('work_order_id' not in params or
                params['work_order_id'] is None):
            raise ValueError("Missing the required parameter `work_order_id` when calling `work_orders_delete_work_order_task`")  # noqa: E501
        # verify the required parameter 'work_order_task_id' is set
        if ('work_order_task_id' not in params or
                params['work_order_task_id'] is None):
            raise ValueError("Missing the required parameter `work_order_task_id` when calling `work_orders_delete_work_order_task`")  # noqa: E501
        # verify the required parameter 'id_company' is set
        if ('id_company' not in params or
                params['id_company'] is None):
            raise ValueError("Missing the required parameter `id_company` when calling `work_orders_delete_work_order_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'work_order_id' in params:
            query_params.append(('WorkOrderId', params['work_order_id']))  # noqa: E501
        if 'work_order_task_id' in params:
            query_params.append(('WorkOrderTaskId', params['work_order_task_id']))  # noqa: E501
        if 'id_company' in params:
            query_params.append(('IdCompany', params['id_company']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/v1/DeleteWorkOrderTask', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def work_orders_get(self, site_id, last_week_active_hours, request_complete_information, **kwargs):  # noqa: E501
        """Get a list of work orders  # noqa: E501

        The default list will return the first 25 records.  The NextPageUrl property will return the next page of records  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get(site_id, last_week_active_hours, request_complete_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API (required)
        :param bool last_week_active_hours: Show staff's last week active hours (required)
        :param bool request_complete_information: True option provides all the data fields. False will only return required fields (required)
        :param int page: Page number to start retrieving data (similar to List View pagification)
        :param int page_size: Number of records per page (max=100)
        :return: WorkorderListResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.work_orders_get_with_http_info(site_id, last_week_active_hours, request_complete_information, **kwargs)  # noqa: E501
        else:
            (data) = self.work_orders_get_with_http_info(site_id, last_week_active_hours, request_complete_information, **kwargs)  # noqa: E501
            return data

    def work_orders_get_with_http_info(self, site_id, last_week_active_hours, request_complete_information, **kwargs):  # noqa: E501
        """Get a list of work orders  # noqa: E501

        The default list will return the first 25 records.  The NextPageUrl property will return the next page of records  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get_with_http_info(site_id, last_week_active_hours, request_complete_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API (required)
        :param bool last_week_active_hours: Show staff's last week active hours (required)
        :param bool request_complete_information: True option provides all the data fields. False will only return required fields (required)
        :param int page: Page number to start retrieving data (similar to List View pagification)
        :param int page_size: Number of records per page (max=100)
        :return: WorkorderListResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'last_week_active_hours', 'request_complete_information', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method work_orders_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'site_id' is set
        if ('site_id' not in params or
                params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `work_orders_get`")  # noqa: E501
        # verify the required parameter 'last_week_active_hours' is set
        if ('last_week_active_hours' not in params or
                params['last_week_active_hours'] is None):
            raise ValueError("Missing the required parameter `last_week_active_hours` when calling `work_orders_get`")  # noqa: E501
        # verify the required parameter 'request_complete_information' is set
        if ('request_complete_information' not in params or
                params['request_complete_information'] is None):
            raise ValueError("Missing the required parameter `request_complete_information` when calling `work_orders_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'site_id' in params:
            query_params.append(('siteId', params['site_id']))  # noqa: E501
        if 'last_week_active_hours' in params:
            query_params.append(('lastWeekActiveHours', params['last_week_active_hours']))  # noqa: E501
        if 'request_complete_information' in params:
            query_params.append(('requestCompleteInformation', params['request_complete_information']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/v1/WorkOrders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkorderListResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def work_orders_get_0(self, id, site_id, request_complete_information, **kwargs):  # noqa: E501
        """Get a specific work order  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get_0(id, site_id, request_complete_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Workorder Id (required)
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API (required)
        :param bool request_complete_information: True option provides all the data fields. False will only return required fields (required)
        :return: WorkorderListResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.work_orders_get_0_with_http_info(id, site_id, request_complete_information, **kwargs)  # noqa: E501
        else:
            (data) = self.work_orders_get_0_with_http_info(id, site_id, request_complete_information, **kwargs)  # noqa: E501
            return data

    def work_orders_get_0_with_http_info(self, id, site_id, request_complete_information, **kwargs):  # noqa: E501
        """Get a specific work order  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get_0_with_http_info(id, site_id, request_complete_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Workorder Id (required)
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API (required)
        :param bool request_complete_information: True option provides all the data fields. False will only return required fields (required)
        :return: WorkorderListResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'site_id', 'request_complete_information']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method work_orders_get_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `work_orders_get_0`")  # noqa: E501
        # verify the required parameter 'site_id' is set
        if ('site_id' not in params or
                params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `work_orders_get_0`")  # noqa: E501
        # verify the required parameter 'request_complete_information' is set
        if ('request_complete_information' not in params or
                params['request_complete_information'] is None):
            raise ValueError("Missing the required parameter `request_complete_information` when calling `work_orders_get_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in params:
            query_params.append(('id', params['id']))  # noqa: E501
        if 'site_id' in params:
            query_params.append(('siteId', params['site_id']))  # noqa: E501
        if 'request_complete_information' in params:
            query_params.append(('requestCompleteInformation', params['request_complete_information']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/v1/WorkOrders/id', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkorderListResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def work_orders_get_to_do(self, request_complete_information, **kwargs):  # noqa: E501
        """Get Users To Do WorkOrder List  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get_to_do(request_complete_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool request_complete_information: True option provides all the data fields. False will only return required fields (required)
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API
        :param int page: Page number to start retrieving data (similar to List View pagification)
        :param int page_size: Number of records per page (max=100)
        :return: WorkorderListResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.work_orders_get_to_do_with_http_info(request_complete_information, **kwargs)  # noqa: E501
        else:
            (data) = self.work_orders_get_to_do_with_http_info(request_complete_information, **kwargs)  # noqa: E501
            return data

    def work_orders_get_to_do_with_http_info(self, request_complete_information, **kwargs):  # noqa: E501
        """Get Users To Do WorkOrder List  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get_to_do_with_http_info(request_complete_information, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool request_complete_information: True option provides all the data fields. False will only return required fields (required)
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API
        :param int page: Page number to start retrieving data (similar to List View pagification)
        :param int page_size: Number of records per page (max=100)
        :return: WorkorderListResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request_complete_information', 'site_id', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method work_orders_get_to_do" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request_complete_information' is set
        if ('request_complete_information' not in params or
                params['request_complete_information'] is None):
            raise ValueError("Missing the required parameter `request_complete_information` when calling `work_orders_get_to_do`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'request_complete_information' in params:
            query_params.append(('requestCompleteInformation', params['request_complete_information']))  # noqa: E501
        if 'site_id' in params:
            query_params.append(('siteId', params['site_id']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/v1/ToDo', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkorderListResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def work_orders_get_work_orders_by_status(self, site_id, request_complete_information, status, **kwargs):  # noqa: E501
        """Get Workorders by Status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get_work_orders_by_status(site_id, request_complete_information, status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API (required)
        :param bool request_complete_information: True option provides all the data fields. False will only return required fields (required)
        :param int status: Status ID can be found in your WorkOrderStatuses API (required)
        :param int page: Page number to start retrieving data (similar to List View pagification)
        :param int page_size: Number of records per page (max=100)
        :return: WorkorderListResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.work_orders_get_work_orders_by_status_with_http_info(site_id, request_complete_information, status, **kwargs)  # noqa: E501
        else:
            (data) = self.work_orders_get_work_orders_by_status_with_http_info(site_id, request_complete_information, status, **kwargs)  # noqa: E501
            return data

    def work_orders_get_work_orders_by_status_with_http_info(self, site_id, request_complete_information, status, **kwargs):  # noqa: E501
        """Get Workorders by Status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get_work_orders_by_status_with_http_info(site_id, request_complete_information, status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API (required)
        :param bool request_complete_information: True option provides all the data fields. False will only return required fields (required)
        :param int status: Status ID can be found in your WorkOrderStatuses API (required)
        :param int page: Page number to start retrieving data (similar to List View pagification)
        :param int page_size: Number of records per page (max=100)
        :return: WorkorderListResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'request_complete_information', 'status', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method work_orders_get_work_orders_by_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'site_id' is set
        if ('site_id' not in params or
                params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `work_orders_get_work_orders_by_status`")  # noqa: E501
        # verify the required parameter 'request_complete_information' is set
        if ('request_complete_information' not in params or
                params['request_complete_information'] is None):
            raise ValueError("Missing the required parameter `request_complete_information` when calling `work_orders_get_work_orders_by_status`")  # noqa: E501
        # verify the required parameter 'status' is set
        if ('status' not in params or
                params['status'] is None):
            raise ValueError("Missing the required parameter `status` when calling `work_orders_get_work_orders_by_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'site_id' in params:
            query_params.append(('siteId', params['site_id']))  # noqa: E501
        if 'request_complete_information' in params:
            query_params.append(('requestCompleteInformation', params['request_complete_information']))  # noqa: E501
        if 'status' in params:
            query_params.append(('Status', params['status']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/v1/WorkOrdersByWorkOrderStatus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkorderListResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def work_orders_get_work_orders_by_user(self, site_id, user_id, **kwargs):  # noqa: E501
        """Get list of workorders created by an User  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get_work_orders_by_user(site_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API (required)
        :param int user_id: User ID can be found in your Maxpanda Users index or User API (required)
        :param int page: Page number to start retrieving data (similar to List View pagification)
        :param int page_size: Number of records per page (max=100)
        :return: PagedResults
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.work_orders_get_work_orders_by_user_with_http_info(site_id, user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.work_orders_get_work_orders_by_user_with_http_info(site_id, user_id, **kwargs)  # noqa: E501
            return data

    def work_orders_get_work_orders_by_user_with_http_info(self, site_id, user_id, **kwargs):  # noqa: E501
        """Get list of workorders created by an User  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get_work_orders_by_user_with_http_info(site_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API (required)
        :param int user_id: User ID can be found in your Maxpanda Users index or User API (required)
        :param int page: Page number to start retrieving data (similar to List View pagification)
        :param int page_size: Number of records per page (max=100)
        :return: PagedResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'user_id', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method work_orders_get_work_orders_by_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'site_id' is set
        if ('site_id' not in params or
                params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `work_orders_get_work_orders_by_user`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `work_orders_get_work_orders_by_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'site_id' in params:
            query_params.append(('SiteId', params['site_id']))  # noqa: E501
        if 'user_id' in params:
            query_params.append(('UserId', params['user_id']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/v1/WorkordersByUser', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResults',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def work_orders_get_workorder_statuses(self, **kwargs):  # noqa: E501
        """Get a list of work orders statues  # noqa: E501

        The default list will return the first 25 records.  The NextPageUrl property will return the next page of records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get_workorder_statuses(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to start retrieving data (similar to List View pagification)
        :param int page_size: Number of records per page (max=100)
        :return: PagedResults
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.work_orders_get_workorder_statuses_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.work_orders_get_workorder_statuses_with_http_info(**kwargs)  # noqa: E501
            return data

    def work_orders_get_workorder_statuses_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of work orders statues  # noqa: E501

        The default list will return the first 25 records.  The NextPageUrl property will return the next page of records.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_get_workorder_statuses_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to start retrieving data (similar to List View pagification)
        :param int page_size: Number of records per page (max=100)
        :return: PagedResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method work_orders_get_workorder_statuses" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/v1/WorkOrderStatuses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResults',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def work_orders_update_workorder(self, body, **kwargs):  # noqa: E501
        """Update a workorder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_update_workorder(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateWorkorder body: Workorder details to be updated (required)
        :return: WorkOrderCreateUpdateResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.work_orders_update_workorder_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.work_orders_update_workorder_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def work_orders_update_workorder_with_http_info(self, body, **kwargs):  # noqa: E501
        """Update a workorder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_update_workorder_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateWorkorder body: Workorder details to be updated (required)
        :return: WorkOrderCreateUpdateResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method work_orders_update_workorder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `work_orders_update_workorder`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/v1/WorkOrder/id', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkOrderCreateUpdateResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def work_orders_update_workorder_status(self, site_id, workorder_id, new_status, **kwargs):  # noqa: E501
        """Change status of workorder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_update_workorder_status(site_id, workorder_id, new_status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API (required)
        :param int workorder_id: Id of workorder (required)
        :param int new_status: New status of workorder (required)
        :return: PageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.work_orders_update_workorder_status_with_http_info(site_id, workorder_id, new_status, **kwargs)  # noqa: E501
        else:
            (data) = self.work_orders_update_workorder_status_with_http_info(site_id, workorder_id, new_status, **kwargs)  # noqa: E501
            return data

    def work_orders_update_workorder_status_with_http_info(self, site_id, workorder_id, new_status, **kwargs):  # noqa: E501
        """Change status of workorder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.work_orders_update_workorder_status_with_http_info(site_id, workorder_id, new_status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int site_id: Site ID can be found in your Maxpanda Site index or Sites API (required)
        :param int workorder_id: Id of workorder (required)
        :param int new_status: New status of workorder (required)
        :return: PageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['site_id', 'workorder_id', 'new_status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method work_orders_update_workorder_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'site_id' is set
        if ('site_id' not in params or
                params['site_id'] is None):
            raise ValueError("Missing the required parameter `site_id` when calling `work_orders_update_workorder_status`")  # noqa: E501
        # verify the required parameter 'workorder_id' is set
        if ('workorder_id' not in params or
                params['workorder_id'] is None):
            raise ValueError("Missing the required parameter `workorder_id` when calling `work_orders_update_workorder_status`")  # noqa: E501
        # verify the required parameter 'new_status' is set
        if ('new_status' not in params or
                params['new_status'] is None):
            raise ValueError("Missing the required parameter `new_status` when calling `work_orders_update_workorder_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'site_id' in params:
            query_params.append(('SiteId', params['site_id']))  # noqa: E501
        if 'workorder_id' in params:
            query_params.append(('WorkorderId', params['workorder_id']))  # noqa: E501
        if 'new_status' in params:
            query_params.append(('NewStatus', params['new_status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/v1/ChangeWorkOrderStatus', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
