import { Construct } from 'constructs';
import { Function, FunctionOptions, Runtime } from 'aws-cdk-lib/aws-lambda';
import { BundlingOptions } from './types';
/**
 * (experimental) Properties for a PythonFunction.
 *
 * @experimental
 */
export interface PythonFunctionProps extends FunctionOptions {
    /**
     * (experimental) Path to the source of the function or the location for dependencies.
     *
     * @experimental
     */
    readonly entry: string;
    /**
     * (experimental) The runtime environment.
     *
     * Only runtimes of the Python family are
     * supported.
     *
     * @default Runtime.PYTHON_3_7
     * @experimental
     */
    readonly runtime: Runtime;
    /**
     * (experimental) The path (relative to entry) to the index file containing the exported handler.
     *
     * @default index.py
     * @experimental
     */
    readonly index?: string;
    /**
     * (experimental) The name of the exported handler in the index file.
     *
     * @default handler
     * @experimental
     */
    readonly handler?: string;
    /**
     * (experimental) Bundling options to use for this function.
     *
     * Use this to specify custom bundling options like
     * the bundling Docker image, asset hash type, custom hash, architecture, etc.
     *
     * @default - Use the default bundling Docker image, with x86_64 architecture.
     * @experimental
     */
    readonly bundling?: BundlingOptions;
}
/**
 * (experimental) A Python Lambda function.
 *
 * @experimental
 */
export declare class PythonFunction extends Function {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PythonFunctionProps);
}
