# coding: utf-8

"""
    DevCycle Bucketing API

    Documents the DevCycle Bucketing API which provides and API interface to User Bucketing and for generated SDKs.  # noqa: E501

    OpenAPI spec version: 1.0.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from devcycle_python_sdk.api_client import ApiClient
from devcycle_python_sdk.models import UserData, Event, Variable
from devcycle_python_sdk.dvc_options import DVCOptions

class DVCClient(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, configuration=None, options=None):
        if(options is None):
            options = DVCOptions() 
        self.options = options
        api_client = ApiClient(configuration)
        self.api_client = api_client

    def all_features(self, user, **kwargs):  # noqa: E501
        """Get all features by key for user data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_features(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserData user: (required)
        :return: dict(str, Feature)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        if not isinstance(user, UserData):
            raise TypeError("user argument must be an instance of UserData for all_features")
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.all_features_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.all_features_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def all_features_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get all features by key for user data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_features_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserData body: (required)
        :return: dict(str, Feature)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_features" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `all_features`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        if (self.options.enableEdgeDB):
            query_params.append(('enableEdgeDB', 'true'))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/features', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, Feature)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def variable(self, user, key, default_value, **kwargs):  # noqa: E501
        """Get variable by key for user data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.variable(user, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserData user: (required)
        :param str key: Variable key (required)
        :param any default_value
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        if not isinstance(user, UserData):
            raise TypeError("user argument must be an instance of UserData for variable")
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.variable_with_http_info(user, key, default_value, **kwargs)  # noqa: E501
        else:
            (data) = self.variable_with_http_info(user, key, default_value, **kwargs)  # noqa: E501
            return data

    def variable_with_http_info(self, body, key, default_value, **kwargs):  # noqa: E501
        """Get variable by key for user data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.variable_with_http_info(body, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserData body: (required)
        :param str key: Variable key (required)
        :return: Variable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        variable_key = key
        all_params = ['body', 'key', 'default_value']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method variable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `variable`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `variable`")  # noqa: E501

        # verify the required parameter 'key' is set
        if ('default_value' not in params or
                params['default_value'] is None):
            raise ValueError("Missing the required parameter `default_value` when calling `variable`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []

        if (self.options.enableEdgeDB):
            query_params.append(('enableEdgeDB', 'true'))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']       # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501
        try:
            response = self.api_client.call_api(
                '/v1/variables/{key}', 'POST',
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type='Variable',  # noqa: E501
                auth_settings=auth_settings,
                async_req=params.get('async_req'),
                _return_http_data_only=params.get('_return_http_data_only'),
                _preload_content=params.get('_preload_content', True),
                _request_timeout=params.get('_request_timeout'),
                collection_formats=collection_formats)
            if not response:
                return Variable(value=default_value, is_defaulted=True, key=variable_key)
            else:
                return response
        except:
            return Variable(value=default_value, is_defaulted=True, key=variable_key)

    def all_variables(self, user, **kwargs):  # noqa: E501
        """Get all variables by key for user data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_variables(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserData user: (required)
        :return: dict(str, Variable)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        if not isinstance(user, UserData):
            raise TypeError("user argument must be an instance of UserData for all_variables")
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.all_variables_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.all_variables_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def all_variables_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get all variables by key for user data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_variables_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserData body: (required)
        :return: dict(str, Variable)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_variables" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `all_variables`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if (self.options.enableEdgeDB):
            query_params.append(('enableEdgeDB', 'true'))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']       # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, Variable)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def track(self, user, event, **kwargs):  # noqa: E501
        """Post events to DevCycle for user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_events(user, event, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserData user: (required)
        :param Event event: (required)
        :return: InlineResponse201
                 If the method is called asynchronously,
                 returns the request thread.
        """
        if not isinstance(user, UserData):
            raise TypeError("user argument must be an instance of UserData for track")

        if not isinstance(event, Event):
            raise TypeError("event argument must be an instance of Event for track")
        body = {
            "user": user,
            "events": [event]
        }
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_events_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_events_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_events_with_http_info(self, body, **kwargs):  # noqa: E501
        """Post events to DevCycle for user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_events_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserDataAndEventsBody body: (required)
        :return: InlineResponse201
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_events" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if (self.options.enableEdgeDB):
            query_params.append(('enableEdgeDB', 'true'))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = {}
        if 'body' in params:
            user_param = body_params = params['body']['user']      # HTTP header `Accept`
            body_params = {
                'user': user_param,
                'events': params['body']['events']
            }       # HTTP header `Accept`
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/track', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse201',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
