from typing import Dict, Tuple

# First value is the value that it is serialized as
# Second value is the path to load it from
SERIALIZABLE_MAPPING: Dict[Tuple[str, ...], Tuple[str, ...]] = {
    ("depreciated", "schema", "messages", "AIMessage"): (
        "sparkai",
        "core",
        "messages",
        "ai",
        "AIMessage",
    ),
    ("depreciated", "schema", "messages", "AIMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "ai",
        "AIMessageChunk",
    ),
    ("depreciated", "schema", "messages", "BaseMessage"): (
        "sparkai",
        "core",
        "messages",
        "base",
        "BaseMessage",
    ),
    ("depreciated", "schema", "messages", "BaseMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "base",
        "BaseMessageChunk",
    ),
    ("depreciated", "schema", "messages", "ChatMessage"): (
        "sparkai",
        "core",
        "messages",
        "chat",
        "ChatMessage",
    ),
    ("depreciated", "schema", "messages", "FunctionMessage"): (
        "sparkai",
        "core",
        "messages",
        "function",
        "FunctionMessage",
    ),
    ("depreciated", "schema", "messages", "HumanMessage"): (
        "sparkai",
        "core",
        "messages",
        "human",
        "HumanMessage",
    ),
    ("depreciated", "schema", "messages", "SystemMessage"): (
        "sparkai",
        "core",
        "messages",
        "system",
        "SystemMessage",
    ),
    ("depreciated", "schema", "messages", "ToolMessage"): (
        "sparkai",
        "core",
        "messages",
        "tool",
        "ToolMessage",
    ),
    ("depreciated", "schema", "agent", "AgentAction"): (
        "sparkai",
        "core",
        "agents",
        "AgentAction",
    ),
    ("depreciated", "schema", "agent", "AgentFinish"): (
        "sparkai",
        "core",
        "agents",
        "AgentFinish",
    ),
    ("depreciated", "schema", "prompt_template", "BasePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "base",
        "BasePromptTemplate",
    ),
    ("depreciated", "chains", "llm", "LLMChain"): (
        "sparkai",
        "core",
        "chains",
        "llm",
        "LLMChain",
    ),
    ("depreciated", "prompts", "prompt", "PromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "prompt",
        "PromptTemplate",
    ),
    ("depreciated", "prompts", "chat", "MessagesPlaceholder"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "MessagesPlaceholder",
    ),
    ("depreciated", "llms", "openai", "OpenAI"): (
        "sparkai",
        "core",
        "llms",
        "base",
        "OpenAI",
    ),
    ("depreciated", "prompts", "chat", "ChatPromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "ChatPromptTemplate",
    ),
    ("depreciated", "prompts", "chat", "HumanMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "HumanMessagePromptTemplate",
    ),
    ("depreciated", "prompts", "chat", "SystemMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "SystemMessagePromptTemplate",
    ),
    ("depreciated", "schema", "agent", "AgentActionMessageLog"): (
        "sparkai",
        "core",
        "agents",
        "AgentActionMessageLog",
    ),
    ("depreciated", "schema", "agent", "OpenAIToolAgentAction"): (
        "sparkai",
        "core",
        "agents",
        "output_parsers",
        "openai_tools",
        "OpenAIToolAgentAction",
    ),
    ("depreciated", "prompts", "chat", "BaseMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "BaseMessagePromptTemplate",
    ),
    ("depreciated", "schema", "output", "ChatGeneration"): (
        "sparkai",
        "core",
        "outputs",
        "chat_generation",
        "ChatGeneration",
    ),
    ("depreciated", "schema", "output", "Generation"): (
        "sparkai",
        "core",
        "outputs",
        "generation",
        "Generation",
    ),
    ("depreciated", "schema", "document", "Document"): (
        "sparkai",
        "core",
        "documents",
        "base",
        "Document",
    ),
    ("depreciated", "output_parsers", "fix", "OutputFixingParser"): (
        "depreciated",
        "output_parsers",
        "fix",
        "OutputFixingParser",
    ),
    ("depreciated", "prompts", "chat", "AIMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "AIMessagePromptTemplate",
    ),
    ("depreciated", "output_parsers", "regex", "RegexParser"): (
        "depreciated",
        "output_parsers",
        "regex",
        "RegexParser",
    ),
    ("depreciated", "schema", "runnable", "DynamicRunnable"): (
        "sparkai",
        "core",
        "runnables",
        "configurable",
        "DynamicRunnable",
    ),
    ("depreciated", "schema", "prompt", "PromptValue"): (
        "sparkai",
        "core",
        "prompt_values",
        "PromptValue",
    ),
    ("depreciated", "schema", "runnable", "RunnableBinding"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableBinding",
    ),
    ("depreciated", "schema", "runnable", "RunnableBranch"): (
        "sparkai",
        "core",
        "runnables",
        "branch",
        "RunnableBranch",
    ),
    ("depreciated", "schema", "runnable", "RunnableWithFallbacks"): (
        "sparkai",
        "core",
        "runnables",
        "fallbacks",
        "RunnableWithFallbacks",
    ),
    ("depreciated", "schema", "output_parser", "StrOutputParser"): (
        "sparkai",
        "core",
        "output_parsers",
        "string",
        "StrOutputParser",
    ),
    ("depreciated", "chat_models", "openai", "ChatOpenAI"): (
        "langchain_openai",
        "chat_models",
        "base",
        "ChatOpenAI",
    ),
    ("depreciated", "output_parsers", "list", "CommaSeparatedListOutputParser"): (
        "sparkai",
        "core",
        "output_parsers",
        "list",
        "CommaSeparatedListOutputParser",
    ),
    ("depreciated", "schema", "runnable", "RunnableParallel"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableParallel",
    ),
    ("depreciated", "chat_models", "azure_openai", "AzureChatOpenAI"): (
        "langchain_openai",
        "chat_models",
        "azure",
        "AzureChatOpenAI",
    ),
    ("depreciated", "chat_models", "bedrock", "BedrockChat"): (
        "depreciated",
        "chat_models",
        "bedrock",
        "BedrockChat",
    ),
    ("depreciated", "chat_models", "anthropic", "ChatAnthropic"): (
        "depreciated",
        "chat_models",
        "anthropic",
        "ChatAnthropic",
    ),
    ("depreciated", "chat_models", "fireworks", "ChatFireworks"): (
        "depreciated",
        "chat_models",
        "fireworks",
        "ChatFireworks",
    ),
    ("depreciated", "chat_models", "google_palm", "ChatGooglePalm"): (
        "depreciated",
        "chat_models",
        "google_palm",
        "ChatGooglePalm",
    ),
    ("depreciated", "chat_models", "vertexai", "ChatVertexAI"): (
        "langchain_google_vertexai",
        "chat_models",
        "ChatVertexAI",
    ),
    ("depreciated", "schema", "output", "ChatGenerationChunk"): (
        "sparkai",
        "core",
        "outputs",
        "chat_generation",
        "ChatGenerationChunk",
    ),
    ("depreciated", "schema", "messages", "ChatMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "chat",
        "ChatMessageChunk",
    ),
    ("depreciated", "schema", "messages", "HumanMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "human",
        "HumanMessageChunk",
    ),
    ("depreciated", "schema", "messages", "FunctionMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "function",
        "FunctionMessageChunk",
    ),
    ("depreciated", "schema", "messages", "SystemMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "system",
        "SystemMessageChunk",
    ),
    ("depreciated", "schema", "messages", "ToolMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "tool",
        "ToolMessageChunk",
    ),
    ("depreciated", "schema", "output", "GenerationChunk"): (
        "sparkai",
        "core",
        "outputs",
        "generation",
        "GenerationChunk",
    ),
    ("depreciated", "llms", "openai", "BaseOpenAI"): (
        "depreciated",
        "llms",
        "openai",
        "BaseOpenAI",
    ),
    ("depreciated", "llms", "bedrock", "Bedrock"): (
        "depreciated",
        "llms",
        "bedrock",
        "Bedrock",
    ),
    ("depreciated", "llms", "fireworks", "Fireworks"): (
        "depreciated",
        "llms",
        "fireworks",
        "Fireworks",
    ),
    ("depreciated", "llms", "google_palm", "GooglePalm"): (
        "depreciated",
        "llms",
        "google_palm",
        "GooglePalm",
    ),
    ("depreciated", "llms", "openai", "AzureOpenAI"): (
        "langchain_openai",
        "llms",
        "azure",
        "AzureOpenAI",
    ),
    ("depreciated", "llms", "replicate", "Replicate"): (
        "depreciated",
        "llms",
        "replicate",
        "Replicate",
    ),
    ("depreciated", "llms", "vertexai", "VertexAI"): (
        "langchain_vertexai",
        "llms",
        "VertexAI",
    ),
    ("depreciated", "output_parsers", "combining", "CombiningOutputParser"): (
        "depreciated",
        "output_parsers",
        "combining",
        "CombiningOutputParser",
    ),
    ("depreciated", "schema", "prompt_template", "BaseChatPromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "BaseChatPromptTemplate",
    ),
    ("depreciated", "prompts", "chat", "ChatMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "ChatMessagePromptTemplate",
    ),
    ("depreciated", "prompts", "few_shot_with_templates", "FewShotPromptWithTemplates"): (
        "sparkai",
        "core",
        "prompts",
        "few_shot_with_templates",
        "FewShotPromptWithTemplates",
    ),
    ("depreciated", "prompts", "pipeline", "PipelinePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "pipeline",
        "PipelinePromptTemplate",
    ),
    ("depreciated", "prompts", "base", "StringPromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "string",
        "StringPromptTemplate",
    ),
    ("depreciated", "prompts", "base", "StringPromptValue"): (
        "sparkai",
        "core",
        "prompt_values",
        "StringPromptValue",
    ),
    ("depreciated", "prompts", "chat", "BaseStringMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "BaseStringMessagePromptTemplate",
    ),
    ("depreciated", "prompts", "chat", "ChatPromptValue"): (
        "sparkai",
        "core",
        "prompt_values",
        "ChatPromptValue",
    ),
    ("depreciated", "prompts", "chat", "ChatPromptValueConcrete"): (
        "sparkai",
        "core",
        "prompt_values",
        "ChatPromptValueConcrete",
    ),
    ("depreciated", "schema", "runnable", "HubRunnable"): (
        "depreciated",
        "runnables",
        "hub",
        "HubRunnable",
    ),
    ("depreciated", "schema", "runnable", "RunnableBindingBase"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableBindingBase",
    ),
    ("depreciated", "schema", "runnable", "OpenAIFunctionsRouter"): (
        "depreciated",
        "runnables",
        "openai_functions",
        "OpenAIFunctionsRouter",
    ),
    ("depreciated", "schema", "runnable", "RouterRunnable"): (
        "sparkai",
        "core",
        "runnables",
        "router",
        "RouterRunnable",
    ),
    ("depreciated", "schema", "runnable", "RunnablePassthrough"): (
        "sparkai",
        "core",
        "runnables",
        "passthrough",
        "RunnablePassthrough",
    ),
    ("depreciated", "schema", "runnable", "RunnableSequence"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableSequence",
    ),
    ("depreciated", "schema", "runnable", "RunnableEach"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableEach",
    ),
    ("depreciated", "schema", "runnable", "RunnableEachBase"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableEachBase",
    ),
    ("depreciated", "schema", "runnable", "RunnableConfigurableAlternatives"): (
        "sparkai",
        "core",
        "runnables",
        "configurable",
        "RunnableConfigurableAlternatives",
    ),
    ("depreciated", "schema", "runnable", "RunnableConfigurableFields"): (
        "sparkai",
        "core",
        "runnables",
        "configurable",
        "RunnableConfigurableFields",
    ),
    ("depreciated", "schema", "runnable", "RunnableWithMessageHistory"): (
        "sparkai",
        "core",
        "runnables",
        "history",
        "RunnableWithMessageHistory",
    ),
    ("depreciated", "schema", "runnable", "RunnableAssign"): (
        "sparkai",
        "core",
        "runnables",
        "passthrough",
        "RunnableAssign",
    ),
    ("depreciated", "schema", "runnable", "RunnableRetry"): (
        "sparkai",
        "core",
        "runnables",
        "retry",
        "RunnableRetry",
    ),
}

# Needed for backwards compatibility for old versions of LangChain where things
# Were in different place
_OG_SERIALIZABLE_MAPPING: Dict[Tuple[str, ...], Tuple[str, ...]] = {
    ("depreciated", "schema", "AIMessage"): (
        "sparkai",
        "core",
        "messages",
        "ai",
        "AIMessage",
    ),
    ("depreciated", "schema", "ChatMessage"): (
        "sparkai",
        "core",
        "messages",
        "chat",
        "ChatMessage",
    ),
    ("depreciated", "schema", "FunctionMessage"): (
        "sparkai",
        "core",
        "messages",
        "function",
        "FunctionMessage",
    ),
    ("depreciated", "schema", "HumanMessage"): (
        "sparkai",
        "core",
        "messages",
        "human",
        "HumanMessage",
    ),
    ("depreciated", "schema", "SystemMessage"): (
        "sparkai",
        "core",
        "messages",
        "system",
        "SystemMessage",
    ),
}

# Needed for backwards compatibility for a few versions where we serialized
# with langchain_core paths.
OLD_CORE_NAMESPACES_MAPPING: Dict[Tuple[str, ...], Tuple[str, ...]] = {
    ("sparkai",
     "core", "messages", "ai", "AIMessage"): (
        "sparkai",
        "core",
        "messages",
        "ai",
        "AIMessage",
    ),
    ("sparkai",
     "core", "messages", "ai", "AIMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "ai",
        "AIMessageChunk",
    ),
    ("sparkai",
     "core", "messages", "base", "BaseMessage"): (
        "sparkai",
        "core",
        "messages",
        "base",
        "BaseMessage",
    ),
    ("sparkai",
     "core", "messages", "base", "BaseMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "base",
        "BaseMessageChunk",
    ),
    ("sparkai",
     "core", "messages", "chat", "ChatMessage"): (
        "sparkai",
        "core",
        "messages",
        "chat",
        "ChatMessage",
    ),
    ("sparkai",
     "core", "messages", "function", "FunctionMessage"): (
        "sparkai",
        "core",
        "messages",
        "function",
        "FunctionMessage",
    ),
    ("sparkai",
     "core", "messages", "human", "HumanMessage"): (
        "sparkai",
        "core",
        "messages",
        "human",
        "HumanMessage",
    ),
    ("sparkai",
     "core", "messages", "system", "SystemMessage"): (
        "sparkai",
        "core",
        "messages",
        "system",
        "SystemMessage",
    ),
    ("sparkai",
     "core", "messages", "tool", "ToolMessage"): (
        "sparkai",
        "core",
        "messages",
        "tool",
        "ToolMessage",
    ),
    ("sparkai",
     "core", "agents", "AgentAction"): (
        "sparkai",
        "core",
        "agents",
        "AgentAction",
    ),
    ("sparkai",
     "core", "agents", "AgentFinish"): (
        "sparkai",
        "core",
        "agents",
        "AgentFinish",
    ),
    ("sparkai",
     "core", "prompts", "base", "BasePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "base",
        "BasePromptTemplate",
    ),
    ("sparkai",
     "core", "prompts", "prompt", "PromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "prompt",
        "PromptTemplate",
    ),
    ("sparkai",
     "core", "prompts", "chat", "MessagesPlaceholder"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "MessagesPlaceholder",
    ),
    ("sparkai",
     "core", "prompts", "chat", "ChatPromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "ChatPromptTemplate",
    ),
    ("sparkai",
     "core", "prompts", "chat", "HumanMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "HumanMessagePromptTemplate",
    ),
    ("sparkai",
     "core", "prompts", "chat", "SystemMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "SystemMessagePromptTemplate",
    ),
    ("sparkai",
     "core", "agents", "AgentActionMessageLog"): (
        "sparkai",
        "core",
        "agents",
        "AgentActionMessageLog",
    ),
    ("sparkai",
     "core", "prompts", "chat", "BaseMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "BaseMessagePromptTemplate",
    ),
    ("sparkai",
     "core", "outputs", "chat_generation", "ChatGeneration"): (
        "sparkai",
        "core",
        "outputs",
        "chat_generation",
        "ChatGeneration",
    ),
    ("sparkai",
     "core", "outputs", "generation", "Generation"): (
        "sparkai",
        "core",
        "outputs",
        "generation",
        "Generation",
    ),
    ("sparkai",
     "core", "documents", "base", "Document"): (
        "sparkai",
        "core",
        "documents",
        "base",
        "Document",
    ),
    ("sparkai",
     "core", "prompts", "chat", "AIMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "AIMessagePromptTemplate",
    ),
    ("sparkai",
     "core", "runnables", "configurable", "DynamicRunnable"): (
        "sparkai",
        "core",
        "runnables",
        "configurable",
        "DynamicRunnable",
    ),
    ("sparkai",
     "core", "prompt_values", "PromptValue"): (
        "sparkai",
        "core",
        "prompt_values",
        "PromptValue",
    ),
    ("sparkai",
     "core", "runnables", "base", "RunnableBinding"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableBinding",
    ),
    ("sparkai",
     "core", "runnables", "branch", "RunnableBranch"): (
        "sparkai",
        "core",
        "runnables",
        "branch",
        "RunnableBranch",
    ),
    ("sparkai",
     "core", "runnables", "fallbacks", "RunnableWithFallbacks"): (
        "sparkai",
        "core",
        "runnables",
        "fallbacks",
        "RunnableWithFallbacks",
    ),
    ("sparkai",
     "core", "output_parsers", "string", "StrOutputParser"): (
        "sparkai",
        "core",
        "output_parsers",
        "string",
        "StrOutputParser",
    ),
    ("sparkai",
     "core", "output_parsers", "list", "CommaSeparatedListOutputParser"): (
        "sparkai",
        "core",
        "output_parsers",
        "list",
        "CommaSeparatedListOutputParser",
    ),
    ("sparkai",
     "core", "runnables", "base", "RunnableParallel"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableParallel",
    ),
    ("sparkai",
     "core", "outputs", "chat_generation", "ChatGenerationChunk"): (
        "sparkai",
        "core",
        "outputs",
        "chat_generation",
        "ChatGenerationChunk",
    ),
    ("sparkai",
     "core", "messages", "chat", "ChatMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "chat",
        "ChatMessageChunk",
    ),
    ("sparkai",
     "core", "messages", "human", "HumanMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "human",
        "HumanMessageChunk",
    ),
    ("sparkai",
     "core", "messages", "function", "FunctionMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "function",
        "FunctionMessageChunk",
    ),
    ("sparkai",
     "core", "messages", "system", "SystemMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "system",
        "SystemMessageChunk",
    ),
    ("sparkai",
     "core", "messages", "tool", "ToolMessageChunk"): (
        "sparkai",
        "core",
        "messages",
        "tool",
        "ToolMessageChunk",
    ),
    ("sparkai",
     "core", "outputs", "generation", "GenerationChunk"): (
        "sparkai",
        "core",
        "outputs",
        "generation",
        "GenerationChunk",
    ),
    ("sparkai",
     "core", "prompts", "chat", "BaseChatPromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "BaseChatPromptTemplate",
    ),
    ("sparkai",
     "core", "prompts", "chat", "ChatMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "ChatMessagePromptTemplate",
    ),
    (
        "sparkai",
        "core",
        "prompts",
        "few_shot_with_templates",
        "FewShotPromptWithTemplates",
    ): (
        "sparkai",
        "core",
        "prompts",
        "few_shot_with_templates",
        "FewShotPromptWithTemplates",
    ),
    ("sparkai",
     "core", "prompts", "pipeline", "PipelinePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "pipeline",
        "PipelinePromptTemplate",
    ),
    ("sparkai",
     "core", "prompts", "string", "StringPromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "string",
        "StringPromptTemplate",
    ),
    ("sparkai",
     "core", "prompt_values", "StringPromptValue"): (
        "sparkai",
        "core",
        "prompt_values",
        "StringPromptValue",
    ),
    ("sparkai",
     "core", "prompts", "chat", "BaseStringMessagePromptTemplate"): (
        "sparkai",
        "core",
        "prompts",
        "chat",
        "BaseStringMessagePromptTemplate",
    ),
    ("sparkai",
     "core", "prompt_values", "ChatPromptValue"): (
        "sparkai",
        "core",
        "prompt_values",
        "ChatPromptValue",
    ),
    ("sparkai",
     "core", "prompt_values", "ChatPromptValueConcrete"): (
        "sparkai",
        "core",
        "prompt_values",
        "ChatPromptValueConcrete",
    ),
    ("sparkai",
     "core", "runnables", "base", "RunnableBindingBase"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableBindingBase",
    ),
    ("sparkai",
     "core", "runnables", "router", "RouterRunnable"): (
        "sparkai",
        "core",
        "runnables",
        "router",
        "RouterRunnable",
    ),
    ("sparkai",
     "core", "runnables", "passthrough", "RunnablePassthrough"): (
        "sparkai",
        "core",
        "runnables",
        "passthrough",
        "RunnablePassthrough",
    ),
    ("sparkai",
     "core", "runnables", "base", "RunnableSequence"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableSequence",
    ),
    ("sparkai",
     "core", "runnables", "base", "RunnableEach"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableEach",
    ),
    ("sparkai",
     "core", "runnables", "base", "RunnableEachBase"): (
        "sparkai",
        "core",
        "runnables",
        "base",
        "RunnableEachBase",
    ),
    (
        "sparkai",
        "core",
        "runnables",
        "configurable",
        "RunnableConfigurableAlternatives",
    ): (
        "sparkai",
        "core",
        "runnables",
        "configurable",
        "RunnableConfigurableAlternatives",
    ),
    ("sparkai",
     "core", "runnables", "configurable", "RunnableConfigurableFields"): (
        "sparkai",
        "core",
        "runnables",
        "configurable",
        "RunnableConfigurableFields",
    ),
    ("sparkai",
     "core", "runnables", "history", "RunnableWithMessageHistory"): (
        "sparkai",
        "core",
        "runnables",
        "history",
        "RunnableWithMessageHistory",
    ),
    ("sparkai",
     "core", "runnables", "passthrough", "RunnableAssign"): (
        "sparkai",
        "core",
        "runnables",
        "passthrough",
        "RunnableAssign",
    ),
    ("sparkai",
     "core", "runnables", "retry", "RunnableRetry"): (
        "sparkai",
        "core",
        "runnables",
        "retry",
        "RunnableRetry",
    ),
}
