# Copyright (c) 2024, VRAI Labs and/or its affiliates. All rights reserved.
#
# This software is licensed under the Apache License, Version 2.0 (the
# "License") as published by the Apache Software Foundation.
#
# You may not use this file except in compliance with the License. You may
# obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
from __future__ import annotations


from typing import Callable, TYPE_CHECKING

if TYPE_CHECKING:
    from typing import Union
    from .interfaces import APIInterface, RecipeInterface


class InputOverrideConfig:
    def __init__(
        self,
        functions: Union[Callable[[RecipeInterface], RecipeInterface], None] = None,
        apis: Union[Callable[[APIInterface], APIInterface], None] = None,
    ):
        self.functions = functions
        self.apis = apis


class OverrideConfig:
    def __init__(
        self,
        functions: Union[Callable[[RecipeInterface], RecipeInterface], None] = None,
        apis: Union[Callable[[APIInterface], APIInterface], None] = None,
    ):
        self.functions = functions
        self.apis = apis


class OAuth2ProviderConfig:
    def __init__(self, override: Union[OverrideConfig, None] = None):
        self.override = override


def validate_and_normalise_user_input(
    override: Union[InputOverrideConfig, None] = None
):
    if override is None:
        return OAuth2ProviderConfig(OverrideConfig())
    return OAuth2ProviderConfig(OverrideConfig(override.functions, override.apis))
