# Copyright 2023-2024 Geoffrey R. Scheller
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Classes of containers supporting the use & implementation of various
algorithms, both functional and imperative programming styles supported.
"""

__version__ = "0.14.0"
__author__ = "Geoffrey R. Scheller"
__copyright__ = "Copyright (c) 2023-2024 Geoffrey R. Scheller"
__license__ = "Apache License 2.0"

from .arrays import PArray
from .queues import FIFOQueue, LIFOQueue, DoubleQueue
from .stacks import Stack, FStack
from .tuples import FTuple
from .core.fp import Maybe, Some, Nothing, Either, Left, Right
from .core.fp import maybeToEither, eitherToMaybe
from .core.iterlib import merge, exhaust
