"""
Python Import Analyzer

A tool for visualizing and analyzing import dependencies in Python projects.
"""

__version__ = "0.1.2"  # Update version number here

from .dependency_analyzer import (
    analyze_dependencies,
    build_dependency_graph,
    find_required_files,
    find_unused_files,
    visualize_dependency_graph,
    visualize_interactive_graph,
    visualize_interactive_2d_graph,
)

__all__ = [
    "analyze_dependencies",
    "build_dependency_graph",
    "find_required_files",
    "find_unused_files",
    "visualize_dependency_graph",
    "visualize_interactive_graph",
    "visualize_interactive_2d_graph",
]
