# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .linked_object import LinkedObject


class LinkedObjectList(UncheckedBaseModel):
    """
    An object containing metadata about linked conversations and linked tickets. Up to 1000 can be returned.
    """

    type: typing.Optional[typing.Literal["list"]] = pydantic.Field(default=None)
    """
    Always list.
    """

    total_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    The total number of linked objects.
    """

    has_more: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not there are more linked objects than returned.
    """

    data: typing.Optional[typing.List[LinkedObject]] = pydantic.Field(default=None)
    """
    An array containing the linked conversations and linked tickets.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
