# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .assign_conversation_request_type import AssignConversationRequestType


class AssignConversationRequest(UncheckedBaseModel):
    """
    Payload of the request to assign a conversation
    """

    type: AssignConversationRequestType
    admin_id: str = pydantic.Field()
    """
    The id of the admin who is performing the action.
    """

    assignee_id: str = pydantic.Field()
    """
    The `id` of the `admin` or `team` which will be assigned the conversation. A conversation can be assigned both an admin and a team.\nSet `0` if you want this assign to no admin or team (ie. Unassigned).
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optionally you can send a response in the conversation when it is assigned.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
