# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.tag_list import TagList
from .raw_client import AsyncRawTagsClient, RawTagsClient
from .types.create_tag_request_body import CreateTagRequestBody
from .types.tag import Tag

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TagsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTagsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTagsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTagsClient
        """
        return self._raw_client

    def attach_tag_to_contact(
        self, contact_id: str, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can tag a specific contact. This will return a tag object for the tag that was added to the contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier for the contact which is given by Intercom

        id : str
            The unique identifier for the tag which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tags.attach_tag_to_contact(
            contact_id="63a07ddf05a32042dffac965",
            id="7522907",
        )
        """
        _response = self._raw_client.attach_tag_to_contact(contact_id, id=id, request_options=request_options)
        return _response.data

    def detach_tag_from_contact(
        self, contact_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can remove tag from a specific contact. This will return a tag object for the tag that was removed from the contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier for the contact which is given by Intercom

        id : str
            The unique identifier for the tag which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tags.detach_tag_from_contact(
            contact_id="63a07ddf05a32042dffac965",
            id="7522907",
        )
        """
        _response = self._raw_client.detach_tag_from_contact(contact_id, id, request_options=request_options)
        return _response.data

    def attach_tag_to_conversation(
        self, conversation_id: str, *, id: str, admin_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can tag a specific conversation. This will return a tag object for the tag that was added to the conversation.

        Parameters
        ----------
        conversation_id : str
            conversation_id

        id : str
            The unique identifier for the tag which is given by Intercom

        admin_id : str
            The unique identifier for the admin which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tags.attach_tag_to_conversation(
            conversation_id="64619700005694",
            id="7522907",
            admin_id="780",
        )
        """
        _response = self._raw_client.attach_tag_to_conversation(
            conversation_id, id=id, admin_id=admin_id, request_options=request_options
        )
        return _response.data

    def detach_tag_from_conversation(
        self, conversation_id: str, id: str, *, admin_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can remove tag from a specific conversation. This will return a tag object for the tag that was removed from the conversation.

        Parameters
        ----------
        conversation_id : str
            conversation_id

        id : str
            id

        admin_id : str
            The unique identifier for the admin which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tags.detach_tag_from_conversation(
            conversation_id="64619700005694",
            id="7522907",
            admin_id="123",
        )
        """
        _response = self._raw_client.detach_tag_from_conversation(
            conversation_id, id, admin_id=admin_id, request_options=request_options
        )
        return _response.data

    def list_tags(self, *, request_options: typing.Optional[RequestOptions] = None) -> TagList:
        """
        You can fetch a list of all tags for a given workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagList
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tags.list_tags()
        """
        _response = self._raw_client.list_tags(request_options=request_options)
        return _response.data

    def create_tag(
        self, *, request: CreateTagRequestBody, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can use this endpoint to perform the following operations:

          **1. Create a new tag:** You can create a new tag by passing in the tag name as specified in "Create or Update Tag Request Payload" described below.

          **2. Update an existing tag:** You can update an existing tag by passing the id of the tag as specified in "Create or Update Tag Request Payload" described below.

          **3. Tag Companies:** You can tag single company or a list of companies. You can tag a company by passing in the tag name and the company details as specified in "Tag Company Request Payload" described below. Also, if the tag doesn't exist then a new one will be created automatically.

          **4. Untag Companies:** You can untag a single company or a list of companies. You can untag a company by passing in the tag id and the company details as specified in "Untag Company Request Payload" described below.

          **5. Tag Multiple Users:** You can tag a list of users. You can tag the users by passing in the tag name and the user details as specified in "Tag Users Request Payload" described below.

        Each operation will return a tag object.

        Parameters
        ----------
        request : CreateTagRequestBody

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            Action successful

        Examples
        --------
        from intercom import Intercom
        from intercom.unstable import CreateOrUpdateTagRequest

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tags.create_tag(
            request=CreateOrUpdateTagRequest(
                name="test",
            ),
        )
        """
        _response = self._raw_client.create_tag(request=request, request_options=request_options)
        return _response.data

    def find_tag(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Tag:
        """
        You can fetch the details of tags that are on the workspace by their id.
        This will return a tag object.

        Parameters
        ----------
        id : str
            The unique identifier of a given tag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            Tag found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tags.find_tag(
            id="123",
        )
        """
        _response = self._raw_client.find_tag(id, request_options=request_options)
        return _response.data

    def delete_tag(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        You can delete the details of tags that are on the workspace by passing in the id.

        Parameters
        ----------
        id : str
            The unique identifier of a given tag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tags.delete_tag(
            id="123",
        )
        """
        _response = self._raw_client.delete_tag(id, request_options=request_options)
        return _response.data

    def attach_tag_to_ticket(
        self, ticket_id: str, *, id: str, admin_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can tag a specific ticket. This will return a tag object for the tag that was added to the ticket.

        Parameters
        ----------
        ticket_id : str
            ticket_id

        id : str
            The unique identifier for the tag which is given by Intercom

        admin_id : str
            The unique identifier for the admin which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tags.attach_tag_to_ticket(
            ticket_id="64619700005694",
            id="7522907",
            admin_id="780",
        )
        """
        _response = self._raw_client.attach_tag_to_ticket(
            ticket_id, id=id, admin_id=admin_id, request_options=request_options
        )
        return _response.data

    def detach_tag_from_ticket(
        self, ticket_id: str, id: str, *, admin_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can remove tag from a specific ticket. This will return a tag object for the tag that was removed from the ticket.

        Parameters
        ----------
        ticket_id : str
            ticket_id

        id : str
            The unique identifier for the tag which is given by Intercom

        admin_id : str
            The unique identifier for the admin which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tags.detach_tag_from_ticket(
            ticket_id="64619700005694",
            id="7522907",
            admin_id="123",
        )
        """
        _response = self._raw_client.detach_tag_from_ticket(
            ticket_id, id, admin_id=admin_id, request_options=request_options
        )
        return _response.data


class AsyncTagsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTagsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTagsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTagsClient
        """
        return self._raw_client

    async def attach_tag_to_contact(
        self, contact_id: str, *, id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can tag a specific contact. This will return a tag object for the tag that was added to the contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier for the contact which is given by Intercom

        id : str
            The unique identifier for the tag which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tags.attach_tag_to_contact(
                contact_id="63a07ddf05a32042dffac965",
                id="7522907",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.attach_tag_to_contact(contact_id, id=id, request_options=request_options)
        return _response.data

    async def detach_tag_from_contact(
        self, contact_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can remove tag from a specific contact. This will return a tag object for the tag that was removed from the contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier for the contact which is given by Intercom

        id : str
            The unique identifier for the tag which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tags.detach_tag_from_contact(
                contact_id="63a07ddf05a32042dffac965",
                id="7522907",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.detach_tag_from_contact(contact_id, id, request_options=request_options)
        return _response.data

    async def attach_tag_to_conversation(
        self, conversation_id: str, *, id: str, admin_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can tag a specific conversation. This will return a tag object for the tag that was added to the conversation.

        Parameters
        ----------
        conversation_id : str
            conversation_id

        id : str
            The unique identifier for the tag which is given by Intercom

        admin_id : str
            The unique identifier for the admin which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tags.attach_tag_to_conversation(
                conversation_id="64619700005694",
                id="7522907",
                admin_id="780",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.attach_tag_to_conversation(
            conversation_id, id=id, admin_id=admin_id, request_options=request_options
        )
        return _response.data

    async def detach_tag_from_conversation(
        self, conversation_id: str, id: str, *, admin_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can remove tag from a specific conversation. This will return a tag object for the tag that was removed from the conversation.

        Parameters
        ----------
        conversation_id : str
            conversation_id

        id : str
            id

        admin_id : str
            The unique identifier for the admin which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tags.detach_tag_from_conversation(
                conversation_id="64619700005694",
                id="7522907",
                admin_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.detach_tag_from_conversation(
            conversation_id, id, admin_id=admin_id, request_options=request_options
        )
        return _response.data

    async def list_tags(self, *, request_options: typing.Optional[RequestOptions] = None) -> TagList:
        """
        You can fetch a list of all tags for a given workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagList
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tags.list_tags()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_tags(request_options=request_options)
        return _response.data

    async def create_tag(
        self, *, request: CreateTagRequestBody, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can use this endpoint to perform the following operations:

          **1. Create a new tag:** You can create a new tag by passing in the tag name as specified in "Create or Update Tag Request Payload" described below.

          **2. Update an existing tag:** You can update an existing tag by passing the id of the tag as specified in "Create or Update Tag Request Payload" described below.

          **3. Tag Companies:** You can tag single company or a list of companies. You can tag a company by passing in the tag name and the company details as specified in "Tag Company Request Payload" described below. Also, if the tag doesn't exist then a new one will be created automatically.

          **4. Untag Companies:** You can untag a single company or a list of companies. You can untag a company by passing in the tag id and the company details as specified in "Untag Company Request Payload" described below.

          **5. Tag Multiple Users:** You can tag a list of users. You can tag the users by passing in the tag name and the user details as specified in "Tag Users Request Payload" described below.

        Each operation will return a tag object.

        Parameters
        ----------
        request : CreateTagRequestBody

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            Action successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.unstable import CreateOrUpdateTagRequest

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tags.create_tag(
                request=CreateOrUpdateTagRequest(
                    name="test",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_tag(request=request, request_options=request_options)
        return _response.data

    async def find_tag(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Tag:
        """
        You can fetch the details of tags that are on the workspace by their id.
        This will return a tag object.

        Parameters
        ----------
        id : str
            The unique identifier of a given tag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            Tag found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tags.find_tag(
                id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.find_tag(id, request_options=request_options)
        return _response.data

    async def delete_tag(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        You can delete the details of tags that are on the workspace by passing in the id.

        Parameters
        ----------
        id : str
            The unique identifier of a given tag

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tags.delete_tag(
                id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_tag(id, request_options=request_options)
        return _response.data

    async def attach_tag_to_ticket(
        self, ticket_id: str, *, id: str, admin_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can tag a specific ticket. This will return a tag object for the tag that was added to the ticket.

        Parameters
        ----------
        ticket_id : str
            ticket_id

        id : str
            The unique identifier for the tag which is given by Intercom

        admin_id : str
            The unique identifier for the admin which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tags.attach_tag_to_ticket(
                ticket_id="64619700005694",
                id="7522907",
                admin_id="780",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.attach_tag_to_ticket(
            ticket_id, id=id, admin_id=admin_id, request_options=request_options
        )
        return _response.data

    async def detach_tag_from_ticket(
        self, ticket_id: str, id: str, *, admin_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Tag:
        """
        You can remove tag from a specific ticket. This will return a tag object for the tag that was removed from the ticket.

        Parameters
        ----------
        ticket_id : str
            ticket_id

        id : str
            The unique identifier for the tag which is given by Intercom

        admin_id : str
            The unique identifier for the admin which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Tag
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tags.detach_tag_from_ticket(
                ticket_id="64619700005694",
                id="7522907",
                admin_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.detach_tag_from_ticket(
            ticket_id, id, admin_id=admin_id, request_options=request_options
        )
        return _response.data
