# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawJobsClient, RawJobsClient
from .types.jobs import Jobs


class JobsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawJobsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawJobsClient
        """
        return self._raw_client

    def status(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Jobs:
        """
        Retrieve the status of job execution.

        Parameters
        ----------
        id : str
            The unique identifier for the job which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Jobs
            Job execution status

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.jobs.status(
            id="id",
        )
        """
        _response = self._raw_client.status(id, request_options=request_options)
        return _response.data


class AsyncJobsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawJobsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawJobsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawJobsClient
        """
        return self._raw_client

    async def status(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Jobs:
        """
        Retrieve the status of job execution.

        Parameters
        ----------
        id : str
            The unique identifier for the job which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Jobs
            Job execution status

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.jobs.status(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.status(id, request_options=request_options)
        return _response.data
