# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel


class DataEvent(UncheckedBaseModel):
    """
    Data events are used to notify Intercom of changes to your data.
    """

    type: typing.Optional[typing.Literal["event"]] = pydantic.Field(default=None)
    """
    The type of the object
    """

    event_name: str = pydantic.Field()
    """
    The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example `updated-plan`.
    """

    created_at: int = pydantic.Field()
    """
    The time the event occurred as a UTC Unix timestamp
    """

    user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Your identifier for the user.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Your identifier for a lead or a user.
    """

    intercom_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Intercom identifier for the user.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    An email address for your user. An email should only be used where your application uses email to uniquely identify users.
    """

    metadata: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Optional metadata about the event.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
