# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel


class CustomObjectInstance(UncheckedBaseModel):
    """
    A Custom Object Instance represents an instance of a custom object type. This allows you to create and set custom attributes to store data about your customers that is not already captured by Intercom. The parent object includes recommended default attributes and you can add your own custom attributes.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Intercom defined id representing the custom object instance.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id you have defined for the custom object instance.
    """

    external_created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the Custom Object instance was created in the external system it originated from.
    """

    external_updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the Custom Object instance was last updated in the external system it originated from.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the attribute was created as a UTC Unix timestamp
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the attribute was last updated as a UTC Unix timestamp
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier of the custom object type that defines the structure of the custom object instance.
    """

    custom_attributes: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    The custom attributes you have set on the custom object instance.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
