# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.custom_channel_attribute import CustomChannelAttribute
from ..types.custom_channel_contact import CustomChannelContact
from ..types.custom_channel_notification_response import CustomChannelNotificationResponse
from ..types.error import Error

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawCustomChannelEventsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def notify_new_conversation(
        self,
        *,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CustomChannelNotificationResponse]:
        """
        Notifies Intercom that a new conversation was created in your custom channel/platform. This triggers conversation creation and workflow automations within Intercom for your custom channel integration.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomChannelNotificationResponse]
            Successfully notified Intercom
        """
        _response = self._client_wrapper.httpx_client.request(
            "custom_channel_events/notify_new_conversation",
            method="POST",
            json={
                "event_id": event_id,
                "external_conversation_id": external_conversation_id,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=CustomChannelContact, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomChannelNotificationResponse,
                    construct_type(
                        type_=CustomChannelNotificationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def notify_new_message(
        self,
        *,
        body: str,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CustomChannelNotificationResponse]:
        """
        Notifies Intercom that a new message was sent in a conversation on your custom channel/platform. This allows Intercom to process the message and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        body : str
            The message content sent by the user.

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomChannelNotificationResponse]
            Successfully notified Intercom
        """
        _response = self._client_wrapper.httpx_client.request(
            "custom_channel_events/notify_new_message",
            method="POST",
            json={
                "body": body,
                "event_id": event_id,
                "external_conversation_id": external_conversation_id,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=CustomChannelContact, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomChannelNotificationResponse,
                    construct_type(
                        type_=CustomChannelNotificationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def notify_quick_reply_selected(
        self,
        *,
        quick_reply_option_id: str,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CustomChannelNotificationResponse]:
        """
        Notifies Intercom that a user selected a quick reply option in your custom channel/platform. This allows Intercom to process the response and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        quick_reply_option_id : str
            Id of the selected quick reply option.

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomChannelNotificationResponse]
            Successfully notified Intercom
        """
        _response = self._client_wrapper.httpx_client.request(
            "custom_channel_events/notify_quick_reply_selected",
            method="POST",
            json={
                "quick_reply_option_id": quick_reply_option_id,
                "event_id": event_id,
                "external_conversation_id": external_conversation_id,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=CustomChannelContact, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomChannelNotificationResponse,
                    construct_type(
                        type_=CustomChannelNotificationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def notify_attribute_collected(
        self,
        *,
        attribute: CustomChannelAttribute,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CustomChannelNotificationResponse]:
        """
        Notifies Intercom that a user provided a response to an attribute collector in your custom channel/platform. This allows Intercom to process the attribute and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        attribute : CustomChannelAttribute

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomChannelNotificationResponse]
            Successfully notified Intercom
        """
        _response = self._client_wrapper.httpx_client.request(
            "custom_channel_events/notify_attribute_collected",
            method="POST",
            json={
                "attribute": convert_and_respect_annotation_metadata(
                    object_=attribute, annotation=CustomChannelAttribute, direction="write"
                ),
                "event_id": event_id,
                "external_conversation_id": external_conversation_id,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=CustomChannelContact, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomChannelNotificationResponse,
                    construct_type(
                        type_=CustomChannelNotificationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawCustomChannelEventsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def notify_new_conversation(
        self,
        *,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CustomChannelNotificationResponse]:
        """
        Notifies Intercom that a new conversation was created in your custom channel/platform. This triggers conversation creation and workflow automations within Intercom for your custom channel integration.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomChannelNotificationResponse]
            Successfully notified Intercom
        """
        _response = await self._client_wrapper.httpx_client.request(
            "custom_channel_events/notify_new_conversation",
            method="POST",
            json={
                "event_id": event_id,
                "external_conversation_id": external_conversation_id,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=CustomChannelContact, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomChannelNotificationResponse,
                    construct_type(
                        type_=CustomChannelNotificationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def notify_new_message(
        self,
        *,
        body: str,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CustomChannelNotificationResponse]:
        """
        Notifies Intercom that a new message was sent in a conversation on your custom channel/platform. This allows Intercom to process the message and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        body : str
            The message content sent by the user.

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomChannelNotificationResponse]
            Successfully notified Intercom
        """
        _response = await self._client_wrapper.httpx_client.request(
            "custom_channel_events/notify_new_message",
            method="POST",
            json={
                "body": body,
                "event_id": event_id,
                "external_conversation_id": external_conversation_id,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=CustomChannelContact, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomChannelNotificationResponse,
                    construct_type(
                        type_=CustomChannelNotificationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def notify_quick_reply_selected(
        self,
        *,
        quick_reply_option_id: str,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CustomChannelNotificationResponse]:
        """
        Notifies Intercom that a user selected a quick reply option in your custom channel/platform. This allows Intercom to process the response and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        quick_reply_option_id : str
            Id of the selected quick reply option.

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomChannelNotificationResponse]
            Successfully notified Intercom
        """
        _response = await self._client_wrapper.httpx_client.request(
            "custom_channel_events/notify_quick_reply_selected",
            method="POST",
            json={
                "quick_reply_option_id": quick_reply_option_id,
                "event_id": event_id,
                "external_conversation_id": external_conversation_id,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=CustomChannelContact, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomChannelNotificationResponse,
                    construct_type(
                        type_=CustomChannelNotificationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def notify_attribute_collected(
        self,
        *,
        attribute: CustomChannelAttribute,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CustomChannelNotificationResponse]:
        """
        Notifies Intercom that a user provided a response to an attribute collector in your custom channel/platform. This allows Intercom to process the attribute and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        attribute : CustomChannelAttribute

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomChannelNotificationResponse]
            Successfully notified Intercom
        """
        _response = await self._client_wrapper.httpx_client.request(
            "custom_channel_events/notify_attribute_collected",
            method="POST",
            json={
                "attribute": convert_and_respect_annotation_metadata(
                    object_=attribute, annotation=CustomChannelAttribute, direction="write"
                ),
                "event_id": event_id,
                "external_conversation_id": external_conversation_id,
                "contact": convert_and_respect_annotation_metadata(
                    object_=contact, annotation=CustomChannelContact, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomChannelNotificationResponse,
                    construct_type(
                        type_=CustomChannelNotificationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
