# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from .company_plan import CompanyPlan
from .company_segments import CompanySegments
from .company_tags import CompanyTags


class Company(UncheckedBaseModel):
    """
    Companies allow you to represent organizations using your product. Each company will have its own description and be associated with contacts. You can fetch, create, update and list companies.
    """

    type: typing.Optional[typing.Literal["company"]] = pydantic.Field(default=None)
    """
    Value is `company`
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Intercom defined id representing the company.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the company.
    """

    app_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Intercom defined code of the workspace the company is associated to.
    """

    plan: typing.Optional[CompanyPlan] = None
    company_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The company id you have defined for the company.
    """

    remote_created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the company was created by you.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the company was added in Intercom.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The last time the company was updated.
    """

    last_request_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the company last recorded making a request.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of employees in the company.
    """

    website: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL for the company website.
    """

    industry: typing.Optional[str] = pydantic.Field(default=None)
    """
    The industry that the company operates in.
    """

    monthly_spend: typing.Optional[int] = pydantic.Field(default=None)
    """
    How much revenue the company generates for your business.
    """

    session_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    How many sessions the company has recorded.
    """

    user_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of users in the company.
    """

    custom_attributes: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    The custom attributes you have set on the company.
    """

    tags: typing.Optional[CompanyTags] = pydantic.Field(default=None)
    """
    The list of tags associated with the company
    """

    segments: typing.Optional[CompanySegments] = pydantic.Field(default=None)
    """
    The list of segments associated with the company
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
