# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from ...types.team_priority_level import TeamPriorityLevel


class Admin(UncheckedBaseModel):
    """
    Admins are teammate accounts that have access to a workspace.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    String representing the object's type. Always has the value `admin`.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id representing the admin.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the admin.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email of the admin.
    """

    job_title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The job title of the admin.
    """

    away_mode_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Identifies if this admin is currently set in away mode.
    """

    away_mode_reassign: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.
    """

    away_status_reason_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The unique identifier of the away status reason
    """

    has_inbox_seat: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Identifies if this admin has a paid inbox seat to restrict/allow features that require them.
    """

    team_ids: typing.Optional[typing.List[int]] = pydantic.Field(default=None)
    """
    This object represents the avatar associated with the admin.
    """

    avatar: typing.Optional[str] = pydantic.Field(default=None)
    """
    Image for the associated team or teammate
    """

    team_priority_level: typing.Optional[TeamPriorityLevel] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
