# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.activity_log_list import ActivityLogList
from ..types.admin_list import AdminList
from ..types.admin_with_app import AdminWithApp
from .raw_client import AsyncRawAdminsClient, RawAdminsClient
from .types.admin import Admin

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AdminsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAdminsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAdminsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAdminsClient
        """
        return self._raw_client

    def identify_admin(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[AdminWithApp]:
        """

        You can view the currently authorised admin along with the embedded app object (a "workspace" in legacy terminology).

        > 🚧 Single Sign On
        >
        > If you are building a custom "Log in with Intercom" flow for your site, and you call the `/me` endpoint to identify the logged-in user, you should not accept any sign-ins from users with unverified email addresses as it poses a potential impersonation security risk.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[AdminWithApp]
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.admins.identify_admin()
        """
        _response = self._raw_client.identify_admin(request_options=request_options)
        return _response.data

    def set_away_admin(
        self,
        id: int,
        *,
        away_mode_enabled: bool,
        away_mode_reassign: bool,
        away_status_reason_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[Admin]:
        """
        You can set an Admin as away for the Inbox.

        Parameters
        ----------
        id : int
            The unique identifier of a given admin

        away_mode_enabled : bool
            Set to "true" to change the status of the admin to away.

        away_mode_reassign : bool
            Set to "true" to assign any new conversation replies to your default inbox.

        away_status_reason_id : typing.Optional[int]
            The unique identifier of the away status reason

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Admin]
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.admins.set_away_admin(
            id=1,
            away_mode_enabled=True,
            away_mode_reassign=True,
            away_status_reason_id=12345,
        )
        """
        _response = self._raw_client.set_away_admin(
            id,
            away_mode_enabled=away_mode_enabled,
            away_mode_reassign=away_mode_reassign,
            away_status_reason_id=away_status_reason_id,
            request_options=request_options,
        )
        return _response.data

    def list_activity_logs(
        self,
        *,
        created_at_after: str,
        created_at_before: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ActivityLogList:
        """
        You can get a log of activities by all admins in an app.

        Parameters
        ----------
        created_at_after : str
            The start date that you request data for. It must be formatted as a UNIX timestamp.

        created_at_before : typing.Optional[str]
            The end date that you request data for. It must be formatted as a UNIX timestamp.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActivityLogList
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.admins.list_activity_logs(
            created_at_after="1677253093",
            created_at_before="1677861493",
        )
        """
        _response = self._raw_client.list_activity_logs(
            created_at_after=created_at_after, created_at_before=created_at_before, request_options=request_options
        )
        return _response.data

    def list_admins(self, *, request_options: typing.Optional[RequestOptions] = None) -> AdminList:
        """
        You can fetch a list of admins for a given workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AdminList
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.admins.list_admins()
        """
        _response = self._raw_client.list_admins(request_options=request_options)
        return _response.data

    def retrieve_admin(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[Admin]:
        """
        You can retrieve the details of a single admin.

        Parameters
        ----------
        id : int
            The unique identifier of a given admin

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Admin]
            Admin found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.admins.retrieve_admin(
            id=1,
        )
        """
        _response = self._raw_client.retrieve_admin(id, request_options=request_options)
        return _response.data


class AsyncAdminsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAdminsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAdminsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAdminsClient
        """
        return self._raw_client

    async def identify_admin(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[AdminWithApp]:
        """

        You can view the currently authorised admin along with the embedded app object (a "workspace" in legacy terminology).

        > 🚧 Single Sign On
        >
        > If you are building a custom "Log in with Intercom" flow for your site, and you call the `/me` endpoint to identify the logged-in user, you should not accept any sign-ins from users with unverified email addresses as it poses a potential impersonation security risk.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[AdminWithApp]
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.admins.identify_admin()


        asyncio.run(main())
        """
        _response = await self._raw_client.identify_admin(request_options=request_options)
        return _response.data

    async def set_away_admin(
        self,
        id: int,
        *,
        away_mode_enabled: bool,
        away_mode_reassign: bool,
        away_status_reason_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[Admin]:
        """
        You can set an Admin as away for the Inbox.

        Parameters
        ----------
        id : int
            The unique identifier of a given admin

        away_mode_enabled : bool
            Set to "true" to change the status of the admin to away.

        away_mode_reassign : bool
            Set to "true" to assign any new conversation replies to your default inbox.

        away_status_reason_id : typing.Optional[int]
            The unique identifier of the away status reason

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Admin]
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.admins.set_away_admin(
                id=1,
                away_mode_enabled=True,
                away_mode_reassign=True,
                away_status_reason_id=12345,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set_away_admin(
            id,
            away_mode_enabled=away_mode_enabled,
            away_mode_reassign=away_mode_reassign,
            away_status_reason_id=away_status_reason_id,
            request_options=request_options,
        )
        return _response.data

    async def list_activity_logs(
        self,
        *,
        created_at_after: str,
        created_at_before: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ActivityLogList:
        """
        You can get a log of activities by all admins in an app.

        Parameters
        ----------
        created_at_after : str
            The start date that you request data for. It must be formatted as a UNIX timestamp.

        created_at_before : typing.Optional[str]
            The end date that you request data for. It must be formatted as a UNIX timestamp.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActivityLogList
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.admins.list_activity_logs(
                created_at_after="1677253093",
                created_at_before="1677861493",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_activity_logs(
            created_at_after=created_at_after, created_at_before=created_at_before, request_options=request_options
        )
        return _response.data

    async def list_admins(self, *, request_options: typing.Optional[RequestOptions] = None) -> AdminList:
        """
        You can fetch a list of admins for a given workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AdminList
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.admins.list_admins()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_admins(request_options=request_options)
        return _response.data

    async def retrieve_admin(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[Admin]:
        """
        You can retrieve the details of a single admin.

        Parameters
        ----------
        id : int
            The unique identifier of a given admin

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Admin]
            Admin found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.admins.retrieve_admin(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_admin(id, request_options=request_options)
        return _response.data
