# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class PartAttachment(UncheckedBaseModel):
    """
    The file attached to a part
    """

    type: str = pydantic.Field()
    """
    The type of attachment
    """

    name: str = pydantic.Field()
    """
    The name of the attachment
    """

    url: str = pydantic.Field()
    """
    The URL of the attachment
    """

    content_type: str = pydantic.Field()
    """
    The content type of the attachment
    """

    filesize: int = pydantic.Field()
    """
    The size of the attachment
    """

    width: int = pydantic.Field()
    """
    The width of the attachment
    """

    height: int = pydantic.Field()
    """
    The height of the attachment
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
