# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from ..news.types.news_item import NewsItem
from .cursor_pages import CursorPages


class PaginatedNewsItemResponse(UncheckedBaseModel):
    """
    Paginated News Item Response
    """

    type: typing.Literal["list"] = pydantic.Field(default="list")
    """
    The type of object
    """

    pages: typing.Optional[CursorPages] = None
    total_count: int = pydantic.Field()
    """
    A count of the total number of News Items.
    """

    data: typing.List[NewsItem] = pydantic.Field()
    """
    An array of News Items
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
