# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class PagesLink(UncheckedBaseModel):
    """
    The majority of list resources in the API are paginated to allow clients to traverse data over multiple requests.

    Their responses are likely to contain a pages object that hosts pagination links which a client can use to paginate through the data without having to construct a query. The link relations for the pages field are as follows.
    """

    type: typing.Literal["pages"] = "pages"
    page: int
    next: typing.Optional[str] = pydantic.Field(default=None)
    """
    A link to the next page of results. A response that does not contain a next link does not have further data to fetch.
    """

    per_page: int
    total_pages: int

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
