# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class DataTableItem(UncheckedBaseModel):
    """
    A field-value pair component for use in a data table.
    """

    type: typing.Literal["field-value"] = pydantic.Field(default="field-value")
    """
    The type of component you are rendering.
    """

    field: str = pydantic.Field()
    """
    The text of the key in your key-value pair.
    """

    value: str = pydantic.Field()
    """
    The text of the value in your key-value pair.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
