# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .create_ticket_request_contacts_item import CreateTicketRequestContactsItem
from .ticket_request_custom_attributes import TicketRequestCustomAttributes


class CreateTicketRequest(UncheckedBaseModel):
    """
    You can create a Ticket
    """

    ticket_type_id: str = pydantic.Field()
    """
    The ID of the type of ticket you want to create
    """

    contacts: typing.List[CreateTicketRequestContactsItem] = pydantic.Field()
    """
    The list of contacts (users or leads) affected by this ticket. Currently only one is allowed
    """

    company_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the company that the ticket is associated with. The ID that you set upon company creation.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the ticket was created. If not provided, the current time will be used.
    """

    ticket_attributes: typing.Optional[TicketRequestCustomAttributes] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
