# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class App(UncheckedBaseModel):
    """
    App is a workspace on Intercom
    """

    type: str = pydantic.Field()
    """
    
    """

    id_code: str = pydantic.Field()
    """
    The id of the app.
    """

    name: str = pydantic.Field()
    """
    The name of the app.
    """

    region: str = pydantic.Field()
    """
    The Intercom region the app is located in.
    """

    timezone: str = pydantic.Field()
    """
    The timezone of the region where the app is located.
    """

    created_at: int = pydantic.Field()
    """
    When the app was created.
    """

    identity_verification: bool = pydantic.Field()
    """
    Whether or not the app uses identity verification.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
