# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .admin_with_app_avatar import AdminWithAppAvatar
from .app import App


class AdminWithApp(UncheckedBaseModel):
    """
    Admins are the teammate accounts that have access to a workspace
    """

    type: typing.Literal["admin"] = pydantic.Field(default="admin")
    """
    String representing the object's type. Always has the value `admin`.
    """

    id: str = pydantic.Field()
    """
    The id representing the admin.
    """

    name: str = pydantic.Field()
    """
    The name of the admin.
    """

    email: str = pydantic.Field()
    """
    The email of the admin.
    """

    job_title: str = pydantic.Field()
    """
    The job title of the admin.
    """

    away_mode_enabled: bool = pydantic.Field()
    """
    Identifies if this admin is currently set in away mode.
    """

    away_mode_reassign: bool = pydantic.Field()
    """
    Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.
    """

    has_inbox_seat: bool = pydantic.Field()
    """
    Identifies if this admin has a paid inbox seat to restrict/allow features that require them.
    """

    team_ids: typing.List[int] = pydantic.Field()
    """
    This is a list of ids of the teams that this admin is part of.
    """

    avatar: typing.Optional[AdminWithAppAvatar] = pydantic.Field(default=None)
    """
    This object represents the avatar associated with the admin.
    """

    email_verified: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Identifies if this admin's email is verified.
    """

    app: typing.Optional[App] = pydantic.Field(default=None)
    """
    App that the admin belongs to.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
