# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.ticket_type_attribute_list import TicketTypeAttributeList
from .ticket_type_category import TicketTypeCategory


class TicketType(UncheckedBaseModel):
    """
    A ticket type, used to define the data fields to be captured in a ticket.
    """

    type: typing.Literal["ticket_type"] = pydantic.Field(default="ticket_type")
    """
    String representing the object's type. Always has the value `ticket_type`.
    """

    id: str = pydantic.Field()
    """
    The id representing the ticket type.
    """

    category: TicketTypeCategory = pydantic.Field()
    """
    Category of the Ticket Type.
    """

    name: str = pydantic.Field()
    """
    The name of the ticket type
    """

    description: str = pydantic.Field()
    """
    The description of the ticket type
    """

    icon: str = pydantic.Field()
    """
    The icon of the ticket type
    """

    workspace_id: str = pydantic.Field()
    """
    The id of the workspace that the ticket type belongs to.
    """

    ticket_type_attributes: TicketTypeAttributeList
    archived: bool = pydantic.Field()
    """
    Whether the ticket type is archived or not.
    """

    created_at: int = pydantic.Field()
    """
    The date and time the ticket type was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The date and time the ticket type was last updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
