# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..tickets.types.ticket_type import TicketType
from ..types.ticket_type_list import TicketTypeList
from .attributes.client import AsyncAttributesClient, AttributesClient
from .raw_client import AsyncRawTicketTypesClient, RawTicketTypesClient
from .types.create_ticket_type_request_category import CreateTicketTypeRequestCategory
from .types.update_ticket_type_request_body_category import UpdateTicketTypeRequestBodyCategory

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TicketTypesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTicketTypesClient(client_wrapper=client_wrapper)
        self.attributes = AttributesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTicketTypesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTicketTypesClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> TicketTypeList:
        """
        You can get a list of all ticket types for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketTypeList
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ticket_types.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        category: typing.Optional[CreateTicketTypeRequestCategory] = OMIT,
        icon: typing.Optional[str] = OMIT,
        is_internal: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketType:
        """
        You can create a new ticket type.
        > 📘 Creating ticket types.
        >
        > Every ticket type will be created with two default attributes: _default_title_ and _default_description_.
        > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)

        Parameters
        ----------
        name : str
            The name of the ticket type.

        description : typing.Optional[str]
            The description of the ticket type.

        category : typing.Optional[CreateTicketTypeRequestCategory]
            Category of the Ticket Type.

        icon : typing.Optional[str]
            The icon of the ticket type.

        is_internal : typing.Optional[bool]
            Whether the tickets associated with this ticket type are intended for internal use only or will be shared with customers. This is currently a limited attribute.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketType
            Ticket type created

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ticket_types.create(
            name="Customer Issue",
            description="Customer Report Template",
            category="Customer",
            icon="🎟️",
        )
        """
        _response = self._raw_client.create(
            name=name,
            description=description,
            category=category,
            icon=icon,
            is_internal=is_internal,
            request_options=request_options,
        )
        return _response.data

    def get(self, ticket_type_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> TicketType:
        """
        You can fetch the details of a single ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketType
            Ticket type found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ticket_types.get(
            ticket_type_id="ticket_type_id",
        )
        """
        _response = self._raw_client.get(ticket_type_id, request_options=request_options)
        return _response.data

    def update(
        self,
        ticket_type_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        category: typing.Optional[UpdateTicketTypeRequestBodyCategory] = OMIT,
        icon: typing.Optional[str] = OMIT,
        archived: typing.Optional[bool] = OMIT,
        is_internal: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketType:
        """

        You can update a ticket type.

        > 📘 Updating a ticket type.
        >
        > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        name : typing.Optional[str]
            The name of the ticket type.

        description : typing.Optional[str]
            The description of the ticket type.

        category : typing.Optional[UpdateTicketTypeRequestBodyCategory]
            Category of the Ticket Type.

        icon : typing.Optional[str]
            The icon of the ticket type.

        archived : typing.Optional[bool]
            The archived status of the ticket type.

        is_internal : typing.Optional[bool]
            Whether the tickets associated with this ticket type are intended for internal use only or will be shared with customers. This is currently a limited attribute.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketType
            Ticket type updated

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ticket_types.update(
            ticket_type_id="ticket_type_id",
            name="Bug Report 2",
        )
        """
        _response = self._raw_client.update(
            ticket_type_id,
            name=name,
            description=description,
            category=category,
            icon=icon,
            archived=archived,
            is_internal=is_internal,
            request_options=request_options,
        )
        return _response.data


class AsyncTicketTypesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTicketTypesClient(client_wrapper=client_wrapper)
        self.attributes = AsyncAttributesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTicketTypesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTicketTypesClient
        """
        return self._raw_client

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> TicketTypeList:
        """
        You can get a list of all ticket types for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketTypeList
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ticket_types.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        category: typing.Optional[CreateTicketTypeRequestCategory] = OMIT,
        icon: typing.Optional[str] = OMIT,
        is_internal: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketType:
        """
        You can create a new ticket type.
        > 📘 Creating ticket types.
        >
        > Every ticket type will be created with two default attributes: _default_title_ and _default_description_.
        > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)

        Parameters
        ----------
        name : str
            The name of the ticket type.

        description : typing.Optional[str]
            The description of the ticket type.

        category : typing.Optional[CreateTicketTypeRequestCategory]
            Category of the Ticket Type.

        icon : typing.Optional[str]
            The icon of the ticket type.

        is_internal : typing.Optional[bool]
            Whether the tickets associated with this ticket type are intended for internal use only or will be shared with customers. This is currently a limited attribute.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketType
            Ticket type created

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ticket_types.create(
                name="Customer Issue",
                description="Customer Report Template",
                category="Customer",
                icon="🎟️",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            description=description,
            category=category,
            icon=icon,
            is_internal=is_internal,
            request_options=request_options,
        )
        return _response.data

    async def get(self, ticket_type_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> TicketType:
        """
        You can fetch the details of a single ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketType
            Ticket type found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ticket_types.get(
                ticket_type_id="ticket_type_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(ticket_type_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        ticket_type_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        category: typing.Optional[UpdateTicketTypeRequestBodyCategory] = OMIT,
        icon: typing.Optional[str] = OMIT,
        archived: typing.Optional[bool] = OMIT,
        is_internal: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketType:
        """

        You can update a ticket type.

        > 📘 Updating a ticket type.
        >
        > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        name : typing.Optional[str]
            The name of the ticket type.

        description : typing.Optional[str]
            The description of the ticket type.

        category : typing.Optional[UpdateTicketTypeRequestBodyCategory]
            Category of the Ticket Type.

        icon : typing.Optional[str]
            The icon of the ticket type.

        archived : typing.Optional[bool]
            The archived status of the ticket type.

        is_internal : typing.Optional[bool]
            Whether the tickets associated with this ticket type are intended for internal use only or will be shared with customers. This is currently a limited attribute.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketType
            Ticket type updated

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ticket_types.update(
                ticket_type_id="ticket_type_id",
                name="Bug Report 2",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            ticket_type_id,
            name=name,
            description=description,
            category=category,
            icon=icon,
            archived=archived,
            is_internal=is_internal,
            request_options=request_options,
        )
        return _response.data
