# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.request_options import RequestOptions
from ...core.unchecked_base_model import construct_type
from ...errors.unauthorized_error import UnauthorizedError
from ...types.error import Error
from ...types.ticket_type_attribute import TicketTypeAttribute
from .types.create_ticket_type_attribute_request_data_type import CreateTicketTypeAttributeRequestDataType

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawAttributesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        ticket_type_id: str,
        *,
        name: str,
        description: str,
        data_type: CreateTicketTypeAttributeRequestDataType,
        required_to_create: typing.Optional[bool] = OMIT,
        required_to_create_for_contacts: typing.Optional[bool] = OMIT,
        visible_on_create: typing.Optional[bool] = OMIT,
        visible_to_contacts: typing.Optional[bool] = OMIT,
        multiline: typing.Optional[bool] = OMIT,
        list_items: typing.Optional[str] = OMIT,
        allow_multiple_values: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TicketTypeAttribute]:
        """
        You can create a new attribute for a ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        name : str
            The name of the ticket type attribute

        description : str
            The description of the attribute presented to the teammate or contact

        data_type : CreateTicketTypeAttributeRequestDataType
            The data type of the attribute

        required_to_create : typing.Optional[bool]
            Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.

        required_to_create_for_contacts : typing.Optional[bool]
            Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.

        visible_on_create : typing.Optional[bool]
            Whether the attribute is visible to teammates when creating a ticket in Inbox.

        visible_to_contacts : typing.Optional[bool]
            Whether the attribute is visible to contacts when creating a ticket in Messenger.

        multiline : typing.Optional[bool]
            Whether the attribute allows multiple lines of text (only applicable to string attributes)

        list_items : typing.Optional[str]
            A comma delimited list of items for the attribute value (only applicable to list attributes)

        allow_multiple_values : typing.Optional[bool]
            Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TicketTypeAttribute]
            Ticket Type Attribute created
        """
        _response = self._client_wrapper.httpx_client.request(
            f"ticket_types/{jsonable_encoder(ticket_type_id)}/attributes",
            method="POST",
            json={
                "name": name,
                "description": description,
                "data_type": data_type,
                "required_to_create": required_to_create,
                "required_to_create_for_contacts": required_to_create_for_contacts,
                "visible_on_create": visible_on_create,
                "visible_to_contacts": visible_to_contacts,
                "multiline": multiline,
                "list_items": list_items,
                "allow_multiple_values": allow_multiple_values,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TicketTypeAttribute,
                    construct_type(
                        type_=TicketTypeAttribute,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        ticket_type_id: str,
        attribute_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        required_to_create: typing.Optional[bool] = OMIT,
        required_to_create_for_contacts: typing.Optional[bool] = OMIT,
        visible_on_create: typing.Optional[bool] = OMIT,
        visible_to_contacts: typing.Optional[bool] = OMIT,
        multiline: typing.Optional[bool] = OMIT,
        list_items: typing.Optional[str] = OMIT,
        allow_multiple_values: typing.Optional[bool] = OMIT,
        archived: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TicketTypeAttribute]:
        """
        You can update an existing attribute for a ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        attribute_id : str
            The unique identifier for the ticket type attribute which is given by Intercom.

        name : typing.Optional[str]
            The name of the ticket type attribute

        description : typing.Optional[str]
            The description of the attribute presented to the teammate or contact

        required_to_create : typing.Optional[bool]
            Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.

        required_to_create_for_contacts : typing.Optional[bool]
            Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.

        visible_on_create : typing.Optional[bool]
            Whether the attribute is visible to teammates when creating a ticket in Inbox.

        visible_to_contacts : typing.Optional[bool]
            Whether the attribute is visible to contacts when creating a ticket in Messenger.

        multiline : typing.Optional[bool]
            Whether the attribute allows multiple lines of text (only applicable to string attributes)

        list_items : typing.Optional[str]
            A comma delimited list of items for the attribute value (only applicable to list attributes)

        allow_multiple_values : typing.Optional[bool]
            Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)

        archived : typing.Optional[bool]
            Whether the attribute should be archived and not shown during creation of the ticket (it will still be present on previously created tickets)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TicketTypeAttribute]
            Ticket Type Attribute updated
        """
        _response = self._client_wrapper.httpx_client.request(
            f"ticket_types/{jsonable_encoder(ticket_type_id)}/attributes/{jsonable_encoder(attribute_id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "required_to_create": required_to_create,
                "required_to_create_for_contacts": required_to_create_for_contacts,
                "visible_on_create": visible_on_create,
                "visible_to_contacts": visible_to_contacts,
                "multiline": multiline,
                "list_items": list_items,
                "allow_multiple_values": allow_multiple_values,
                "archived": archived,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TicketTypeAttribute,
                    construct_type(
                        type_=TicketTypeAttribute,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAttributesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        ticket_type_id: str,
        *,
        name: str,
        description: str,
        data_type: CreateTicketTypeAttributeRequestDataType,
        required_to_create: typing.Optional[bool] = OMIT,
        required_to_create_for_contacts: typing.Optional[bool] = OMIT,
        visible_on_create: typing.Optional[bool] = OMIT,
        visible_to_contacts: typing.Optional[bool] = OMIT,
        multiline: typing.Optional[bool] = OMIT,
        list_items: typing.Optional[str] = OMIT,
        allow_multiple_values: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TicketTypeAttribute]:
        """
        You can create a new attribute for a ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        name : str
            The name of the ticket type attribute

        description : str
            The description of the attribute presented to the teammate or contact

        data_type : CreateTicketTypeAttributeRequestDataType
            The data type of the attribute

        required_to_create : typing.Optional[bool]
            Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.

        required_to_create_for_contacts : typing.Optional[bool]
            Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.

        visible_on_create : typing.Optional[bool]
            Whether the attribute is visible to teammates when creating a ticket in Inbox.

        visible_to_contacts : typing.Optional[bool]
            Whether the attribute is visible to contacts when creating a ticket in Messenger.

        multiline : typing.Optional[bool]
            Whether the attribute allows multiple lines of text (only applicable to string attributes)

        list_items : typing.Optional[str]
            A comma delimited list of items for the attribute value (only applicable to list attributes)

        allow_multiple_values : typing.Optional[bool]
            Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TicketTypeAttribute]
            Ticket Type Attribute created
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ticket_types/{jsonable_encoder(ticket_type_id)}/attributes",
            method="POST",
            json={
                "name": name,
                "description": description,
                "data_type": data_type,
                "required_to_create": required_to_create,
                "required_to_create_for_contacts": required_to_create_for_contacts,
                "visible_on_create": visible_on_create,
                "visible_to_contacts": visible_to_contacts,
                "multiline": multiline,
                "list_items": list_items,
                "allow_multiple_values": allow_multiple_values,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TicketTypeAttribute,
                    construct_type(
                        type_=TicketTypeAttribute,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        ticket_type_id: str,
        attribute_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        required_to_create: typing.Optional[bool] = OMIT,
        required_to_create_for_contacts: typing.Optional[bool] = OMIT,
        visible_on_create: typing.Optional[bool] = OMIT,
        visible_to_contacts: typing.Optional[bool] = OMIT,
        multiline: typing.Optional[bool] = OMIT,
        list_items: typing.Optional[str] = OMIT,
        allow_multiple_values: typing.Optional[bool] = OMIT,
        archived: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TicketTypeAttribute]:
        """
        You can update an existing attribute for a ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        attribute_id : str
            The unique identifier for the ticket type attribute which is given by Intercom.

        name : typing.Optional[str]
            The name of the ticket type attribute

        description : typing.Optional[str]
            The description of the attribute presented to the teammate or contact

        required_to_create : typing.Optional[bool]
            Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.

        required_to_create_for_contacts : typing.Optional[bool]
            Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.

        visible_on_create : typing.Optional[bool]
            Whether the attribute is visible to teammates when creating a ticket in Inbox.

        visible_to_contacts : typing.Optional[bool]
            Whether the attribute is visible to contacts when creating a ticket in Messenger.

        multiline : typing.Optional[bool]
            Whether the attribute allows multiple lines of text (only applicable to string attributes)

        list_items : typing.Optional[str]
            A comma delimited list of items for the attribute value (only applicable to list attributes)

        allow_multiple_values : typing.Optional[bool]
            Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)

        archived : typing.Optional[bool]
            Whether the attribute should be archived and not shown during creation of the ticket (it will still be present on previously created tickets)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TicketTypeAttribute]
            Ticket Type Attribute updated
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ticket_types/{jsonable_encoder(ticket_type_id)}/attributes/{jsonable_encoder(attribute_id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "required_to_create": required_to_create,
                "required_to_create_for_contacts": required_to_create_for_contacts,
                "visible_on_create": visible_on_create,
                "visible_to_contacts": visible_to_contacts,
                "multiline": multiline,
                "list_items": list_items,
                "allow_multiple_values": allow_multiple_values,
                "archived": archived,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TicketTypeAttribute,
                    construct_type(
                        type_=TicketTypeAttribute,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
