# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...admins.types.admin import Admin
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .note_contact import NoteContact


class Note(UncheckedBaseModel):
    """
    Notes allow you to annotate and comment on your contacts.
    """

    type: typing.Literal["note"] = pydantic.Field(default="note")
    """
    String representing the object's type. Always has the value `note`.
    """

    id: str = pydantic.Field()
    """
    The id of the note.
    """

    created_at: int = pydantic.Field()
    """
    The time the note was created.
    """

    contact: typing.Optional[NoteContact] = pydantic.Field(default=None)
    """
    Represents the contact that the note was created about.
    """

    author: Admin = pydantic.Field()
    """
    Optional. Represents the Admin that created the note.
    """

    body: str = pydantic.Field()
    """
    The body text of the note.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
