# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..help_center.types.help_center import HelpCenter
from .collections.client import AsyncCollectionsClient, CollectionsClient
from .raw_client import AsyncRawHelpCentersClient, RawHelpCentersClient


class HelpCentersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawHelpCentersClient(client_wrapper=client_wrapper)
        self.collections = CollectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawHelpCentersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawHelpCentersClient
        """
        return self._raw_client

    def find(self, help_center_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HelpCenter:
        """
        You can fetch the details of a single Help Center by making a GET request to `https://api.intercom.io/help_center/help_center/<id>`.

        Parameters
        ----------
        help_center_id : str
            The unique identifier for the Help Center which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HelpCenter
            Collection found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.help_centers.find(
            help_center_id="123",
        )
        """
        _response = self._raw_client.find(help_center_id, request_options=request_options)
        return _response.data

    def list(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[HelpCenter]:
        """
        You can list all Help Centers by making a GET request to `https://api.intercom.io/help_center/help_centers`.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[HelpCenter]
            Help Centers found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        response = client.help_centers.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(page=page, per_page=per_page, request_options=request_options)


class AsyncHelpCentersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawHelpCentersClient(client_wrapper=client_wrapper)
        self.collections = AsyncCollectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawHelpCentersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawHelpCentersClient
        """
        return self._raw_client

    async def find(self, help_center_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HelpCenter:
        """
        You can fetch the details of a single Help Center by making a GET request to `https://api.intercom.io/help_center/help_center/<id>`.

        Parameters
        ----------
        help_center_id : str
            The unique identifier for the Help Center which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HelpCenter
            Collection found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.help_centers.find(
                help_center_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.find(help_center_id, request_options=request_options)
        return _response.data

    async def list(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[HelpCenter]:
        """
        You can list all Help Centers by making a GET request to `https://api.intercom.io/help_center/help_centers`.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[HelpCenter]
            Help Centers found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.help_centers.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(page=page, per_page=per_page, request_options=request_options)
