import builtins  # noqa: F401
from files_sdk.api import Api  # noqa: F401
from files_sdk.list_obj import ListObj
from files_sdk.error import (  # noqa: F401
    InvalidParameterError,
    MissingParameterError,
    NotImplementedError,
)


class FtpActionLog:
    default_attributes = {
        "timestamp": None,  # date-time - Start Time of Action
        "remote_ip": None,  # string - IP Address of FTP Client
        "server_ip": None,  # string - IP Address of FTP Server
        "username": None,  # string - Username
        "session_uuid": None,  # string - Unique ID of the Session
        "seq_id": None,  # int64 - FTP Sequence ID
        "auth_ciphers": None,  # string - Authentication Ciphers
        "action_type": None,  # string - Action Type
        "path": None,  # string - Path as sent by the Client (may not match Files.com path due to user root folders for FTP). This must be slash-delimited, but it must neither start nor end with a slash. Maximum of 5000 characters.
        "true_path": None,  # string - Path on Files.com
        "name": None,  # string - Name of File
        "cmd": None,  # string - FTP Command Name
        "param": None,  # string - FTP Command Param
        "responseCode": None,  # int64 - FTP Response Code
        "responseMessage": None,  # string - FTP Response Message
        "entries_returned": None,  # int64 - Number of entries returned when listing files and folders
        "success": None,  # boolean - Whether FTP Action was successful.
        "status": None,  # string - FTP Action status.
        "duration_ms": None,  # int64 - Duration (in milliseconds)
    }

    def __init__(self, attributes=None, options=None):
        if not isinstance(attributes, dict):
            attributes = {}
        if not isinstance(options, dict):
            options = {}
        self.set_attributes(attributes)
        self.options = options

    def set_attributes(self, attributes):
        for (
            attribute,
            default_value,
        ) in FtpActionLog.default_attributes.items():
            setattr(self, attribute, attributes.get(attribute, default_value))

    def get_attributes(self):
        return {
            k: getattr(self, k, None)
            for k in FtpActionLog.default_attributes
            if getattr(self, k, None) is not None
        }


# Parameters:
#   cursor - string - Used for pagination.  When a list request has more records available, cursors are provided in the response headers `X-Files-Cursor-Next` and `X-Files-Cursor-Prev`.  Send one of those cursor value here to resume an existing list from the next available record.  Note: many of our SDKs have iterator methods that will automatically handle cursor-based pagination.
#   per_page - int64 - Number of records to show per page.  (Max: 10,000, 1,000 or less is recommended).
#   filter - object - If set, return records where the specified field is equal to the supplied value. Valid fields are `start_date`, `end_date`, `path`, `true_path`, `remote_ip`, `session_uuid`, `success`, `status`, `action_type` or `username`. Valid field combinations are `[ start_date ]`, `[ end_date ]`, `[ path ]`, `[ true_path ]`, `[ remote_ip ]`, `[ session_uuid ]`, `[ success ]`, `[ status ]`, `[ action_type ]`, `[ username ]`, `[ start_date, end_date ]`, `[ start_date, path ]`, `[ start_date, true_path ]`, `[ start_date, remote_ip ]`, `[ start_date, session_uuid ]`, `[ start_date, success ]`, `[ start_date, status ]`, `[ start_date, action_type ]`, `[ start_date, username ]`, `[ end_date, path ]`, `[ end_date, true_path ]`, `[ end_date, remote_ip ]`, `[ end_date, session_uuid ]`, `[ end_date, success ]`, `[ end_date, status ]`, `[ end_date, action_type ]`, `[ end_date, username ]`, `[ path, true_path ]`, `[ path, remote_ip ]`, `[ path, session_uuid ]`, `[ path, success ]`, `[ path, status ]`, `[ path, action_type ]`, `[ path, username ]`, `[ true_path, remote_ip ]`, `[ true_path, session_uuid ]`, `[ true_path, success ]`, `[ true_path, status ]`, `[ true_path, action_type ]`, `[ true_path, username ]`, `[ remote_ip, session_uuid ]`, `[ remote_ip, success ]`, `[ remote_ip, status ]`, `[ remote_ip, action_type ]`, `[ remote_ip, username ]`, `[ session_uuid, success ]`, `[ session_uuid, status ]`, `[ session_uuid, action_type ]`, `[ session_uuid, username ]`, `[ success, status ]`, `[ success, action_type ]`, `[ success, username ]`, `[ status, action_type ]`, `[ status, username ]`, `[ action_type, username ]`, `[ start_date, end_date, path ]`, `[ start_date, end_date, true_path ]`, `[ start_date, end_date, remote_ip ]`, `[ start_date, end_date, session_uuid ]`, `[ start_date, end_date, success ]`, `[ start_date, end_date, status ]`, `[ start_date, end_date, action_type ]`, `[ start_date, end_date, username ]`, `[ start_date, path, true_path ]`, `[ start_date, path, remote_ip ]`, `[ start_date, path, session_uuid ]`, `[ start_date, path, success ]`, `[ start_date, path, status ]`, `[ start_date, path, action_type ]`, `[ start_date, path, username ]`, `[ start_date, true_path, remote_ip ]`, `[ start_date, true_path, session_uuid ]`, `[ start_date, true_path, success ]`, `[ start_date, true_path, status ]`, `[ start_date, true_path, action_type ]`, `[ start_date, true_path, username ]`, `[ start_date, remote_ip, session_uuid ]`, `[ start_date, remote_ip, success ]`, `[ start_date, remote_ip, status ]`, `[ start_date, remote_ip, action_type ]`, `[ start_date, remote_ip, username ]`, `[ start_date, session_uuid, success ]`, `[ start_date, session_uuid, status ]`, `[ start_date, session_uuid, action_type ]`, `[ start_date, session_uuid, username ]`, `[ start_date, success, status ]`, `[ start_date, success, action_type ]`, `[ start_date, success, username ]`, `[ start_date, status, action_type ]`, `[ start_date, status, username ]`, `[ start_date, action_type, username ]`, `[ end_date, path, true_path ]`, `[ end_date, path, remote_ip ]`, `[ end_date, path, session_uuid ]`, `[ end_date, path, success ]`, `[ end_date, path, status ]`, `[ end_date, path, action_type ]`, `[ end_date, path, username ]`, `[ end_date, true_path, remote_ip ]`, `[ end_date, true_path, session_uuid ]`, `[ end_date, true_path, success ]`, `[ end_date, true_path, status ]`, `[ end_date, true_path, action_type ]`, `[ end_date, true_path, username ]`, `[ end_date, remote_ip, session_uuid ]`, `[ end_date, remote_ip, success ]`, `[ end_date, remote_ip, status ]`, `[ end_date, remote_ip, action_type ]`, `[ end_date, remote_ip, username ]`, `[ end_date, session_uuid, success ]`, `[ end_date, session_uuid, status ]`, `[ end_date, session_uuid, action_type ]`, `[ end_date, session_uuid, username ]`, `[ end_date, success, status ]`, `[ end_date, success, action_type ]`, `[ end_date, success, username ]`, `[ end_date, status, action_type ]`, `[ end_date, status, username ]`, `[ end_date, action_type, username ]`, `[ path, true_path, remote_ip ]`, `[ path, true_path, session_uuid ]`, `[ path, true_path, success ]`, `[ path, true_path, status ]`, `[ path, true_path, action_type ]`, `[ path, true_path, username ]`, `[ path, remote_ip, session_uuid ]`, `[ path, remote_ip, success ]`, `[ path, remote_ip, status ]`, `[ path, remote_ip, action_type ]`, `[ path, remote_ip, username ]`, `[ path, session_uuid, success ]`, `[ path, session_uuid, status ]`, `[ path, session_uuid, action_type ]`, `[ path, session_uuid, username ]`, `[ path, success, status ]`, `[ path, success, action_type ]`, `[ path, success, username ]`, `[ path, status, action_type ]`, `[ path, status, username ]`, `[ path, action_type, username ]`, `[ true_path, remote_ip, session_uuid ]`, `[ true_path, remote_ip, success ]`, `[ true_path, remote_ip, status ]`, `[ true_path, remote_ip, action_type ]`, `[ true_path, remote_ip, username ]`, `[ true_path, session_uuid, success ]`, `[ true_path, session_uuid, status ]`, `[ true_path, session_uuid, action_type ]`, `[ true_path, session_uuid, username ]`, `[ true_path, success, status ]`, `[ true_path, success, action_type ]`, `[ true_path, success, username ]`, `[ true_path, status, action_type ]`, `[ true_path, status, username ]`, `[ true_path, action_type, username ]`, `[ remote_ip, session_uuid, success ]`, `[ remote_ip, session_uuid, status ]`, `[ remote_ip, session_uuid, action_type ]`, `[ remote_ip, session_uuid, username ]`, `[ remote_ip, success, status ]`, `[ remote_ip, success, action_type ]`, `[ remote_ip, success, username ]`, `[ remote_ip, status, action_type ]`, `[ remote_ip, status, username ]`, `[ remote_ip, action_type, username ]`, `[ session_uuid, success, status ]`, `[ session_uuid, success, action_type ]`, `[ session_uuid, success, username ]`, `[ session_uuid, status, action_type ]`, `[ session_uuid, status, username ]`, `[ session_uuid, action_type, username ]`, `[ success, status, action_type ]`, `[ success, status, username ]`, `[ success, action_type, username ]`, `[ status, action_type, username ]`, `[ start_date, end_date, path, true_path ]`, `[ start_date, end_date, path, remote_ip ]`, `[ start_date, end_date, path, session_uuid ]`, `[ start_date, end_date, path, success ]`, `[ start_date, end_date, path, status ]`, `[ start_date, end_date, path, action_type ]`, `[ start_date, end_date, path, username ]`, `[ start_date, end_date, true_path, remote_ip ]`, `[ start_date, end_date, true_path, session_uuid ]`, `[ start_date, end_date, true_path, success ]`, `[ start_date, end_date, true_path, status ]`, `[ start_date, end_date, true_path, action_type ]`, `[ start_date, end_date, true_path, username ]`, `[ start_date, end_date, remote_ip, session_uuid ]`, `[ start_date, end_date, remote_ip, success ]`, `[ start_date, end_date, remote_ip, status ]`, `[ start_date, end_date, remote_ip, action_type ]`, `[ start_date, end_date, remote_ip, username ]`, `[ start_date, end_date, session_uuid, success ]`, `[ start_date, end_date, session_uuid, status ]`, `[ start_date, end_date, session_uuid, action_type ]`, `[ start_date, end_date, session_uuid, username ]`, `[ start_date, end_date, success, status ]`, `[ start_date, end_date, success, action_type ]`, `[ start_date, end_date, success, username ]`, `[ start_date, end_date, status, action_type ]`, `[ start_date, end_date, status, username ]`, `[ start_date, end_date, action_type, username ]`, `[ start_date, path, true_path, remote_ip ]`, `[ start_date, path, true_path, session_uuid ]`, `[ start_date, path, true_path, success ]`, `[ start_date, path, true_path, status ]`, `[ start_date, path, true_path, action_type ]`, `[ start_date, path, true_path, username ]`, `[ start_date, path, remote_ip, session_uuid ]`, `[ start_date, path, remote_ip, success ]`, `[ start_date, path, remote_ip, status ]`, `[ start_date, path, remote_ip, action_type ]`, `[ start_date, path, remote_ip, username ]`, `[ start_date, path, session_uuid, success ]`, `[ start_date, path, session_uuid, status ]`, `[ start_date, path, session_uuid, action_type ]`, `[ start_date, path, session_uuid, username ]`, `[ start_date, path, success, status ]`, `[ start_date, path, success, action_type ]`, `[ start_date, path, success, username ]`, `[ start_date, path, status, action_type ]`, `[ start_date, path, status, username ]`, `[ start_date, path, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid ]`, `[ start_date, true_path, remote_ip, success ]`, `[ start_date, true_path, remote_ip, status ]`, `[ start_date, true_path, remote_ip, action_type ]`, `[ start_date, true_path, remote_ip, username ]`, `[ start_date, true_path, session_uuid, success ]`, `[ start_date, true_path, session_uuid, status ]`, `[ start_date, true_path, session_uuid, action_type ]`, `[ start_date, true_path, session_uuid, username ]`, `[ start_date, true_path, success, status ]`, `[ start_date, true_path, success, action_type ]`, `[ start_date, true_path, success, username ]`, `[ start_date, true_path, status, action_type ]`, `[ start_date, true_path, status, username ]`, `[ start_date, true_path, action_type, username ]`, `[ start_date, remote_ip, session_uuid, success ]`, `[ start_date, remote_ip, session_uuid, status ]`, `[ start_date, remote_ip, session_uuid, action_type ]`, `[ start_date, remote_ip, session_uuid, username ]`, `[ start_date, remote_ip, success, status ]`, `[ start_date, remote_ip, success, action_type ]`, `[ start_date, remote_ip, success, username ]`, `[ start_date, remote_ip, status, action_type ]`, `[ start_date, remote_ip, status, username ]`, `[ start_date, remote_ip, action_type, username ]`, `[ start_date, session_uuid, success, status ]`, `[ start_date, session_uuid, success, action_type ]`, `[ start_date, session_uuid, success, username ]`, `[ start_date, session_uuid, status, action_type ]`, `[ start_date, session_uuid, status, username ]`, `[ start_date, session_uuid, action_type, username ]`, `[ start_date, success, status, action_type ]`, `[ start_date, success, status, username ]`, `[ start_date, success, action_type, username ]`, `[ start_date, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip ]`, `[ end_date, path, true_path, session_uuid ]`, `[ end_date, path, true_path, success ]`, `[ end_date, path, true_path, status ]`, `[ end_date, path, true_path, action_type ]`, `[ end_date, path, true_path, username ]`, `[ end_date, path, remote_ip, session_uuid ]`, `[ end_date, path, remote_ip, success ]`, `[ end_date, path, remote_ip, status ]`, `[ end_date, path, remote_ip, action_type ]`, `[ end_date, path, remote_ip, username ]`, `[ end_date, path, session_uuid, success ]`, `[ end_date, path, session_uuid, status ]`, `[ end_date, path, session_uuid, action_type ]`, `[ end_date, path, session_uuid, username ]`, `[ end_date, path, success, status ]`, `[ end_date, path, success, action_type ]`, `[ end_date, path, success, username ]`, `[ end_date, path, status, action_type ]`, `[ end_date, path, status, username ]`, `[ end_date, path, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid ]`, `[ end_date, true_path, remote_ip, success ]`, `[ end_date, true_path, remote_ip, status ]`, `[ end_date, true_path, remote_ip, action_type ]`, `[ end_date, true_path, remote_ip, username ]`, `[ end_date, true_path, session_uuid, success ]`, `[ end_date, true_path, session_uuid, status ]`, `[ end_date, true_path, session_uuid, action_type ]`, `[ end_date, true_path, session_uuid, username ]`, `[ end_date, true_path, success, status ]`, `[ end_date, true_path, success, action_type ]`, `[ end_date, true_path, success, username ]`, `[ end_date, true_path, status, action_type ]`, `[ end_date, true_path, status, username ]`, `[ end_date, true_path, action_type, username ]`, `[ end_date, remote_ip, session_uuid, success ]`, `[ end_date, remote_ip, session_uuid, status ]`, `[ end_date, remote_ip, session_uuid, action_type ]`, `[ end_date, remote_ip, session_uuid, username ]`, `[ end_date, remote_ip, success, status ]`, `[ end_date, remote_ip, success, action_type ]`, `[ end_date, remote_ip, success, username ]`, `[ end_date, remote_ip, status, action_type ]`, `[ end_date, remote_ip, status, username ]`, `[ end_date, remote_ip, action_type, username ]`, `[ end_date, session_uuid, success, status ]`, `[ end_date, session_uuid, success, action_type ]`, `[ end_date, session_uuid, success, username ]`, `[ end_date, session_uuid, status, action_type ]`, `[ end_date, session_uuid, status, username ]`, `[ end_date, session_uuid, action_type, username ]`, `[ end_date, success, status, action_type ]`, `[ end_date, success, status, username ]`, `[ end_date, success, action_type, username ]`, `[ end_date, status, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid ]`, `[ path, true_path, remote_ip, success ]`, `[ path, true_path, remote_ip, status ]`, `[ path, true_path, remote_ip, action_type ]`, `[ path, true_path, remote_ip, username ]`, `[ path, true_path, session_uuid, success ]`, `[ path, true_path, session_uuid, status ]`, `[ path, true_path, session_uuid, action_type ]`, `[ path, true_path, session_uuid, username ]`, `[ path, true_path, success, status ]`, `[ path, true_path, success, action_type ]`, `[ path, true_path, success, username ]`, `[ path, true_path, status, action_type ]`, `[ path, true_path, status, username ]`, `[ path, true_path, action_type, username ]`, `[ path, remote_ip, session_uuid, success ]`, `[ path, remote_ip, session_uuid, status ]`, `[ path, remote_ip, session_uuid, action_type ]`, `[ path, remote_ip, session_uuid, username ]`, `[ path, remote_ip, success, status ]`, `[ path, remote_ip, success, action_type ]`, `[ path, remote_ip, success, username ]`, `[ path, remote_ip, status, action_type ]`, `[ path, remote_ip, status, username ]`, `[ path, remote_ip, action_type, username ]`, `[ path, session_uuid, success, status ]`, `[ path, session_uuid, success, action_type ]`, `[ path, session_uuid, success, username ]`, `[ path, session_uuid, status, action_type ]`, `[ path, session_uuid, status, username ]`, `[ path, session_uuid, action_type, username ]`, `[ path, success, status, action_type ]`, `[ path, success, status, username ]`, `[ path, success, action_type, username ]`, `[ path, status, action_type, username ]`, `[ true_path, remote_ip, session_uuid, success ]`, `[ true_path, remote_ip, session_uuid, status ]`, `[ true_path, remote_ip, session_uuid, action_type ]`, `[ true_path, remote_ip, session_uuid, username ]`, `[ true_path, remote_ip, success, status ]`, `[ true_path, remote_ip, success, action_type ]`, `[ true_path, remote_ip, success, username ]`, `[ true_path, remote_ip, status, action_type ]`, `[ true_path, remote_ip, status, username ]`, `[ true_path, remote_ip, action_type, username ]`, `[ true_path, session_uuid, success, status ]`, `[ true_path, session_uuid, success, action_type ]`, `[ true_path, session_uuid, success, username ]`, `[ true_path, session_uuid, status, action_type ]`, `[ true_path, session_uuid, status, username ]`, `[ true_path, session_uuid, action_type, username ]`, `[ true_path, success, status, action_type ]`, `[ true_path, success, status, username ]`, `[ true_path, success, action_type, username ]`, `[ true_path, status, action_type, username ]`, `[ remote_ip, session_uuid, success, status ]`, `[ remote_ip, session_uuid, success, action_type ]`, `[ remote_ip, session_uuid, success, username ]`, `[ remote_ip, session_uuid, status, action_type ]`, `[ remote_ip, session_uuid, status, username ]`, `[ remote_ip, session_uuid, action_type, username ]`, `[ remote_ip, success, status, action_type ]`, `[ remote_ip, success, status, username ]`, `[ remote_ip, success, action_type, username ]`, `[ remote_ip, status, action_type, username ]`, `[ session_uuid, success, status, action_type ]`, `[ session_uuid, success, status, username ]`, `[ session_uuid, success, action_type, username ]`, `[ session_uuid, status, action_type, username ]`, `[ success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip ]`, `[ start_date, end_date, path, true_path, session_uuid ]`, `[ start_date, end_date, path, true_path, success ]`, `[ start_date, end_date, path, true_path, status ]`, `[ start_date, end_date, path, true_path, action_type ]`, `[ start_date, end_date, path, true_path, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid ]`, `[ start_date, end_date, path, remote_ip, success ]`, `[ start_date, end_date, path, remote_ip, status ]`, `[ start_date, end_date, path, remote_ip, action_type ]`, `[ start_date, end_date, path, remote_ip, username ]`, `[ start_date, end_date, path, session_uuid, success ]`, `[ start_date, end_date, path, session_uuid, status ]`, `[ start_date, end_date, path, session_uuid, action_type ]`, `[ start_date, end_date, path, session_uuid, username ]`, `[ start_date, end_date, path, success, status ]`, `[ start_date, end_date, path, success, action_type ]`, `[ start_date, end_date, path, success, username ]`, `[ start_date, end_date, path, status, action_type ]`, `[ start_date, end_date, path, status, username ]`, `[ start_date, end_date, path, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid ]`, `[ start_date, end_date, true_path, remote_ip, success ]`, `[ start_date, end_date, true_path, remote_ip, status ]`, `[ start_date, end_date, true_path, remote_ip, action_type ]`, `[ start_date, end_date, true_path, remote_ip, username ]`, `[ start_date, end_date, true_path, session_uuid, success ]`, `[ start_date, end_date, true_path, session_uuid, status ]`, `[ start_date, end_date, true_path, session_uuid, action_type ]`, `[ start_date, end_date, true_path, session_uuid, username ]`, `[ start_date, end_date, true_path, success, status ]`, `[ start_date, end_date, true_path, success, action_type ]`, `[ start_date, end_date, true_path, success, username ]`, `[ start_date, end_date, true_path, status, action_type ]`, `[ start_date, end_date, true_path, status, username ]`, `[ start_date, end_date, true_path, action_type, username ]`, `[ start_date, end_date, remote_ip, session_uuid, success ]`, `[ start_date, end_date, remote_ip, session_uuid, status ]`, `[ start_date, end_date, remote_ip, session_uuid, action_type ]`, `[ start_date, end_date, remote_ip, session_uuid, username ]`, `[ start_date, end_date, remote_ip, success, status ]`, `[ start_date, end_date, remote_ip, success, action_type ]`, `[ start_date, end_date, remote_ip, success, username ]`, `[ start_date, end_date, remote_ip, status, action_type ]`, `[ start_date, end_date, remote_ip, status, username ]`, `[ start_date, end_date, remote_ip, action_type, username ]`, `[ start_date, end_date, session_uuid, success, status ]`, `[ start_date, end_date, session_uuid, success, action_type ]`, `[ start_date, end_date, session_uuid, success, username ]`, `[ start_date, end_date, session_uuid, status, action_type ]`, `[ start_date, end_date, session_uuid, status, username ]`, `[ start_date, end_date, session_uuid, action_type, username ]`, `[ start_date, end_date, success, status, action_type ]`, `[ start_date, end_date, success, status, username ]`, `[ start_date, end_date, success, action_type, username ]`, `[ start_date, end_date, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid ]`, `[ start_date, path, true_path, remote_ip, success ]`, `[ start_date, path, true_path, remote_ip, status ]`, `[ start_date, path, true_path, remote_ip, action_type ]`, `[ start_date, path, true_path, remote_ip, username ]`, `[ start_date, path, true_path, session_uuid, success ]`, `[ start_date, path, true_path, session_uuid, status ]`, `[ start_date, path, true_path, session_uuid, action_type ]`, `[ start_date, path, true_path, session_uuid, username ]`, `[ start_date, path, true_path, success, status ]`, `[ start_date, path, true_path, success, action_type ]`, `[ start_date, path, true_path, success, username ]`, `[ start_date, path, true_path, status, action_type ]`, `[ start_date, path, true_path, status, username ]`, `[ start_date, path, true_path, action_type, username ]`, `[ start_date, path, remote_ip, session_uuid, success ]`, `[ start_date, path, remote_ip, session_uuid, status ]`, `[ start_date, path, remote_ip, session_uuid, action_type ]`, `[ start_date, path, remote_ip, session_uuid, username ]`, `[ start_date, path, remote_ip, success, status ]`, `[ start_date, path, remote_ip, success, action_type ]`, `[ start_date, path, remote_ip, success, username ]`, `[ start_date, path, remote_ip, status, action_type ]`, `[ start_date, path, remote_ip, status, username ]`, `[ start_date, path, remote_ip, action_type, username ]`, `[ start_date, path, session_uuid, success, status ]`, `[ start_date, path, session_uuid, success, action_type ]`, `[ start_date, path, session_uuid, success, username ]`, `[ start_date, path, session_uuid, status, action_type ]`, `[ start_date, path, session_uuid, status, username ]`, `[ start_date, path, session_uuid, action_type, username ]`, `[ start_date, path, success, status, action_type ]`, `[ start_date, path, success, status, username ]`, `[ start_date, path, success, action_type, username ]`, `[ start_date, path, status, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid, success ]`, `[ start_date, true_path, remote_ip, session_uuid, status ]`, `[ start_date, true_path, remote_ip, session_uuid, action_type ]`, `[ start_date, true_path, remote_ip, session_uuid, username ]`, `[ start_date, true_path, remote_ip, success, status ]`, `[ start_date, true_path, remote_ip, success, action_type ]`, `[ start_date, true_path, remote_ip, success, username ]`, `[ start_date, true_path, remote_ip, status, action_type ]`, `[ start_date, true_path, remote_ip, status, username ]`, `[ start_date, true_path, remote_ip, action_type, username ]`, `[ start_date, true_path, session_uuid, success, status ]`, `[ start_date, true_path, session_uuid, success, action_type ]`, `[ start_date, true_path, session_uuid, success, username ]`, `[ start_date, true_path, session_uuid, status, action_type ]`, `[ start_date, true_path, session_uuid, status, username ]`, `[ start_date, true_path, session_uuid, action_type, username ]`, `[ start_date, true_path, success, status, action_type ]`, `[ start_date, true_path, success, status, username ]`, `[ start_date, true_path, success, action_type, username ]`, `[ start_date, true_path, status, action_type, username ]`, `[ start_date, remote_ip, session_uuid, success, status ]`, `[ start_date, remote_ip, session_uuid, success, action_type ]`, `[ start_date, remote_ip, session_uuid, success, username ]`, `[ start_date, remote_ip, session_uuid, status, action_type ]`, `[ start_date, remote_ip, session_uuid, status, username ]`, `[ start_date, remote_ip, session_uuid, action_type, username ]`, `[ start_date, remote_ip, success, status, action_type ]`, `[ start_date, remote_ip, success, status, username ]`, `[ start_date, remote_ip, success, action_type, username ]`, `[ start_date, remote_ip, status, action_type, username ]`, `[ start_date, session_uuid, success, status, action_type ]`, `[ start_date, session_uuid, success, status, username ]`, `[ start_date, session_uuid, success, action_type, username ]`, `[ start_date, session_uuid, status, action_type, username ]`, `[ start_date, success, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid ]`, `[ end_date, path, true_path, remote_ip, success ]`, `[ end_date, path, true_path, remote_ip, status ]`, `[ end_date, path, true_path, remote_ip, action_type ]`, `[ end_date, path, true_path, remote_ip, username ]`, `[ end_date, path, true_path, session_uuid, success ]`, `[ end_date, path, true_path, session_uuid, status ]`, `[ end_date, path, true_path, session_uuid, action_type ]`, `[ end_date, path, true_path, session_uuid, username ]`, `[ end_date, path, true_path, success, status ]`, `[ end_date, path, true_path, success, action_type ]`, `[ end_date, path, true_path, success, username ]`, `[ end_date, path, true_path, status, action_type ]`, `[ end_date, path, true_path, status, username ]`, `[ end_date, path, true_path, action_type, username ]`, `[ end_date, path, remote_ip, session_uuid, success ]`, `[ end_date, path, remote_ip, session_uuid, status ]`, `[ end_date, path, remote_ip, session_uuid, action_type ]`, `[ end_date, path, remote_ip, session_uuid, username ]`, `[ end_date, path, remote_ip, success, status ]`, `[ end_date, path, remote_ip, success, action_type ]`, `[ end_date, path, remote_ip, success, username ]`, `[ end_date, path, remote_ip, status, action_type ]`, `[ end_date, path, remote_ip, status, username ]`, `[ end_date, path, remote_ip, action_type, username ]`, `[ end_date, path, session_uuid, success, status ]`, `[ end_date, path, session_uuid, success, action_type ]`, `[ end_date, path, session_uuid, success, username ]`, `[ end_date, path, session_uuid, status, action_type ]`, `[ end_date, path, session_uuid, status, username ]`, `[ end_date, path, session_uuid, action_type, username ]`, `[ end_date, path, success, status, action_type ]`, `[ end_date, path, success, status, username ]`, `[ end_date, path, success, action_type, username ]`, `[ end_date, path, status, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid, success ]`, `[ end_date, true_path, remote_ip, session_uuid, status ]`, `[ end_date, true_path, remote_ip, session_uuid, action_type ]`, `[ end_date, true_path, remote_ip, session_uuid, username ]`, `[ end_date, true_path, remote_ip, success, status ]`, `[ end_date, true_path, remote_ip, success, action_type ]`, `[ end_date, true_path, remote_ip, success, username ]`, `[ end_date, true_path, remote_ip, status, action_type ]`, `[ end_date, true_path, remote_ip, status, username ]`, `[ end_date, true_path, remote_ip, action_type, username ]`, `[ end_date, true_path, session_uuid, success, status ]`, `[ end_date, true_path, session_uuid, success, action_type ]`, `[ end_date, true_path, session_uuid, success, username ]`, `[ end_date, true_path, session_uuid, status, action_type ]`, `[ end_date, true_path, session_uuid, status, username ]`, `[ end_date, true_path, session_uuid, action_type, username ]`, `[ end_date, true_path, success, status, action_type ]`, `[ end_date, true_path, success, status, username ]`, `[ end_date, true_path, success, action_type, username ]`, `[ end_date, true_path, status, action_type, username ]`, `[ end_date, remote_ip, session_uuid, success, status ]`, `[ end_date, remote_ip, session_uuid, success, action_type ]`, `[ end_date, remote_ip, session_uuid, success, username ]`, `[ end_date, remote_ip, session_uuid, status, action_type ]`, `[ end_date, remote_ip, session_uuid, status, username ]`, `[ end_date, remote_ip, session_uuid, action_type, username ]`, `[ end_date, remote_ip, success, status, action_type ]`, `[ end_date, remote_ip, success, status, username ]`, `[ end_date, remote_ip, success, action_type, username ]`, `[ end_date, remote_ip, status, action_type, username ]`, `[ end_date, session_uuid, success, status, action_type ]`, `[ end_date, session_uuid, success, status, username ]`, `[ end_date, session_uuid, success, action_type, username ]`, `[ end_date, session_uuid, status, action_type, username ]`, `[ end_date, success, status, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid, success ]`, `[ path, true_path, remote_ip, session_uuid, status ]`, `[ path, true_path, remote_ip, session_uuid, action_type ]`, `[ path, true_path, remote_ip, session_uuid, username ]`, `[ path, true_path, remote_ip, success, status ]`, `[ path, true_path, remote_ip, success, action_type ]`, `[ path, true_path, remote_ip, success, username ]`, `[ path, true_path, remote_ip, status, action_type ]`, `[ path, true_path, remote_ip, status, username ]`, `[ path, true_path, remote_ip, action_type, username ]`, `[ path, true_path, session_uuid, success, status ]`, `[ path, true_path, session_uuid, success, action_type ]`, `[ path, true_path, session_uuid, success, username ]`, `[ path, true_path, session_uuid, status, action_type ]`, `[ path, true_path, session_uuid, status, username ]`, `[ path, true_path, session_uuid, action_type, username ]`, `[ path, true_path, success, status, action_type ]`, `[ path, true_path, success, status, username ]`, `[ path, true_path, success, action_type, username ]`, `[ path, true_path, status, action_type, username ]`, `[ path, remote_ip, session_uuid, success, status ]`, `[ path, remote_ip, session_uuid, success, action_type ]`, `[ path, remote_ip, session_uuid, success, username ]`, `[ path, remote_ip, session_uuid, status, action_type ]`, `[ path, remote_ip, session_uuid, status, username ]`, `[ path, remote_ip, session_uuid, action_type, username ]`, `[ path, remote_ip, success, status, action_type ]`, `[ path, remote_ip, success, status, username ]`, `[ path, remote_ip, success, action_type, username ]`, `[ path, remote_ip, status, action_type, username ]`, `[ path, session_uuid, success, status, action_type ]`, `[ path, session_uuid, success, status, username ]`, `[ path, session_uuid, success, action_type, username ]`, `[ path, session_uuid, status, action_type, username ]`, `[ path, success, status, action_type, username ]`, `[ true_path, remote_ip, session_uuid, success, status ]`, `[ true_path, remote_ip, session_uuid, success, action_type ]`, `[ true_path, remote_ip, session_uuid, success, username ]`, `[ true_path, remote_ip, session_uuid, status, action_type ]`, `[ true_path, remote_ip, session_uuid, status, username ]`, `[ true_path, remote_ip, session_uuid, action_type, username ]`, `[ true_path, remote_ip, success, status, action_type ]`, `[ true_path, remote_ip, success, status, username ]`, `[ true_path, remote_ip, success, action_type, username ]`, `[ true_path, remote_ip, status, action_type, username ]`, `[ true_path, session_uuid, success, status, action_type ]`, `[ true_path, session_uuid, success, status, username ]`, `[ true_path, session_uuid, success, action_type, username ]`, `[ true_path, session_uuid, status, action_type, username ]`, `[ true_path, success, status, action_type, username ]`, `[ remote_ip, session_uuid, success, status, action_type ]`, `[ remote_ip, session_uuid, success, status, username ]`, `[ remote_ip, session_uuid, success, action_type, username ]`, `[ remote_ip, session_uuid, status, action_type, username ]`, `[ remote_ip, success, status, action_type, username ]`, `[ session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid ]`, `[ start_date, end_date, path, true_path, remote_ip, success ]`, `[ start_date, end_date, path, true_path, remote_ip, status ]`, `[ start_date, end_date, path, true_path, remote_ip, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, username ]`, `[ start_date, end_date, path, true_path, session_uuid, success ]`, `[ start_date, end_date, path, true_path, session_uuid, status ]`, `[ start_date, end_date, path, true_path, session_uuid, action_type ]`, `[ start_date, end_date, path, true_path, session_uuid, username ]`, `[ start_date, end_date, path, true_path, success, status ]`, `[ start_date, end_date, path, true_path, success, action_type ]`, `[ start_date, end_date, path, true_path, success, username ]`, `[ start_date, end_date, path, true_path, status, action_type ]`, `[ start_date, end_date, path, true_path, status, username ]`, `[ start_date, end_date, path, true_path, action_type, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success ]`, `[ start_date, end_date, path, remote_ip, session_uuid, status ]`, `[ start_date, end_date, path, remote_ip, session_uuid, action_type ]`, `[ start_date, end_date, path, remote_ip, session_uuid, username ]`, `[ start_date, end_date, path, remote_ip, success, status ]`, `[ start_date, end_date, path, remote_ip, success, action_type ]`, `[ start_date, end_date, path, remote_ip, success, username ]`, `[ start_date, end_date, path, remote_ip, status, action_type ]`, `[ start_date, end_date, path, remote_ip, status, username ]`, `[ start_date, end_date, path, remote_ip, action_type, username ]`, `[ start_date, end_date, path, session_uuid, success, status ]`, `[ start_date, end_date, path, session_uuid, success, action_type ]`, `[ start_date, end_date, path, session_uuid, success, username ]`, `[ start_date, end_date, path, session_uuid, status, action_type ]`, `[ start_date, end_date, path, session_uuid, status, username ]`, `[ start_date, end_date, path, session_uuid, action_type, username ]`, `[ start_date, end_date, path, success, status, action_type ]`, `[ start_date, end_date, path, success, status, username ]`, `[ start_date, end_date, path, success, action_type, username ]`, `[ start_date, end_date, path, status, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, status ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, action_type ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, username ]`, `[ start_date, end_date, true_path, remote_ip, success, status ]`, `[ start_date, end_date, true_path, remote_ip, success, action_type ]`, `[ start_date, end_date, true_path, remote_ip, success, username ]`, `[ start_date, end_date, true_path, remote_ip, status, action_type ]`, `[ start_date, end_date, true_path, remote_ip, status, username ]`, `[ start_date, end_date, true_path, remote_ip, action_type, username ]`, `[ start_date, end_date, true_path, session_uuid, success, status ]`, `[ start_date, end_date, true_path, session_uuid, success, action_type ]`, `[ start_date, end_date, true_path, session_uuid, success, username ]`, `[ start_date, end_date, true_path, session_uuid, status, action_type ]`, `[ start_date, end_date, true_path, session_uuid, status, username ]`, `[ start_date, end_date, true_path, session_uuid, action_type, username ]`, `[ start_date, end_date, true_path, success, status, action_type ]`, `[ start_date, end_date, true_path, success, status, username ]`, `[ start_date, end_date, true_path, success, action_type, username ]`, `[ start_date, end_date, true_path, status, action_type, username ]`, `[ start_date, end_date, remote_ip, session_uuid, success, status ]`, `[ start_date, end_date, remote_ip, session_uuid, success, action_type ]`, `[ start_date, end_date, remote_ip, session_uuid, success, username ]`, `[ start_date, end_date, remote_ip, session_uuid, status, action_type ]`, `[ start_date, end_date, remote_ip, session_uuid, status, username ]`, `[ start_date, end_date, remote_ip, session_uuid, action_type, username ]`, `[ start_date, end_date, remote_ip, success, status, action_type ]`, `[ start_date, end_date, remote_ip, success, status, username ]`, `[ start_date, end_date, remote_ip, success, action_type, username ]`, `[ start_date, end_date, remote_ip, status, action_type, username ]`, `[ start_date, end_date, session_uuid, success, status, action_type ]`, `[ start_date, end_date, session_uuid, success, status, username ]`, `[ start_date, end_date, session_uuid, success, action_type, username ]`, `[ start_date, end_date, session_uuid, status, action_type, username ]`, `[ start_date, end_date, success, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success ]`, `[ start_date, path, true_path, remote_ip, session_uuid, status ]`, `[ start_date, path, true_path, remote_ip, session_uuid, action_type ]`, `[ start_date, path, true_path, remote_ip, session_uuid, username ]`, `[ start_date, path, true_path, remote_ip, success, status ]`, `[ start_date, path, true_path, remote_ip, success, action_type ]`, `[ start_date, path, true_path, remote_ip, success, username ]`, `[ start_date, path, true_path, remote_ip, status, action_type ]`, `[ start_date, path, true_path, remote_ip, status, username ]`, `[ start_date, path, true_path, remote_ip, action_type, username ]`, `[ start_date, path, true_path, session_uuid, success, status ]`, `[ start_date, path, true_path, session_uuid, success, action_type ]`, `[ start_date, path, true_path, session_uuid, success, username ]`, `[ start_date, path, true_path, session_uuid, status, action_type ]`, `[ start_date, path, true_path, session_uuid, status, username ]`, `[ start_date, path, true_path, session_uuid, action_type, username ]`, `[ start_date, path, true_path, success, status, action_type ]`, `[ start_date, path, true_path, success, status, username ]`, `[ start_date, path, true_path, success, action_type, username ]`, `[ start_date, path, true_path, status, action_type, username ]`, `[ start_date, path, remote_ip, session_uuid, success, status ]`, `[ start_date, path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, path, remote_ip, session_uuid, success, username ]`, `[ start_date, path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, path, remote_ip, session_uuid, status, username ]`, `[ start_date, path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, path, remote_ip, success, status, action_type ]`, `[ start_date, path, remote_ip, success, status, username ]`, `[ start_date, path, remote_ip, success, action_type, username ]`, `[ start_date, path, remote_ip, status, action_type, username ]`, `[ start_date, path, session_uuid, success, status, action_type ]`, `[ start_date, path, session_uuid, success, status, username ]`, `[ start_date, path, session_uuid, success, action_type, username ]`, `[ start_date, path, session_uuid, status, action_type, username ]`, `[ start_date, path, success, status, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid, success, status ]`, `[ start_date, true_path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, true_path, remote_ip, session_uuid, success, username ]`, `[ start_date, true_path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, true_path, remote_ip, session_uuid, status, username ]`, `[ start_date, true_path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, true_path, remote_ip, success, status, action_type ]`, `[ start_date, true_path, remote_ip, success, status, username ]`, `[ start_date, true_path, remote_ip, success, action_type, username ]`, `[ start_date, true_path, remote_ip, status, action_type, username ]`, `[ start_date, true_path, session_uuid, success, status, action_type ]`, `[ start_date, true_path, session_uuid, success, status, username ]`, `[ start_date, true_path, session_uuid, success, action_type, username ]`, `[ start_date, true_path, session_uuid, status, action_type, username ]`, `[ start_date, true_path, success, status, action_type, username ]`, `[ start_date, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, remote_ip, session_uuid, success, status, username ]`, `[ start_date, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, remote_ip, success, status, action_type, username ]`, `[ start_date, session_uuid, success, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success ]`, `[ end_date, path, true_path, remote_ip, session_uuid, status ]`, `[ end_date, path, true_path, remote_ip, session_uuid, action_type ]`, `[ end_date, path, true_path, remote_ip, session_uuid, username ]`, `[ end_date, path, true_path, remote_ip, success, status ]`, `[ end_date, path, true_path, remote_ip, success, action_type ]`, `[ end_date, path, true_path, remote_ip, success, username ]`, `[ end_date, path, true_path, remote_ip, status, action_type ]`, `[ end_date, path, true_path, remote_ip, status, username ]`, `[ end_date, path, true_path, remote_ip, action_type, username ]`, `[ end_date, path, true_path, session_uuid, success, status ]`, `[ end_date, path, true_path, session_uuid, success, action_type ]`, `[ end_date, path, true_path, session_uuid, success, username ]`, `[ end_date, path, true_path, session_uuid, status, action_type ]`, `[ end_date, path, true_path, session_uuid, status, username ]`, `[ end_date, path, true_path, session_uuid, action_type, username ]`, `[ end_date, path, true_path, success, status, action_type ]`, `[ end_date, path, true_path, success, status, username ]`, `[ end_date, path, true_path, success, action_type, username ]`, `[ end_date, path, true_path, status, action_type, username ]`, `[ end_date, path, remote_ip, session_uuid, success, status ]`, `[ end_date, path, remote_ip, session_uuid, success, action_type ]`, `[ end_date, path, remote_ip, session_uuid, success, username ]`, `[ end_date, path, remote_ip, session_uuid, status, action_type ]`, `[ end_date, path, remote_ip, session_uuid, status, username ]`, `[ end_date, path, remote_ip, session_uuid, action_type, username ]`, `[ end_date, path, remote_ip, success, status, action_type ]`, `[ end_date, path, remote_ip, success, status, username ]`, `[ end_date, path, remote_ip, success, action_type, username ]`, `[ end_date, path, remote_ip, status, action_type, username ]`, `[ end_date, path, session_uuid, success, status, action_type ]`, `[ end_date, path, session_uuid, success, status, username ]`, `[ end_date, path, session_uuid, success, action_type, username ]`, `[ end_date, path, session_uuid, status, action_type, username ]`, `[ end_date, path, success, status, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid, success, status ]`, `[ end_date, true_path, remote_ip, session_uuid, success, action_type ]`, `[ end_date, true_path, remote_ip, session_uuid, success, username ]`, `[ end_date, true_path, remote_ip, session_uuid, status, action_type ]`, `[ end_date, true_path, remote_ip, session_uuid, status, username ]`, `[ end_date, true_path, remote_ip, session_uuid, action_type, username ]`, `[ end_date, true_path, remote_ip, success, status, action_type ]`, `[ end_date, true_path, remote_ip, success, status, username ]`, `[ end_date, true_path, remote_ip, success, action_type, username ]`, `[ end_date, true_path, remote_ip, status, action_type, username ]`, `[ end_date, true_path, session_uuid, success, status, action_type ]`, `[ end_date, true_path, session_uuid, success, status, username ]`, `[ end_date, true_path, session_uuid, success, action_type, username ]`, `[ end_date, true_path, session_uuid, status, action_type, username ]`, `[ end_date, true_path, success, status, action_type, username ]`, `[ end_date, remote_ip, session_uuid, success, status, action_type ]`, `[ end_date, remote_ip, session_uuid, success, status, username ]`, `[ end_date, remote_ip, session_uuid, success, action_type, username ]`, `[ end_date, remote_ip, session_uuid, status, action_type, username ]`, `[ end_date, remote_ip, success, status, action_type, username ]`, `[ end_date, session_uuid, success, status, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid, success, status ]`, `[ path, true_path, remote_ip, session_uuid, success, action_type ]`, `[ path, true_path, remote_ip, session_uuid, success, username ]`, `[ path, true_path, remote_ip, session_uuid, status, action_type ]`, `[ path, true_path, remote_ip, session_uuid, status, username ]`, `[ path, true_path, remote_ip, session_uuid, action_type, username ]`, `[ path, true_path, remote_ip, success, status, action_type ]`, `[ path, true_path, remote_ip, success, status, username ]`, `[ path, true_path, remote_ip, success, action_type, username ]`, `[ path, true_path, remote_ip, status, action_type, username ]`, `[ path, true_path, session_uuid, success, status, action_type ]`, `[ path, true_path, session_uuid, success, status, username ]`, `[ path, true_path, session_uuid, success, action_type, username ]`, `[ path, true_path, session_uuid, status, action_type, username ]`, `[ path, true_path, success, status, action_type, username ]`, `[ path, remote_ip, session_uuid, success, status, action_type ]`, `[ path, remote_ip, session_uuid, success, status, username ]`, `[ path, remote_ip, session_uuid, success, action_type, username ]`, `[ path, remote_ip, session_uuid, status, action_type, username ]`, `[ path, remote_ip, success, status, action_type, username ]`, `[ path, session_uuid, success, status, action_type, username ]`, `[ true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ true_path, remote_ip, session_uuid, success, status, username ]`, `[ true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ true_path, remote_ip, success, status, action_type, username ]`, `[ true_path, session_uuid, success, status, action_type, username ]`, `[ remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, status ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, username ]`, `[ start_date, end_date, path, true_path, remote_ip, success, status ]`, `[ start_date, end_date, path, true_path, remote_ip, success, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, success, username ]`, `[ start_date, end_date, path, true_path, remote_ip, status, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, status, username ]`, `[ start_date, end_date, path, true_path, remote_ip, action_type, username ]`, `[ start_date, end_date, path, true_path, session_uuid, success, status ]`, `[ start_date, end_date, path, true_path, session_uuid, success, action_type ]`, `[ start_date, end_date, path, true_path, session_uuid, success, username ]`, `[ start_date, end_date, path, true_path, session_uuid, status, action_type ]`, `[ start_date, end_date, path, true_path, session_uuid, status, username ]`, `[ start_date, end_date, path, true_path, session_uuid, action_type, username ]`, `[ start_date, end_date, path, true_path, success, status, action_type ]`, `[ start_date, end_date, path, true_path, success, status, username ]`, `[ start_date, end_date, path, true_path, success, action_type, username ]`, `[ start_date, end_date, path, true_path, status, action_type, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, status ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, end_date, path, remote_ip, session_uuid, status, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, end_date, path, remote_ip, success, status, action_type ]`, `[ start_date, end_date, path, remote_ip, success, status, username ]`, `[ start_date, end_date, path, remote_ip, success, action_type, username ]`, `[ start_date, end_date, path, remote_ip, status, action_type, username ]`, `[ start_date, end_date, path, session_uuid, success, status, action_type ]`, `[ start_date, end_date, path, session_uuid, success, status, username ]`, `[ start_date, end_date, path, session_uuid, success, action_type, username ]`, `[ start_date, end_date, path, session_uuid, status, action_type, username ]`, `[ start_date, end_date, path, success, status, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, status ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, status, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, success, status, action_type ]`, `[ start_date, end_date, true_path, remote_ip, success, status, username ]`, `[ start_date, end_date, true_path, remote_ip, success, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, status, action_type, username ]`, `[ start_date, end_date, true_path, session_uuid, success, status, action_type ]`, `[ start_date, end_date, true_path, session_uuid, success, status, username ]`, `[ start_date, end_date, true_path, session_uuid, success, action_type, username ]`, `[ start_date, end_date, true_path, session_uuid, status, action_type, username ]`, `[ start_date, end_date, true_path, success, status, action_type, username ]`, `[ start_date, end_date, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, end_date, remote_ip, session_uuid, success, status, username ]`, `[ start_date, end_date, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, end_date, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, end_date, remote_ip, success, status, action_type, username ]`, `[ start_date, end_date, session_uuid, success, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, status ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, path, true_path, remote_ip, session_uuid, status, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, path, true_path, remote_ip, success, status, action_type ]`, `[ start_date, path, true_path, remote_ip, success, status, username ]`, `[ start_date, path, true_path, remote_ip, success, action_type, username ]`, `[ start_date, path, true_path, remote_ip, status, action_type, username ]`, `[ start_date, path, true_path, session_uuid, success, status, action_type ]`, `[ start_date, path, true_path, session_uuid, success, status, username ]`, `[ start_date, path, true_path, session_uuid, success, action_type, username ]`, `[ start_date, path, true_path, session_uuid, status, action_type, username ]`, `[ start_date, path, true_path, success, status, action_type, username ]`, `[ start_date, path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, path, remote_ip, success, status, action_type, username ]`, `[ start_date, path, session_uuid, success, status, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, true_path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, true_path, remote_ip, success, status, action_type, username ]`, `[ start_date, true_path, session_uuid, success, status, action_type, username ]`, `[ start_date, remote_ip, session_uuid, success, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, status ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, action_type ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, status, action_type ]`, `[ end_date, path, true_path, remote_ip, session_uuid, status, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, action_type, username ]`, `[ end_date, path, true_path, remote_ip, success, status, action_type ]`, `[ end_date, path, true_path, remote_ip, success, status, username ]`, `[ end_date, path, true_path, remote_ip, success, action_type, username ]`, `[ end_date, path, true_path, remote_ip, status, action_type, username ]`, `[ end_date, path, true_path, session_uuid, success, status, action_type ]`, `[ end_date, path, true_path, session_uuid, success, status, username ]`, `[ end_date, path, true_path, session_uuid, success, action_type, username ]`, `[ end_date, path, true_path, session_uuid, status, action_type, username ]`, `[ end_date, path, true_path, success, status, action_type, username ]`, `[ end_date, path, remote_ip, session_uuid, success, status, action_type ]`, `[ end_date, path, remote_ip, session_uuid, success, status, username ]`, `[ end_date, path, remote_ip, session_uuid, success, action_type, username ]`, `[ end_date, path, remote_ip, session_uuid, status, action_type, username ]`, `[ end_date, path, remote_ip, success, status, action_type, username ]`, `[ end_date, path, session_uuid, success, status, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ end_date, true_path, remote_ip, session_uuid, success, status, username ]`, `[ end_date, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ end_date, true_path, remote_ip, success, status, action_type, username ]`, `[ end_date, true_path, session_uuid, success, status, action_type, username ]`, `[ end_date, remote_ip, session_uuid, success, status, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ path, true_path, remote_ip, session_uuid, success, status, username ]`, `[ path, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ path, true_path, remote_ip, success, status, action_type, username ]`, `[ path, true_path, session_uuid, success, status, action_type, username ]`, `[ path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ true_path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, status ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, status, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, success, status, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, success, status, username ]`, `[ start_date, end_date, path, true_path, remote_ip, success, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, status, action_type, username ]`, `[ start_date, end_date, path, true_path, session_uuid, success, status, action_type ]`, `[ start_date, end_date, path, true_path, session_uuid, success, status, username ]`, `[ start_date, end_date, path, true_path, session_uuid, success, action_type, username ]`, `[ start_date, end_date, path, true_path, session_uuid, status, action_type, username ]`, `[ start_date, end_date, path, true_path, success, status, action_type, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, end_date, path, remote_ip, success, status, action_type, username ]`, `[ start_date, end_date, path, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, success, status, action_type, username ]`, `[ start_date, end_date, true_path, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, success, status, action_type, username ]`, `[ start_date, path, true_path, session_uuid, success, status, action_type, username ]`, `[ start_date, path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, status, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip, success, status, action_type, username ]`, `[ end_date, path, true_path, session_uuid, success, status, action_type, username ]`, `[ end_date, path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, status, action_type, username ]` or `[ end_date, path, true_path, remote_ip, session_uuid, success, status, action_type, username ]`.
#   filter_prefix - object - If set, return records where the specified field is prefixed by the supplied value. Valid fields are `path`, `true_path`, `status`, `action_type` or `username`. Valid field combinations are `[ start_date ]`, `[ end_date ]`, `[ path ]`, `[ true_path ]`, `[ remote_ip ]`, `[ session_uuid ]`, `[ success ]`, `[ status ]`, `[ action_type ]`, `[ username ]`, `[ start_date, end_date ]`, `[ start_date, path ]`, `[ start_date, true_path ]`, `[ start_date, remote_ip ]`, `[ start_date, session_uuid ]`, `[ start_date, success ]`, `[ start_date, status ]`, `[ start_date, action_type ]`, `[ start_date, username ]`, `[ end_date, path ]`, `[ end_date, true_path ]`, `[ end_date, remote_ip ]`, `[ end_date, session_uuid ]`, `[ end_date, success ]`, `[ end_date, status ]`, `[ end_date, action_type ]`, `[ end_date, username ]`, `[ path, true_path ]`, `[ path, remote_ip ]`, `[ path, session_uuid ]`, `[ path, success ]`, `[ path, status ]`, `[ path, action_type ]`, `[ path, username ]`, `[ true_path, remote_ip ]`, `[ true_path, session_uuid ]`, `[ true_path, success ]`, `[ true_path, status ]`, `[ true_path, action_type ]`, `[ true_path, username ]`, `[ remote_ip, session_uuid ]`, `[ remote_ip, success ]`, `[ remote_ip, status ]`, `[ remote_ip, action_type ]`, `[ remote_ip, username ]`, `[ session_uuid, success ]`, `[ session_uuid, status ]`, `[ session_uuid, action_type ]`, `[ session_uuid, username ]`, `[ success, status ]`, `[ success, action_type ]`, `[ success, username ]`, `[ status, action_type ]`, `[ status, username ]`, `[ action_type, username ]`, `[ start_date, end_date, path ]`, `[ start_date, end_date, true_path ]`, `[ start_date, end_date, remote_ip ]`, `[ start_date, end_date, session_uuid ]`, `[ start_date, end_date, success ]`, `[ start_date, end_date, status ]`, `[ start_date, end_date, action_type ]`, `[ start_date, end_date, username ]`, `[ start_date, path, true_path ]`, `[ start_date, path, remote_ip ]`, `[ start_date, path, session_uuid ]`, `[ start_date, path, success ]`, `[ start_date, path, status ]`, `[ start_date, path, action_type ]`, `[ start_date, path, username ]`, `[ start_date, true_path, remote_ip ]`, `[ start_date, true_path, session_uuid ]`, `[ start_date, true_path, success ]`, `[ start_date, true_path, status ]`, `[ start_date, true_path, action_type ]`, `[ start_date, true_path, username ]`, `[ start_date, remote_ip, session_uuid ]`, `[ start_date, remote_ip, success ]`, `[ start_date, remote_ip, status ]`, `[ start_date, remote_ip, action_type ]`, `[ start_date, remote_ip, username ]`, `[ start_date, session_uuid, success ]`, `[ start_date, session_uuid, status ]`, `[ start_date, session_uuid, action_type ]`, `[ start_date, session_uuid, username ]`, `[ start_date, success, status ]`, `[ start_date, success, action_type ]`, `[ start_date, success, username ]`, `[ start_date, status, action_type ]`, `[ start_date, status, username ]`, `[ start_date, action_type, username ]`, `[ end_date, path, true_path ]`, `[ end_date, path, remote_ip ]`, `[ end_date, path, session_uuid ]`, `[ end_date, path, success ]`, `[ end_date, path, status ]`, `[ end_date, path, action_type ]`, `[ end_date, path, username ]`, `[ end_date, true_path, remote_ip ]`, `[ end_date, true_path, session_uuid ]`, `[ end_date, true_path, success ]`, `[ end_date, true_path, status ]`, `[ end_date, true_path, action_type ]`, `[ end_date, true_path, username ]`, `[ end_date, remote_ip, session_uuid ]`, `[ end_date, remote_ip, success ]`, `[ end_date, remote_ip, status ]`, `[ end_date, remote_ip, action_type ]`, `[ end_date, remote_ip, username ]`, `[ end_date, session_uuid, success ]`, `[ end_date, session_uuid, status ]`, `[ end_date, session_uuid, action_type ]`, `[ end_date, session_uuid, username ]`, `[ end_date, success, status ]`, `[ end_date, success, action_type ]`, `[ end_date, success, username ]`, `[ end_date, status, action_type ]`, `[ end_date, status, username ]`, `[ end_date, action_type, username ]`, `[ path, true_path, remote_ip ]`, `[ path, true_path, session_uuid ]`, `[ path, true_path, success ]`, `[ path, true_path, status ]`, `[ path, true_path, action_type ]`, `[ path, true_path, username ]`, `[ path, remote_ip, session_uuid ]`, `[ path, remote_ip, success ]`, `[ path, remote_ip, status ]`, `[ path, remote_ip, action_type ]`, `[ path, remote_ip, username ]`, `[ path, session_uuid, success ]`, `[ path, session_uuid, status ]`, `[ path, session_uuid, action_type ]`, `[ path, session_uuid, username ]`, `[ path, success, status ]`, `[ path, success, action_type ]`, `[ path, success, username ]`, `[ path, status, action_type ]`, `[ path, status, username ]`, `[ path, action_type, username ]`, `[ true_path, remote_ip, session_uuid ]`, `[ true_path, remote_ip, success ]`, `[ true_path, remote_ip, status ]`, `[ true_path, remote_ip, action_type ]`, `[ true_path, remote_ip, username ]`, `[ true_path, session_uuid, success ]`, `[ true_path, session_uuid, status ]`, `[ true_path, session_uuid, action_type ]`, `[ true_path, session_uuid, username ]`, `[ true_path, success, status ]`, `[ true_path, success, action_type ]`, `[ true_path, success, username ]`, `[ true_path, status, action_type ]`, `[ true_path, status, username ]`, `[ true_path, action_type, username ]`, `[ remote_ip, session_uuid, success ]`, `[ remote_ip, session_uuid, status ]`, `[ remote_ip, session_uuid, action_type ]`, `[ remote_ip, session_uuid, username ]`, `[ remote_ip, success, status ]`, `[ remote_ip, success, action_type ]`, `[ remote_ip, success, username ]`, `[ remote_ip, status, action_type ]`, `[ remote_ip, status, username ]`, `[ remote_ip, action_type, username ]`, `[ session_uuid, success, status ]`, `[ session_uuid, success, action_type ]`, `[ session_uuid, success, username ]`, `[ session_uuid, status, action_type ]`, `[ session_uuid, status, username ]`, `[ session_uuid, action_type, username ]`, `[ success, status, action_type ]`, `[ success, status, username ]`, `[ success, action_type, username ]`, `[ status, action_type, username ]`, `[ start_date, end_date, path, true_path ]`, `[ start_date, end_date, path, remote_ip ]`, `[ start_date, end_date, path, session_uuid ]`, `[ start_date, end_date, path, success ]`, `[ start_date, end_date, path, status ]`, `[ start_date, end_date, path, action_type ]`, `[ start_date, end_date, path, username ]`, `[ start_date, end_date, true_path, remote_ip ]`, `[ start_date, end_date, true_path, session_uuid ]`, `[ start_date, end_date, true_path, success ]`, `[ start_date, end_date, true_path, status ]`, `[ start_date, end_date, true_path, action_type ]`, `[ start_date, end_date, true_path, username ]`, `[ start_date, end_date, remote_ip, session_uuid ]`, `[ start_date, end_date, remote_ip, success ]`, `[ start_date, end_date, remote_ip, status ]`, `[ start_date, end_date, remote_ip, action_type ]`, `[ start_date, end_date, remote_ip, username ]`, `[ start_date, end_date, session_uuid, success ]`, `[ start_date, end_date, session_uuid, status ]`, `[ start_date, end_date, session_uuid, action_type ]`, `[ start_date, end_date, session_uuid, username ]`, `[ start_date, end_date, success, status ]`, `[ start_date, end_date, success, action_type ]`, `[ start_date, end_date, success, username ]`, `[ start_date, end_date, status, action_type ]`, `[ start_date, end_date, status, username ]`, `[ start_date, end_date, action_type, username ]`, `[ start_date, path, true_path, remote_ip ]`, `[ start_date, path, true_path, session_uuid ]`, `[ start_date, path, true_path, success ]`, `[ start_date, path, true_path, status ]`, `[ start_date, path, true_path, action_type ]`, `[ start_date, path, true_path, username ]`, `[ start_date, path, remote_ip, session_uuid ]`, `[ start_date, path, remote_ip, success ]`, `[ start_date, path, remote_ip, status ]`, `[ start_date, path, remote_ip, action_type ]`, `[ start_date, path, remote_ip, username ]`, `[ start_date, path, session_uuid, success ]`, `[ start_date, path, session_uuid, status ]`, `[ start_date, path, session_uuid, action_type ]`, `[ start_date, path, session_uuid, username ]`, `[ start_date, path, success, status ]`, `[ start_date, path, success, action_type ]`, `[ start_date, path, success, username ]`, `[ start_date, path, status, action_type ]`, `[ start_date, path, status, username ]`, `[ start_date, path, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid ]`, `[ start_date, true_path, remote_ip, success ]`, `[ start_date, true_path, remote_ip, status ]`, `[ start_date, true_path, remote_ip, action_type ]`, `[ start_date, true_path, remote_ip, username ]`, `[ start_date, true_path, session_uuid, success ]`, `[ start_date, true_path, session_uuid, status ]`, `[ start_date, true_path, session_uuid, action_type ]`, `[ start_date, true_path, session_uuid, username ]`, `[ start_date, true_path, success, status ]`, `[ start_date, true_path, success, action_type ]`, `[ start_date, true_path, success, username ]`, `[ start_date, true_path, status, action_type ]`, `[ start_date, true_path, status, username ]`, `[ start_date, true_path, action_type, username ]`, `[ start_date, remote_ip, session_uuid, success ]`, `[ start_date, remote_ip, session_uuid, status ]`, `[ start_date, remote_ip, session_uuid, action_type ]`, `[ start_date, remote_ip, session_uuid, username ]`, `[ start_date, remote_ip, success, status ]`, `[ start_date, remote_ip, success, action_type ]`, `[ start_date, remote_ip, success, username ]`, `[ start_date, remote_ip, status, action_type ]`, `[ start_date, remote_ip, status, username ]`, `[ start_date, remote_ip, action_type, username ]`, `[ start_date, session_uuid, success, status ]`, `[ start_date, session_uuid, success, action_type ]`, `[ start_date, session_uuid, success, username ]`, `[ start_date, session_uuid, status, action_type ]`, `[ start_date, session_uuid, status, username ]`, `[ start_date, session_uuid, action_type, username ]`, `[ start_date, success, status, action_type ]`, `[ start_date, success, status, username ]`, `[ start_date, success, action_type, username ]`, `[ start_date, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip ]`, `[ end_date, path, true_path, session_uuid ]`, `[ end_date, path, true_path, success ]`, `[ end_date, path, true_path, status ]`, `[ end_date, path, true_path, action_type ]`, `[ end_date, path, true_path, username ]`, `[ end_date, path, remote_ip, session_uuid ]`, `[ end_date, path, remote_ip, success ]`, `[ end_date, path, remote_ip, status ]`, `[ end_date, path, remote_ip, action_type ]`, `[ end_date, path, remote_ip, username ]`, `[ end_date, path, session_uuid, success ]`, `[ end_date, path, session_uuid, status ]`, `[ end_date, path, session_uuid, action_type ]`, `[ end_date, path, session_uuid, username ]`, `[ end_date, path, success, status ]`, `[ end_date, path, success, action_type ]`, `[ end_date, path, success, username ]`, `[ end_date, path, status, action_type ]`, `[ end_date, path, status, username ]`, `[ end_date, path, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid ]`, `[ end_date, true_path, remote_ip, success ]`, `[ end_date, true_path, remote_ip, status ]`, `[ end_date, true_path, remote_ip, action_type ]`, `[ end_date, true_path, remote_ip, username ]`, `[ end_date, true_path, session_uuid, success ]`, `[ end_date, true_path, session_uuid, status ]`, `[ end_date, true_path, session_uuid, action_type ]`, `[ end_date, true_path, session_uuid, username ]`, `[ end_date, true_path, success, status ]`, `[ end_date, true_path, success, action_type ]`, `[ end_date, true_path, success, username ]`, `[ end_date, true_path, status, action_type ]`, `[ end_date, true_path, status, username ]`, `[ end_date, true_path, action_type, username ]`, `[ end_date, remote_ip, session_uuid, success ]`, `[ end_date, remote_ip, session_uuid, status ]`, `[ end_date, remote_ip, session_uuid, action_type ]`, `[ end_date, remote_ip, session_uuid, username ]`, `[ end_date, remote_ip, success, status ]`, `[ end_date, remote_ip, success, action_type ]`, `[ end_date, remote_ip, success, username ]`, `[ end_date, remote_ip, status, action_type ]`, `[ end_date, remote_ip, status, username ]`, `[ end_date, remote_ip, action_type, username ]`, `[ end_date, session_uuid, success, status ]`, `[ end_date, session_uuid, success, action_type ]`, `[ end_date, session_uuid, success, username ]`, `[ end_date, session_uuid, status, action_type ]`, `[ end_date, session_uuid, status, username ]`, `[ end_date, session_uuid, action_type, username ]`, `[ end_date, success, status, action_type ]`, `[ end_date, success, status, username ]`, `[ end_date, success, action_type, username ]`, `[ end_date, status, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid ]`, `[ path, true_path, remote_ip, success ]`, `[ path, true_path, remote_ip, status ]`, `[ path, true_path, remote_ip, action_type ]`, `[ path, true_path, remote_ip, username ]`, `[ path, true_path, session_uuid, success ]`, `[ path, true_path, session_uuid, status ]`, `[ path, true_path, session_uuid, action_type ]`, `[ path, true_path, session_uuid, username ]`, `[ path, true_path, success, status ]`, `[ path, true_path, success, action_type ]`, `[ path, true_path, success, username ]`, `[ path, true_path, status, action_type ]`, `[ path, true_path, status, username ]`, `[ path, true_path, action_type, username ]`, `[ path, remote_ip, session_uuid, success ]`, `[ path, remote_ip, session_uuid, status ]`, `[ path, remote_ip, session_uuid, action_type ]`, `[ path, remote_ip, session_uuid, username ]`, `[ path, remote_ip, success, status ]`, `[ path, remote_ip, success, action_type ]`, `[ path, remote_ip, success, username ]`, `[ path, remote_ip, status, action_type ]`, `[ path, remote_ip, status, username ]`, `[ path, remote_ip, action_type, username ]`, `[ path, session_uuid, success, status ]`, `[ path, session_uuid, success, action_type ]`, `[ path, session_uuid, success, username ]`, `[ path, session_uuid, status, action_type ]`, `[ path, session_uuid, status, username ]`, `[ path, session_uuid, action_type, username ]`, `[ path, success, status, action_type ]`, `[ path, success, status, username ]`, `[ path, success, action_type, username ]`, `[ path, status, action_type, username ]`, `[ true_path, remote_ip, session_uuid, success ]`, `[ true_path, remote_ip, session_uuid, status ]`, `[ true_path, remote_ip, session_uuid, action_type ]`, `[ true_path, remote_ip, session_uuid, username ]`, `[ true_path, remote_ip, success, status ]`, `[ true_path, remote_ip, success, action_type ]`, `[ true_path, remote_ip, success, username ]`, `[ true_path, remote_ip, status, action_type ]`, `[ true_path, remote_ip, status, username ]`, `[ true_path, remote_ip, action_type, username ]`, `[ true_path, session_uuid, success, status ]`, `[ true_path, session_uuid, success, action_type ]`, `[ true_path, session_uuid, success, username ]`, `[ true_path, session_uuid, status, action_type ]`, `[ true_path, session_uuid, status, username ]`, `[ true_path, session_uuid, action_type, username ]`, `[ true_path, success, status, action_type ]`, `[ true_path, success, status, username ]`, `[ true_path, success, action_type, username ]`, `[ true_path, status, action_type, username ]`, `[ remote_ip, session_uuid, success, status ]`, `[ remote_ip, session_uuid, success, action_type ]`, `[ remote_ip, session_uuid, success, username ]`, `[ remote_ip, session_uuid, status, action_type ]`, `[ remote_ip, session_uuid, status, username ]`, `[ remote_ip, session_uuid, action_type, username ]`, `[ remote_ip, success, status, action_type ]`, `[ remote_ip, success, status, username ]`, `[ remote_ip, success, action_type, username ]`, `[ remote_ip, status, action_type, username ]`, `[ session_uuid, success, status, action_type ]`, `[ session_uuid, success, status, username ]`, `[ session_uuid, success, action_type, username ]`, `[ session_uuid, status, action_type, username ]`, `[ success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip ]`, `[ start_date, end_date, path, true_path, session_uuid ]`, `[ start_date, end_date, path, true_path, success ]`, `[ start_date, end_date, path, true_path, status ]`, `[ start_date, end_date, path, true_path, action_type ]`, `[ start_date, end_date, path, true_path, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid ]`, `[ start_date, end_date, path, remote_ip, success ]`, `[ start_date, end_date, path, remote_ip, status ]`, `[ start_date, end_date, path, remote_ip, action_type ]`, `[ start_date, end_date, path, remote_ip, username ]`, `[ start_date, end_date, path, session_uuid, success ]`, `[ start_date, end_date, path, session_uuid, status ]`, `[ start_date, end_date, path, session_uuid, action_type ]`, `[ start_date, end_date, path, session_uuid, username ]`, `[ start_date, end_date, path, success, status ]`, `[ start_date, end_date, path, success, action_type ]`, `[ start_date, end_date, path, success, username ]`, `[ start_date, end_date, path, status, action_type ]`, `[ start_date, end_date, path, status, username ]`, `[ start_date, end_date, path, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid ]`, `[ start_date, end_date, true_path, remote_ip, success ]`, `[ start_date, end_date, true_path, remote_ip, status ]`, `[ start_date, end_date, true_path, remote_ip, action_type ]`, `[ start_date, end_date, true_path, remote_ip, username ]`, `[ start_date, end_date, true_path, session_uuid, success ]`, `[ start_date, end_date, true_path, session_uuid, status ]`, `[ start_date, end_date, true_path, session_uuid, action_type ]`, `[ start_date, end_date, true_path, session_uuid, username ]`, `[ start_date, end_date, true_path, success, status ]`, `[ start_date, end_date, true_path, success, action_type ]`, `[ start_date, end_date, true_path, success, username ]`, `[ start_date, end_date, true_path, status, action_type ]`, `[ start_date, end_date, true_path, status, username ]`, `[ start_date, end_date, true_path, action_type, username ]`, `[ start_date, end_date, remote_ip, session_uuid, success ]`, `[ start_date, end_date, remote_ip, session_uuid, status ]`, `[ start_date, end_date, remote_ip, session_uuid, action_type ]`, `[ start_date, end_date, remote_ip, session_uuid, username ]`, `[ start_date, end_date, remote_ip, success, status ]`, `[ start_date, end_date, remote_ip, success, action_type ]`, `[ start_date, end_date, remote_ip, success, username ]`, `[ start_date, end_date, remote_ip, status, action_type ]`, `[ start_date, end_date, remote_ip, status, username ]`, `[ start_date, end_date, remote_ip, action_type, username ]`, `[ start_date, end_date, session_uuid, success, status ]`, `[ start_date, end_date, session_uuid, success, action_type ]`, `[ start_date, end_date, session_uuid, success, username ]`, `[ start_date, end_date, session_uuid, status, action_type ]`, `[ start_date, end_date, session_uuid, status, username ]`, `[ start_date, end_date, session_uuid, action_type, username ]`, `[ start_date, end_date, success, status, action_type ]`, `[ start_date, end_date, success, status, username ]`, `[ start_date, end_date, success, action_type, username ]`, `[ start_date, end_date, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid ]`, `[ start_date, path, true_path, remote_ip, success ]`, `[ start_date, path, true_path, remote_ip, status ]`, `[ start_date, path, true_path, remote_ip, action_type ]`, `[ start_date, path, true_path, remote_ip, username ]`, `[ start_date, path, true_path, session_uuid, success ]`, `[ start_date, path, true_path, session_uuid, status ]`, `[ start_date, path, true_path, session_uuid, action_type ]`, `[ start_date, path, true_path, session_uuid, username ]`, `[ start_date, path, true_path, success, status ]`, `[ start_date, path, true_path, success, action_type ]`, `[ start_date, path, true_path, success, username ]`, `[ start_date, path, true_path, status, action_type ]`, `[ start_date, path, true_path, status, username ]`, `[ start_date, path, true_path, action_type, username ]`, `[ start_date, path, remote_ip, session_uuid, success ]`, `[ start_date, path, remote_ip, session_uuid, status ]`, `[ start_date, path, remote_ip, session_uuid, action_type ]`, `[ start_date, path, remote_ip, session_uuid, username ]`, `[ start_date, path, remote_ip, success, status ]`, `[ start_date, path, remote_ip, success, action_type ]`, `[ start_date, path, remote_ip, success, username ]`, `[ start_date, path, remote_ip, status, action_type ]`, `[ start_date, path, remote_ip, status, username ]`, `[ start_date, path, remote_ip, action_type, username ]`, `[ start_date, path, session_uuid, success, status ]`, `[ start_date, path, session_uuid, success, action_type ]`, `[ start_date, path, session_uuid, success, username ]`, `[ start_date, path, session_uuid, status, action_type ]`, `[ start_date, path, session_uuid, status, username ]`, `[ start_date, path, session_uuid, action_type, username ]`, `[ start_date, path, success, status, action_type ]`, `[ start_date, path, success, status, username ]`, `[ start_date, path, success, action_type, username ]`, `[ start_date, path, status, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid, success ]`, `[ start_date, true_path, remote_ip, session_uuid, status ]`, `[ start_date, true_path, remote_ip, session_uuid, action_type ]`, `[ start_date, true_path, remote_ip, session_uuid, username ]`, `[ start_date, true_path, remote_ip, success, status ]`, `[ start_date, true_path, remote_ip, success, action_type ]`, `[ start_date, true_path, remote_ip, success, username ]`, `[ start_date, true_path, remote_ip, status, action_type ]`, `[ start_date, true_path, remote_ip, status, username ]`, `[ start_date, true_path, remote_ip, action_type, username ]`, `[ start_date, true_path, session_uuid, success, status ]`, `[ start_date, true_path, session_uuid, success, action_type ]`, `[ start_date, true_path, session_uuid, success, username ]`, `[ start_date, true_path, session_uuid, status, action_type ]`, `[ start_date, true_path, session_uuid, status, username ]`, `[ start_date, true_path, session_uuid, action_type, username ]`, `[ start_date, true_path, success, status, action_type ]`, `[ start_date, true_path, success, status, username ]`, `[ start_date, true_path, success, action_type, username ]`, `[ start_date, true_path, status, action_type, username ]`, `[ start_date, remote_ip, session_uuid, success, status ]`, `[ start_date, remote_ip, session_uuid, success, action_type ]`, `[ start_date, remote_ip, session_uuid, success, username ]`, `[ start_date, remote_ip, session_uuid, status, action_type ]`, `[ start_date, remote_ip, session_uuid, status, username ]`, `[ start_date, remote_ip, session_uuid, action_type, username ]`, `[ start_date, remote_ip, success, status, action_type ]`, `[ start_date, remote_ip, success, status, username ]`, `[ start_date, remote_ip, success, action_type, username ]`, `[ start_date, remote_ip, status, action_type, username ]`, `[ start_date, session_uuid, success, status, action_type ]`, `[ start_date, session_uuid, success, status, username ]`, `[ start_date, session_uuid, success, action_type, username ]`, `[ start_date, session_uuid, status, action_type, username ]`, `[ start_date, success, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid ]`, `[ end_date, path, true_path, remote_ip, success ]`, `[ end_date, path, true_path, remote_ip, status ]`, `[ end_date, path, true_path, remote_ip, action_type ]`, `[ end_date, path, true_path, remote_ip, username ]`, `[ end_date, path, true_path, session_uuid, success ]`, `[ end_date, path, true_path, session_uuid, status ]`, `[ end_date, path, true_path, session_uuid, action_type ]`, `[ end_date, path, true_path, session_uuid, username ]`, `[ end_date, path, true_path, success, status ]`, `[ end_date, path, true_path, success, action_type ]`, `[ end_date, path, true_path, success, username ]`, `[ end_date, path, true_path, status, action_type ]`, `[ end_date, path, true_path, status, username ]`, `[ end_date, path, true_path, action_type, username ]`, `[ end_date, path, remote_ip, session_uuid, success ]`, `[ end_date, path, remote_ip, session_uuid, status ]`, `[ end_date, path, remote_ip, session_uuid, action_type ]`, `[ end_date, path, remote_ip, session_uuid, username ]`, `[ end_date, path, remote_ip, success, status ]`, `[ end_date, path, remote_ip, success, action_type ]`, `[ end_date, path, remote_ip, success, username ]`, `[ end_date, path, remote_ip, status, action_type ]`, `[ end_date, path, remote_ip, status, username ]`, `[ end_date, path, remote_ip, action_type, username ]`, `[ end_date, path, session_uuid, success, status ]`, `[ end_date, path, session_uuid, success, action_type ]`, `[ end_date, path, session_uuid, success, username ]`, `[ end_date, path, session_uuid, status, action_type ]`, `[ end_date, path, session_uuid, status, username ]`, `[ end_date, path, session_uuid, action_type, username ]`, `[ end_date, path, success, status, action_type ]`, `[ end_date, path, success, status, username ]`, `[ end_date, path, success, action_type, username ]`, `[ end_date, path, status, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid, success ]`, `[ end_date, true_path, remote_ip, session_uuid, status ]`, `[ end_date, true_path, remote_ip, session_uuid, action_type ]`, `[ end_date, true_path, remote_ip, session_uuid, username ]`, `[ end_date, true_path, remote_ip, success, status ]`, `[ end_date, true_path, remote_ip, success, action_type ]`, `[ end_date, true_path, remote_ip, success, username ]`, `[ end_date, true_path, remote_ip, status, action_type ]`, `[ end_date, true_path, remote_ip, status, username ]`, `[ end_date, true_path, remote_ip, action_type, username ]`, `[ end_date, true_path, session_uuid, success, status ]`, `[ end_date, true_path, session_uuid, success, action_type ]`, `[ end_date, true_path, session_uuid, success, username ]`, `[ end_date, true_path, session_uuid, status, action_type ]`, `[ end_date, true_path, session_uuid, status, username ]`, `[ end_date, true_path, session_uuid, action_type, username ]`, `[ end_date, true_path, success, status, action_type ]`, `[ end_date, true_path, success, status, username ]`, `[ end_date, true_path, success, action_type, username ]`, `[ end_date, true_path, status, action_type, username ]`, `[ end_date, remote_ip, session_uuid, success, status ]`, `[ end_date, remote_ip, session_uuid, success, action_type ]`, `[ end_date, remote_ip, session_uuid, success, username ]`, `[ end_date, remote_ip, session_uuid, status, action_type ]`, `[ end_date, remote_ip, session_uuid, status, username ]`, `[ end_date, remote_ip, session_uuid, action_type, username ]`, `[ end_date, remote_ip, success, status, action_type ]`, `[ end_date, remote_ip, success, status, username ]`, `[ end_date, remote_ip, success, action_type, username ]`, `[ end_date, remote_ip, status, action_type, username ]`, `[ end_date, session_uuid, success, status, action_type ]`, `[ end_date, session_uuid, success, status, username ]`, `[ end_date, session_uuid, success, action_type, username ]`, `[ end_date, session_uuid, status, action_type, username ]`, `[ end_date, success, status, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid, success ]`, `[ path, true_path, remote_ip, session_uuid, status ]`, `[ path, true_path, remote_ip, session_uuid, action_type ]`, `[ path, true_path, remote_ip, session_uuid, username ]`, `[ path, true_path, remote_ip, success, status ]`, `[ path, true_path, remote_ip, success, action_type ]`, `[ path, true_path, remote_ip, success, username ]`, `[ path, true_path, remote_ip, status, action_type ]`, `[ path, true_path, remote_ip, status, username ]`, `[ path, true_path, remote_ip, action_type, username ]`, `[ path, true_path, session_uuid, success, status ]`, `[ path, true_path, session_uuid, success, action_type ]`, `[ path, true_path, session_uuid, success, username ]`, `[ path, true_path, session_uuid, status, action_type ]`, `[ path, true_path, session_uuid, status, username ]`, `[ path, true_path, session_uuid, action_type, username ]`, `[ path, true_path, success, status, action_type ]`, `[ path, true_path, success, status, username ]`, `[ path, true_path, success, action_type, username ]`, `[ path, true_path, status, action_type, username ]`, `[ path, remote_ip, session_uuid, success, status ]`, `[ path, remote_ip, session_uuid, success, action_type ]`, `[ path, remote_ip, session_uuid, success, username ]`, `[ path, remote_ip, session_uuid, status, action_type ]`, `[ path, remote_ip, session_uuid, status, username ]`, `[ path, remote_ip, session_uuid, action_type, username ]`, `[ path, remote_ip, success, status, action_type ]`, `[ path, remote_ip, success, status, username ]`, `[ path, remote_ip, success, action_type, username ]`, `[ path, remote_ip, status, action_type, username ]`, `[ path, session_uuid, success, status, action_type ]`, `[ path, session_uuid, success, status, username ]`, `[ path, session_uuid, success, action_type, username ]`, `[ path, session_uuid, status, action_type, username ]`, `[ path, success, status, action_type, username ]`, `[ true_path, remote_ip, session_uuid, success, status ]`, `[ true_path, remote_ip, session_uuid, success, action_type ]`, `[ true_path, remote_ip, session_uuid, success, username ]`, `[ true_path, remote_ip, session_uuid, status, action_type ]`, `[ true_path, remote_ip, session_uuid, status, username ]`, `[ true_path, remote_ip, session_uuid, action_type, username ]`, `[ true_path, remote_ip, success, status, action_type ]`, `[ true_path, remote_ip, success, status, username ]`, `[ true_path, remote_ip, success, action_type, username ]`, `[ true_path, remote_ip, status, action_type, username ]`, `[ true_path, session_uuid, success, status, action_type ]`, `[ true_path, session_uuid, success, status, username ]`, `[ true_path, session_uuid, success, action_type, username ]`, `[ true_path, session_uuid, status, action_type, username ]`, `[ true_path, success, status, action_type, username ]`, `[ remote_ip, session_uuid, success, status, action_type ]`, `[ remote_ip, session_uuid, success, status, username ]`, `[ remote_ip, session_uuid, success, action_type, username ]`, `[ remote_ip, session_uuid, status, action_type, username ]`, `[ remote_ip, success, status, action_type, username ]`, `[ session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid ]`, `[ start_date, end_date, path, true_path, remote_ip, success ]`, `[ start_date, end_date, path, true_path, remote_ip, status ]`, `[ start_date, end_date, path, true_path, remote_ip, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, username ]`, `[ start_date, end_date, path, true_path, session_uuid, success ]`, `[ start_date, end_date, path, true_path, session_uuid, status ]`, `[ start_date, end_date, path, true_path, session_uuid, action_type ]`, `[ start_date, end_date, path, true_path, session_uuid, username ]`, `[ start_date, end_date, path, true_path, success, status ]`, `[ start_date, end_date, path, true_path, success, action_type ]`, `[ start_date, end_date, path, true_path, success, username ]`, `[ start_date, end_date, path, true_path, status, action_type ]`, `[ start_date, end_date, path, true_path, status, username ]`, `[ start_date, end_date, path, true_path, action_type, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success ]`, `[ start_date, end_date, path, remote_ip, session_uuid, status ]`, `[ start_date, end_date, path, remote_ip, session_uuid, action_type ]`, `[ start_date, end_date, path, remote_ip, session_uuid, username ]`, `[ start_date, end_date, path, remote_ip, success, status ]`, `[ start_date, end_date, path, remote_ip, success, action_type ]`, `[ start_date, end_date, path, remote_ip, success, username ]`, `[ start_date, end_date, path, remote_ip, status, action_type ]`, `[ start_date, end_date, path, remote_ip, status, username ]`, `[ start_date, end_date, path, remote_ip, action_type, username ]`, `[ start_date, end_date, path, session_uuid, success, status ]`, `[ start_date, end_date, path, session_uuid, success, action_type ]`, `[ start_date, end_date, path, session_uuid, success, username ]`, `[ start_date, end_date, path, session_uuid, status, action_type ]`, `[ start_date, end_date, path, session_uuid, status, username ]`, `[ start_date, end_date, path, session_uuid, action_type, username ]`, `[ start_date, end_date, path, success, status, action_type ]`, `[ start_date, end_date, path, success, status, username ]`, `[ start_date, end_date, path, success, action_type, username ]`, `[ start_date, end_date, path, status, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, status ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, action_type ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, username ]`, `[ start_date, end_date, true_path, remote_ip, success, status ]`, `[ start_date, end_date, true_path, remote_ip, success, action_type ]`, `[ start_date, end_date, true_path, remote_ip, success, username ]`, `[ start_date, end_date, true_path, remote_ip, status, action_type ]`, `[ start_date, end_date, true_path, remote_ip, status, username ]`, `[ start_date, end_date, true_path, remote_ip, action_type, username ]`, `[ start_date, end_date, true_path, session_uuid, success, status ]`, `[ start_date, end_date, true_path, session_uuid, success, action_type ]`, `[ start_date, end_date, true_path, session_uuid, success, username ]`, `[ start_date, end_date, true_path, session_uuid, status, action_type ]`, `[ start_date, end_date, true_path, session_uuid, status, username ]`, `[ start_date, end_date, true_path, session_uuid, action_type, username ]`, `[ start_date, end_date, true_path, success, status, action_type ]`, `[ start_date, end_date, true_path, success, status, username ]`, `[ start_date, end_date, true_path, success, action_type, username ]`, `[ start_date, end_date, true_path, status, action_type, username ]`, `[ start_date, end_date, remote_ip, session_uuid, success, status ]`, `[ start_date, end_date, remote_ip, session_uuid, success, action_type ]`, `[ start_date, end_date, remote_ip, session_uuid, success, username ]`, `[ start_date, end_date, remote_ip, session_uuid, status, action_type ]`, `[ start_date, end_date, remote_ip, session_uuid, status, username ]`, `[ start_date, end_date, remote_ip, session_uuid, action_type, username ]`, `[ start_date, end_date, remote_ip, success, status, action_type ]`, `[ start_date, end_date, remote_ip, success, status, username ]`, `[ start_date, end_date, remote_ip, success, action_type, username ]`, `[ start_date, end_date, remote_ip, status, action_type, username ]`, `[ start_date, end_date, session_uuid, success, status, action_type ]`, `[ start_date, end_date, session_uuid, success, status, username ]`, `[ start_date, end_date, session_uuid, success, action_type, username ]`, `[ start_date, end_date, session_uuid, status, action_type, username ]`, `[ start_date, end_date, success, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success ]`, `[ start_date, path, true_path, remote_ip, session_uuid, status ]`, `[ start_date, path, true_path, remote_ip, session_uuid, action_type ]`, `[ start_date, path, true_path, remote_ip, session_uuid, username ]`, `[ start_date, path, true_path, remote_ip, success, status ]`, `[ start_date, path, true_path, remote_ip, success, action_type ]`, `[ start_date, path, true_path, remote_ip, success, username ]`, `[ start_date, path, true_path, remote_ip, status, action_type ]`, `[ start_date, path, true_path, remote_ip, status, username ]`, `[ start_date, path, true_path, remote_ip, action_type, username ]`, `[ start_date, path, true_path, session_uuid, success, status ]`, `[ start_date, path, true_path, session_uuid, success, action_type ]`, `[ start_date, path, true_path, session_uuid, success, username ]`, `[ start_date, path, true_path, session_uuid, status, action_type ]`, `[ start_date, path, true_path, session_uuid, status, username ]`, `[ start_date, path, true_path, session_uuid, action_type, username ]`, `[ start_date, path, true_path, success, status, action_type ]`, `[ start_date, path, true_path, success, status, username ]`, `[ start_date, path, true_path, success, action_type, username ]`, `[ start_date, path, true_path, status, action_type, username ]`, `[ start_date, path, remote_ip, session_uuid, success, status ]`, `[ start_date, path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, path, remote_ip, session_uuid, success, username ]`, `[ start_date, path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, path, remote_ip, session_uuid, status, username ]`, `[ start_date, path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, path, remote_ip, success, status, action_type ]`, `[ start_date, path, remote_ip, success, status, username ]`, `[ start_date, path, remote_ip, success, action_type, username ]`, `[ start_date, path, remote_ip, status, action_type, username ]`, `[ start_date, path, session_uuid, success, status, action_type ]`, `[ start_date, path, session_uuid, success, status, username ]`, `[ start_date, path, session_uuid, success, action_type, username ]`, `[ start_date, path, session_uuid, status, action_type, username ]`, `[ start_date, path, success, status, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid, success, status ]`, `[ start_date, true_path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, true_path, remote_ip, session_uuid, success, username ]`, `[ start_date, true_path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, true_path, remote_ip, session_uuid, status, username ]`, `[ start_date, true_path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, true_path, remote_ip, success, status, action_type ]`, `[ start_date, true_path, remote_ip, success, status, username ]`, `[ start_date, true_path, remote_ip, success, action_type, username ]`, `[ start_date, true_path, remote_ip, status, action_type, username ]`, `[ start_date, true_path, session_uuid, success, status, action_type ]`, `[ start_date, true_path, session_uuid, success, status, username ]`, `[ start_date, true_path, session_uuid, success, action_type, username ]`, `[ start_date, true_path, session_uuid, status, action_type, username ]`, `[ start_date, true_path, success, status, action_type, username ]`, `[ start_date, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, remote_ip, session_uuid, success, status, username ]`, `[ start_date, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, remote_ip, success, status, action_type, username ]`, `[ start_date, session_uuid, success, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success ]`, `[ end_date, path, true_path, remote_ip, session_uuid, status ]`, `[ end_date, path, true_path, remote_ip, session_uuid, action_type ]`, `[ end_date, path, true_path, remote_ip, session_uuid, username ]`, `[ end_date, path, true_path, remote_ip, success, status ]`, `[ end_date, path, true_path, remote_ip, success, action_type ]`, `[ end_date, path, true_path, remote_ip, success, username ]`, `[ end_date, path, true_path, remote_ip, status, action_type ]`, `[ end_date, path, true_path, remote_ip, status, username ]`, `[ end_date, path, true_path, remote_ip, action_type, username ]`, `[ end_date, path, true_path, session_uuid, success, status ]`, `[ end_date, path, true_path, session_uuid, success, action_type ]`, `[ end_date, path, true_path, session_uuid, success, username ]`, `[ end_date, path, true_path, session_uuid, status, action_type ]`, `[ end_date, path, true_path, session_uuid, status, username ]`, `[ end_date, path, true_path, session_uuid, action_type, username ]`, `[ end_date, path, true_path, success, status, action_type ]`, `[ end_date, path, true_path, success, status, username ]`, `[ end_date, path, true_path, success, action_type, username ]`, `[ end_date, path, true_path, status, action_type, username ]`, `[ end_date, path, remote_ip, session_uuid, success, status ]`, `[ end_date, path, remote_ip, session_uuid, success, action_type ]`, `[ end_date, path, remote_ip, session_uuid, success, username ]`, `[ end_date, path, remote_ip, session_uuid, status, action_type ]`, `[ end_date, path, remote_ip, session_uuid, status, username ]`, `[ end_date, path, remote_ip, session_uuid, action_type, username ]`, `[ end_date, path, remote_ip, success, status, action_type ]`, `[ end_date, path, remote_ip, success, status, username ]`, `[ end_date, path, remote_ip, success, action_type, username ]`, `[ end_date, path, remote_ip, status, action_type, username ]`, `[ end_date, path, session_uuid, success, status, action_type ]`, `[ end_date, path, session_uuid, success, status, username ]`, `[ end_date, path, session_uuid, success, action_type, username ]`, `[ end_date, path, session_uuid, status, action_type, username ]`, `[ end_date, path, success, status, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid, success, status ]`, `[ end_date, true_path, remote_ip, session_uuid, success, action_type ]`, `[ end_date, true_path, remote_ip, session_uuid, success, username ]`, `[ end_date, true_path, remote_ip, session_uuid, status, action_type ]`, `[ end_date, true_path, remote_ip, session_uuid, status, username ]`, `[ end_date, true_path, remote_ip, session_uuid, action_type, username ]`, `[ end_date, true_path, remote_ip, success, status, action_type ]`, `[ end_date, true_path, remote_ip, success, status, username ]`, `[ end_date, true_path, remote_ip, success, action_type, username ]`, `[ end_date, true_path, remote_ip, status, action_type, username ]`, `[ end_date, true_path, session_uuid, success, status, action_type ]`, `[ end_date, true_path, session_uuid, success, status, username ]`, `[ end_date, true_path, session_uuid, success, action_type, username ]`, `[ end_date, true_path, session_uuid, status, action_type, username ]`, `[ end_date, true_path, success, status, action_type, username ]`, `[ end_date, remote_ip, session_uuid, success, status, action_type ]`, `[ end_date, remote_ip, session_uuid, success, status, username ]`, `[ end_date, remote_ip, session_uuid, success, action_type, username ]`, `[ end_date, remote_ip, session_uuid, status, action_type, username ]`, `[ end_date, remote_ip, success, status, action_type, username ]`, `[ end_date, session_uuid, success, status, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid, success, status ]`, `[ path, true_path, remote_ip, session_uuid, success, action_type ]`, `[ path, true_path, remote_ip, session_uuid, success, username ]`, `[ path, true_path, remote_ip, session_uuid, status, action_type ]`, `[ path, true_path, remote_ip, session_uuid, status, username ]`, `[ path, true_path, remote_ip, session_uuid, action_type, username ]`, `[ path, true_path, remote_ip, success, status, action_type ]`, `[ path, true_path, remote_ip, success, status, username ]`, `[ path, true_path, remote_ip, success, action_type, username ]`, `[ path, true_path, remote_ip, status, action_type, username ]`, `[ path, true_path, session_uuid, success, status, action_type ]`, `[ path, true_path, session_uuid, success, status, username ]`, `[ path, true_path, session_uuid, success, action_type, username ]`, `[ path, true_path, session_uuid, status, action_type, username ]`, `[ path, true_path, success, status, action_type, username ]`, `[ path, remote_ip, session_uuid, success, status, action_type ]`, `[ path, remote_ip, session_uuid, success, status, username ]`, `[ path, remote_ip, session_uuid, success, action_type, username ]`, `[ path, remote_ip, session_uuid, status, action_type, username ]`, `[ path, remote_ip, success, status, action_type, username ]`, `[ path, session_uuid, success, status, action_type, username ]`, `[ true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ true_path, remote_ip, session_uuid, success, status, username ]`, `[ true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ true_path, remote_ip, success, status, action_type, username ]`, `[ true_path, session_uuid, success, status, action_type, username ]`, `[ remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, status ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, username ]`, `[ start_date, end_date, path, true_path, remote_ip, success, status ]`, `[ start_date, end_date, path, true_path, remote_ip, success, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, success, username ]`, `[ start_date, end_date, path, true_path, remote_ip, status, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, status, username ]`, `[ start_date, end_date, path, true_path, remote_ip, action_type, username ]`, `[ start_date, end_date, path, true_path, session_uuid, success, status ]`, `[ start_date, end_date, path, true_path, session_uuid, success, action_type ]`, `[ start_date, end_date, path, true_path, session_uuid, success, username ]`, `[ start_date, end_date, path, true_path, session_uuid, status, action_type ]`, `[ start_date, end_date, path, true_path, session_uuid, status, username ]`, `[ start_date, end_date, path, true_path, session_uuid, action_type, username ]`, `[ start_date, end_date, path, true_path, success, status, action_type ]`, `[ start_date, end_date, path, true_path, success, status, username ]`, `[ start_date, end_date, path, true_path, success, action_type, username ]`, `[ start_date, end_date, path, true_path, status, action_type, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, status ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, end_date, path, remote_ip, session_uuid, status, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, end_date, path, remote_ip, success, status, action_type ]`, `[ start_date, end_date, path, remote_ip, success, status, username ]`, `[ start_date, end_date, path, remote_ip, success, action_type, username ]`, `[ start_date, end_date, path, remote_ip, status, action_type, username ]`, `[ start_date, end_date, path, session_uuid, success, status, action_type ]`, `[ start_date, end_date, path, session_uuid, success, status, username ]`, `[ start_date, end_date, path, session_uuid, success, action_type, username ]`, `[ start_date, end_date, path, session_uuid, status, action_type, username ]`, `[ start_date, end_date, path, success, status, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, status ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, status, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, success, status, action_type ]`, `[ start_date, end_date, true_path, remote_ip, success, status, username ]`, `[ start_date, end_date, true_path, remote_ip, success, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, status, action_type, username ]`, `[ start_date, end_date, true_path, session_uuid, success, status, action_type ]`, `[ start_date, end_date, true_path, session_uuid, success, status, username ]`, `[ start_date, end_date, true_path, session_uuid, success, action_type, username ]`, `[ start_date, end_date, true_path, session_uuid, status, action_type, username ]`, `[ start_date, end_date, true_path, success, status, action_type, username ]`, `[ start_date, end_date, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, end_date, remote_ip, session_uuid, success, status, username ]`, `[ start_date, end_date, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, end_date, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, end_date, remote_ip, success, status, action_type, username ]`, `[ start_date, end_date, session_uuid, success, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, status ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, path, true_path, remote_ip, session_uuid, status, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, path, true_path, remote_ip, success, status, action_type ]`, `[ start_date, path, true_path, remote_ip, success, status, username ]`, `[ start_date, path, true_path, remote_ip, success, action_type, username ]`, `[ start_date, path, true_path, remote_ip, status, action_type, username ]`, `[ start_date, path, true_path, session_uuid, success, status, action_type ]`, `[ start_date, path, true_path, session_uuid, success, status, username ]`, `[ start_date, path, true_path, session_uuid, success, action_type, username ]`, `[ start_date, path, true_path, session_uuid, status, action_type, username ]`, `[ start_date, path, true_path, success, status, action_type, username ]`, `[ start_date, path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, path, remote_ip, success, status, action_type, username ]`, `[ start_date, path, session_uuid, success, status, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, true_path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, true_path, remote_ip, success, status, action_type, username ]`, `[ start_date, true_path, session_uuid, success, status, action_type, username ]`, `[ start_date, remote_ip, session_uuid, success, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, status ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, action_type ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, status, action_type ]`, `[ end_date, path, true_path, remote_ip, session_uuid, status, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, action_type, username ]`, `[ end_date, path, true_path, remote_ip, success, status, action_type ]`, `[ end_date, path, true_path, remote_ip, success, status, username ]`, `[ end_date, path, true_path, remote_ip, success, action_type, username ]`, `[ end_date, path, true_path, remote_ip, status, action_type, username ]`, `[ end_date, path, true_path, session_uuid, success, status, action_type ]`, `[ end_date, path, true_path, session_uuid, success, status, username ]`, `[ end_date, path, true_path, session_uuid, success, action_type, username ]`, `[ end_date, path, true_path, session_uuid, status, action_type, username ]`, `[ end_date, path, true_path, success, status, action_type, username ]`, `[ end_date, path, remote_ip, session_uuid, success, status, action_type ]`, `[ end_date, path, remote_ip, session_uuid, success, status, username ]`, `[ end_date, path, remote_ip, session_uuid, success, action_type, username ]`, `[ end_date, path, remote_ip, session_uuid, status, action_type, username ]`, `[ end_date, path, remote_ip, success, status, action_type, username ]`, `[ end_date, path, session_uuid, success, status, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ end_date, true_path, remote_ip, session_uuid, success, status, username ]`, `[ end_date, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ end_date, true_path, remote_ip, success, status, action_type, username ]`, `[ end_date, true_path, session_uuid, success, status, action_type, username ]`, `[ end_date, remote_ip, session_uuid, success, status, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ path, true_path, remote_ip, session_uuid, success, status, username ]`, `[ path, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ path, true_path, remote_ip, success, status, action_type, username ]`, `[ path, true_path, session_uuid, success, status, action_type, username ]`, `[ path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ true_path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, status ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, status, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, status, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, success, status, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, success, status, username ]`, `[ start_date, end_date, path, true_path, remote_ip, success, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, status, action_type, username ]`, `[ start_date, end_date, path, true_path, session_uuid, success, status, action_type ]`, `[ start_date, end_date, path, true_path, session_uuid, success, status, username ]`, `[ start_date, end_date, path, true_path, session_uuid, success, action_type, username ]`, `[ start_date, end_date, path, true_path, session_uuid, status, action_type, username ]`, `[ start_date, end_date, path, true_path, success, status, action_type, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, end_date, path, remote_ip, success, status, action_type, username ]`, `[ start_date, end_date, path, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, success, status, action_type, username ]`, `[ start_date, end_date, true_path, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, success, status, action_type, username ]`, `[ start_date, path, true_path, session_uuid, success, status, action_type, username ]`, `[ start_date, path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, true_path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, status, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ end_date, path, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ end_date, path, true_path, remote_ip, success, status, action_type, username ]`, `[ end_date, path, true_path, session_uuid, success, status, action_type, username ]`, `[ end_date, path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ end_date, true_path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ path, true_path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, status, action_type ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, status, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, success, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, session_uuid, status, action_type, username ]`, `[ start_date, end_date, path, true_path, remote_ip, success, status, action_type, username ]`, `[ start_date, end_date, path, true_path, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, end_date, true_path, remote_ip, session_uuid, success, status, action_type, username ]`, `[ start_date, path, true_path, remote_ip, session_uuid, success, status, action_type, username ]` or `[ end_date, path, true_path, remote_ip, session_uuid, success, status, action_type, username ]`.
def list(params=None, options=None):
    if not isinstance(params, dict):
        params = {}
    if not isinstance(options, dict):
        options = {}
    if "cursor" in params and not isinstance(params["cursor"], str):
        raise InvalidParameterError("Bad parameter: cursor must be an str")
    if "per_page" in params and not isinstance(params["per_page"], int):
        raise InvalidParameterError("Bad parameter: per_page must be an int")
    if "filter" in params and not isinstance(params["filter"], dict):
        raise InvalidParameterError("Bad parameter: filter must be an dict")
    if "filter_prefix" in params and not isinstance(
        params["filter_prefix"], dict
    ):
        raise InvalidParameterError(
            "Bad parameter: filter_prefix must be an dict"
        )
    return ListObj(FtpActionLog, "GET", "/ftp_action_logs", params, options)


def all(params=None, options=None):
    list(params, options)


def new(*args, **kwargs):
    return FtpActionLog(*args, **kwargs)
