from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar

from attrs import define as _attrs_define

if TYPE_CHECKING:
    from ..models.api_error_filesystem_in_use import ApiErrorFilesystemInUse


T = TypeVar("T", bound="FilesystemDeleteResponse400")


@_attrs_define
class FilesystemDeleteResponse400:
    """
    Attributes:
        error (ApiErrorFilesystemInUse):
    """

    error: ApiErrorFilesystemInUse

    def to_dict(self) -> dict[str, Any]:
        error = self.error.to_dict()

        field_dict: dict[str, Any] = {}

        field_dict.update(
            {
                "error": error,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.api_error_filesystem_in_use import ApiErrorFilesystemInUse

        d = dict(src_dict)
        error = ApiErrorFilesystemInUse.from_dict(d.pop("error"))

        filesystem_delete_response_400 = cls(
            error=error,
        )

        return filesystem_delete_response_400
