# -*- coding: utf-8 -*-
import http.server
import ssl
import argparse
import pkgutil

BANNER = pkgutil.get_data("simplehttps", "banner.txt").decode("utf-8")

def run(port=4443, directory=".", cert="cert.pem", key="key.pem"):
    print(BANNER)

    handler = http.server.SimpleHTTPRequestHandler
    server_address = ("0.0.0.0", port)

    httpd = http.server.HTTPServer(server_address, handler)

    context = ssl.SSLContext(ssl.PROTOCOL_TLS_SERVER)
    context.load_cert_chain(certfile=cert, keyfile=key)
    httpd.socket = context.wrap_socket(httpd.socket, server_side=True)

    print(f"HTTPS server running on https://0.0.0.0:{port}")
    httpd.serve_forever()


def cli():
    parser = argparse.ArgumentParser(description="Simple HTTPS Server with TLS")
    parser.add_argument("--port", "-p", type=int, default=4443, help="Port to serve on")
    parser.add_argument("--cert", "-c", default="cert.pem", help="Certificate file")
    parser.add_argument("--key", "-k", default="key.pem", help="Private key file")
    parser.add_argument("--dir", "-d", default=".", help="Directory to serve")
    args = parser.parse_args()

    run(port=args.port, directory=args.dir, cert=args.cert, key=args.key)


if __name__ == "__main__":
    cli()
