"""
    Consolidate Services

    Description of all APIs  # noqa: E501

    The version of the OpenAPI document: version not set
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from argocd_python_client.api_client import ApiClient, Endpoint as _Endpoint
from argocd_python_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from argocd_python_client.model.repository_helm_charts_response import RepositoryHelmChartsResponse
from argocd_python_client.model.repository_refs import RepositoryRefs
from argocd_python_client.model.repository_repo_app_details_query import RepositoryRepoAppDetailsQuery
from argocd_python_client.model.repository_repo_app_details_response import RepositoryRepoAppDetailsResponse
from argocd_python_client.model.repository_repo_apps_response import RepositoryRepoAppsResponse
from argocd_python_client.model.runtime_error import RuntimeError
from argocd_python_client.model.v1alpha1_repository import V1alpha1Repository
from argocd_python_client.model.v1alpha1_repository_list import V1alpha1RepositoryList


class RepositoryServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __repository_service_create_repository(
            self,
            body,
            **kwargs
        ):
            """CreateRepository creates a new repository configuration  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.repository_service_create_repository(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (V1alpha1Repository): Repository definition

            Keyword Args:
                upsert (bool): Whether to create in upsert mode.. [optional]
                creds_only (bool): Whether to operate on credential set instead of repository.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1Repository
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.repository_service_create_repository = _Endpoint(
            settings={
                'response_type': (V1alpha1Repository,),
                'auth': [],
                'endpoint_path': '/api/v1/repositories',
                'operation_id': 'repository_service_create_repository',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                    'upsert',
                    'creds_only',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (V1alpha1Repository,),
                    'upsert':
                        (bool,),
                    'creds_only':
                        (bool,),
                },
                'attribute_map': {
                    'upsert': 'upsert',
                    'creds_only': 'credsOnly',
                },
                'location_map': {
                    'body': 'body',
                    'upsert': 'query',
                    'creds_only': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__repository_service_create_repository
        )

        def __repository_service_delete_repository(
            self,
            repo,
            **kwargs
        ):
            """DeleteRepository deletes a repository from the configuration  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.repository_service_delete_repository(repo, async_req=True)
            >>> result = thread.get()

            Args:
                repo (str): Repo URL for query

            Keyword Args:
                force_refresh (bool): Whether to force a cache refresh on repo's connection state.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                bool, date, datetime, dict, float, int, list, str, none_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['repo'] = \
                repo
            return self.call_with_http_info(**kwargs)

        self.repository_service_delete_repository = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/api/v1/repositories/{repo}',
                'operation_id': 'repository_service_delete_repository',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'repo',
                    'force_refresh',
                ],
                'required': [
                    'repo',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repo':
                        (str,),
                    'force_refresh':
                        (bool,),
                },
                'attribute_map': {
                    'repo': 'repo',
                    'force_refresh': 'forceRefresh',
                },
                'location_map': {
                    'repo': 'path',
                    'force_refresh': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__repository_service_delete_repository
        )

        def __repository_service_get(
            self,
            repo,
            **kwargs
        ):
            """Get returns a repository or its credentials  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.repository_service_get(repo, async_req=True)
            >>> result = thread.get()

            Args:
                repo (str): Repo URL for query

            Keyword Args:
                force_refresh (bool): Whether to force a cache refresh on repo's connection state.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1Repository
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['repo'] = \
                repo
            return self.call_with_http_info(**kwargs)

        self.repository_service_get = _Endpoint(
            settings={
                'response_type': (V1alpha1Repository,),
                'auth': [],
                'endpoint_path': '/api/v1/repositories/{repo}',
                'operation_id': 'repository_service_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'repo',
                    'force_refresh',
                ],
                'required': [
                    'repo',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repo':
                        (str,),
                    'force_refresh':
                        (bool,),
                },
                'attribute_map': {
                    'repo': 'repo',
                    'force_refresh': 'forceRefresh',
                },
                'location_map': {
                    'repo': 'path',
                    'force_refresh': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__repository_service_get
        )

        def __repository_service_get_app_details(
            self,
            source_repo_url,
            body,
            **kwargs
        ):
            """GetAppDetails returns application details by given path  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.repository_service_get_app_details(source_repo_url, body, async_req=True)
            >>> result = thread.get()

            Args:
                source_repo_url (str): RepoURL is the URL to the repository (Git or Helm) that contains the application manifests
                body (RepositoryRepoAppDetailsQuery):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RepositoryRepoAppDetailsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_repo_url'] = \
                source_repo_url
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.repository_service_get_app_details = _Endpoint(
            settings={
                'response_type': (RepositoryRepoAppDetailsResponse,),
                'auth': [],
                'endpoint_path': '/api/v1/repositories/{source.repoURL}/appdetails',
                'operation_id': 'repository_service_get_app_details',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_repo_url',
                    'body',
                ],
                'required': [
                    'source_repo_url',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_repo_url':
                        (str,),
                    'body':
                        (RepositoryRepoAppDetailsQuery,),
                },
                'attribute_map': {
                    'source_repo_url': 'source.repoURL',
                },
                'location_map': {
                    'source_repo_url': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__repository_service_get_app_details
        )

        def __repository_service_get_helm_charts(
            self,
            repo,
            **kwargs
        ):
            """GetHelmCharts returns list of helm charts in the specified repository  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.repository_service_get_helm_charts(repo, async_req=True)
            >>> result = thread.get()

            Args:
                repo (str): Repo URL for query

            Keyword Args:
                force_refresh (bool): Whether to force a cache refresh on repo's connection state.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RepositoryHelmChartsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['repo'] = \
                repo
            return self.call_with_http_info(**kwargs)

        self.repository_service_get_helm_charts = _Endpoint(
            settings={
                'response_type': (RepositoryHelmChartsResponse,),
                'auth': [],
                'endpoint_path': '/api/v1/repositories/{repo}/helmcharts',
                'operation_id': 'repository_service_get_helm_charts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'repo',
                    'force_refresh',
                ],
                'required': [
                    'repo',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repo':
                        (str,),
                    'force_refresh':
                        (bool,),
                },
                'attribute_map': {
                    'repo': 'repo',
                    'force_refresh': 'forceRefresh',
                },
                'location_map': {
                    'repo': 'path',
                    'force_refresh': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__repository_service_get_helm_charts
        )

        def __repository_service_list_apps(
            self,
            repo,
            **kwargs
        ):
            """ListApps returns list of apps in the repe  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.repository_service_list_apps(repo, async_req=True)
            >>> result = thread.get()

            Args:
                repo (str):

            Keyword Args:
                revision (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RepositoryRepoAppsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['repo'] = \
                repo
            return self.call_with_http_info(**kwargs)

        self.repository_service_list_apps = _Endpoint(
            settings={
                'response_type': (RepositoryRepoAppsResponse,),
                'auth': [],
                'endpoint_path': '/api/v1/repositories/{repo}/apps',
                'operation_id': 'repository_service_list_apps',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'repo',
                    'revision',
                ],
                'required': [
                    'repo',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repo':
                        (str,),
                    'revision':
                        (str,),
                },
                'attribute_map': {
                    'repo': 'repo',
                    'revision': 'revision',
                },
                'location_map': {
                    'repo': 'path',
                    'revision': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__repository_service_list_apps
        )

        def __repository_service_list_refs(
            self,
            repo,
            **kwargs
        ):
            """repository_service_list_refs  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.repository_service_list_refs(repo, async_req=True)
            >>> result = thread.get()

            Args:
                repo (str): Repo URL for query

            Keyword Args:
                force_refresh (bool): Whether to force a cache refresh on repo's connection state.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RepositoryRefs
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['repo'] = \
                repo
            return self.call_with_http_info(**kwargs)

        self.repository_service_list_refs = _Endpoint(
            settings={
                'response_type': (RepositoryRefs,),
                'auth': [],
                'endpoint_path': '/api/v1/repositories/{repo}/refs',
                'operation_id': 'repository_service_list_refs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'repo',
                    'force_refresh',
                ],
                'required': [
                    'repo',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repo':
                        (str,),
                    'force_refresh':
                        (bool,),
                },
                'attribute_map': {
                    'repo': 'repo',
                    'force_refresh': 'forceRefresh',
                },
                'location_map': {
                    'repo': 'path',
                    'force_refresh': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__repository_service_list_refs
        )

        def __repository_service_list_repositories(
            self,
            **kwargs
        ):
            """ListRepositories gets a list of all configured repositories  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.repository_service_list_repositories(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                repo (str): Repo URL for query.. [optional]
                force_refresh (bool): Whether to force a cache refresh on repo's connection state.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1RepositoryList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.repository_service_list_repositories = _Endpoint(
            settings={
                'response_type': (V1alpha1RepositoryList,),
                'auth': [],
                'endpoint_path': '/api/v1/repositories',
                'operation_id': 'repository_service_list_repositories',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'repo',
                    'force_refresh',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repo':
                        (str,),
                    'force_refresh':
                        (bool,),
                },
                'attribute_map': {
                    'repo': 'repo',
                    'force_refresh': 'forceRefresh',
                },
                'location_map': {
                    'repo': 'query',
                    'force_refresh': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__repository_service_list_repositories
        )

        def __repository_service_update_repository(
            self,
            repo_repo,
            body,
            **kwargs
        ):
            """UpdateRepository updates a repository configuration  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.repository_service_update_repository(repo_repo, body, async_req=True)
            >>> result = thread.get()

            Args:
                repo_repo (str): Repo contains the URL to the remote repository
                body (V1alpha1Repository):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1Repository
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['repo_repo'] = \
                repo_repo
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.repository_service_update_repository = _Endpoint(
            settings={
                'response_type': (V1alpha1Repository,),
                'auth': [],
                'endpoint_path': '/api/v1/repositories/{repo.repo}',
                'operation_id': 'repository_service_update_repository',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'repo_repo',
                    'body',
                ],
                'required': [
                    'repo_repo',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repo_repo':
                        (str,),
                    'body':
                        (V1alpha1Repository,),
                },
                'attribute_map': {
                    'repo_repo': 'repo.repo',
                },
                'location_map': {
                    'repo_repo': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__repository_service_update_repository
        )

        def __repository_service_validate_access(
            self,
            repo,
            body,
            **kwargs
        ):
            """ValidateAccess validates access to a repository with given parameters  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.repository_service_validate_access(repo, body, async_req=True)
            >>> result = thread.get()

            Args:
                repo (str): The URL to the repo
                body (str): The URL to the repo

            Keyword Args:
                username (str): Username for accessing repo.. [optional]
                password (str): Password for accessing repo.. [optional]
                ssh_private_key (str): Private key data for accessing SSH repository.. [optional]
                insecure (bool): Whether to skip certificate or host key validation.. [optional]
                tls_client_cert_data (str): TLS client cert data for accessing HTTPS repository.. [optional]
                tls_client_cert_key (str): TLS client cert key for accessing HTTPS repository.. [optional]
                type (str): The type of the repo.. [optional]
                name (str): The name of the repo.. [optional]
                enable_oci (bool): Whether helm-oci support should be enabled for this repo.. [optional]
                github_app_private_key (str): Github App Private Key PEM data.. [optional]
                github_app_id (str): Github App ID of the app used to access the repo.. [optional]
                github_app_installation_id (str): Github App Installation ID of the installed GitHub App.. [optional]
                github_app_enterprise_base_url (str): Github App Enterprise base url if empty will default to https://api.github.com.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                bool, date, datetime, dict, float, int, list, str, none_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['repo'] = \
                repo
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.repository_service_validate_access = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/api/v1/repositories/{repo}/validate',
                'operation_id': 'repository_service_validate_access',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'repo',
                    'body',
                    'username',
                    'password',
                    'ssh_private_key',
                    'insecure',
                    'tls_client_cert_data',
                    'tls_client_cert_key',
                    'type',
                    'name',
                    'enable_oci',
                    'github_app_private_key',
                    'github_app_id',
                    'github_app_installation_id',
                    'github_app_enterprise_base_url',
                ],
                'required': [
                    'repo',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repo':
                        (str,),
                    'body':
                        (str,),
                    'username':
                        (str,),
                    'password':
                        (str,),
                    'ssh_private_key':
                        (str,),
                    'insecure':
                        (bool,),
                    'tls_client_cert_data':
                        (str,),
                    'tls_client_cert_key':
                        (str,),
                    'type':
                        (str,),
                    'name':
                        (str,),
                    'enable_oci':
                        (bool,),
                    'github_app_private_key':
                        (str,),
                    'github_app_id':
                        (str,),
                    'github_app_installation_id':
                        (str,),
                    'github_app_enterprise_base_url':
                        (str,),
                },
                'attribute_map': {
                    'repo': 'repo',
                    'username': 'username',
                    'password': 'password',
                    'ssh_private_key': 'sshPrivateKey',
                    'insecure': 'insecure',
                    'tls_client_cert_data': 'tlsClientCertData',
                    'tls_client_cert_key': 'tlsClientCertKey',
                    'type': 'type',
                    'name': 'name',
                    'enable_oci': 'enableOci',
                    'github_app_private_key': 'githubAppPrivateKey',
                    'github_app_id': 'githubAppID',
                    'github_app_installation_id': 'githubAppInstallationID',
                    'github_app_enterprise_base_url': 'githubAppEnterpriseBaseUrl',
                },
                'location_map': {
                    'repo': 'path',
                    'body': 'body',
                    'username': 'query',
                    'password': 'query',
                    'ssh_private_key': 'query',
                    'insecure': 'query',
                    'tls_client_cert_data': 'query',
                    'tls_client_cert_key': 'query',
                    'type': 'query',
                    'name': 'query',
                    'enable_oci': 'query',
                    'github_app_private_key': 'query',
                    'github_app_id': 'query',
                    'github_app_installation_id': 'query',
                    'github_app_enterprise_base_url': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__repository_service_validate_access
        )
